/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript;

import fleet.com.intellij.lang.javascript.dialects.JSLanguageFeature;
import fleet.com.intellij.lexer.FlexLexer;
import fleet.com.intellij.openapi.util.NotNullLazyValue;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DialectOptionHolder {
    public static final DialectOptionHolder ECMA_4 = new DialectOptionHolder("ECMA_4");
    public static final DialectOptionHolder JS_WITH_JSX = new DialectOptionHolder("JSX");
    public static final DialectOptionHolder JS_WITHOUT_JSX = new DialectOptionHolder("ECMA_6");
    public static final DialectOptionHolder JS_1_5 = new DialectOptionHolder("JS_1_5");
    @Deprecated(forRemoval=true)
    public static final DialectOptionHolder ECMA_6 = JS_WITH_JSX;
    public static final DialectOptionHolder TS = new DialectOptionHolder("TS", true);
    public static final DialectOptionHolder TSX = new DialectOptionHolder("TSX", true);
    public static final DialectOptionHolder FLOW = new DialectOptionHolder("FLOW");
    public static final DialectOptionHolder OTHER = new DialectOptionHolder("OTHER");
    public final boolean isECMA4;
    private final boolean hasE4X;
    public final boolean isECMA6;
    public final boolean isTypeScript;
    public final boolean isFlow;
    public final boolean isTSX;
    public final boolean isQML;
    @NonNls
    private final String myName;
    private final Set<JSLanguageFeature> myFeatures;
    private final NotNullLazyValue<Constructor<?>> myLexerClass;

    public DialectOptionHolder(@NotNull @NonNls String name) {
        this(name, false);
    }

    public DialectOptionHolder(@NotNull @NonNls String name, boolean isTypeScript) {
        this(name, isTypeScript, false);
    }

    public DialectOptionHolder(@NotNull @NonNls String name, boolean isTypeScript, boolean isECMA6) {
        this.isECMA4 = "ECMA_4".equals(name);
        this.isFlow = "FLOW".equals(name);
        this.isTSX = "TSX".equals(name);
        this.isQML = "QmlLang".equals(name);
        this.hasE4X = "E4X".equals(name) || "JSX".equals(name) || this.isFlow || this.isTSX;
        this.isECMA6 = isECMA6 || "ECMA_6".equals(name) || this.isFlow || this.isQML || "JSX".equals(name) || "JS_1_6".equals(name) || "JS_1_7".equals(name) || "JS_1_8".equals(name);
        this.isTypeScript = isTypeScript;
        this.myName = name;
        this.myFeatures = this.defineFeatures();
        this.myLexerClass = NotNullLazyValue.lazy(this::findLexerClass);
    }

    @NotNull
    protected Constructor<?> findLexerClass() {
        try {
            return Class.forName("fleet.com.intellij.lang.javascript._" + this.myName + "Lexer").getConstructor(Reader.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasJSSyntax() {
        return true;
    }

    public boolean supportsTypeGuard() {
        return this.hasJSSyntax() && !this.isECMA4;
    }

    @NotNull
    protected @Unmodifiable @NotNull Set<@NotNull JSLanguageFeature> defineFeatures() {
        EnumSet<JSLanguageFeature> features = EnumSet.noneOf(JSLanguageFeature.class);
        if (this.hasE4X || this.isECMA4) {
            features.add(JSLanguageFeature.E4X);
        }
        if (this.isECMA4) {
            features.add(JSLanguageFeature.FOR_EACH);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.FOR_OF);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.LET_DEFINITIONS);
            features.add(JSLanguageFeature.CONST_DEFINITIONS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.YIELD_GENERATORS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.DESTRUCTURING_PARAMETERS);
        }
        features.add(JSLanguageFeature.ACCESSORS);
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        if (this.isECMA4 || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.REST_PARAMETERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features.add(JSLanguageFeature.GENERICS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.IMPORT_DECLARATIONS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        if (this.isECMA4 || this.isTypeScript || this.isECMA6) {
            features.add(JSLanguageFeature.CLASSES);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.ANNOTATIONS);
            features.add(JSLanguageFeature.ASYNC_AWAIT);
            features.add(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            features.add(JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            features.add(JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
            features.add(JSLanguageFeature.STRING_TEMPLATES);
        }
        if (this.isECMA6) {
            features.add(JSLanguageFeature.BIND_EXPRESSIONS);
            features.add(JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA4) {
            features.add(JSLanguageFeature.TYPES);
            features.add(JSLanguageFeature.INTERFACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA6) {
            features.add(JSLanguageFeature.TRAILING_FUNCTION_COMMA);
            features.add(JSLanguageFeature.OPTIONAL_CATCH_BINDING);
        }
        if (this.isECMA6) {
            if (!this.isFlow) {
                features.add(JSLanguageFeature.BIG_INT);
                features.add(JSLanguageFeature.OPTIONAL_CHAINING_OPERATOR);
            }
            features.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
            features.add(JSLanguageFeature.THROW_EXPRESSIONS);
            features.add(JSLanguageFeature.DECORATOR_DECLARATIONS);
            features.add(JSLanguageFeature.PIPE_EXPRESSIONS);
        }
        if (this.isTypeScript) {
            features.add(JSLanguageFeature.BIG_INT);
            features.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
        }
        if (this.isTypeScript || this.isECMA4 || this.isFlow) {
            features.add(JSLanguageFeature.VISIBILITY_MODIFIERS);
        }
        if (this.isTypeScript || this.isECMA4 || this.isECMA6) {
            features.add(JSLanguageFeature.PARAMETER_INITIALIZERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features.add(JSLanguageFeature.ENUMS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.NULLISH_COALESCING);
        }
        return Collections.unmodifiableSet(features);
    }

    public boolean hasFeature(@NotNull JSLanguageFeature feature) {
        return this.myFeatures.contains((Object)feature);
    }

    public boolean isJSX() {
        return this.isTSX || this.isFlow || "JSX".equals(this.myName);
    }

    public boolean isJavaScript() {
        return this != ECMA_4 && !this.isTypeScript && this != OTHER;
    }

    public boolean hasE4XStandard() {
        return this.isECMA4;
    }

    @NotNull
    public FlexLexer createLexer(boolean highlightMode, boolean jsDocTypesMode) {
        try {
            Constructor constructor = (Constructor)this.myLexerClass.getValue();
            return (FlexLexer)constructor.newInstance(null, highlightMode, jsDocTypesMode);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

