/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.desktop;

import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.ZipFile;
import fleet.dock.desktop.FleetCdsKt;
import fleet.util.logging.KLogger;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0000\u001a&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"ignoreClasses", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "allLayers", "", "Ljava/lang/ModuleLayer;", "moduleLayer", "loadAllClasses", "", "loadAllClassesInPath", "", "path", "Ljava/nio/file/Path;", "packageName", "classLoader", "Ljava/lang/ClassLoader;", "loadClass", "", "className", "fleet.dock.desktop"})
@SourceDebugExtension(value={"SMAP\nFleetCds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetCds.kt\nfleet/dock/desktop/FleetCdsKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n13#2,2:142\n13#2,2:146\n13#2,2:148\n41#2,2:150\n13#2,2:154\n41#2,2:158\n5#2,2:160\n5#2,2:162\n41#2,2:164\n1855#3:144\n1855#3:145\n1856#3:152\n1856#3:153\n1855#3,2:156\n1855#3,2:166\n*S KotlinDebug\n*F\n+ 1 FleetCds.kt\nfleet/dock/desktop/FleetCdsKt\n*L\n44#1:142,2\n50#1:146,2\n53#1:148,2\n79#1:150,2\n89#1:154,2\n103#1:158,2\n111#1:160,2\n116#1:162,2\n120#1:164,2\n48#1:144\n49#1:145\n49#1:152\n48#1:153\n95#1:156,2\n134#1:166,2\n*E\n"})
public final class FleetCdsKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    private static final HashSet<String> ignoreClasses;

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadAllClasses(@NotNull ModuleLayer moduleLayer) {
        KLogger kLogger;
        Intrinsics.checkNotNullParameter((Object)moduleLayer, (String)"moduleLayer");
        KLogger this_$iv = FleetCdsKt.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.info((Object)"Loading all classes for AppCDS classes list");
        }
        FileSystem jrtFileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Set loadedClassesNames = new LinkedHashSet();
        Iterable $this$forEach$iv = FleetCdsKt.allLayers(moduleLayer);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleLayer layer = (ModuleLayer)element$iv;
            boolean bl = false;
            Set<Module> set = layer.modules();
            Intrinsics.checkNotNullExpressionValue(set, (String)"modules(...)");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KLogger kLogger2;
                Module module = (Module)element$iv2;
                boolean bl2 = false;
                KLogger this_$iv2 = FleetCdsKt.getLogger();
                boolean $i$f$info2 = false;
                if (this_$iv2.isInfoEnabled()) {
                    kLogger2 = this_$iv2;
                    boolean bl3 = false;
                    kLogger2.info((Object)("Loading module " + module.getName()));
                }
                ClassLoader classLoader = module.getClassLoader();
                for (String packageName : module.getPackages()) {
                    KLogger this_$iv3 = FleetCdsKt.getLogger();
                    boolean $i$f$info3 = false;
                    if (this_$iv3.isInfoEnabled()) {
                        kLogger2 = this_$iv3;
                        boolean bl4 = false;
                        kLogger2.info((Object)("Package " + packageName));
                    }
                    Intrinsics.checkNotNull((Object)packageName);
                    String packagePath = StringsKt.replace$default((String)packageName, (char)'.', (char)'/', (boolean)false, (int)4, null);
                    if (classLoader != null) {
                        try {
                            Enumeration<URL> resources = classLoader.getResources(packagePath + "/");
                            while (resources.hasMoreElements()) {
                                URL resource = resources.nextElement();
                                if (Intrinsics.areEqual((Object)resource.getProtocol(), (Object)"jar")) {
                                    String string = resource.getFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFile(...)");
                                    URI uri = new URL(StringsKt.substringBefore$default((String)string, (char)'!', null, (int)2, null)).toURI();
                                    AutoCloseable autoCloseable = (AutoCloseable)ImmutableZipFile.load((Path)Path.of(uri));
                                    Throwable throwable = null;
                                    try {
                                        ZipFile zf = (ZipFile)autoCloseable;
                                        boolean bl5 = false;
                                        zf.processResources(packagePath, arg_0 -> FleetCdsKt.loadAllClasses$lambda$8$lambda$7$lambda$5$lambda$3(loadAllClasses.2.1.3.1.INSTANCE, arg_0), (arg_0, arg_1) -> FleetCdsKt.loadAllClasses$lambda$8$lambda$7$lambda$5$lambda$4((Function2)new Function2<String, InputStream, Unit>(classLoader, (Set<String>)loadedClassesNames){
                                            final /* synthetic */ ClassLoader $classLoader;
                                            final /* synthetic */ Set<String> $loadedClassesNames;
                                            {
                                                this.$classLoader = $classLoader;
                                                this.$loadedClassesNames = $loadedClassesNames;
                                                super(2);
                                            }

                                            public final void invoke(String entryName, InputStream e) {
                                                Intrinsics.checkNotNull((Object)entryName);
                                                String className = StringsKt.removeSuffix((String)StringsKt.replace$default((String)entryName, (char)'/', (char)'.', (boolean)false, (int)4, null), (CharSequence)".class");
                                                ClassLoader classLoader = this.$classLoader;
                                                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"$classLoader");
                                                if (FleetCdsKt.access$loadClass(className, classLoader)) {
                                                    this.$loadedClassesNames.add(className);
                                                }
                                            }
                                        }, arg_0, arg_1));
                                        Unit unit = Unit.INSTANCE;
                                        continue;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                                        continue;
                                    }
                                }
                                Path path = Paths.get(URI.create(resource.toString()));
                                Intrinsics.checkNotNull((Object)path);
                                loadedClassesNames.addAll((Collection)FleetCdsKt.loadAllClassesInPath(path, packageName, classLoader));
                            }
                            continue;
                        }
                        catch (Throwable e) {
                            KLogger this_$iv4 = FleetCdsKt.getLogger();
                            boolean $i$f$error = false;
                            if (!this_$iv4.isErrorEnabled()) continue;
                            Throwable throwable = e;
                            kLogger2 = this_$iv4;
                            boolean bl6 = false;
                            String string = "Failed to load package " + packageName;
                            kLogger2.error(throwable, (Object)string);
                            continue;
                        }
                    }
                    Path path = jrtFileSystem.getPath("/modules/" + module.getName() + "/" + packagePath, new String[0]);
                    Intrinsics.checkNotNull((Object)path);
                    Intrinsics.checkNotNull((Object)systemClassLoader);
                    loadedClassesNames.addAll((Collection)FleetCdsKt.loadAllClassesInPath(path, packageName, systemClassLoader));
                }
            }
        }
        KLogger this_$iv5 = FleetCdsKt.getLogger();
        boolean $i$f$info4 = false;
        if (this_$iv5.isInfoEnabled()) {
            kLogger = this_$iv5;
            boolean bl = false;
            kLogger.info((Object)("Loaded classes count: " + loadedClassesNames.size()));
        }
    }

    private static final Set<String> loadAllClassesInPath(Path path, String packageName, ClassLoader classLoader) {
        Set loadedClassesNames;
        block3: {
            loadedClassesNames = new LinkedHashSet();
            try {
                Iterable $this$forEach$iv = PathsKt.listDirectoryEntries((Path)path, (String)"*.class");
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path file = (Path)element$iv;
                    boolean bl = false;
                    String className = packageName + "." + StringsKt.removeSuffix((String)PathsKt.getName((Path)file), (CharSequence)".class");
                    if (!FleetCdsKt.loadClass(className, classLoader)) continue;
                    loadedClassesNames.add(className);
                }
            }
            catch (Throwable e) {
                KLogger this_$iv = FleetCdsKt.getLogger();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break block3;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Failed to load package " + packageName + " from " + path;
                kLogger.error(throwable, (Object)string);
            }
        }
        return loadedClassesNames;
    }

    private static final boolean loadClass(String className, ClassLoader classLoader) {
        block5: {
            try {
                if (!ignoreClasses.contains(className)) {
                    KLogger this_$iv = FleetCdsKt.getLogger();
                    boolean $i$f$trace = false;
                    if (this_$iv.isTraceEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl = false;
                        kLogger.trace((Object)("Class " + className));
                    }
                    classLoader.loadClass(className);
                    return true;
                }
                KLogger this_$iv = FleetCdsKt.getLogger();
                boolean $i$f$trace = false;
                if (this_$iv.isTraceEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.trace((Object)("Ignored class " + className));
                }
            }
            catch (Throwable e) {
                KLogger this_$iv = FleetCdsKt.getLogger();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break block5;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Failed to load class " + className;
                kLogger.error(throwable, (Object)string);
            }
        }
        return false;
    }

    private static final List<ModuleLayer> allLayers(ModuleLayer moduleLayer) {
        List list;
        List $this$allLayers_u24lambda_u2416 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] objectArray = new ModuleLayer[]{moduleLayer};
        Set visited = SetsKt.mutableSetOf((Object[])objectArray);
        ArrayDeque<ModuleLayer> queue = new ArrayDeque<ModuleLayer>();
        queue.push(moduleLayer);
        while (!((Collection)queue).isEmpty()) {
            ModuleLayer layer = (ModuleLayer)queue.pop();
            Intrinsics.checkNotNull((Object)layer);
            $this$allLayers_u24lambda_u2416.add(layer);
            List<ModuleLayer> parents = layer.parents();
            Intrinsics.checkNotNull(parents);
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)parents);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleLayer parent = (ModuleLayer)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)parent);
                if (!visited.add(parent)) continue;
                queue.push(parent);
            }
        }
        return CollectionsKt.build((List)list);
    }

    private static final boolean loadAllClasses$lambda$8$lambda$7$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void loadAllClasses$lambda$8$lambda$7$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ boolean access$loadClass(String className, ClassLoader classLoader) {
        return FleetCdsKt.loadClass(className, classLoader);
    }

    static {
        Object[] objectArray = new String[]{"ch.qos.logback.classic.ViewStatusMessagesServlet", "ch.qos.logback.classic.helpers.MDCInsertingServletFilter", "ch.qos.logback.classic.selector.servlet.ContextDetachingSCL", "ch.qos.logback.classic.selector.servlet.LoggerContextFilter", "ch.qos.logback.classic.servlet.LogbackServletContainerInitializer", "ch.qos.logback.classic.servlet.LogbackServletContextListener", "ch.qos.logback.core.net.LoginAuthenticator", "ch.qos.logback.core.status.ViewStatusMessagesServletBase", "io.opentelemetry.exporter.internal.grpc.MarshalerInputStream", "io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub", "io.opentelemetry.exporter.otlp.internal.OtlpLogRecordExporterProvider", "io.opentelemetry.exporter.otlp.internal.OtlpMetricExporterProvider", "io.opentelemetry.exporter.otlp.internal.OtlpSpanExporterProvider", "io.opentelemetry.exporter.otlp.logs.MarshalerLogsServiceGrpc$1", "io.opentelemetry.exporter.otlp.logs.MarshalerLogsServiceGrpc$2", "io.opentelemetry.exporter.otlp.logs.MarshalerLogsServiceGrpc$LogsServiceFutureStub", "io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc$1", "io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc$2", "io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc$MetricsServiceFutureStub", "io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc$1", "io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc$2", "io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc$TraceServiceFutureStub"};
        ignoreClasses = SetsKt.hashSetOf((Object[])objectArray);
    }
}

