/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.logback;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicyBase;
import ch.qos.logback.core.util.SimpleInvocationGate;
import fleet.preferences.FleetPropertiesKt;
import fleet.util.logback.CommonLogbackConfiguratorKt;
import fleet.util.logback.FleetLogAppender;
import fleet.util.logging.FleetLogConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010$\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002JB\u0010)\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001a2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u0015022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u00103\u001a\u0004\u0018\u00010\u00062\b\u00104\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lfleet/util/logback/CommonLogbackConfigurator;", "Lch/qos/logback/classic/BasicConfigurator;", "configDirPath", "Ljava/nio/file/Path;", "logDirPath", "baseConfig", "Lfleet/util/logging/FleetLogConfiguration;", "forcedConfig", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lfleet/util/logging/FleetLogConfiguration;Lfleet/util/logging/FleetLogConfiguration;)V", "dynamicLoggers", "Ljava/util/ArrayList;", "Lch/qos/logback/classic/Logger;", "Lkotlin/collections/ArrayList;", "getLogDirPath", "()Ljava/nio/file/Path;", "shouldReconfigureDynamically", "", "getShouldReconfigureDynamically", "()Z", "appenderWithLevel", "Lch/qos/logback/core/Appender;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "loggerContext", "Lch/qos/logback/classic/LoggerContext;", "appender", "level", "Lch/qos/logback/classic/Level;", "applyConfig", "", "config", "appenders", "", "Lfleet/util/logback/FleetLogAppender;", "configure", "Lch/qos/logback/classic/spi/Configurator$ExecutionStatus;", "configureAppenders", "configureDynamicallyAndWatch", "createRollingFileAppender", "Lch/qos/logback/core/rolling/RollingFileAppender;", "fileSize", "", "defineLogger", "entry", "Lfleet/util/logging/FleetLogConfiguration$Entry;", "defaultLevel", "defaultPerTarget", "", "Lfleet/util/logging/FleetLogConfiguration$Target;", "Lfleet/util/logging/FleetLogConfiguration$Level;", "levelFilter", "Lch/qos/logback/core/filter/Filter;", "loadConfig", "oldConfig", "undefineLogger", "logger", "Companion", "fleet.util.logging.impl"})
@SourceDebugExtension(value={"SMAP\nCommonLogbackConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonLogbackConfigurator.kt\nfleet/util/logback/CommonLogbackConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n1855#2,2:381\n1855#2,2:383\n1855#2,2:385\n1855#2,2:387\n1549#2:389\n1620#2,3:390\n2333#2,14:393\n1855#2,2:407\n1855#2,2:409\n*S KotlinDebug\n*F\n+ 1 CommonLogbackConfigurator.kt\nfleet/util/logback/CommonLogbackConfigurator\n*L\n76#1:381,2\n106#1:383,2\n194#1:385,2\n209#1:387,2\n215#1:389\n215#1:390,3\n234#1:393,14\n238#1:407,2\n288#1:409,2\n*E\n"})
public class CommonLogbackConfigurator
extends BasicConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path configDirPath;
    @Nullable
    private final Path logDirPath;
    @NotNull
    private final FleetLogConfiguration baseConfig;
    @Nullable
    private final FleetLogConfiguration forcedConfig;
    @NotNull
    private final ArrayList<Logger> dynamicLoggers;
    private final boolean shouldReconfigureDynamically;

    public CommonLogbackConfigurator(@Nullable Path configDirPath, @Nullable Path logDirPath, @NotNull FleetLogConfiguration baseConfig, @Nullable FleetLogConfiguration forcedConfig) {
        Intrinsics.checkNotNullParameter((Object)baseConfig, (String)"baseConfig");
        this.configDirPath = configDirPath;
        this.logDirPath = logDirPath;
        this.baseConfig = baseConfig;
        this.forcedConfig = forcedConfig;
        this.dynamicLoggers = new ArrayList();
        this.shouldReconfigureDynamically = true;
    }

    public /* synthetic */ CommonLogbackConfigurator(Path path, Path path2, FleetLogConfiguration fleetLogConfiguration, FleetLogConfiguration fleetLogConfiguration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        if ((n & 2) != 0) {
            path2 = null;
        }
        if ((n & 4) != 0) {
            fleetLogConfiguration = CommonLogbackConfigurator.Companion.getDefaultConfiguration();
        }
        if ((n & 8) != 0) {
            fleetLogConfiguration2 = null;
        }
        this(path, path2, fleetLogConfiguration, fleetLogConfiguration2);
    }

    @Nullable
    public final Path getLogDirPath() {
        return this.logDirPath;
    }

    public boolean getShouldReconfigureDynamically() {
        return this.shouldReconfigureDynamically;
    }

    @NotNull
    public Configurator.ExecutionStatus configure(@NotNull LoggerContext loggerContext) {
        Intrinsics.checkNotNullParameter((Object)loggerContext, (String)"loggerContext");
        Collection<FleetLogAppender> appenders = this.configureAppenders(loggerContext);
        Logger logger = loggerContext.getLogger("ROOT");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Logger rootLogger = logger;
        rootLogger.setLevel(Level.WARN);
        Iterable $this$forEach$iv = appenders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FleetLogAppender it = (FleetLogAppender)element$iv;
            boolean bl = false;
            rootLogger.addAppender(it.getAppender());
        }
        FleetLogConfiguration config = this.loadConfig(null);
        if (config == null) {
            Level fleetLevel = FleetPropertiesKt.isFleetDebugMode() ? Level.DEBUG : Level.WARN;
            Intrinsics.checkNotNull((Object)fleetLevel);
            CommonLogbackConfiguratorKt.createLogger$default(loggerContext, "fleet", fleetLevel, null, 4, null);
            CommonLogbackConfiguratorKt.createLogger$default(loggerContext, "noria.ui", fleetLevel, null, 4, null);
            CommonLogbackConfiguratorKt.createLogger$default(loggerContext, "noria", fleetLevel, null, 4, null);
        } else if (this.getShouldReconfigureDynamically()) {
            this.configureDynamicallyAndWatch(loggerContext, config, appenders);
        } else {
            this.applyConfig(loggerContext, config, appenders);
        }
        return Configurator.ExecutionStatus.NEUTRAL;
    }

    private final FleetLogConfiguration loadConfig(FleetLogConfiguration oldConfig) {
        List files = FleetLogConfiguration.Companion.getLogFiles(this.configDirPath);
        FleetLogConfiguration config = FleetLogConfiguration.Companion.fetchFromFiles(files, this.baseConfig, this.forcedConfig);
        if (config != null && !Intrinsics.areEqual((Object)config, (Object)oldConfig)) {
            System.out.println((Object)"Loaded default logback configuration");
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path configurationFile = (Path)element$iv;
                boolean bl = false;
                System.out.println((Object)("Loaded logback configuration from file '" + configurationFile + "'"));
            }
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<FleetLogAppender> configureAppenders(@NotNull LoggerContext loggerContext) {
        void $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        LayoutWrappingEncoder layoutWrappingEncoder;
        ConsoleAppender consoleAppender;
        AsyncAppender asyncAppender;
        List list;
        Intrinsics.checkNotNullParameter((Object)loggerContext, (String)"loggerContext");
        List $this$configureAppenders_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Layout consoleLayout = CommonLogbackConfiguratorKt.access$getConsoleLayout(loggerContext);
        AsyncAppender $this$configureAppenders_u24lambda_u248_u24lambda_u244 = asyncAppender = new AsyncAppender();
        boolean bl2 = false;
        $this$configureAppenders_u24lambda_u248_u24lambda_u244.setName("ConsoleLogDelegate");
        $this$configureAppenders_u24lambda_u248_u24lambda_u244.setContext((Context)loggerContext);
        System.out.println((Object)("Configure console log with " + $this$configureAppenders_u24lambda_u248_u24lambda_u244.getClass()));
        ConsoleAppender $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243 = consoleAppender = new ConsoleAppender();
        boolean bl3 = false;
        $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243.setContext((Context)loggerContext);
        LayoutWrappingEncoder layoutWrappingEncoder2 = layoutWrappingEncoder = new LayoutWrappingEncoder();
        ConsoleAppender consoleAppender2 = $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243;
        boolean bl4 = false;
        $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243_u24lambda_u242.setContext((Context)loggerContext);
        $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243_u24lambda_u242.setCharset(Charsets.UTF_8);
        $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243_u24lambda_u242.setLayout(consoleLayout);
        consoleAppender2.setEncoder((Encoder)layoutWrappingEncoder);
        $this$configureAppenders_u24lambda_u248_u24lambda_u244_u24lambda_u243.start();
        ConsoleAppender appender = consoleAppender;
        $this$configureAppenders_u24lambda_u248_u24lambda_u244.addAppender((Appender)appender);
        $this$configureAppenders_u24lambda_u248_u24lambda_u244.start();
        AsyncAppender consoleAppender3 = asyncAppender;
        $this$configureAppenders_u24lambda_u248.add(new FleetLogAppender.Targeted((Appender<ILoggingEvent>)((Appender)consoleAppender3), FleetLogConfiguration.Target.CONSOLE));
        if (this.logDirPath != null) {
            void $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
            RollingFileAppender<ILoggingEvent> rollingFileAppender;
            AsyncAppender asyncAppender2;
            AsyncAppender $this$configureAppenders_u24lambda_u248_u24lambda_u247 = asyncAppender2 = new AsyncAppender();
            boolean bl5 = false;
            $this$configureAppenders_u24lambda_u248_u24lambda_u247.setName("FileLogDelegate");
            $this$configureAppenders_u24lambda_u248_u24lambda_u247.setContext((Context)loggerContext);
            RollingFileAppender<ILoggingEvent> $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246 = rollingFileAppender = this.createRollingFileAppender(loggerContext, this.logDirPath, CommonLogbackConfiguratorKt.access$getTextLogFileSize());
            boolean bl6 = false;
            $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246.setContext((Context)loggerContext);
            layoutWrappingEncoder2 = new LayoutWrappingEncoder();
            consoleAppender2 = layoutWrappingEncoder2;
            RollingFileAppender<ILoggingEvent> rollingFileAppender2 = $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246;
            boolean bl7 = false;
            $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setContext((Context)loggerContext);
            $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setCharset(Charsets.UTF_8);
            $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setLayout(consoleLayout);
            rollingFileAppender2.setEncoder((Encoder)layoutWrappingEncoder2);
            $this$configureAppenders_u24lambda_u248_u24lambda_u247_u24lambda_u246.start();
            RollingFileAppender<ILoggingEvent> appender2 = rollingFileAppender;
            $this$configureAppenders_u24lambda_u248_u24lambda_u247.addAppender((Appender)appender2);
            $this$configureAppenders_u24lambda_u248_u24lambda_u247.start();
            AsyncAppender fileAppender = asyncAppender2;
            $this$configureAppenders_u24lambda_u248.add(new FleetLogAppender.Targeted((Appender<ILoggingEvent>)((Appender)fileAppender), FleetLogConfiguration.Target.FILE));
        }
        return CollectionsKt.build((List)list);
    }

    private final void configureDynamicallyAndWatch(LoggerContext loggerContext, FleetLogConfiguration config, Collection<? extends FleetLogAppender> appenders) {
        System.out.println((Object)("Applying new dynamic config " + config));
        this.applyConfig(loggerContext, config, appenders);
        Integer refreshTimeout = config.getRefreshTimeout();
        if (refreshTimeout != null && refreshTimeout > 0) {
            int n = 0;
            Future[] futureArray = new Future[1];
            while (n < 1) {
                int n2 = n++;
                futureArray[n2] = null;
            }
            Future[] futureRef = futureArray;
            futureRef[0] = loggerContext.getScheduledExecutorService().scheduleAtFixedRate(() -> CommonLogbackConfigurator.configureDynamicallyAndWatch$lambda$9(this, config, futureRef, loggerContext, appenders), refreshTimeout.intValue(), refreshTimeout.intValue(), TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void applyConfig(LoggerContext loggerContext, FleetLogConfiguration config, Collection<? extends FleetLogAppender> appenders) {
        void $this$mapTo$iv$iv;
        Object $i$a$-synchronized-CommonLogbackConfigurator$applyConfig$32;
        Logger it;
        FleetLogConfiguration.Level level = config.getDefault();
        if (level == null || (level = CommonLogbackConfiguratorKt.access$toLogbackLevel(level)) == null) {
            level = Level.WARN;
        }
        FleetLogConfiguration.Level defaultLevel = level;
        Logger logger = loggerContext.getLogger("ROOT");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Logger rootLogger = logger;
        rootLogger.setLevel((Level)defaultLevel);
        Iterable $this$forEach$iv = appenders;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            FleetLogConfiguration.Level level2;
            FleetLogAppender appender = (FleetLogAppender)element$iv;
            boolean bl = false;
            appender.getAppender().clearAllFilters();
            FleetLogAppender fleetLogAppender = appender;
            if (fleetLogAppender instanceof FleetLogAppender.Constant) {
                appender.getAppender().addFilter(this.levelFilter(CommonLogbackConfiguratorKt.access$toLogbackLevel(((FleetLogAppender.Constant)appender).getLevel())));
                continue;
            }
            if (!(fleetLogAppender instanceof FleetLogAppender.Targeted)) continue;
            if ((FleetLogConfiguration.Level)config.getPerTarget().get(((FleetLogAppender.Targeted)appender).getTarget()) == null) continue;
            boolean bl2 = false;
            this.levelFilter(CommonLogbackConfiguratorKt.access$toLogbackLevel(level2));
        }
        ArrayList<Logger> $i$f$forEach22 = this.dynamicLoggers;
        synchronized ($i$f$forEach22) {
            boolean $i$a$-synchronized-CommonLogbackConfigurator$applyConfig$32 = false;
            Iterable $this$forEach$iv2 = this.dynamicLoggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                it = (Logger)element$iv;
                boolean bl = false;
                this.undefineLogger(it);
            }
            this.dynamicLoggers.clear();
            $i$a$-synchronized-CommonLogbackConfigurator$applyConfig$32 = Unit.INSTANCE;
        }
        Iterable $this$map$iv = config.getLoggers();
        boolean $i$f$map = false;
        $i$a$-synchronized-CommonLogbackConfigurator$applyConfig$32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FleetLogConfiguration.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)defaultLevel);
            collection.add(this.defineLogger(loggerContext, (FleetLogConfiguration.Entry)it, (Level)defaultLevel, config.getPerTarget(), appenders));
        }
        List newList = (List)destination$iv$iv;
        boolean bl = false;
        ArrayList<Logger> arrayList = this.dynamicLoggers;
        synchronized (arrayList) {
            boolean bl3 = false;
            boolean bl4 = this.dynamicLoggers.addAll(newList);
        }
    }

    private final Logger defineLogger(LoggerContext loggerContext, FleetLogConfiguration.Entry entry, Level defaultLevel, Map<FleetLogConfiguration.Target, ? extends FleetLogConfiguration.Level> defaultPerTarget, Collection<? extends FleetLogAppender> appenders) {
        FleetLogConfiguration.Level level;
        Object v0;
        Logger logger = loggerContext.getLogger(entry.getLoggerName());
        Iterable $this$minByOrNull$iv = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)entry.getDefault()), (Iterable)entry.getPerTarget().values());
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                FleetLogConfiguration.Level it = (FleetLogConfiguration.Level)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getIntValue();
                do {
                    Object e$iv = iterator$iv.next();
                    FleetLogConfiguration.Level it2 = (FleetLogConfiguration.Level)e$iv;
                    $i$a$-minByOrNull-CommonLogbackConfigurator$defineLogger$loggerLevel$1 = false;
                    int v$iv = it2.getIntValue();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((level = (FleetLogConfiguration.Level)v0) == null || (level = CommonLogbackConfiguratorKt.access$toLogbackLevel(level)) == null) {
            level = defaultLevel;
        }
        FleetLogConfiguration.Level loggerLevel = level;
        logger.setLevel((Level)loggerLevel);
        logger.setAdditive(false);
        Iterable $this$forEach$iv = appenders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FleetLogAppender appender = (FleetLogAppender)element$iv;
            boolean bl = false;
            FleetLogAppender fleetLogAppender = appender;
            if (fleetLogAppender instanceof FleetLogAppender.Constant) {
                logger.addAppender(this.appenderWithLevel(loggerContext, appender.getAppender(), CommonLogbackConfiguratorKt.access$toLogbackLevel(((FleetLogAppender.Constant)appender).getLevel())));
                continue;
            }
            if (!(fleetLogAppender instanceof FleetLogAppender.Targeted)) continue;
            FleetLogConfiguration.Target target = ((FleetLogAppender.Targeted)appender).getTarget();
            Object object = (FleetLogConfiguration.Level)entry.getPerTarget().get(target);
            if (object == null || (object = CommonLogbackConfiguratorKt.access$toLogbackLevel(object)) == null) {
                FleetLogConfiguration.Level level2 = entry.getDefault();
                if (level2 != null) {
                    object = CommonLogbackConfiguratorKt.access$toLogbackLevel(level2);
                } else {
                    FleetLogConfiguration.Level level3 = defaultPerTarget.get(target);
                    object = level3 != null ? CommonLogbackConfiguratorKt.access$toLogbackLevel(level3) : null;
                    if (object == null) {
                        object = defaultLevel;
                    }
                }
            }
            FleetLogConfiguration.Level level4 = object;
            logger.addAppender(this.appenderWithLevel(loggerContext, appender.getAppender(), (Level)level4));
        }
        Intrinsics.checkNotNull((Object)logger);
        return logger;
    }

    private final Appender<ILoggingEvent> appenderWithLevel(LoggerContext loggerContext, Appender<ILoggingEvent> appender, Level level) {
        if (level == null) {
            return appender;
        }
        return (Appender)new AppenderBase<ILoggingEvent>(loggerContext, this, level, appender){
            final /* synthetic */ Appender<ILoggingEvent> $appender;
            {
                this.$appender = $appender;
                this.name = "Delegate";
                this.context = (Context)$loggerContext;
                this.addFilter(CommonLogbackConfigurator.access$levelFilter($receiver, $level));
                this.start();
            }

            protected void append(@Nullable ILoggingEvent eventObject) {
                this.$appender.doAppend((Object)eventObject);
            }
        };
    }

    private final Filter<ILoggingEvent> levelFilter(Level level) {
        ThresholdFilter thresholdFilter;
        ThresholdFilter $this$levelFilter_u24lambda_u2419 = thresholdFilter = new ThresholdFilter();
        boolean bl = false;
        $this$levelFilter_u24lambda_u2419.setLevel(level.toString());
        $this$levelFilter_u24lambda_u2419.start();
        return (Filter)thresholdFilter;
    }

    private final void undefineLogger(Logger logger) {
        logger.setLevel(null);
        Iterator iterator = logger.iteratorForAppenders();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iteratorForAppenders(...)");
        Iterable $this$forEach$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Appender appender = (Appender)element$iv;
            boolean bl = false;
            logger.detachAppender(appender);
            if (!Intrinsics.areEqual((Object)appender.getName(), (Object)"Delegate")) continue;
            appender.clearAllFilters();
            appender.stop();
        }
    }

    private final RollingFileAppender<ILoggingEvent> createRollingFileAppender(LoggerContext loggerContext, Path logDirPath, long fileSize) {
        Path logFile = logDirPath.resolve("fleet.log");
        System.out.println((Object)("Configure file log with " + ((Object)((Object)this)).getClass() + " (" + logFile + ")"));
        RollingFileAppender fileAppender = new RollingFileAppender();
        Path path = logFile.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        fileAppender.setFile(((Object)path).toString());
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setContext((Context)loggerContext);
        rollingPolicy.setFileNamePattern(logDirPath + "/fleet%i.log");
        rollingPolicy.setMaxIndex(16);
        rollingPolicy.setParent((FileAppender)fileAppender);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        rollingPolicy.start();
        TriggeringPolicyBase<ILoggingEvent> triggeringPolicy2 = new TriggeringPolicyBase<ILoggingEvent>(fileSize){
            private final long maxFileSize;
            private long estimatedActiveFileSize;
            @NotNull
            private final SimpleInvocationGate invocationGate;
            {
                this.maxFileSize = $fileSize;
                this.invocationGate = new SimpleInvocationGate();
            }

            public boolean isTriggeringEvent(@NotNull File activeFile, @NotNull ILoggingEvent event) {
                boolean rotateNeeded;
                Intrinsics.checkNotNullParameter((Object)activeFile, (String)"activeFile");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.estimatedActiveFileSize = this.invocationGate.isTooSoon(System.currentTimeMillis()) ? (this.estimatedActiveFileSize += (long)event.getFormattedMessage().length()) : activeFile.length();
                boolean bl = rotateNeeded = this.estimatedActiveFileSize > this.maxFileSize;
                if (rotateNeeded) {
                    this.estimatedActiveFileSize = 0L;
                }
                return rotateNeeded;
            }
        };
        triggeringPolicy2.setContext((Context)loggerContext);
        fileAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy2);
        triggeringPolicy2.start();
        return fileAppender;
    }

    private static final void configureDynamicallyAndWatch$lambda$9(CommonLogbackConfigurator this$0, FleetLogConfiguration $config, Future[] $futureRef, LoggerContext $loggerContext, Collection $appenders) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$futureRef, (String)"$futureRef");
        Intrinsics.checkNotNullParameter((Object)$loggerContext, (String)"$loggerContext");
        Intrinsics.checkNotNullParameter((Object)$appenders, (String)"$appenders");
        FleetLogConfiguration newConfig = this$0.loadConfig($config);
        if (!Intrinsics.areEqual((Object)newConfig, (Object)$config)) {
            Future future = $futureRef[0];
            Intrinsics.checkNotNull((Object)future);
            future.cancel(false);
            if (newConfig != null) {
                this$0.configureDynamicallyAndWatch($loggerContext, newConfig, $appenders);
            }
        }
    }

    public CommonLogbackConfigurator() {
        this(null, null, null, null, 15, null);
    }

    public static final /* synthetic */ Filter access$levelFilter(CommonLogbackConfigurator $this, Level level) {
        return $this.levelFilter(level);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/util/logback/CommonLogbackConfigurator$Companion;", "", "()V", "defaultConfiguration", "Lfleet/util/logging/FleetLogConfiguration;", "getDefaultConfiguration", "()Lfleet/util/logging/FleetLogConfiguration;", "fleet.util.logging.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final FleetLogConfiguration getDefaultConfiguration() {
            return FleetPropertiesKt.isFleetTestMode() ? FleetLogConfiguration.Companion.getTestDefaultConfiguration() : FleetLogConfiguration.Companion.getProductionDefaultConfiguration();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

