/*
 * Decompiled with CFR 0.152.
 */
package fleet.api.exec;

import fleet.rpc.core.Blob;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/api/exec/ChannelOutputStream;", "Ljava/io/OutputStream;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "Lfleet/rpc/core/Blob;", "<init>", "(Lkotlinx/coroutines/channels/SendChannel;)V", "getChannel", "()Lkotlinx/coroutines/channels/SendChannel;", "MAX_ARRAY_SIZE_SENT", "", "write", "", "b", "", "off", "len", "close", "fleet.protocol"})
public class ChannelOutputStream
extends OutputStream {
    @NotNull
    private final SendChannel<Blob> channel;
    private final int MAX_ARRAY_SIZE_SENT;

    public ChannelOutputStream(@NotNull SendChannel<? super Blob> channel) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        this.channel = channel;
        this.MAX_ARRAY_SIZE_SENT = 1024;
    }

    @NotNull
    public final SendChannel<Blob> getChannel() {
        return this.channel;
    }

    @Override
    public void write(int b) {
        byte[] byArray = new byte[]{(byte)b};
        Object result = ChannelsKt.trySendBlocking(this.channel, (Object)new Blob(byArray));
        if (ChannelResult.isClosed-impl((Object)result)) {
            throw new IOException("Unable to write, channel is closed");
        }
        if (ChannelResult.isFailure-impl((Object)result)) {
            throw new IOException("Unable to write to channel", ChannelResult.exceptionOrNull-impl((Object)result));
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int offset = off;
        while (offset < len + off) {
            int nextOffset = Math.min(offset + this.MAX_ARRAY_SIZE_SENT, len + off);
            byte[] byArray = b;
            Object result = ChannelsKt.trySendBlocking(this.channel, (Object)new Blob(ArraysKt.copyOfRange((byte[])byArray, (int)offset, (int)nextOffset)));
            if (ChannelResult.isClosed-impl((Object)result)) {
                throw new IOException("Unable to write, channel is closed");
            }
            if (ChannelResult.isFailure-impl((Object)result)) {
                throw new IOException("Unable to write to channel", ChannelResult.exceptionOrNull-impl((Object)result));
            }
            offset = nextOffset;
        }
    }

    @Override
    public void close() {
        SendChannel.DefaultImpls.close$default(this.channel, null, (int)1, null);
        super.close();
    }
}

