/*
 * Decompiled with CFR 0.152.
 */
package fleet.api;

import fleet.api.Os;
import fleet.api.PlatformKt;
import fleet.api.ProtocolPath$;
import fleet.api.ProtocolPathKt;
import fleet.api.Root;
import fleet.util.StringKt;
import fleet.util.logging.KLogger;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 =2\u00020\u0001:\u0002=>B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB5\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0000J\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0018\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0000J\u001f\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0018\"\u00020\u0006\u00a2\u0006\u0002\u0010 J\u0014\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020$J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0002J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u00102\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u00020\nH\u00d6\u0001J\t\u00104\u001a\u00020\u0006H\u00d6\u0001J%\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0001\u00a2\u0006\u0002\b<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010(\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006?"}, d2={"Lfleet/api/ProtocolPath;", "", "root", "Lfleet/api/Root;", "components", "", "", "<init>", "(Lfleet/api/Root;Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILfleet/api/Root;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getRoot", "()Lfleet/api/Root;", "getComponents", "()Ljava/util/List;", "parent", "isRoot", "", "sanitized", "child", "elements", "", "([Ljava/lang/String;)Lfleet/api/ProtocolPath;", "resolveChild", "relativePath", "startsWith", "other", "endsWith", "names", "([Ljava/lang/String;)Z", "relativeSegmentsTo", "joinToString", "separator", "", "toNio", "Ljava/nio/file/Path;", "rootString", "name", "getName", "()Ljava/lang/String;", "os", "Lfleet/api/Os;", "getOs", "()Lfleet/api/Os;", "component1", "component2", "copy", "equals", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$fleet_protocol", "Companion", "$serializer", "fleet.protocol"})
@SourceDebugExtension(value={"SMAP\nProtocolPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolPath.kt\nfleet/api/ProtocolPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,315:1\n1734#2,3:316\n1734#2,3:319\n37#3,2:322\n42#4,2:324\n*S KotlinDebug\n*F\n+ 1 ProtocolPath.kt\nfleet/api/ProtocolPath\n*L\n87#1:316,3\n95#1:319,3\n119#1:322,2\n123#1:324,2\n*E\n"})
public final class ProtocolPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Root root;
    @NotNull
    private final List<String> components;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public ProtocolPath(@NotNull Root root, @NotNull List<String> components) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.root = root;
        this.components = components;
    }

    @NotNull
    public final Root getRoot() {
        return this.root;
    }

    @NotNull
    public final List<String> getComponents() {
        return this.components;
    }

    @Nullable
    public final ProtocolPath parent() {
        return !((Collection)this.components).isEmpty() ? ProtocolPath.copy$default(this, null, CollectionsKt.dropLast(this.components, (int)1), 1, null) : null;
    }

    public final boolean isRoot() {
        return this.components.isEmpty();
    }

    @NotNull
    public final ProtocolPath sanitized() {
        return new ProtocolPath(this.root, Companion.sanitizeComponents(this.components));
    }

    @NotNull
    public final ProtocolPath child(String ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return ProtocolPath.copy$default(this, null, Companion.sanitizeComponents(CollectionsKt.plus((Collection)this.components, (Object[])elements)), 1, null);
    }

    @NotNull
    public final ProtocolPath child(@NotNull List<String> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return ProtocolPath.copy$default(this, null, Companion.sanitizeComponents(CollectionsKt.plus((Collection)this.components, (Iterable)elements)), 1, null);
    }

    @NotNull
    public final ProtocolPath resolveChild(@NotNull String relativePath2) {
        Intrinsics.checkNotNullParameter((Object)relativePath2, (String)"relativePath");
        return this.child(Companion.toComponents(relativePath2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean startsWith(@NotNull ProtocolPath other) {
        String b;
        Pair pair;
        String a;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.root, (Object)other.root)) return false;
        if (this.components.size() < other.components.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.components, (Iterable)other.components);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            pair = (Pair)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)(a = (String)pair.component1()), (Object)(b = (String)pair.component2())));
        return false;
    }

    public final boolean endsWith(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return this.endsWith(ArraysKt.toList((Object[])names));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean endsWith(@NotNull List<String> names) {
        String b;
        Pair pair;
        String a;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (this.components.size() < names.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)CollectionsKt.reversed((Iterable)this.components), (Iterable)CollectionsKt.reversed((Iterable)names));
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            pair = (Pair)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)(a = (String)pair.component1()), (Object)(b = (String)pair.component2())));
        return false;
    }

    @NotNull
    public final List<String> relativeSegmentsTo(@Nullable ProtocolPath other) {
        if (other == null || !this.startsWith(other)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.drop((Iterable)this.components, (int)other.components.size());
    }

    @NotNull
    public final String joinToString() {
        return this.joinToString(this.separator());
    }

    public final char separator() {
        return this.root.separator();
    }

    @NotNull
    public final String joinToString(char separator) {
        return this.rootString(separator) + Companion.joinToString(this.components, separator);
    }

    @Deprecated(message="There is no safe way to convert ProtocolPath to NIO path")
    @NotNull
    public final Path toNio() {
        Object object;
        String rootString = this.rootString(this.separator());
        try {
            Collection $this$toTypedArray$iv = this.components;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new String[0]);
            object = Path.of(rootString, Arrays.copyOf(object, ((String[])object).length));
        }
        catch (InvalidPathException e) {
            String firstComponent = !this.components.isEmpty() ? this.components.get(0) : "";
            KLogger this_$iv = ProtocolPathKt.access$getLogger$p();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Problem converting a path beginning with \"" + rootString + firstComponent + "\" to a NIO path";
                kLogger.error(throwable, (Object)string);
            }
            throw e;
        }
        return object;
    }

    private final String rootString(char separator) {
        return this.root instanceof Root.Windows ? "" + this.root + separator : this.root.toString();
    }

    @NotNull
    public final String getName() {
        String string = (String)CollectionsKt.lastOrNull(this.components);
        if (string == null) {
            string = this.root.toString();
        }
        return string;
    }

    @NotNull
    public final Os getOs() {
        Os os;
        Root root = this.root;
        if (Intrinsics.areEqual((Object)root, (Object)Root.Unix.INSTANCE)) {
            os = Os.Linux;
        } else if (root instanceof Root.Windows) {
            os = Os.Windows;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return os;
    }

    @NotNull
    public final Root component1() {
        return this.root;
    }

    @NotNull
    public final List<String> component2() {
        return this.components;
    }

    @NotNull
    public final ProtocolPath copy(@NotNull Root root, @NotNull List<String> components) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        return new ProtocolPath(root, components);
    }

    public static /* synthetic */ ProtocolPath copy$default(ProtocolPath protocolPath, Root root, List list, int n, Object object) {
        if ((n & 1) != 0) {
            root = protocolPath.root;
        }
        if ((n & 2) != 0) {
            list = protocolPath.components;
        }
        return protocolPath.copy(root, list);
    }

    @NotNull
    public String toString() {
        return "ProtocolPath(root=" + this.root + ", components=" + this.components + ")";
    }

    public int hashCode() {
        int result = this.root.hashCode();
        result = result * 31 + ((Object)this.components).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtocolPath)) {
            return false;
        }
        ProtocolPath protocolPath = (ProtocolPath)other;
        if (!Intrinsics.areEqual((Object)this.root, (Object)protocolPath.root)) {
            return false;
        }
        return Intrinsics.areEqual(this.components, protocolPath.components);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$fleet_protocol(ProtocolPath self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], (Object)self.root);
        output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.components);
    }

    public /* synthetic */ ProtocolPath(int seen0, Root root, List components, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.root = root;
        this.components = components;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{Root.Companion.serializer(), new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)};
        $childSerializers = kSerializerArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u0006`\b\"\u0004\b\u0000\u0010\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u0005j\b\u0012\u0004\u0012\u0002H\u0007`\bH\u0002J.\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0005j\b\u0012\u0004\u0012\u00020\u000b`\b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0005j\b\u0012\u0004\u0012\u00020\r`\bJ\u001c\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u001d\u001a\u00020\rJ\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b \u0010\u001bJ\u001c\u0010!\u001a\u00020\"*\u00020\r2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\"H\u0002J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010(\u001a\u00020)J\u0018\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010(\u001a\u00020)J#\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0004\b-\u0010.J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00\u00a8\u00061"}, d2={"Lfleet/api/ProtocolPath$Companion;", "", "<init>", "()V", "elementsComparator", "Ljava/util/Comparator;", "", "T", "Lkotlin/Comparator;", "cmp", "comparator", "Lfleet/api/ProtocolPath;", "componentsComparator", "", "joinToString", "components", "separator", "", "fromNioPath", "path", "Ljava/nio/file/Path;", "isUnixAbsolutePath", "", "str", "unixPath", "Lkotlin/Result;", "unixPath-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "toComponents", "pathString", "sanitizeComponents", "windowsPath", "windowsPath-IoAF18A", "nthIndexOf", "", "character", "n", "isAbsoluteDosPath", "isAbsoluteUncPath", "isAbsolutePath", "os", "Lfleet/api/Os;", "of", "ofOrNull", "parsePath", "parsePath-gIAlu-s", "(Lfleet/api/Os;Ljava/lang/String;)Ljava/lang/Object;", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.protocol"})
    @SourceDebugExtension(value={"SMAP\nProtocolPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolPath.kt\nfleet/api/ProtocolPath$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n1557#3:317\n1628#3,3:318\n*S KotlinDebug\n*F\n+ 1 ProtocolPath.kt\nfleet/api/ProtocolPath$Companion\n*L\n169#1:317\n169#1:318,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> Comparator<List<T>> elementsComparator(Comparator<T> cmp) {
            return (arg_0, arg_1) -> Companion.elementsComparator$lambda$0(cmp, arg_0, arg_1);
        }

        @NotNull
        public final Comparator<ProtocolPath> comparator(@NotNull Comparator<String> componentsComparator) {
            Intrinsics.checkNotNullParameter(componentsComparator, (String)"componentsComparator");
            Comparator<Object> comparator = Root.Companion.getComparator();
            Comparator comparator2 = new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    ProtocolPath protocolPath = (ProtocolPath)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    ProtocolPath it = (ProtocolPath)b;
                    Root root = it.getRoot();
                    bl = false;
                    Root root2 = it.getRoot();
                    return comparator.compare(root, root2);
                }
            };
            comparator = this.elementsComparator(componentsComparator);
            Comparator<ProtocolPath> comparator3 = ((Comparator)comparator2).thenComparing(new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    ProtocolPath protocolPath = (ProtocolPath)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    ProtocolPath it = (ProtocolPath)b;
                    List<String> list = it.getComponents();
                    bl = false;
                    List<String> list2 = it.getComponents();
                    return comparator.compare(list, list2);
                }
            });
            Intrinsics.checkNotNullExpressionValue(comparator3, (String)"thenComparing(...)");
            return comparator3;
        }

        @NotNull
        public final String joinToString(@NotNull List<String> components, char separator) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            return CollectionsKt.joinToString$default((Iterable)components, (CharSequence)String.valueOf(separator), null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Use with caution, it's much better to know yours target OS, see ProtocolPath#of", replaceWith=@ReplaceWith(expression="ProtocolPath.of(path, os)", imports={}))
        @NotNull
        public final ProtocolPath fromNioPath(@NotNull Path path) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.isAbsolute()) {
                throw new IllegalStateException((path + " is not absolute").toString());
            }
            Path path2 = path.getRoot();
            if (path2 == null) {
                boolean $i$a$-requireNotNull-ProtocolPath$Companion$fromNioPath$pathRoot$22 = false;
                String $i$a$-requireNotNull-ProtocolPath$Companion$fromNioPath$pathRoot$22 = "nio.Path.root should be not null in " + path;
                throw new IllegalArgumentException($i$a$-requireNotNull-ProtocolPath$Companion$fromNioPath$pathRoot$22.toString());
            }
            Path pathRoot = path2;
            char[] $i$a$-requireNotNull-ProtocolPath$Companion$fromNioPath$pathRoot$22 = new char[]{'\\'};
            String rootString = StringKt.uppercaseLocaleAgnostic((String)StringsKt.trimEnd((String)((Object)pathRoot).toString(), (char[])$i$a$-requireNotNull-ProtocolPath$Companion$fromNioPath$pathRoot$22));
            Root root = Intrinsics.areEqual((Object)rootString, (Object)"/") ? (Root)Root.Unix.INSTANCE : (Root)new Root.Windows(rootString);
            Path path3 = path.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"normalize(...)");
            Iterable iterable = path3;
            Root root2 = root;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path4 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            List list = (List)destination$iv$iv;
            Root root3 = root2;
            return new ProtocolPath(root3, list);
        }

        private final boolean isUnixAbsolutePath(String str) {
            return StringsKt.startsWith$default((String)str, (String)"/", (boolean)false, (int)2, null);
        }

        private final Object unixPath-IoAF18A(String str) {
            if (this.isUnixAbsolutePath(str)) {
                return Result.constructor-impl((Object)new ProtocolPath(Root.Unix.INSTANCE, this.sanitizeComponents(this.toComponents(StringsKt.drop((String)str, (int)1)))));
            }
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Path should start with '/' [" + str + "]")));
        }

        @NotNull
        public final List<String> toComponents(@NotNull String pathString) {
            List list;
            Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
            if (StringsKt.contains$default((CharSequence)pathString, (char)'\\', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)pathString, (char)'/', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\\'};
                list = StringsKt.split$default((CharSequence)pathString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else if (StringsKt.contains$default((CharSequence)pathString, (CharSequence)"/", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'/'};
                list = StringsKt.split$default((CharSequence)pathString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list = ((CharSequence)pathString).length() == 0 || Intrinsics.areEqual((Object)pathString, (Object)".") ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)pathString);
            }
            return list;
        }

        @NotNull
        public final List<String> sanitizeComponents(@NotNull List<String> components) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            LinkedList<String> list = new LinkedList<String>();
            for (String component : components) {
                if (Intrinsics.areEqual((Object)component, (Object)"..")) {
                    if (list.isEmpty()) {
                        return CollectionsKt.emptyList();
                    }
                    String cfr_ignored_0 = (String)list.removeLast();
                    continue;
                }
                if (!(((CharSequence)component).length() > 0) || Intrinsics.areEqual((Object)component, (Object)".")) continue;
                list.add(component);
            }
            return list;
        }

        private final Object windowsPath-IoAF18A(String str) {
            Object object;
            if (this.isAbsoluteDosPath(str)) {
                object = Result.constructor-impl((Object)new ProtocolPath(new Root.Windows(StringKt.uppercaseLocaleAgnostic((String)StringsKt.take((String)str, (int)2))), this.sanitizeComponents(this.toComponents(StringsKt.drop((String)str, (int)3)))));
            } else if (this.isAbsoluteUncPath(str)) {
                int fourthBackslashIndex = this.nthIndexOf(str, '\\', 4);
                if (fourthBackslashIndex != -1) {
                    String prefix = StringsKt.take((String)str, (int)fourthBackslashIndex);
                    String remainingPath = StringsKt.drop((String)str, (int)(fourthBackslashIndex + 1));
                    object = Result.constructor-impl((Object)new ProtocolPath(new Root.Windows(prefix), this.sanitizeComponents(this.toComponents(remainingPath))));
                } else {
                    object = Result.constructor-impl((Object)new ProtocolPath(new Root.Windows(str), CollectionsKt.emptyList()));
                }
            } else {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Path should start with a drive letter or a UNC share [" + str + "]")));
            }
            return object;
        }

        private final int nthIndexOf(String $this$nthIndexOf, char character, int n) {
            if (!(n > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int count = 0;
            int n2 = ((CharSequence)$this$nthIndexOf).length();
            for (int i = 0; i < n2; ++i) {
                if ($this$nthIndexOf.charAt(i) != character || ++count != n) continue;
                return i;
            }
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAbsoluteDosPath(@NotNull String path) {
            boolean bl;
            char c;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (path.length() < 2) return false;
            if (path.charAt(1) != ':') return false;
            if (path.length() != 2 && path.charAt(2) != '/') {
                if (path.charAt(2) != '\\') return false;
            }
            if ('a' <= (c = path.charAt(0))) {
                if (c < '{') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            c = path.charAt(0);
            if ('A' > c) return false;
            if (c >= '[') return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAbsoluteUncPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (path.length() < 6) return false;
            if (path.charAt(0) != '\\') return false;
            if (path.charAt(1) != '\\') return false;
            if (path.charAt(2) == '\\') return false;
            String string = path.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int it = StringsKt.indexOf$default((CharSequence)string, (char)'\\', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            if (it == -1) return false;
            if (path.length() <= it + 1) return false;
            if (path.charAt(it + 1) == '\\') return false;
            return true;
        }

        public final boolean isAbsolutePath(@NotNull String str, @NotNull Os os) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
            return PlatformKt.isWindows(os) ? this.isAbsoluteDosPath(str) || this.isAbsoluteUncPath(str) : (PlatformKt.isUnix(os) ? this.isUnixAbsolutePath(str) : false);
        }

        @NotNull
        public final ProtocolPath of(@NotNull String str, @NotNull Os os) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
            Object object = this.parsePath-gIAlu-s(os, str);
            ResultKt.throwOnFailure((Object)object);
            return (ProtocolPath)object;
        }

        @Nullable
        public final ProtocolPath ofOrNull(@NotNull String str, @NotNull Os os) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
            Object object = this.parsePath-gIAlu-s(os, str);
            return (ProtocolPath)(Result.isFailure-impl((Object)object) ? null : object);
        }

        @NotNull
        public final Object parsePath-gIAlu-s(@NotNull Os os, @NotNull String str) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (PlatformKt.isWindows(os)) {
                object = this.windowsPath-IoAF18A(str);
            } else if (PlatformKt.isUnix(os)) {
                object = this.unixPath-IoAF18A(str);
            } else {
                throw new IllegalStateException(("Can't create a path: " + str + " for unsupported " + os + ".").toString());
            }
            return object;
        }

        @NotNull
        public final KSerializer<ProtocolPath> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        private static final int elementsComparator$lambda$0(Comparator $cmp, List l1, List l2) {
            int m = Math.min(l1.size(), l2.size());
            for (int i = 0; i < m; ++i) {
                int c = $cmp.compare(l1.get(i), l2.get(i));
                if (c == 0) continue;
                return c;
            }
            return Intrinsics.compare((int)l1.size(), (int)l2.size());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

