/*
 * Decompiled with CFR 0.152.
 */
package fleet.api;

import fleet.api.EnvironmentOpts;
import fleet.api.ExecApi;
import fleet.api.IOError;
import fleet.api.OsAwareEnvironment;
import fleet.api.Platform;
import fleet.api.ProcessCommand;
import fleet.api.ProtocolPath;
import fleet.api.Pty;
import fleet.api.RemoteProcess;
import fleet.api.RpcResult;
import fleet.api.SpawnedProcess;
import fleet.rpc.core.Blob;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=3, xi=48)
public final class ExecApiClientStub
implements ExecApi {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public ExecApiClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Override
    @Nullable
    public final Object exec(@NotNull String executable, @NotNull List<String> arguments, @Nullable ProtocolPath workingDirectoryPath, @NotNull EnvironmentOpts environment, @NotNull ReceiveChannel<Blob> stdin, @NotNull ReceiveChannel<? extends ProcessCommand> control, @NotNull SendChannel<? super Blob> stdout2, @NotNull SendChannel<? super Blob> stderr2, @Nullable Pty pty, @NotNull Continuation<? super RpcResult<SpawnedProcess, ? extends IOError>> $completion) {
        Object[] objectArray = new Object[]{executable, arguments, workingDirectoryPath, environment, stdin, control, stdout2, stderr2, pty};
        return this.invocationHandler.invoke((Object)"exec", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object which(@NotNull String name, @NotNull Continuation<? super ProtocolPath> $completion) {
        Object[] objectArray = new Object[]{name};
        return this.invocationHandler.invoke((Object)"which", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object getPlatform(@NotNull Continuation<? super Platform> $completion) {
        return this.invocationHandler.invoke((Object)"getPlatform", (Object)new Object[0], $completion);
    }

    @Override
    @Nullable
    public final Object getEnvironmentInternal(@NotNull Continuation<? super OsAwareEnvironment> $completion) {
        return this.invocationHandler.invoke((Object)"getEnvironmentInternal", (Object)new Object[0], $completion);
    }

    @Override
    @Nullable
    public final Object getProcessList(@NotNull Continuation<? super List<RemoteProcess>> $completion) {
        return this.invocationHandler.invoke((Object)"getProcessList", (Object)new Object[0], $completion);
    }

    @Override
    @Nullable
    public final Object getProcessInfo(int pid, @NotNull Continuation<? super RemoteProcess> $completion) {
        Object[] objectArray = new Object[]{Boxing.boxInt((int)pid)};
        return this.invocationHandler.invoke((Object)"getProcessInfo", (Object)objectArray, $completion);
    }
}

