/*
 * Decompiled with CFR 0.152.
 */
package fleet.lang.intellij.common;

import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.lang.intellij.common.HighlightingNodeExtender;
import fleet.lang.intellij.common.HighlightingToken;
import fleet.lang.intellij.common.SyntaxExtenderKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lfleet/lang/intellij/common/HighlightingLexerNodeExtender;", "Lfleet/lang/intellij/common/HighlightingNodeExtender;", "lexerFactory", "Lkotlin/Function1;", "Lfleet/com/intellij/psi/tree/IElementType;", "Lkotlin/ParameterName;", "name", "type", "Lfleet/com/intellij/lexer/Lexer;", "(Lkotlin/jvm/functions/Function1;)V", "extend", "", "Lfleet/lang/intellij/common/HighlightingToken;", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "fleet.plugins.ij.parsing.common"})
public final class HighlightingLexerNodeExtender
implements HighlightingNodeExtender {
    @NotNull
    private final Function1<IElementType, Lexer> lexerFactory;

    public HighlightingLexerNodeExtender(@NotNull Function1<? super IElementType, ? extends Lexer> lexerFactory) {
        Intrinsics.checkNotNullParameter(lexerFactory, (String)"lexerFactory");
        this.lexerFactory = lexerFactory;
    }

    @Override
    @NotNull
    public List<HighlightingToken> extend(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Lexer lexer = (Lexer)this.lexerFactory.invoke((Object)SyntaxExtenderKt.getElementType(node));
        lexer.start(node.getText());
        ArrayList<HighlightingToken> tokens = new ArrayList<HighlightingToken>();
        while (lexer.getTokenType() != null) {
            IElementType iElementType = lexer.getTokenType();
            Intrinsics.checkNotNull((Object)iElementType);
            String string = lexer.getTokenText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
            tokens.add(new HighlightingToken(iElementType, string, node.getStartOffset() + (long)lexer.getTokenStart(), node.getStartOffset() + (long)lexer.getTokenEnd()));
            lexer.advance();
        }
        return tokens;
    }
}

