/*
 * Decompiled with CFR 0.152.
 */
package fleet.themes;

import androidx.compose.ui.graphics.Color;
import fleet.compose.theme.graphics.NoriaColorKt;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.keys.ThemeKind;
import fleet.themes.Colors;
import fleet.themes.FleetTheme;
import fleet.themes.KeyRetriever;
import fleet.themes.PTextAttributes;
import fleet.themes.Palette;
import fleet.themes.ThemeData;
import fleet.themes.ThemeLoaderKt;
import fleet.themes.ThemesKt;
import fleet.themes.serialization.ColorsSerializer;
import fleet.themes.serialization.PaletteSerializer;
import fleet.tracing.TracingKt;
import fleet.util.SettingsKt;
import fleet.util.logging.KLogger;
import fleet.util.serialization.SerializationKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import noria.model.Theme;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a;\u0010\u000e\u001a\u00020\u0003\"\u0006\b\u0000\u0010\u000f\u0018\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u000f0\u00140\u000bH\u0082\b\u001a\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0006\u0010\u0017\u001a\u00020\u0016\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a \u0010\u001b\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003\u001a\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0003H\u0002\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\u0003\u001a(\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010$\u001a\u0004\u0018\u00010\u00032\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0&H\u0002\u001a\f\u0010'\u001a\u00020\u001d*\u0004\u0018\u00010(\u001a$\u0010)\u001a\u00020**\u00020+2\u0016\u0010,\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030.\u0012\u0004\u0012\u00020\r0-H\u0002\u001a\n\u0010/\u001a\u00020\u0003*\u00020(\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020(H\u0002\u001a\n\u0010\u001b\u001a\u00020\u0016*\u00020(\u001a\f\u00100\u001a\u0004\u0018\u00010\u0003*\u00020(\u001a.\u00101\u001a\u00020\u0003*\u00020\"2\u0016\b\u0002\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"\u0018\u00010&H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00104\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00065"}, d2={"CURRENT_THEME_VERSION", "", "MAIN_PALETTE_HEADER", "", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "metaRetrievers", "", "Lfleet/themes/KeyRetriever;", "", "encodeThemeSection", "T", "json", "Lkotlinx/serialization/json/Json;", "name", "items", "Lkotlin/Pair;", "getIslandDarkTheme", "Lnoria/model/Theme;", "getIslandLightTheme", "loadData", "Lfleet/themes/ThemeData;", "themeContent", "loadFleetTheme", "isDefaultTheme", "", "idForLogging", "parseTheme", "text", "stringToColor", "Landroidx/compose/ui/graphics/Color;", "colorString", "color", "keyToColor", "", "canBeParsed", "Lfleet/themes/FleetTheme;", "collectMetaTo", "", "Lkotlinx/serialization/json/JsonObject;", "result", "", "Lnoria/model/ThemeKey;", "createEditableThemeContent", "readThemeFile", "toFleetThemeFormat", "paletteColors", "toFleetThemeFormat-DxMtmZc", "(JLjava/util/Map;)Ljava/lang/String;", "fleet.themes"})
@SourceDebugExtension(value={"SMAP\nThemeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeLoader.kt\nfleet/themes/ThemeLoaderKt\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KLogger.kt\nfleet/util/logging/KLogger\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,637:1\n122#1,2:646\n124#1,18:649\n122#1,2:667\n124#1,18:670\n122#1,2:692\n124#1,18:695\n113#2:638\n113#2:639\n113#2:640\n113#2:641\n113#2:648\n113#2:669\n113#2:694\n113#2:713\n113#2:714\n113#2:729\n125#3:642\n152#3,3:643\n125#3:688\n152#3,3:689\n494#4,7:715\n1#5:722\n41#6,2:723\n37#6,2:725\n288#7,2:727\n*S KotlinDebug\n*F\n+ 1 ThemeLoader.kt\nfleet/themes/ThemeLoaderKt\n*L\n111#1:646,2\n111#1:649,18\n113#1:667,2\n113#1:670,18\n115#1:692,2\n115#1:695,18\n104#1:638\n107#1:639\n108#1:640\n109#1:641\n111#1:648\n113#1:669\n115#1:694\n123#1:713\n132#1:714\n98#1:729\n111#1:642\n111#1:643,3\n115#1:688\n115#1:689,3\n145#1:715,7\n171#1:723,2\n189#1:725,2\n237#1:727,2\n*E\n"})
public final class ThemeLoaderKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    private static final List<KeyRetriever<? extends Object>> metaRetrievers;
    @NotNull
    private static final String MAIN_PALETTE_HEADER = "palette";
    private static final int CURRENT_THEME_VERSION = 8;

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    @NotNull
    public static final Theme loadFleetTheme(@NotNull FleetTheme $this$loadFleetTheme) {
        Intrinsics.checkNotNullParameter((Object)$this$loadFleetTheme, (String)"<this>");
        String content = ThemeLoaderKt.readThemeFile($this$loadFleetTheme);
        return ThemeLoaderKt.loadFleetTheme(content, $this$loadFleetTheme.isDefaultTheme(), $this$loadFleetTheme.getId().getId());
    }

    @NotNull
    public static final Theme loadFleetTheme(@Nullable String themeContent, boolean isDefaultTheme, @NotNull String idForLogging) {
        Intrinsics.checkNotNullParameter((Object)idForLogging, (String)"idForLogging");
        return (Theme)TracingKt.span$default((String)"loadNoriaTheme", null, (Function0)((Function0)new Function0<Theme>(themeContent, isDefaultTheme, idForLogging){
            final /* synthetic */ String $themeContent;
            final /* synthetic */ boolean $isDefaultTheme;
            final /* synthetic */ String $idForLogging;
            {
                this.$themeContent = $themeContent;
                this.$isDefaultTheme = $isDefaultTheme;
                this.$idForLogging = $idForLogging;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Theme invoke() {
                Theme theme;
                void this_$iv;
                ThemeData themeData;
                String string = this.$themeContent;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    themeData = ThemeLoaderKt.access$loadData(it);
                } else {
                    themeData = null;
                }
                ThemeData thisData = themeData;
                KLogger kLogger = ThemeLoaderKt.access$getLogger();
                String string2 = this.$idForLogging;
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    void var6_8 = this_$iv;
                    boolean bl = false;
                    var6_8.debug((Object)("Loading theme: " + string2 + ", data==null: " + (thisData == null)));
                }
                if (this.$isDefaultTheme) {
                    theme = ThemeData.Companion.getMINIMAL().merge(thisData);
                    theme = new Theme(theme.toMap());
                } else if (thisData == null) {
                    theme = ThemeData.Companion.getMINIMAL().merge(ThemeLoaderKt.access$loadData(ThemesKt.getDEFAULT_THEME()));
                    theme = new Theme(theme.toMap());
                } else {
                    Object object = thisData.getMeta().get(ThemeKeys.INSTANCE.getThemeKind());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.compose.theme.keys.ThemeKind");
                    ThemeKind themeKind = (ThemeKind)object;
                    ThemeData defaultThemeData = switch (loadFleetTheme.WhenMappings.$EnumSwitchMapping$0[themeKind.ordinal()]) {
                        case 1 -> ThemeLoaderKt.access$loadData(ThemesKt.getTHEME_DEFAULT_LIGHT());
                        case 2 -> ThemeLoaderKt.access$loadData(ThemesKt.getTHEME_DEFAULT_DARK());
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    ThemeData theme2 = ThemeData.Companion.getMINIMAL().merge(defaultThemeData).merge(thisData);
                    theme = new Theme(theme2.toMap());
                }
                return theme;
            }
        }), (int)2, null);
    }

    @NotNull
    public static final Theme getIslandLightTheme() {
        return new Theme(ThemeData.Companion.getMINIMAL().merge(ThemeLoaderKt.loadData(ThemesKt.getTHEME_DEFAULT_LIGHT())).merge(ThemeLoaderKt.loadData(ThemesKt.getTHEME_ISLANDS_LIGHT())).toMap());
    }

    @NotNull
    public static final Theme getIslandDarkTheme() {
        return new Theme(ThemeData.Companion.getMINIMAL().merge(ThemeLoaderKt.loadData(ThemesKt.getTHEME_DEFAULT_DARK())).merge(ThemeLoaderKt.loadData(ThemesKt.getTHEME_ISLANDS_DARK())).toMap());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createEditableThemeContent(@NotNull FleetTheme $this$createEditableThemeContent) {
        StringBuilder stringBuilder;
        boolean $i$f$encodeToString;
        String[] $this$encodeToString$iv$iv;
        String section$iv;
        Object value$iv;
        String key$iv;
        Map<String, Color> items$iv;
        String name$iv;
        Collection collection;
        Object $this$mapTo$iv$iv;
        List $this$map$iv;
        Object $this$encodeToString$iv;
        CharSequence $this$encodeToString$iv2;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)$this$createEditableThemeContent, (String)"<this>");
        ThemeData themeData = ThemeData.Companion.getMINIMAL().merge(ThemeLoaderKt.loadData($this$createEditableThemeContent));
        Json json2 = JsonKt.Json$default(null, (Function1)createEditableThemeContent.json.1.INSTANCE, (int)1, null);
        StringBuilder $this$createEditableThemeContent_u24lambda_u242 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder3 = $this$createEditableThemeContent_u24lambda_u242.append("{");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        Object object = themeData.getMeta().get(ThemeKeys.INSTANCE.getThemeName());
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = $this$createEditableThemeContent.getId().getId();
        }
        String name = ThemeLoaderKt.createEditableThemeContent$quote(json2, string + " - Edited");
        String kind = ThemeLoaderKt.createEditableThemeContent$quote(json2, String.valueOf(themeData.getMeta().get(ThemeKeys.INSTANCE.getThemeKind())));
        StringFormat stringFormat = (StringFormat)json2;
        Object object2 = themeData.getMeta().get(ThemeKeys.INSTANCE.getThemeVersion());
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
        Integer value$iv2 = (Integer)object2;
        boolean $i$f$encodeToString2 = false;
        $this$encodeToString$iv2.getSerializersModule();
        String version = $this$encodeToString$iv2.encodeToString((SerializationStrategy)IntSerializer.INSTANCE, value$iv2);
        StringBuilder stringBuilder4 = $this$createEditableThemeContent_u24lambda_u242.append("  \"meta\": {");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        $this$encodeToString$iv2 = $this$createEditableThemeContent_u24lambda_u242;
        value$iv2 = (StringFormat)json2;
        String value$iv3 = ThemeKeys.INSTANCE.getThemeName().getName();
        boolean $i$f$encodeToString3 = false;
        $this$encodeToString$iv.getSerializersModule();
        StringBuilder stringBuilder5 = $this$encodeToString$iv2.append("    " + $this$encodeToString$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)value$iv3) + ": " + name + ",");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        $this$encodeToString$iv2 = $this$createEditableThemeContent_u24lambda_u242;
        $this$encodeToString$iv = (StringFormat)json2;
        String value$iv4 = ThemeKeys.INSTANCE.getThemeKind().getName();
        boolean $i$f$encodeToString4 = false;
        $this$encodeToString$iv.getSerializersModule();
        StringBuilder stringBuilder6 = $this$encodeToString$iv2.append("    " + $this$encodeToString$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)value$iv4) + ": " + kind + ",");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        $this$encodeToString$iv2 = $this$createEditableThemeContent_u24lambda_u242;
        $this$encodeToString$iv = (StringFormat)json2;
        value$iv4 = ThemeKeys.INSTANCE.getThemeVersion().getName();
        boolean $i$f$encodeToString232 = false;
        $this$encodeToString$iv.getSerializersModule();
        StringBuilder stringBuilder7 = $this$encodeToString$iv2.append("    " + $this$encodeToString$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)value$iv4) + ": " + version);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = $this$createEditableThemeContent_u24lambda_u242.append("  },");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        $this$encodeToString$iv2 = "colors";
        $this$encodeToString$iv = themeData.getColors().getColors();
        StringBuilder stringBuilder9 = $this$createEditableThemeContent_u24lambda_u242;
        boolean $i$f$map = false;
        void $i$f$encodeToString232 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Object object3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            void it;
            Map.Entry entry;
            Map.Entry entry2 = entry = object3.next();
            collection = destination$iv$iv;
            boolean bl22 = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)ThemeLoaderKt.toFleetThemeFormat-DxMtmZc(((Color)it.getValue()).unbox-impl(), themeData.getPalette().getColors())));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$encodeThemeSection = false;
        $this$mapTo$iv$iv = new StringBuilder();
        StringBuilder $this$encodeThemeSection_u24lambda_u243$iv = $this$mapTo$iv$iv;
        boolean bl3 = false;
        object3 = $this$encodeThemeSection_u24lambda_u243$iv;
        StringFormat stringFormat2 = (StringFormat)json2;
        boolean $i$f$encodeToString3232 = false;
        stringFormat2.getSerializersModule();
        String string2 = "  " + stringFormat2.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)name$iv) + ": {";
        StringBuilder stringBuilder10 = ((StringBuilder)object3).append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        Pair pair = (Pair)CollectionsKt.lastOrNull((List)((Object)items$iv));
        Object lastItem$iv = pair != null ? (String)pair.getFirst() : null;
        Object var17_23 = null;
        Iterator $i$f$encodeToString3232 = items$iv.iterator();
        while ($i$f$encodeToString3232.hasNext()) {
            void var17_24;
            Pair bl22 = (Pair)$i$f$encodeToString3232.next();
            key$iv = (String)bl22.component1();
            value$iv = bl22.component2();
            String[] stringArray = new String[]{"."};
            section$iv = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)key$iv, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (var17_24 != null && !Intrinsics.areEqual((Object)var17_24, (Object)section$iv) && !Intrinsics.areEqual((Object)section$iv, (Object)key$iv)) {
                StringBuilder stringBuilder11 = $this$encodeThemeSection_u24lambda_u243$iv.append("");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
            }
            String string3 = section$iv;
            $this$encodeToString$iv$iv = (String[])json2;
            $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            String string4 = $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)key$iv);
            $this$encodeToString$iv$iv = (StringFormat)json2;
            $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            $this$encodeThemeSection_u24lambda_u243$iv.append(StringsKt.prependIndent((String)(string4 + ": " + $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, value$iv)), (String)"    "));
            if (!Intrinsics.areEqual((Object)key$iv, (Object)lastItem$iv)) {
                StringBuilder stringBuilder12 = $this$encodeThemeSection_u24lambda_u243$iv.append(",");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
                continue;
            }
            StringBuilder stringBuilder13 = $this$encodeThemeSection_u24lambda_u243$iv.append("");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append(...)");
        }
        $this$encodeThemeSection_u24lambda_u243$iv.append("  }");
        String string5 = ((StringBuilder)$this$mapTo$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        stringBuilder9.append(string5);
        StringBuilder stringBuilder14 = $this$createEditableThemeContent_u24lambda_u242.append(",");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
        name$iv = "textAttributes";
        Map<String, Object> map = themeData.getTextAttributes();
        if (map == null || (map = MapsKt.toList(map)) == null) {
            map = CollectionsKt.emptyList();
        }
        items$iv = map;
        stringBuilder9 = $this$createEditableThemeContent_u24lambda_u242;
        $i$f$encodeThemeSection = false;
        $this$mapTo$iv$iv = new StringBuilder();
        $this$encodeThemeSection_u24lambda_u243$iv = $this$mapTo$iv$iv;
        boolean bl2 = false;
        lastItem$iv = $this$encodeThemeSection_u24lambda_u243$iv;
        StringFormat stringFormat3 = (StringFormat)json2;
        boolean $i$f$encodeToString432 = false;
        stringFormat3.getSerializersModule();
        String string6 = "  " + stringFormat3.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)name$iv) + ": {";
        StringBuilder stringBuilder15 = ((StringBuilder)lastItem$iv).append(string6);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
        Pair pair2 = (Pair)CollectionsKt.lastOrNull((List)((Object)items$iv));
        lastItem$iv = pair2 != null ? (String)pair2.getFirst() : null;
        Object var17_28 = null;
        Object $i$f$encodeToString432 = items$iv.iterator();
        while ($i$f$encodeToString432.hasNext()) {
            void var17_29;
            Pair bl22 = (Pair)$i$f$encodeToString432.next();
            key$iv = (String)bl22.component1();
            value$iv = bl22.component2();
            $this$encodeToString$iv$iv = new String[]{"."};
            section$iv = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)key$iv, (String[])$this$encodeToString$iv$iv, (boolean)false, (int)0, (int)6, null));
            if (var17_29 != null && !Intrinsics.areEqual((Object)var17_29, (Object)section$iv) && !Intrinsics.areEqual((Object)section$iv, (Object)key$iv)) {
                StringBuilder stringBuilder16 = $this$encodeThemeSection_u24lambda_u243$iv.append("");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16.append('\n'), (String)"append(...)");
            }
            String string7 = section$iv;
            $this$encodeToString$iv$iv = (String[])json2;
            $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            String string8 = $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)key$iv);
            $this$encodeToString$iv$iv = (StringFormat)json2;
            $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            $this$encodeThemeSection_u24lambda_u243$iv.append(StringsKt.prependIndent((String)(string8 + ": " + $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)PTextAttributes.Companion.serializer(), value$iv)), (String)"    "));
            if (!Intrinsics.areEqual((Object)key$iv, (Object)lastItem$iv)) {
                StringBuilder stringBuilder17 = $this$encodeThemeSection_u24lambda_u243$iv.append(",");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append(...)");
                continue;
            }
            StringBuilder stringBuilder18 = $this$encodeThemeSection_u24lambda_u243$iv.append("");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append(...)");
        }
        $this$encodeThemeSection_u24lambda_u243$iv.append("  }");
        String string9 = ((StringBuilder)$this$mapTo$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(...)");
        stringBuilder9.append(string9);
        StringBuilder stringBuilder19 = $this$createEditableThemeContent_u24lambda_u242.append(",");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19.append('\n'), (String)"append(...)");
        name$iv = MAIN_PALETTE_HEADER;
        items$iv = themeData.getPalette().getColors();
        stringBuilder9 = $this$createEditableThemeContent_u24lambda_u242;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            $i$f$encodeToString432 = entry;
            collection = destination$iv$iv;
            boolean bl4 = false;
            String k = (String)$i$f$encodeToString432.getKey();
            long c = ((Color)$i$f$encodeToString432.getValue()).unbox-impl();
            collection.add(TuplesKt.to((Object)k, (Object)ThemeLoaderKt.toFleetThemeFormat-DxMtmZc$default(c, null, 1, null)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$encodeThemeSection = false;
        $this$encodeThemeSection_u24lambda_u243$iv = stringBuilder = new StringBuilder();
        bl2 = false;
        lastItem$iv = $this$encodeThemeSection_u24lambda_u243$iv;
        StringFormat stringFormat4 = (StringFormat)json2;
        boolean $i$f$encodeToString5 = false;
        stringFormat4.getSerializersModule();
        String string10 = "  " + stringFormat4.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)name$iv) + ": {";
        StringBuilder stringBuilder20 = ((StringBuilder)lastItem$iv).append(string10);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20.append('\n'), (String)"append(...)");
        Pair pair3 = (Pair)CollectionsKt.lastOrNull(items$iv);
        lastItem$iv = pair3 != null ? (String)pair3.getFirst() : null;
        Object var17_35 = null;
        Iterator iterator = items$iv.iterator();
        while (iterator.hasNext()) {
            void var17_36;
            Pair pair4 = (Pair)iterator.next();
            key$iv = (String)pair4.component1();
            value$iv = pair4.component2();
            $this$encodeToString$iv$iv = new String[]{"."};
            section$iv = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)key$iv, (String[])$this$encodeToString$iv$iv, (boolean)false, (int)0, (int)6, null));
            if (var17_36 != null && !Intrinsics.areEqual((Object)var17_36, (Object)section$iv) && !Intrinsics.areEqual((Object)section$iv, (Object)key$iv)) {
                StringBuilder stringBuilder21 = $this$encodeThemeSection_u24lambda_u243$iv.append("");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21.append('\n'), (String)"append(...)");
            }
            String string11 = section$iv;
            $this$encodeToString$iv$iv = (String[])json2;
            $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            String string12 = $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)key$iv);
            $this$encodeToString$iv$iv = (StringFormat)json2;
            $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            $this$encodeThemeSection_u24lambda_u243$iv.append(StringsKt.prependIndent((String)(string12 + ": " + $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, value$iv)), (String)"    "));
            if (!Intrinsics.areEqual((Object)key$iv, (Object)lastItem$iv)) {
                StringBuilder stringBuilder22 = $this$encodeThemeSection_u24lambda_u243$iv.append(",");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22.append('\n'), (String)"append(...)");
                continue;
            }
            StringBuilder stringBuilder23 = $this$encodeThemeSection_u24lambda_u243$iv.append("");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23.append('\n'), (String)"append(...)");
        }
        $this$encodeThemeSection_u24lambda_u243$iv.append("  }");
        String string13 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toString(...)");
        stringBuilder9.append(string13);
        StringBuilder stringBuilder24 = $this$createEditableThemeContent_u24lambda_u242.append("");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder25 = $this$createEditableThemeContent_u24lambda_u242.append("}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder25, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder25.append('\n'), (String)"append(...)");
        String string14 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toString(...)");
        return string14;
    }

    private static final /* synthetic */ <T> String encodeThemeSection(Json json2, String name, List<? extends Pair<String, ? extends T>> items) {
        StringBuilder stringBuilder;
        boolean $i$f$encodeThemeSection = false;
        StringBuilder $this$encodeThemeSection_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$encodeThemeSection_u24lambda_u243;
        Object $this$encodeToString$iv = (StringFormat)json2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        $this$encodeToString$iv = "  " + $this$encodeToString$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)name) + ": {";
        StringBuilder stringBuilder3 = stringBuilder2.append((String)$this$encodeToString$iv);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        Pair pair = (Pair)CollectionsKt.lastOrNull(items);
        String lastItem = pair != null ? (String)pair.getFirst() : null;
        String lastSection = null;
        for (Pair<String, T> pair2 : items) {
            String key = (String)pair2.component1();
            Object value = pair2.component2();
            String[] stringArray = new String[]{"."};
            String section = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (lastSection != null && !Intrinsics.areEqual((Object)lastSection, (Object)section) && !Intrinsics.areEqual((Object)section, (Object)key)) {
                StringBuilder stringBuilder4 = $this$encodeThemeSection_u24lambda_u243.append("");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            }
            lastSection = section;
            StringFormat $this$encodeToString$iv2 = (StringFormat)json2;
            boolean $i$f$encodeToString2 = false;
            $this$encodeToString$iv2.getSerializersModule();
            String string = $this$encodeToString$iv2.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)key);
            StringFormat $this$encodeToString$iv3 = (StringFormat)json2;
            boolean $i$f$encodeToString3 = false;
            SerializersModule serializersModule = $this$encodeToString$iv3.getSerializersModule();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            $this$encodeThemeSection_u24lambda_u243.append(StringsKt.prependIndent((String)(string + ": " + $this$encodeToString$iv3.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), value)), (String)"    "));
            if (!Intrinsics.areEqual((Object)key, (Object)lastItem)) {
                StringBuilder stringBuilder5 = $this$encodeThemeSection_u24lambda_u243.append(",");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
                continue;
            }
            StringBuilder stringBuilder6 = $this$encodeThemeSection_u24lambda_u243.append("");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        }
        $this$encodeThemeSection_u24lambda_u243.append("  }");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String toFleetThemeFormat-DxMtmZc(long $this$toFleetThemeFormat_u2dDxMtmZc, Map<String, Color> paletteColors) {
        if (paletteColors != null) {
            String string;
            Map<String, Color> $this$filterValues$iv = paletteColors;
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, Color> result$iv = new LinkedHashMap<String, Color>();
            for (Map.Entry<String, Color> entry$iv : $this$filterValues$iv.entrySet()) {
                long it = entry$iv.getValue().unbox-impl();
                boolean bl = false;
                if (!Color.equals-impl0((long)it, (long)$this$toFleetThemeFormat_u2dDxMtmZc)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Set set = ((Map)result$iv).keySet();
            if (set != null && (string = (String)CollectionsKt.firstOrNull((Iterable)set)) != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
        }
        String alpha = !(Color.getAlpha-impl((long)$this$toFleetThemeFormat_u2dDxMtmZc) == 1.0f) ? ThemeLoaderKt.toFleetThemeFormat_DxMtmZc$hex(Color.getAlpha-impl((long)$this$toFleetThemeFormat_u2dDxMtmZc)) : "";
        String string = ("#" + ThemeLoaderKt.toFleetThemeFormat_DxMtmZc$hex(Color.getRed-impl((long)$this$toFleetThemeFormat_u2dDxMtmZc)) + ThemeLoaderKt.toFleetThemeFormat_DxMtmZc$hex(Color.getGreen-impl((long)$this$toFleetThemeFormat_u2dDxMtmZc)) + ThemeLoaderKt.toFleetThemeFormat_DxMtmZc$hex(Color.getBlue-impl((long)$this$toFleetThemeFormat_u2dDxMtmZc)) + alpha).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    static /* synthetic */ String toFleetThemeFormat-DxMtmZc$default(long l, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = null;
        }
        return ThemeLoaderKt.toFleetThemeFormat-DxMtmZc(l, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean canBeParsed(@Nullable FleetTheme $this$canBeParsed) {
        boolean bl;
        if ($this$canBeParsed == null) {
            return false;
        }
        try {
            InputStream inputStream = (InputStream)$this$canBeParsed.getLoader().getInputProvider$fleet_themes().invoke();
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                boolean bl2 = false;
                Closeable closeable = inputStream2;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader p0 = (BufferedReader)closeable;
                    boolean bl3 = false;
                    object2 = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object content = object2;
                ThemeLoaderKt.parseTheme((String)content);
            }
            bl = true;
        }
        catch (Throwable e) {
            KLogger this_$iv = ThemeLoaderKt.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl4 = false;
                String string = "Unable to parse " + $this$canBeParsed.getId() + " theme";
                kLogger.error(throwable, (Object)string);
            }
            bl = false;
        }
        return bl;
    }

    private static final ThemeData loadData(FleetTheme $this$loadData) {
        ThemeData themeData;
        String string = ThemeLoaderKt.readThemeFile($this$loadData);
        if (string != null) {
            String it = string;
            boolean bl = false;
            themeData = ThemeLoaderKt.loadData(it);
        } else {
            themeData = null;
        }
        return themeData;
    }

    private static final ThemeData loadData(String themeContent) {
        return ThemeLoaderKt.parseTheme(themeContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String readThemeFile(@NotNull FleetTheme $this$readThemeFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$readThemeFile, (String)"<this>");
        try {
            Object object2;
            InputStream inputStream = (InputStream)$this$readThemeFile.getLoader().getInputProvider$fleet_themes().invoke();
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Object object3 = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object3);
                int n = 8192;
                closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object3 = null;
                try {
                    Object p0 = (BufferedReader)closeable;
                    boolean bl = false;
                    p0 = TextStreamsKt.readText((Reader)((Reader)p0));
                    object2 = p0;
                }
                catch (Throwable p0) {
                    object3 = p0;
                    throw p0;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (Throwable e) {
            KLogger this_$iv = ThemeLoaderKt.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Unable to read theme " + $this$readThemeFile.getId();
                kLogger.warn(throwable, (Object)string);
            }
            object = null;
        }
        return object;
    }

    private static final ThemeData parseTheme(String text) {
        return (ThemeData)TracingKt.span$default((String)"parseTheme", null, (Function0)((Function0)new Function0<ThemeData>(text){
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super(0);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final ThemeData invoke() {
                parsed = SettingsKt.parseJsonSettingsToJsonElement((String)this.$text);
                var3_2 = (JsonElement)parsed.get((Object)"palette");
                if (var3_2 == null || (var4_3 = JsonElementKt.getJsonObject((JsonElement)var3_2)) == null) ** GOTO lbl-1000
                it = var4_3;
                $i$a$-let-ThemeLoaderKt$parseTheme$1$palette$1 = false;
                var5_7 = (Palette)SerializationKt.getDefaultJson().decodeFromJsonElement((DeserializationStrategy)PaletteSerializer.INSTANCE, (JsonElement)it);
                if (var5_7 != null) {
                    v0 = Palette.copy$default(var5_7, "palette", null, 2, null);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                palette = v0;
                v1 = (JsonElement)parsed.get((Object)"meta");
                metaConfig = v1 != null ? JsonElementKt.getJsonObject((JsonElement)v1) : null;
                metaMap = new LinkedHashMap<K, V>();
                v2 = metaConfig;
                if (v2 != null) {
                    ThemeLoaderKt.access$collectMetaTo(v2, metaMap);
                }
                if ((v3 = (JsonElement)parsed.get((Object)"textAttributes")) != null && (v3 = JsonElementKt.getJsonObject((JsonElement)v3)) != null) {
                    $this$mapValues$iv = (Map)v3;
                    $i$f$mapValues = false;
                    var11_12 = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    $i$f$mapValuesTo = false;
                    $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        var18_23 = (Map.Entry)element$iv$iv$iv;
                        var19_24 = destination$iv$iv;
                        $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                        var21_27 = (Map.Entry)element$iv$iv$iv;
                        var27_31 = it$iv$iv.getKey();
                        var26_30 = var19_24;
                        $i$a$-mapValues-ThemeLoaderKt$parseTheme$1$attributesMap$1 = false;
                        value = (JsonElement)var21_27.getValue();
                        var28_32 = (PTextAttributes)SerializationKt.getDefaultJson().decodeFromJsonElement((DeserializationStrategy)PTextAttributes.Companion.serializer(), value);
                        var26_30.put(var27_31, var28_32);
                    }
                    v4 = destination$iv$iv;
                } else {
                    v5 = (JsonElement)parsed.get((Object)"text-attributes");
                    if (v5 != null && (v5 = JsonElementKt.getJsonObject((JsonElement)v5)) != null) {
                        $this$mapValues$iv = (Map)v5;
                        $i$f$mapValues = false;
                        $i$f$mapValuesTo = $this$mapValues$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        $i$f$mapValuesTo = false;
                        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        $i$f$associateByTo = false;
                        for (E element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = (Map.Entry)element$iv$iv$iv;
                            var21_27 = destination$iv$iv;
                            $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                            var23_29 = (Map.Entry)element$iv$iv$iv;
                            var27_31 = it$iv$iv.getKey();
                            var26_30 = var21_27;
                            $i$a$-mapValues-ThemeLoaderKt$parseTheme$1$attributesMap$2 = false;
                            value = (JsonElement)var23_29.getValue();
                            var28_32 = (PTextAttributes)SerializationKt.getDefaultJson().decodeFromJsonElement((DeserializationStrategy)PTextAttributes.Companion.serializer(), value);
                            var26_30.put(var27_31, var28_32);
                        }
                        v4 = destination$iv$iv;
                    } else {
                        v4 = null;
                    }
                }
                attributesMap = v4;
                var7_4 = (JsonElement)parsed.get((Object)"colors");
                if (var7_4 != null && (var8_6 = JsonElementKt.getJsonObject((JsonElement)var7_4)) != null) {
                    it = var8_6;
                    $i$a$-let-ThemeLoaderKt$parseTheme$1$colors$1 = false;
                    v6 = (Colors)SerializationKt.getDefaultJson().decodeFromJsonElement((DeserializationStrategy)new ColorsSerializer(palette), (JsonElement)it);
                } else {
                    v6 = null;
                }
                colors = v6;
                v7 = MapsKt.emptyMap();
                v8 = colors;
                if (v8 == null) {
                    v8 = Colors.Companion.getEmpty();
                }
                if ((v9 = palette) == null) {
                    v9 = Palette.Companion.getEmpty();
                }
                return new ThemeData(metaMap, attributesMap, v7, v8, v9);
            }
        }), (int)2, null);
    }

    private static final void collectMetaTo(JsonObject $this$collectMetaTo, Map<ThemeKey<?>, Object> result) {
        for (Map.Entry entry : ((Map)$this$collectMetaTo).entrySet()) {
            Object retrieved;
            Object object;
            Object var8_8;
            KeyRetriever retriever;
            Object v0;
            JsonPrimitive value;
            block4: {
                String key = (String)entry.getKey();
                JsonElement v = (JsonElement)entry.getValue();
                value = JsonElementKt.getJsonPrimitive((JsonElement)v);
                Iterable $this$firstOrNull$iv = metaRetrievers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KeyRetriever it = (KeyRetriever)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKey().getName(), (Object)key)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            if ((retriever = (var8_8 = v0) instanceof KeyRetriever ? (KeyRetriever)var8_8 : null) == null) continue;
            try {
                object = retriever.getRetrieve().invoke((Object)value.getContent());
            }
            catch (Throwable throwable) {
                object = null;
            }
            if ((retrieved = object) == null || !((Boolean)retriever.getValidate().invoke(retrieved)).booleanValue()) continue;
            result.put(retriever.getKey(), retrieved);
        }
    }

    private static final Color stringToColor(String color, Map<String, Color> keyToColor) {
        String string;
        block3: {
            block2: {
                string = color;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Color color2 = keyToColor.get(it);
                string = color2;
                if (color2 != null) break block3;
            }
            string = ThemeLoaderKt.stringToColor(color);
        }
        return string;
    }

    @Nullable
    public static final Color stringToColor(@Nullable String colorString) {
        Color color;
        if (colorString == null) {
            return null;
        }
        try {
            long l;
            String string;
            if (StringsKt.startsWith$default((String)colorString, (String)"#", (boolean)false, (int)2, null)) {
                String string2 = colorString.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = colorString;
            }
            String color2 = string;
            if (StringsKt.endsWith$default((String)color2, (String)"%", (boolean)false, (int)2, null)) {
                String string3 = color2.substring(0, 6);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String mainPart = string3;
                String string4 = color2.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                char[] cArray = new char[]{'%'};
                String alpha = StringsKt.trimEnd((String)string4, (char[])cArray);
                l = Color.copy-wmQWz5c$default((long)NoriaColorKt.css((Color.Companion)Color.Companion, (String)mainPart), (float)(Float.parseFloat(alpha) / (float)100), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
            } else {
                l = NoriaColorKt.css((Color.Companion)Color.Companion, (String)color2);
            }
            color = Color.box-impl((long)l);
        }
        catch (Throwable ignore) {
            color = null;
        }
        return color;
    }

    private static final String createEditableThemeContent$quote(Json json2, String s) {
        StringFormat $this$encodeToString$iv = (StringFormat)json2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)s);
    }

    private static final String toFleetThemeFormat_DxMtmZc$hex(float x) {
        String string = "%02x";
        Object[] objectArray = new Object[]{(long)(x * 255.0f)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final /* synthetic */ Color access$stringToColor(String color, Map keyToColor) {
        return ThemeLoaderKt.stringToColor(color, keyToColor);
    }

    public static final /* synthetic */ KLogger access$getLogger() {
        return ThemeLoaderKt.getLogger();
    }

    public static final /* synthetic */ ThemeData access$loadData(FleetTheme $receiver) {
        return ThemeLoaderKt.loadData($receiver);
    }

    public static final /* synthetic */ ThemeData access$loadData(String themeContent) {
        return ThemeLoaderKt.loadData(themeContent);
    }

    public static final /* synthetic */ void access$collectMetaTo(JsonObject $receiver, Map result) {
        ThemeLoaderKt.collectMetaTo($receiver, result);
    }

    static {
        Object[] objectArray = new KeyRetriever[]{new KeyRetriever(ThemeKeys.INSTANCE.getThemeName(), metaRetrievers.1.INSTANCE, metaRetrievers.2.INSTANCE), new KeyRetriever(ThemeKeys.INSTANCE.getThemeKind(), metaRetrievers.3.INSTANCE, metaRetrievers.4.INSTANCE), new KeyRetriever(ThemeKeys.INSTANCE.getThemeVersion(), metaRetrievers.5.INSTANCE, metaRetrievers.6.INSTANCE)};
        metaRetrievers = CollectionsKt.listOf((Object[])objectArray);
    }
}

