/*
 * Decompiled with CFR 0.152.
 */
package fleet.themes;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.themes.Colors;
import fleet.themes.FigmaOptimizedText;
import fleet.themes.PFontSpec;
import fleet.themes.PTextAttributes;
import fleet.themes.PTextSpec;
import fleet.themes.Palette;
import fleet.themes.ThemeData;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000 02\u00020\u0001:\u00010BW\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0017\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\rH\u00c6\u0003Je\u0010\u001c\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0010\u0010\"\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000Jp\u0010#\u001a\u00020$\"\b\b\u0000\u0010%*\u00020\u0001\"\b\b\u0001\u0010&*\u00020\u00012\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H%0\u00032\u0016\u0010(\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010)2&\u0010*\u001a\"\u0012\u0004\u0012\u0002H%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020,0\u0003\u0012\u0006\u0012\u0004\u0018\u0001H&0+H\u0002J\u0016\u0010-\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010.J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u00061"}, d2={"Lfleet/themes/ThemeData;", "", "meta", "", "Lnoria/model/ThemeKey;", "textAttributes", "", "Lfleet/themes/PTextAttributes;", "styles", "Lfleet/themes/PTextSpec;", "colors", "Lfleet/themes/Colors;", "palette", "Lfleet/themes/Palette;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lfleet/themes/Colors;Lfleet/themes/Palette;)V", "getColors", "()Lfleet/themes/Colors;", "getMeta", "()Ljava/util/Map;", "getPalette", "()Lfleet/themes/Palette;", "getStyles", "getTextAttributes", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "merge", "resolve", "", "F", "T", "from", "to", "", "transform", "Lkotlin/Function2;", "Landroidx/compose/ui/graphics/Color;", "toMap", "Lkotlinx/collections/immutable/PersistentMap;", "toString", "Companion", "fleet.themes"})
@SourceDebugExtension(value={"SMAP\nThemeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeLoader.kt\nfleet/themes/ThemeData\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,637:1\n215#2,2:638\n155#3:640\n*S KotlinDebug\n*F\n+ 1 ThemeLoader.kt\nfleet/themes/ThemeData\n*L\n629#1:638,2\n554#1:640\n*E\n"})
final class ThemeData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ThemeKey<?>, Object> meta;
    @Nullable
    private final Map<String, PTextAttributes> textAttributes;
    @NotNull
    private final Map<String, PTextSpec> styles;
    @NotNull
    private final Colors colors;
    @NotNull
    private final Palette palette;
    @NotNull
    private static final ThemeData MINIMAL;

    public ThemeData(@NotNull Map<ThemeKey<?>, ? extends Object> meta, @Nullable Map<String, PTextAttributes> textAttributes, @NotNull Map<String, PTextSpec> styles, @NotNull Colors colors, @NotNull Palette palette) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this.meta = meta;
        this.textAttributes = textAttributes;
        this.styles = styles;
        this.colors = colors;
        this.palette = palette;
    }

    @NotNull
    public final Map<ThemeKey<?>, Object> getMeta() {
        return this.meta;
    }

    @Nullable
    public final Map<String, PTextAttributes> getTextAttributes() {
        return this.textAttributes;
    }

    @NotNull
    public final Map<String, PTextSpec> getStyles() {
        return this.styles;
    }

    @NotNull
    public final Colors getColors() {
        return this.colors;
    }

    @NotNull
    public final Palette getPalette() {
        return this.palette;
    }

    @NotNull
    public final ThemeData merge(@Nullable ThemeData other) {
        if (other == null) {
            return this;
        }
        Map map = MapsKt.plus(this.meta, other.meta);
        Map<String, PTextAttributes> map2 = other.textAttributes;
        if (map2 == null) {
            map2 = this.textAttributes;
        }
        return new ThemeData(map, map2, MapsKt.plus(this.styles, other.styles), new Colors(MapsKt.plus(this.colors.getColors(), other.colors.getColors())), new Palette(this.palette.getPrefix(), MapsKt.plus(this.palette.getColors(), other.palette.getColors())));
    }

    @NotNull
    public final PersistentMap<ThemeKey<?>, Object> toMap() {
        Map<String, PTextAttributes> map;
        PersistentMap.Builder result = ExtensionsKt.persistentHashMapOf().builder();
        if (!this.meta.isEmpty()) {
            result.putAll(this.meta);
        }
        if (!((map = this.textAttributes) == null || map.isEmpty())) {
            this.resolve(this.textAttributes, (Map)result, toMap.1.INSTANCE);
        }
        if (!this.styles.isEmpty()) {
            this.resolve(this.styles, (Map)result, toMap.2.INSTANCE);
        }
        if (!this.colors.getColors().isEmpty()) {
            this.resolve(this.colors.getColors(), (Map)result, toMap.3.INSTANCE);
        }
        return result.build();
    }

    private final <F, T> void resolve(Map<String, ? extends F> from, Map<ThemeKey<?>, Object> to, Function2<? super F, ? super Map<String, Color>, ? extends T> transform) {
        Map<String, Color> nameToColor = this.palette.getColors();
        Map<String, F> $this$forEach$iv = from;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, F>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, F> element$iv;
            Map.Entry<String, F> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            F value = entry.getValue();
            Object transformed = transform.invoke(value, nameToColor);
            if (transformed == null) continue;
            to.put(new ThemeKey(key), transformed);
        }
    }

    @NotNull
    public final Map<ThemeKey<?>, Object> component1() {
        return this.meta;
    }

    @Nullable
    public final Map<String, PTextAttributes> component2() {
        return this.textAttributes;
    }

    @NotNull
    public final Map<String, PTextSpec> component3() {
        return this.styles;
    }

    @NotNull
    public final Colors component4() {
        return this.colors;
    }

    @NotNull
    public final Palette component5() {
        return this.palette;
    }

    @NotNull
    public final ThemeData copy(@NotNull Map<ThemeKey<?>, ? extends Object> meta, @Nullable Map<String, PTextAttributes> textAttributes, @NotNull Map<String, PTextSpec> styles, @NotNull Colors colors, @NotNull Palette palette) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new ThemeData(meta, textAttributes, styles, colors, palette);
    }

    public static /* synthetic */ ThemeData copy$default(ThemeData themeData, Map map, Map map2, Map map3, Colors colors, Palette palette, int n, Object object) {
        if ((n & 1) != 0) {
            map = themeData.meta;
        }
        if ((n & 2) != 0) {
            map2 = themeData.textAttributes;
        }
        if ((n & 4) != 0) {
            map3 = themeData.styles;
        }
        if ((n & 8) != 0) {
            colors = themeData.colors;
        }
        if ((n & 0x10) != 0) {
            palette = themeData.palette;
        }
        return themeData.copy(map, map2, map3, colors, palette);
    }

    @NotNull
    public String toString() {
        return "ThemeData(meta=" + this.meta + ", textAttributes=" + this.textAttributes + ", styles=" + this.styles + ", colors=" + this.colors + ", palette=" + this.palette + ")";
    }

    public int hashCode() {
        int result = ((Object)this.meta).hashCode();
        result = result * 31 + (this.textAttributes == null ? 0 : ((Object)this.textAttributes).hashCode());
        result = result * 31 + ((Object)this.styles).hashCode();
        result = result * 31 + this.colors.hashCode();
        result = result * 31 + this.palette.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThemeData)) {
            return false;
        }
        ThemeData themeData = (ThemeData)other;
        if (!Intrinsics.areEqual(this.meta, themeData.meta)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textAttributes, themeData.textAttributes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.styles, themeData.styles)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.colors, (Object)themeData.colors)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.palette, (Object)themeData.palette);
    }

    static {
        int $this$dp$iv = 16;
        boolean $i$f$getDp = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"default.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), null, null, 3, null)), TuplesKt.to((Object)"default.multiline.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefaultMultiline(), null, null, 3, null)), TuplesKt.to((Object)"default.semi.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), 600, null, 2, null)), TuplesKt.to((Object)"default.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), 700, null, 2, null)), TuplesKt.to((Object)"default.extra.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), 800, null, 2, null)), TuplesKt.to((Object)"default.italic.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), null, true, 1, null)), TuplesKt.to((Object)"default.semi.bold.italic.text", (Object)FigmaOptimizedText.Companion.getDefault().toPTextSpec(600, true)), TuplesKt.to((Object)"header.1.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getHeader1(), 700, null, 2, null)), TuplesKt.to((Object)"header.2.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getHeader2(), null, null, 3, null)), TuplesKt.to((Object)"header.2.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getHeader2(), 700, null, 2, null)), TuplesKt.to((Object)"header.3.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getHeader3(), null, null, 3, null)), TuplesKt.to((Object)"header.3.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getHeader3(), 700, null, 2, null)), TuplesKt.to((Object)"medium.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getMedium(), null, null, 3, null)), TuplesKt.to((Object)"medium.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getMedium(), 700, null, 2, null)), TuplesKt.to((Object)"small.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getSmall(), null, null, 3, null)), TuplesKt.to((Object)"small.semi.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getSmall(), 500, null, 2, null)), TuplesKt.to((Object)"small.italic.text", (Object)new PTextSpec(new PFontSpec("Inter", Float.valueOf(11.0f), null, true, 4, null), Float.valueOf(1.27f), null, null, null, 28, null)), TuplesKt.to((Object)"extra.small.text", (Object)new PTextSpec(new PFontSpec(FigmaOptimizedText.Companion.getDefault().getFontFamily(), Float.valueOf(8.0f), null, null, 12, null), null, null, null, null, 30, null)), TuplesKt.to((Object)"code.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getCode(), null, null, 3, null)), TuplesKt.to((Object)"code.semi.bold.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getCode(), 500, null, 2, null)), TuplesKt.to((Object)"code.italic.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getCode(), null, true, 1, null)), TuplesKt.to((Object)"code.small.text", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getCodeSmall(), null, null, 3, null)), TuplesKt.to((Object)"tab.textSpec", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), null, null, 3, null)), TuplesKt.to((Object)"tab.preview.textSpec", (Object)FigmaOptimizedText.toPTextSpec$default(FigmaOptimizedText.Companion.getDefault(), null, true, 1, null))};
        MINIMAL = new ThemeData(MapsKt.mapOf((Pair)TuplesKt.to((Object)ThemeKeys.INSTANCE.getIconSize(), (Object)Dp.box-impl((float)Dp.constructor-impl((float)$this$dp$iv)))), null, MapsKt.mapOf((Pair[])pairArray), Colors.Companion.getEmpty(), Palette.Companion.getEmpty());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/themes/ThemeData$Companion;", "", "()V", "MINIMAL", "Lfleet/themes/ThemeData;", "getMINIMAL", "()Lfleet/themes/ThemeData;", "fleet.themes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThemeData getMINIMAL() {
            return MINIMAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

