/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.NativePtyExecutor;
import com.pty4j.unix.PtyExecutor;
import com.pty4j.unix.UnixPtyException;
import com.pty4j.unix.freebsd.OSFacadeImpl;
import com.pty4j.util.LazyValue;
import com.pty4j.util.PtyUtil;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import jtermios.JTermios;
import jtermios.Termios;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtyHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(PtyHelpers.class);
    public static int ONLCR = 4;
    public static int VINTR = 0;
    public static int VQUIT = 1;
    public static int VERASE = 2;
    public static int VKILL = 3;
    public static int VSUSP = 10;
    public static int VREPRINT = 12;
    public static int VWERASE = 14;
    public static int ECHOCTL = 4096;
    public static int ECHOKE = 16384;
    public static int ECHOK = 4;
    public static int IMAXBEL = 8192;
    public static int HUPCL = 16384;
    public static int IUTF8 = 16384;
    public static int O_NOCTTY = JTermios.O_NOCTTY;
    public static int O_RDWR = JTermios.O_RDWR;
    public static int TCSANOW = JTermios.TCSANOW;
    private static final int STDIN_FILENO = 0;
    private static final int STDOUT_FILENO = 1;
    private static final int STDERR_FILENO = 2;
    private static final int SIG_UNBLOCK = 2;
    public static int SIGHUP = 1;
    public static int SIGINT = 2;
    public static int SIGQUIT = 3;
    public static int SIGILL = 4;
    public static int SIGABORT = 6;
    public static int SIGFPE = 8;
    public static int SIGKILL = 9;
    public static int SIGSEGV = 11;
    public static int SIGPIPE = 13;
    public static int SIGALRM = 14;
    public static int SIGTERM = 15;
    public static int SIGCHLD = 20;
    public static int WNOHANG = 1;
    public static int WUNTRACED = 2;
    private static final LazyValue<OSFacade> OS_FACADE_VALUE = new LazyValue<OSFacade>(() -> {
        if (Platform.isMac()) {
            return new com.pty4j.unix.macosx.OSFacadeImpl();
        }
        if (Platform.isFreeBSD()) {
            return new OSFacadeImpl();
        }
        if (Platform.isOpenBSD()) {
            return new com.pty4j.unix.openbsd.OSFacadeImpl();
        }
        if (Platform.isLinux() || Platform.isAndroid()) {
            return new com.pty4j.unix.linux.OSFacadeImpl();
        }
        if (Platform.isWindows()) {
            throw new IllegalArgumentException("WinPtyProcess should be used on Windows");
        }
        throw new RuntimeException("Pty4J has no support for OS " + System.getProperty("os.name"));
    });
    private static final LazyValue<PtyExecutor> PTY_EXECUTOR_VALUE = new LazyValue<PtyExecutor>(() -> {
        String libraryName = Platform.isMac() ? "libpty.dylib" : "libpty.so";
        File libraryFile = PtyUtil.resolveNativeFile(libraryName);
        return new NativePtyExecutor(libraryFile.getAbsolutePath());
    });

    private static Termios convertToTermios(TerminalSettings settings) {
        Termios result = new Termios();
        result.c_iflag = settings.c_iflag;
        result.c_oflag = settings.c_oflag;
        result.c_cflag = settings.c_cflag;
        result.c_lflag = settings.c_lflag;
        System.arraycopy(settings.c_cc, 0, result.c_cc, 0, settings.c_cc.length);
        result.c_ispeed = settings.c_ispeed;
        result.c_ospeed = settings.c_ospeed;
        return result;
    }

    private static void fillTerminalSettings(TerminalSettings settings, Termios termios) {
        settings.c_iflag = termios.c_iflag;
        settings.c_oflag = termios.c_oflag;
        settings.c_cflag = termios.c_cflag;
        settings.c_lflag = termios.c_lflag;
        System.arraycopy(termios.c_cc, 0, settings.c_cc, 0, termios.c_cc.length);
        settings.c_ispeed = termios.c_ispeed;
        settings.c_ospeed = termios.c_ospeed;
    }

    @NotNull
    private static OSFacade getOsFacade() {
        try {
            return OS_FACADE_VALUE.getValue();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot load implementation of " + OSFacade.class, t);
        }
    }

    @NotNull
    static PtyExecutor getPtyExecutor() {
        try {
            return PTY_EXECUTOR_VALUE.getValue();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot load native pty executor library", t);
        }
    }

    public static OSFacade getInstance() {
        return PtyHelpers.getOsFacade();
    }

    public static Termios createTermios() {
        Termios term = new Termios();
        boolean isUTF8 = true;
        term.c_iflag = JTermios.ICRNL | JTermios.IXON | JTermios.IXANY | IMAXBEL | JTermios.BRKINT | (isUTF8 ? IUTF8 : 0);
        term.c_oflag = JTermios.OPOST | ONLCR;
        term.c_cflag = JTermios.CREAD | JTermios.CS8 | HUPCL;
        term.c_lflag = JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN | JTermios.ECHO | JTermios.ECHOE | ECHOK | ECHOKE | ECHOCTL;
        term.c_cc[JTermios.VEOF] = PtyHelpers.CTRLKEY('D');
        term.c_cc[PtyHelpers.VERASE] = 127;
        term.c_cc[PtyHelpers.VWERASE] = PtyHelpers.CTRLKEY('W');
        term.c_cc[PtyHelpers.VKILL] = PtyHelpers.CTRLKEY('U');
        term.c_cc[PtyHelpers.VREPRINT] = PtyHelpers.CTRLKEY('R');
        term.c_cc[PtyHelpers.VINTR] = PtyHelpers.CTRLKEY('C');
        term.c_cc[PtyHelpers.VQUIT] = 28;
        term.c_cc[PtyHelpers.VSUSP] = PtyHelpers.CTRLKEY('Z');
        term.c_cc[JTermios.VSTART] = PtyHelpers.CTRLKEY('Q');
        term.c_cc[JTermios.VSTOP] = PtyHelpers.CTRLKEY('S');
        term.c_ispeed = JTermios.B38400;
        term.c_ospeed = JTermios.B38400;
        return term;
    }

    private static byte CTRLKEY(char c) {
        return (byte)((byte)c - 65 + 1);
    }

    private static int __sigbits(int __signo) {
        return __signo > 32 ? 0 : 1 << __signo - 1;
    }

    @NotNull
    public static WinSize getWinSize(int fd, @Nullable PtyProcess process) throws UnixPtyException {
        return PtyHelpers.getPtyExecutor().getWindowSize(fd, process);
    }

    public static boolean isProcessAlive(int pid) {
        int[] stat = new int[]{-1};
        int result = PtyHelpers.waitpid(pid, stat, WNOHANG);
        return result == 0 && stat[0] < 0;
    }

    public static int signal(int pid, int signal) {
        return PtyHelpers.getOsFacade().kill(pid, signal);
    }

    public static int waitpid(int pid, int[] stat, int options) {
        return PtyHelpers.getOsFacade().waitpid(pid, stat, options);
    }

    public static int errno() {
        return Native.getLastError();
    }

    public static String strerror() {
        return PtyHelpers.getOsFacade().strerror(PtyHelpers.errno());
    }

    public static void chdir(String dirpath) {
        PtyHelpers.getOsFacade().chdir(dirpath);
    }

    public static int execPty(String full_path, String[] argv, String[] envp, String dirpath, String pts_name, int fdm, String err_pts_name, int err_fdm, boolean console) {
        PtyExecutor executor = PtyHelpers.getPtyExecutor();
        return executor.execPty(full_path, argv, envp, dirpath, pts_name, fdm, err_pts_name, err_fdm, console);
    }

    static {
        try {
            PtyHelpers.getOsFacade();
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t.getCause());
        }
        try {
            PtyHelpers.getPtyExecutor();
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t.getCause());
        }
    }

    public static class TerminalSettings {
        public int c_iflag;
        public int c_oflag;
        public int c_cflag;
        public int c_lflag;
        public byte[] c_cc = new byte[20];
        public int c_ispeed;
        public int c_ospeed;
    }

    public static interface OSFacade {
        public int kill(int var1, int var2);

        public int waitpid(int var1, int[] var2, int var3);

        public int sigprocmask(int var1, IntByReference var2, IntByReference var3);

        public String strerror(int var1);

        public int getpt();

        public int grantpt(int var1);

        public int unlockpt(int var1);

        public int close(int var1);

        public String ptsname(int var1);

        public int killpg(int var1, int var2);

        public int fork();

        public int pipe(int[] var1);

        public int setsid();

        public int getpid();

        public int setpgid(int var1, int var2);

        public void dup2(int var1, int var2);

        public int getppid();

        public void unsetenv(String var1);

        public int login_tty(int var1);

        public void chdir(String var1);

        default public int tcdrain(int fd) {
            return JTermios.tcdrain((int)fd);
        }

        default public int open(String path, int mode) {
            return JTermios.open((String)path, (int)mode);
        }

        default public int read(int fd, byte[] buffer, int len) {
            return JTermios.read((int)fd, (byte[])buffer, (int)len);
        }

        default public int errno() {
            return JTermios.errno();
        }

        default public int tcgetattr(int fd, TerminalSettings settings) {
            Termios termios = new Termios();
            int result = JTermios.tcgetattr((int)fd, (Termios)termios);
            PtyHelpers.fillTerminalSettings(settings, termios);
            return result;
        }

        default public int tcsetattr(int fd, int opt, TerminalSettings settings) {
            Termios termios = PtyHelpers.convertToTermios(settings);
            return JTermios.tcsetattr((int)fd, (int)opt, (Termios)termios);
        }
    }
}

