/*
 * Decompiled with CFR 0.152.
 */
package fleet.protocol.debug;

import fleet.api.Location;
import fleet.api.ProjectRootId;
import fleet.api.RpcResult;
import fleet.protocol.debug.DebugBackendApi;
import fleet.protocol.debug.DebugBreakpointId;
import fleet.protocol.debug.DebugEvaluateContext;
import fleet.protocol.debug.DebugExpressionId;
import fleet.protocol.debug.DebugQueryFailure;
import fleet.protocol.debug.DebugSessionCommand;
import fleet.protocol.debug.DebugSessionId;
import fleet.protocol.debug.DebugSessionState;
import fleet.protocol.debug.DebugStack;
import fleet.protocol.debug.DebugStackFrame;
import fleet.protocol.debug.DebugStackFrameId;
import fleet.protocol.debug.DebugStackId;
import fleet.protocol.debug.DebugSuspensionId;
import fleet.protocol.debug.DebugVariable;
import fleet.protocol.debug.DebugVariableAction;
import fleet.protocol.debug.DebugVariableId;
import fleet.protocol.debug.DebugVariableUpdate;
import fleet.protocol.debug.DebuggerId;
import fleet.protocol.debug.ExceptionPresentation;
import fleet.protocol.debug.ExpressionInfo;
import fleet.protocol.debug.FleetBreakpoint;
import fleet.protocol.debug.ProcessAttachInfo;
import fleet.rpc.core.RpcFlow;
import fleet.util.UID;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=3, xi=48)
public final class DebugBackendApiClientStub
implements DebugBackendApi {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public DebugBackendApiClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Override
    @Nullable
    public final Object getSupportedDebuggers(@NotNull Continuation<? super Flow<? extends List<DebuggerId>>> $completion) {
        return this.invocationHandler.invoke((Object)"getSupportedDebuggers", (Object)new Object[0], $completion);
    }

    @Override
    @Nullable
    public final Object addBreakpoint(@NotNull FleetBreakpoint breakpoint, @NotNull Continuation<? super Boolean> $completion) {
        Object[] objectArray = new Object[]{breakpoint};
        return this.invocationHandler.invoke((Object)"addBreakpoint", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object updateBreakpoint(@NotNull FleetBreakpoint breakpoint, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{breakpoint};
        return this.invocationHandler.invoke((Object)"updateBreakpoint", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object removeBreakpoint(@NotNull DebugBreakpointId breakpointId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{breakpointId};
        return this.invocationHandler.invoke((Object)"removeBreakpoint", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object startSession(@NotNull DebuggerId platform, @NotNull DebugSessionId sessionId, @NotNull ProjectRootId projectRootId, @NotNull JsonElement parameters, @NotNull Continuation<? super RpcResult<Unit, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{platform, sessionId, projectRootId, parameters};
        return this.invocationHandler.invoke((Object)"startSession", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object connectToSession(@NotNull DebugSessionId sessionId, @NotNull Flow<? extends DebugSessionCommand> commandsFlow, @NotNull Continuation<? super RpcResult<RpcFlow<DebugSessionState>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, commandsFlow};
        return this.invocationHandler.invoke((Object)"connectToSession", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object listStacks(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull Continuation<? super RpcResult<List<DebugStack>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId};
        return this.invocationHandler.invoke((Object)"listStacks", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object listStackFrames(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugStackId stackId, @NotNull Continuation<? super RpcResult<List<DebugStackFrame>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, stackId};
        return this.invocationHandler.invoke((Object)"listStackFrames", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object listFrameVariables(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugStackFrameId frameId, @NotNull Continuation<? super RpcResult<List<DebugVariable>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, frameId};
        return this.invocationHandler.invoke((Object)"listFrameVariables", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object listVariableChildren(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugVariableId variableId, @Nullable DebugVariableAction.FetchMore fetchMoreAction, @NotNull Continuation<? super RpcResult<List<DebugVariable>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, variableId, fetchMoreAction};
        return this.invocationHandler.invoke((Object)"listVariableChildren", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object subscribeForVariablesUpdates(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull Continuation<? super RpcResult<RpcFlow<DebugVariableUpdate>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId};
        return this.invocationHandler.invoke((Object)"subscribeForVariablesUpdates", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object collectProcessesToAttach(@NotNull DebuggerId platform, @NotNull Continuation<? super RpcResult<RpcFlow<ProcessAttachInfo>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{platform};
        return this.invocationHandler.invoke((Object)"collectProcessesToAttach", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object collectExceptions(@NotNull ProjectRootId projectRootId, @NotNull DebuggerId platform, @NotNull String pattern, int maxItems, @NotNull Continuation<? super RpcResult<List<ExceptionPresentation>, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{projectRootId, platform, pattern, Boxing.boxInt((int)maxItems)};
        return this.invocationHandler.invoke((Object)"collectExceptions", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object runVariableAction(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugVariableId variableId, @NotNull Continuation<? super RpcResult<Location, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, variableId};
        return this.invocationHandler.invoke((Object)"runVariableAction", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object evaluate(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugStackFrameId frameId, @NotNull DebugEvaluateContext context, @NotNull DebugExpressionId expression, @NotNull Continuation<? super RpcResult<DebugVariable, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, frameId, context, expression};
        return this.invocationHandler.invoke((Object)"evaluate", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object evaluateText(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugStackFrameId frameId, @NotNull DebugEvaluateContext context, @NotNull String expression, @NotNull Continuation<? super RpcResult<DebugVariable, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, frameId, context, expression};
        return this.invocationHandler.invoke((Object)"evaluateText", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object createOrUpdateExpression(@NotNull DebugExpressionId expressionId, @NotNull UID documentId, @NotNull DebuggerId debuggerId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{expressionId, documentId, debuggerId};
        return this.invocationHandler.invoke((Object)"createOrUpdateExpression", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object removeExpression(@NotNull DebugExpressionId expressionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{expressionId};
        return this.invocationHandler.invoke((Object)"removeExpression", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object getExpressionInfo(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugStackFrameId frameId, @NotNull UID documentId, long offset, @NotNull Continuation<? super RpcResult<ExpressionInfo, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, frameId, documentId, Boxing.boxLong((long)offset)};
        return this.invocationHandler.invoke((Object)"getExpressionInfo", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object findVariableTypeDefinition(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugVariableId variableId, @NotNull Continuation<? super RpcResult<Location, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, variableId};
        return this.invocationHandler.invoke((Object)"findVariableTypeDefinition", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object findVariableDefinition(@NotNull DebugSessionId sessionId, @NotNull DebugSuspensionId suspensionId, @NotNull DebugVariableId variableId, @NotNull Continuation<? super RpcResult<Location, ? extends DebugQueryFailure>> $completion) {
        Object[] objectArray = new Object[]{sessionId, suspensionId, variableId};
        return this.invocationHandler.invoke((Object)"findVariableDefinition", (Object)objectArray, $completion);
    }
}

