/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.textmate.frontend;

import andel.text.Text;
import fleet.ast.AST;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.quoteHandler.QuoteHandler;
import fleet.plugins.textmate.frontend.TMElementType;
import fleet.plugins.textmate.frontend.TextMateQuoteHandler;
import fleet.util.SequenceKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J&\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0016J&\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0016J&\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0016J&\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0016J&\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\bH\u0002J\u0012\u0010$\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\"0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lfleet/plugins/textmate/frontend/TextMateQuoteHandler;", "Lfleet/frontend/lang/quoteHandler/QuoteHandler;", "preferencesRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;", "(Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;)V", "findClosingQuote", "", "leafType", "Lfleet/plugins/textmate/frontend/TMElementType;", "leftQuote", "", "findOpeningQuote", "rightQuote", "findSuitableSmartQuote", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateAutoClosingPair;", "predicate", "Lkotlin/Function1;", "", "getCharAtOffset", "text", "Landel/text/Text;", "offset", "", "getClosingQuote", "ast", "Lfleet/ast/AST;", "getRangeToDeleteOnBackspace", "Lkotlin/ranges/LongRange;", "isClosingQuote", "isInsideLiteral", "isOpeningQuote", "missingClosingQuote", "scopesUpToParent", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "elementType", "relatesToQuotes", "fleet.plugins.textmate.frontend"})
@SourceDebugExtension(value={"SMAP\nTextMateQuoteHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateQuoteHandler.kt\nfleet/plugins/textmate/frontend/TextMateQuoteHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1247#2,2:152\n288#3,2:154\n288#3,2:156\n*S KotlinDebug\n*F\n+ 1 TextMateQuoteHandler.kt\nfleet/plugins/textmate/frontend/TextMateQuoteHandler\n*L\n23#1:152,2\n145#1:154,2\n147#1:156,2\n*E\n"})
final class TextMateQuoteHandler
implements QuoteHandler {
    @NotNull
    private final PreferencesRegistry preferencesRegistry;

    public TextMateQuoteHandler(@NotNull PreferencesRegistry preferencesRegistry) {
        Intrinsics.checkNotNullParameter((Object)preferencesRegistry, (String)"preferencesRegistry");
        this.preferencesRegistry = preferencesRegistry;
    }

    private final Sequence<TextMateScope> scopesUpToParent(TMElementType elementType) {
        return SequencesKt.generateSequence((Object)elementType.getScope(), (Function1)scopesUpToParent.1.INSTANCE);
    }

    private final boolean relatesToQuotes(Sequence<TextMateScope> $this$relatesToQuotes) {
        boolean bl;
        block3: {
            Sequence<TextMateScope> $this$any$iv = $this$relatesToQuotes;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl2;
                CharSequence charSequence;
                TextMateScope it = (TextMateScope)element$iv;
                boolean bl3 = false;
                CharSequence charSequence2 = charSequence = it.getScopeName();
                if (charSequence2 != null) {
                    Intrinsics.checkNotNull((Object)charSequence2);
                    bl2 = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)"string.quoted", (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public boolean isOpeningQuote(long offset, @NotNull Text text, @Nullable AST<?> ast) {
        boolean bl;
        Object leafType;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SyntaxNode syntaxNode = ast;
        Object object = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null && (syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)syntaxNode, (long)offset)) != null ? syntaxNode.getType() : (leafType = null);
        if (leafType instanceof TMElementType) {
            char typedChar = this.getCharAtOffset(text, offset);
            Sequence<TextMateScope> scopesUpToParent2 = this.scopesUpToParent((TMElementType)((Object)leafType));
            bl = this.preferencesRegistry.isPossibleLeftSmartTypingBrace(typedChar) && this.relatesToQuotes(scopesUpToParent2) && !this.isInsideLiteral(offset, text, (AST<?>)ast);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast) {
        boolean bl;
        Object leafType;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SyntaxNode syntaxNode = ast;
        Object object = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null && (syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)syntaxNode, (long)offset)) != null ? syntaxNode.getType() : (leafType = null);
        if (leafType instanceof TMElementType) {
            char typedChar = this.getCharAtOffset(text, offset);
            Sequence<TextMateScope> scopesUpToParent2 = this.scopesUpToParent((TMElementType)((Object)leafType));
            bl = this.preferencesRegistry.isPossibleRightSmartTypingBrace(typedChar) && this.relatesToQuotes(scopesUpToParent2) && this.isInsideLiteral(offset, text, (AST<?>)ast);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean missingClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SyntaxNode syntaxNode = ast;
        SyntaxNode leaf = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null ? SyntaxNodeExtKt.leafByOffset((SyntaxNode)syntaxNode, (long)offset) : null;
        char typedChar = this.getCharAtOffset(text, offset);
        SyntaxNode syntaxNode2 = leaf;
        Object leafType = syntaxNode2 != null ? syntaxNode2.getType() : null;
        if (leaf == null) return true;
        if (!(leafType instanceof TMElementType)) return true;
        String expectedClosingQuote = this.findClosingQuote((TMElementType)((Object)leafType), typedChar);
        if (expectedClosingQuote == null) return true;
        List nextSiblingsOnly2 = SequencesKt.toList((Sequence)SequenceKt.takeWhileInclusive((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)leaf.nextSibling(), (Function1)missingClosingQuote.nextSiblingsOnly.1.INSTANCE), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(this){
            final /* synthetic */ TextMateQuoteHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object type = it.getType();
                return type instanceof TMElementType && TextMateQuoteHandler.access$relatesToQuotes(this.this$0, TextMateQuoteHandler.access$scopesUpToParent(this.this$0, (TMElementType)((Object)type)));
            }
        })), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(expectedClosingQuote){
            final /* synthetic */ String $expectedClosingQuote;
            {
                this.$expectedClosingQuote = $expectedClosingQuote;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$expectedClosingQuote.contentEquals(it.getText());
            }
        })));
        if (nextSiblingsOnly2.isEmpty()) return true;
        if (expectedClosingQuote.contentEquals(((SyntaxNode)CollectionsKt.last((List)nextSiblingsOnly2)).getText())) return false;
        return true;
    }

    public boolean isInsideLiteral(long offset, @NotNull Text text, @Nullable AST<?> ast) {
        String openingQuote;
        SyntaxNode leaf;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SyntaxNode syntaxNode = ast;
        SyntaxNode syntaxNode2 = leaf = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null ? SyntaxNodeExtKt.leafByOffset((SyntaxNode)syntaxNode, (long)offset) : null;
        Object leafType = syntaxNode2 != null ? syntaxNode2.getType() : null;
        char typedChar = this.getCharAtOffset(text, offset);
        if (leafType instanceof TMElementType.Regular && (openingQuote = this.findOpeningQuote((TMElementType)((Object)leafType), typedChar)) != null) {
            List prevSiblingsOnly2 = SequencesKt.toList((Sequence)SequenceKt.takeWhileInclusive((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)leaf.prevSibling(), (Function1)isInsideLiteral.prevSiblingsOnly.1.INSTANCE), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(this){
                final /* synthetic */ TextMateQuoteHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SyntaxNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object type = it.getType();
                    return type instanceof TMElementType && TextMateQuoteHandler.access$relatesToQuotes(this.this$0, TextMateQuoteHandler.access$scopesUpToParent(this.this$0, (TMElementType)((Object)type)));
                }
            })), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(openingQuote){
                final /* synthetic */ String $openingQuote;
                {
                    this.$openingQuote = $openingQuote;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SyntaxNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !this.$openingQuote.contentEquals(it.getText());
                }
            })));
            return !((Collection)prevSiblingsOnly2).isEmpty();
        }
        return false;
    }

    @NotNull
    public String getClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast) {
        String possibleClosingQuote;
        TMElementType leafType;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        char typedChar = this.getCharAtOffset(text, offset);
        SyntaxNode syntaxNode = ast;
        Object object = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null && (syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)syntaxNode, (long)offset)) != null ? syntaxNode.getType() : null;
        TMElementType tMElementType = leafType = object instanceof TMElementType ? (TMElementType)((Object)object) : null;
        if (leafType != null && (possibleClosingQuote = this.findClosingQuote(leafType, typedChar)) != null) {
            return possibleClosingQuote;
        }
        return String.valueOf(typedChar);
    }

    @Nullable
    public LongRange getRangeToDeleteOnBackspace(long offset, @NotNull Text text, @Nullable AST<?> ast) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (offset < 1L || offset >= text.charsCount() || !this.isClosingQuote(offset, text, ast)) {
            return null;
        }
        return this.getCharAtOffset(text, offset) == this.getCharAtOffset(text, offset - 1L) ? new LongRange(offset - 1L, offset) : null;
    }

    private final String findClosingQuote(TMElementType leafType, char leftQuote) {
        Object object = this.findSuitableSmartQuote(leafType, (Function1<? super TextMateAutoClosingPair, Boolean>)((Function1)new Function1<TextMateAutoClosingPair, Boolean>(leftQuote){
            final /* synthetic */ char $leftQuote;
            {
                this.$leftQuote = $leftQuote;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TextMateAutoClosingPair it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getLeft(), (Object)String.valueOf(this.$leftQuote));
            }
        }));
        return object != null && (object = object.getRight()) != null ? object.toString() : null;
    }

    private final String findOpeningQuote(TMElementType leafType, char rightQuote) {
        Object object = this.findSuitableSmartQuote(leafType, (Function1<? super TextMateAutoClosingPair, Boolean>)((Function1)new Function1<TextMateAutoClosingPair, Boolean>(rightQuote){
            final /* synthetic */ char $rightQuote;
            {
                this.$rightQuote = $rightQuote;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TextMateAutoClosingPair it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getRight(), (Object)String.valueOf(this.$rightQuote));
            }
        }));
        return object != null && (object = object.getLeft()) != null ? object.toString() : null;
    }

    private final TextMateAutoClosingPair findSuitableSmartQuote(TMElementType leafType, Function1<? super TextMateAutoClosingPair, Boolean> predicate) {
        TextMateAutoClosingPair textMateAutoClosingPair;
        Set set;
        Object v1;
        block4: {
            TextMateScope parentScope = (TextMateScope)SequencesKt.last(this.scopesUpToParent(leafType));
            List list = this.preferencesRegistry.getPreferences(leafType.getScope());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPreferences(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Preferences it = (Preferences)element$iv;
                boolean bl = false;
                if (!StringsKt.contentEquals((CharSequence)it.getScopeSelector(), (CharSequence)parentScope.getScopeName())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Preferences preferences = v1;
        if (preferences != null && (set = preferences.getSmartTypingPairs()) != null) {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            textMateAutoClosingPair = v2;
        } else {
            textMateAutoClosingPair = null;
        }
        return textMateAutoClosingPair;
    }

    private final char getCharAtOffset(Text text, long offset) {
        return text.charSequence().getAbsolute(offset);
    }

    public static final /* synthetic */ boolean access$relatesToQuotes(TextMateQuoteHandler $this, Sequence $receiver) {
        return $this.relatesToQuotes((Sequence<TextMateScope>)$receiver);
    }

    public static final /* synthetic */ Sequence access$scopesUpToParent(TextMateQuoteHandler $this, TMElementType elementType) {
        return $this.scopesUpToParent(elementType);
    }
}

