/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.textmate.frontend;

import com.intellij.util.containers.Interner;
import fleet.api.workspace.document.LanguageId;
import fleet.plugins.textmate.frontend.BlockCommentInfo;
import fleet.plugins.textmate.frontend.CommentInformation;
import fleet.plugins.textmate.frontend.LineCommentInfo;
import fleet.plugins.textmate.frontend.TMElementType;
import fleet.plugins.textmate.frontend.TextMateModel;
import fleet.plugins.textmate.frontend.TextMateModelKt;
import fleet.util.logging.KLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.BundleReaderKt;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.bundles.VSCBundleReaderKt;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aQ\u0010\u0006\u001a\u00020\u000729\u0010\b\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u000b\u0012%\u0012#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\fj\u0002`\u00110\n0\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u001f*\u00060\u001aj\u0002`\u001bH\u0000\u001aX\u0010 \u001a\u00020!*\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#2\u0006\u0010$\u001a\u00020%2\u001c\u0010&\u001a\u0018\u0012\b\u0012\u00060\u001aj\u0002`\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003*F\b\u0000\u0010/\"\u001f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\f2\u001f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\f*\n\u00100\"\u00020\u001a2\u00020\u001a\u00a8\u00061"}, d2={"logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "loadTextMateModel", "Lfleet/plugins/textmate/frontend/TextMateModel;", "resourceLoadersEps", "", "Lkotlin/Pair;", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "relativePath", "Ljava/io/InputStream;", "Lfleet/plugins/textmate/frontend/ResourceLoader;", "extraTmDirs", "Ljava/nio/file/Path;", "readBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "path", "retrieveCommentInfo", "Lfleet/plugins/textmate/frontend/CommentInformation;", "textMateScopeName", "", "Lfleet/plugins/textmate/frontend/TextMateScopeName;", "shellVariablesRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry;", "asLanguage", "Lfleet/api/workspace/document/LanguageId;", "registerBundle", "", "interner", "Lcom/intellij/util/containers/Interner;", "syntaxTable", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable;", "scopeToFileNameMatchers", "", "", "Lorg/jetbrains/plugins/textmate/bundles/TextMateGrammar;", "preferencesRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl;", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistryImpl;", "snippetsRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl;", "ResourceLoader", "TextMateScopeName", "fleet.plugins.textmate.frontend"})
@SourceDebugExtension(value={"SMAP\nTextMateModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateModel.kt\nfleet/plugins/textmate/frontend/TextMateModelKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n17#2,5:346\n22#2:367\n1855#3,2:351\n1855#3:353\n1856#3:358\n1238#3,4:361\n1855#3,2:382\n13#4,2:354\n37#4,2:356\n41#4,2:365\n9#4,2:368\n9#4,2:370\n17#4,2:388\n41#4,2:390\n453#5:359\n403#5:360\n372#5,7:373\n1313#6:372\n1314#6:380\n1313#6:381\n1314#6:384\n1313#6,2:385\n1#7:387\n*S KotlinDebug\n*F\n+ 1 TextMateModel.kt\nfleet/plugins/textmate/frontend/TextMateModelKt\n*L\n176#1:346,5\n176#1:367\n216#1:351,2\n218#1:353\n218#1:358\n231#1:361,4\n273#1:382,2\n219#1:354,2\n228#1:356,2\n236#1:365,2\n240#1:368,2\n255#1:370,2\n188#1:388,2\n197#1:390,2\n231#1:359\n231#1:360\n260#1:373,7\n256#1:372\n256#1:380\n264#1:381\n264#1:384\n277#1:385,2\n*E\n"})
public final class TextMateModelKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    @NotNull
    public static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    @NotNull
    public static final LanguageId asLanguage(@NotNull CharSequence $this$asLanguage) {
        Intrinsics.checkNotNullParameter((Object)$this$asLanguage, (String)"<this>");
        return new LanguageId("textmate:" + $this$asLanguage);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TextMateModel loadTextMateModel(@NotNull List<? extends Pair<String, ? extends Function1<? super String, ? extends InputStream>>> resourceLoadersEps, @NotNull List<? extends Path> extraTmDirs) {
        long start$iv;
        TextMateSyntaxTable syntaxTable;
        ShellVariablesRegistryImpl shellVariablesRegistry;
        PreferencesRegistryImpl preferencesRegistry;
        SnippetsRegistryImpl snippetsRegistry;
        Map commentInformationPerLanguage;
        Map scopeToFileNameMatchers;
        block12: {
            Intrinsics.checkNotNullParameter(resourceLoadersEps, (String)"resourceLoadersEps");
            Intrinsics.checkNotNullParameter(extraTmDirs, (String)"extraTmDirs");
            scopeToFileNameMatchers = new LinkedHashMap();
            commentInformationPerLanguage = new LinkedHashMap();
            snippetsRegistry = new SnippetsRegistryImpl();
            preferencesRegistry = new PreferencesRegistryImpl();
            shellVariablesRegistry = new ShellVariablesRegistryImpl();
            syntaxTable = new TextMateSyntaxTable();
            Interner interner = Interner.createWeakInterner();
            Intrinsics.checkNotNullExpressionValue((Object)interner, (String)"createWeakInterner(...)");
            Interner interner2 = interner;
            boolean $i$f$measureTimeMillis = false;
            start$iv = System.currentTimeMillis();
            boolean bl = false;
            try {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                InputStream builtinBundles;
                Path path = Paths.get("fleet/plugins/textmate/frontend/bundles", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path rootPath = path;
                Module module = TextMateModel.class.getModule();
                Path path2 = rootPath.resolve("bundles.txt");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                InputStream inputStream = module.getResourceAsStream(PathsKt.getInvariantSeparatorsPathString((Path)path2));
                if (inputStream == null) {
                    boolean $i$a$-requireNotNull-TextMateModelKt$loadTextMateModel$elapsedTime$1$builtinBundles$22 = false;
                    String $i$a$-requireNotNull-TextMateModelKt$loadTextMateModel$elapsedTime$1$builtinBundles$22 = "Cannot read list of builtin bundles from `" + rootPath + "/bundles.txt`";
                    throw new IllegalArgumentException($i$a$-requireNotNull-TextMateModelKt$loadTextMateModel$elapsedTime$1$builtinBundles$22.toString());
                }
                InputStream inputStream2 = builtinBundles = inputStream;
                Charset $i$a$-requireNotNull-TextMateModelKt$loadTextMateModel$elapsedTime$1$builtinBundles$22 = Charsets.UTF_8;
                Iterator iterator = new InputStreamReader(inputStream2, $i$a$-requireNotNull-TextMateModelKt$loadTextMateModel$elapsedTime$1$builtinBundles$22);
                int n = 8192;
                TextStreamsKt.forEachLine((Reader)(iterator instanceof BufferedReader ? (BufferedReader)((Object)iterator) : new BufferedReader((Reader)((Object)iterator), n)), (Function1)((Function1)new Function1<String, Unit>(rootPath, module, (Interner<CharSequence>)interner2, syntaxTable, (Map<CharSequence, List<TextMateGrammar>>)scopeToFileNameMatchers, preferencesRegistry, shellVariablesRegistry, snippetsRegistry){
                    final /* synthetic */ Path $rootPath;
                    final /* synthetic */ Module $module;
                    final /* synthetic */ Interner<CharSequence> $interner;
                    final /* synthetic */ TextMateSyntaxTable $syntaxTable;
                    final /* synthetic */ Map<CharSequence, List<TextMateGrammar>> $scopeToFileNameMatchers;
                    final /* synthetic */ PreferencesRegistryImpl $preferencesRegistry;
                    final /* synthetic */ ShellVariablesRegistryImpl $shellVariablesRegistry;
                    final /* synthetic */ SnippetsRegistryImpl $snippetsRegistry;
                    {
                        this.$rootPath = $rootPath;
                        this.$module = $module;
                        this.$interner = $interner;
                        this.$syntaxTable = $syntaxTable;
                        this.$scopeToFileNameMatchers = $scopeToFileNameMatchers;
                        this.$preferencesRegistry = $preferencesRegistry;
                        this.$shellVariablesRegistry = $shellVariablesRegistry;
                        this.$snippetsRegistry = $snippetsRegistry;
                        super(1);
                    }

                    public final void invoke(@NotNull String bundleName) {
                        Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
                        KLogger this_$iv = TextMateModelKt.getLogger();
                        boolean $i$f$debug = false;
                        if (this_$iv.isDebugEnabled()) {
                            KLogger kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.debug((Object)("Reading built-in textmate bundle `" + bundleName + "`"));
                        }
                        Path bundlePath = this.$rootPath.resolve(bundleName);
                        Function1 resourceLoader2 = (Function1)new Function1<String, InputStream>(bundlePath, this.$module, bundleName){
                            final /* synthetic */ Path $bundlePath;
                            final /* synthetic */ Module $module;
                            final /* synthetic */ String $bundleName;
                            {
                                this.$bundlePath = $bundlePath;
                                this.$module = $module;
                                this.$bundleName = $bundleName;
                                super(1);
                            }

                            @Nullable
                            public final InputStream invoke(@NotNull String relativePath) {
                                Object object;
                                Object $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$1$resourceLoader$1$22;
                                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                                Object object2 = this.$bundlePath;
                                Object object3 = this.$module;
                                try {
                                    boolean $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$1$resourceLoader$1$22 = false;
                                    Path path = object2.resolve(relativePath).normalize();
                                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
                                    String invariantSeparatorsPathString = PathsKt.getInvariantSeparatorsPathString((Path)path);
                                    $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$1$resourceLoader$1$22 = Result.constructor-impl((Object)((Module)object3).getResourceAsStream(invariantSeparatorsPathString));
                                }
                                catch (Throwable invariantSeparatorsPathString) {
                                    $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$1$resourceLoader$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)invariantSeparatorsPathString));
                                }
                                object2 = $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$1$resourceLoader$1$22;
                                object3 = this.$bundleName;
                                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                                if (throwable == null) {
                                    object = object2;
                                } else {
                                    Throwable e = throwable;
                                    boolean bl = false;
                                    KLogger this_$iv = TextMateModelKt.getLogger();
                                    boolean $i$f$warn = false;
                                    if (this_$iv.isWarnEnabled()) {
                                        Throwable throwable2 = e;
                                        KLogger kLogger = this_$iv;
                                        boolean bl2 = false;
                                        String string = "Cannot find referenced file `" + relativePath + "` in `" + (String)object3 + "`";
                                        kLogger.warn(throwable2, (Object)string);
                                    }
                                    object = null;
                                }
                                return (InputStream)object;
                            }
                        };
                        TextMateModelKt.access$loadTextMateModel$lambda$14$loadBundle(this.$interner, this.$syntaxTable, this.$scopeToFileNameMatchers, this.$preferencesRegistry, this.$shellVariablesRegistry, this.$snippetsRegistry, resourceLoader2, bundleName);
                    }
                }));
                Object $this$forEach$iv = resourceLoadersEps;
                boolean $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    String key = (String)pair.component1();
                    Function1 loader = (Function1)pair.component2();
                    TextMateModelKt.loadTextMateModel$lambda$14$loadBundle((Interner<CharSequence>)interner2, syntaxTable, scopeToFileNameMatchers, preferencesRegistry, shellVariablesRegistry, snippetsRegistry, (Function1<? super String, ? extends InputStream>)loader, key);
                }
                $this$forEach$iv = extraTmDirs;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Throwable throwable;
                    Object $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$3$32;
                    Object element$iv = iterator.next();
                    Path bundleDir = (Path)element$iv;
                    boolean bl3 = false;
                    KLogger this_$iv = TextMateModelKt.getLogger();
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl4 = false;
                        kLogger.info((Object)("Loading extra textmate bundle: " + bundleDir));
                    }
                    try {
                        Unit unit;
                        boolean $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$3$32 = false;
                        TextMateBundleReader textMateBundleReader = TextMateModelKt.readBundle(bundleDir);
                        if (textMateBundleReader != null) {
                            TextMateModelKt.registerBundle(textMateBundleReader, (Interner<CharSequence>)interner2, syntaxTable, scopeToFileNameMatchers, preferencesRegistry, shellVariablesRegistry, snippetsRegistry);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$3$32 = Result.constructor-impl(unit);
                    }
                    catch (Throwable throwable2) {
                        $i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$3$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    if (Result.exceptionOrNull-impl((Object)$i$a$-runCatching-TextMateModelKt$loadTextMateModel$elapsedTime$1$3$32) == null) continue;
                    Throwable e = throwable;
                    boolean bl5 = false;
                    KLogger this_$iv2 = TextMateModelKt.getLogger();
                    boolean $i$f$warn = false;
                    if (!this_$iv2.isWarnEnabled()) continue;
                    Throwable throwable3 = e;
                    KLogger kLogger = this_$iv2;
                    boolean bl6 = false;
                    String string = "Couldn't load bundle from " + bundleDir;
                    kLogger.warn(throwable3, (Object)string);
                }
                $this$forEach$iv = scopeToFileNameMatchers;
                Map map2 = commentInformationPerLanguage;
                boolean $i$f$mapValues = false;
                iterator = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry e = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl7 = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl8 = false;
                    CharSequence scopeName = (CharSequence)entry.getKey();
                    CommentInformation commentInformation = TextMateModelKt.retrieveCommentInfo(scopeName, (ShellVariablesRegistry)shellVariablesRegistry);
                    map4.put(k, commentInformation);
                }
                map2.putAll(destination$iv$iv);
            }
            catch (IOException e) {
                KLogger this_$iv = TextMateModelKt.getLogger();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break block12;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl9 = false;
                String string = "Cannot list textmate bundles directory: ";
                kLogger.error(throwable, (Object)string);
            }
        }
        long elapsedTime2 = System.currentTimeMillis() - start$iv;
        KLogger this_$iv = TextMateModelKt.getLogger();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("TextMate grammars are loaded in " + elapsedTime2 + "ms"));
        }
        return new TextMateModel(syntaxTable, (PreferencesRegistry)preferencesRegistry, (ShellVariablesRegistry)shellVariablesRegistry, (SnippetsRegistry)snippetsRegistry, scopeToFileNameMatchers, commentInformationPerLanguage);
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerBundle(TextMateBundleReader $this$registerBundle, Interner<CharSequence> interner, TextMateSyntaxTable syntaxTable, Map<CharSequence, List<TextMateGrammar>> scopeToFileNameMatchers, PreferencesRegistryImpl preferencesRegistry, ShellVariablesRegistryImpl shellVariablesRegistry, SnippetsRegistryImpl snippetsRegistry) {
        CharSequence scopeName;
        KLogger this_$iv = TextMateModelKt.getLogger();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Registering TextMate bundle `" + $this$registerBundle.getBundleName() + "`"));
        }
        Sequence $this$forEach$iv = $this$registerBundle.readGrammars();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            CharSequence grammarScopeName;
            TextMateGrammar grammar = (TextMateGrammar)element$iv;
            boolean bl = false;
            scopeName = syntaxTable.loadSyntax((Plist)grammar.getPlist().getValue(), interner);
            String string = grammar.getOverrideScopeName();
            if ((string != null ? (CharSequence)string : scopeName) == null) continue;
            grammarScopeName = grammarScopeName;
            boolean bl2 = false;
            Map<CharSequence, List<TextMateGrammar>> map2 = scopeToFileNameMatchers;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(grammarScopeName);
            if (value$iv == null) {
                boolean bl3 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(grammarScopeName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(grammar);
        }
        $this$forEach$iv = $this$registerBundle.readPreferences();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextMatePreferences preferences = (TextMatePreferences)element$iv;
            boolean bl = false;
            Object object = interner.intern((Object)preferences.getScopeName());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"intern(...)");
            scopeName = (CharSequence)object;
            preferencesRegistry.addPreferences(new Preferences(scopeName, preferences.getHighlightingPairs(), preferences.getSmartTypingPairs(), preferences.getSurroundingPairs(), preferences.getAutoCloseBefore(), preferences.getIndentationRules(), preferences.getOnEnterRules()));
            Iterable $this$forEach$iv2 = preferences.getVariables();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TextMateShellVariable variable = (TextMateShellVariable)element$iv2;
                boolean bl4 = false;
                shellVariablesRegistry.addVariable(variable);
            }
        }
        $this$forEach$iv = $this$registerBundle.readSnippets();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextMateSnippet snippet = (TextMateSnippet)element$iv;
            boolean bl = false;
            snippetsRegistry.register(snippet);
        }
    }

    private static final TextMateBundleReader readBundle(Path path) {
        return switch (WhenMappings.$EnumSwitchMapping$0[BundleType.Companion.detectBundleType(path).ordinal()]) {
            case 1 -> BundleReaderKt.readTextMateBundle((Path)path);
            case 2 -> BundleReaderKt.readSublimeBundle((Path)path);
            case 3 -> VSCBundleReaderKt.readVSCBundle((Function1)((Function1)new Function1<String, InputStream>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(1);
                }

                @Nullable
                public final InputStream invoke(@NotNull String relativePath) {
                    Object object;
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                    Object object3 = this.$path;
                    try {
                        boolean bl = false;
                        Path path = object3.resolve(relativePath);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                        Path path2 = path;
                        OpenOption[] openOptionArray = new OpenOption[]{};
                        InputStream inputStream = Files.newInputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                        object2 = Result.constructor-impl((Object)inputStream);
                    }
                    catch (Throwable throwable) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object3 = object2;
                    object2 = this.$path;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                    if (throwable == null) {
                        object = object3;
                    } else {
                        Throwable e = throwable;
                        boolean bl = false;
                        if (e instanceof NoSuchFileException) {
                            KLogger this_$iv = TextMateModelKt.getLogger();
                            boolean $i$f$warn = false;
                            if (this_$iv.isWarnEnabled()) {
                                KLogger kLogger = this_$iv;
                                boolean bl2 = false;
                                kLogger.warn((Object)("Cannot find referenced file `" + relativePath + "` in `" + (Path)object2 + "`"));
                            }
                        } else {
                            KLogger this_$iv = TextMateModelKt.getLogger();
                            boolean $i$f$warn = false;
                            if (this_$iv.isWarnEnabled()) {
                                Throwable throwable2 = e;
                                KLogger kLogger = this_$iv;
                                boolean bl3 = false;
                                String string = "Cannot read referenced file `" + relativePath + "` in `" + (Path)object2 + "`";
                                kLogger.warn(throwable2, (Object)string);
                            }
                        }
                        object = null;
                    }
                    return (InputStream)object;
                }
            }));
            case 4 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final CommentInformation retrieveCommentInfo(CharSequence textMateScopeName, ShellVariablesRegistry shellVariablesRegistry) {
        BlockCommentInfo blockCommentInfo;
        LineCommentInfo lineCommentInfo;
        TextMateScope textMateScope = new TextMateScope(textMateScopeName, null);
        TextMateShellVariable lineCommentVariable = null;
        Pair blockCommentVariables = null;
        int index = 1;
        while (blockCommentVariables == null || lineCommentVariable == null) {
            Object variableSuffix = index > 1 ? "_" + index : "";
            TextMateShellVariable start = shellVariablesRegistry.getVariableValue("TM_COMMENT_START" + (String)variableSuffix, textMateScope);
            TextMateShellVariable end = shellVariablesRegistry.getVariableValue("TM_COMMENT_END" + (String)variableSuffix, textMateScope);
            ++index;
            if (start == null) break;
            if (!(end != null && Intrinsics.areEqual((Object)end.scopeName, (Object)start.scopeName) || lineCommentVariable != null)) {
                lineCommentVariable = start;
            }
            if (end == null || !Intrinsics.areEqual((Object)end.scopeName, (Object)start.scopeName) || blockCommentVariables != null) continue;
            blockCommentVariables = TuplesKt.to((Object)start, (Object)end);
        }
        if (lineCommentVariable == null && blockCommentVariables == null) {
            return null;
        }
        TextMateShellVariable textMateShellVariable = lineCommentVariable;
        if (textMateShellVariable != null) {
            TextMateShellVariable it = textMateShellVariable;
            boolean bl = false;
            String string = it.value;
            CharSequence charSequence = it.scopeName;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"scopeName");
            TMElementType.OriginalComment originalComment = TMElementType.Companion.originalComment(charSequence, "line");
            Intrinsics.checkNotNull((Object)string);
            lineCommentInfo = new LineCommentInfo(originalComment, string);
        } else {
            lineCommentInfo = null;
        }
        LineCommentInfo lineCommentInfo2 = lineCommentInfo;
        Pair pair = blockCommentVariables;
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            TextMateShellVariable start = (TextMateShellVariable)pair2.component1();
            TextMateShellVariable end = (TextMateShellVariable)pair2.component2();
            String string = start.value;
            String string2 = end.value;
            CharSequence charSequence = start.scopeName;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"scopeName");
            TMElementType.OriginalComment originalComment = TMElementType.Companion.originalComment(charSequence, "block");
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)string2);
            blockCommentInfo = new BlockCommentInfo(originalComment, string, string2);
        } else {
            blockCommentInfo = null;
        }
        BlockCommentInfo blockCommentInfo2 = blockCommentInfo;
        return new CommentInformation(lineCommentInfo2, blockCommentInfo2);
    }

    private static final void loadTextMateModel$lambda$14$loadBundle(Interner<CharSequence> interner, TextMateSyntaxTable syntaxTable, Map<CharSequence, List<TextMateGrammar>> scopeToFileNameMatchers, PreferencesRegistryImpl preferencesRegistry, ShellVariablesRegistryImpl shellVariablesRegistry, SnippetsRegistryImpl snippetsRegistry, Function1<? super String, ? extends InputStream> resourceLoader2, String bundleName) {
        block7: {
            Object object;
            KLogger kLogger;
            KLogger this_$iv;
            Object object2;
            try {
                Unit unit;
                boolean bl = false;
                TextMateBundleReader reader = object2 = VSCBundleReaderKt.readVSCBundle(resourceLoader2);
                boolean bl2 = false;
                if (reader == null) {
                    this_$iv = TextMateModelKt.getLogger();
                    boolean $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        kLogger = this_$iv;
                        boolean bl3 = false;
                        kLogger.warn((Object)("Couldn't load built-in textmate bundle `" + bundleName + "`"));
                    }
                }
                Object object3 = object2;
                if (object3 != null) {
                    TextMateModelKt.registerBundle(object3, interner, syntaxTable, scopeToFileNameMatchers, preferencesRegistry, shellVariablesRegistry, snippetsRegistry);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block7;
            Object e = object2 = throwable;
            boolean bl = false;
            this_$iv = TextMateModelKt.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                kLogger = e;
                KLogger kLogger2 = this_$iv;
                boolean bl4 = false;
                String string = "Couldn't load bundle from " + resourceLoader2 + " with bundle name " + bundleName;
                kLogger2.error((Throwable)kLogger, (Object)string);
            }
        }
    }

    public static final /* synthetic */ void access$loadTextMateModel$lambda$14$loadBundle(Interner interner, TextMateSyntaxTable syntaxTable, Map scopeToFileNameMatchers, PreferencesRegistryImpl preferencesRegistry, ShellVariablesRegistryImpl shellVariablesRegistry, SnippetsRegistryImpl snippetsRegistry, Function1 resourceLoader2, String bundleName) {
        TextMateModelKt.loadTextMateModel$lambda$14$loadBundle((Interner<CharSequence>)interner, syntaxTable, scopeToFileNameMatchers, preferencesRegistry, shellVariablesRegistry, snippetsRegistry, (Function1<? super String, ? extends InputStream>)resourceLoader2, bundleName);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BundleType.values().length];
            try {
                nArray[BundleType.TEXTMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.SUBLIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.VSCODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.UNDEFINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

