/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.jcef.frontend.distribution;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.api.Arch;
import fleet.api.ArchiveApi;
import fleet.api.BackendProgress;
import fleet.api.Checksum;
import fleet.api.DownloadApi;
import fleet.api.DownloadProgressInformation;
import fleet.api.DownloadResult;
import fleet.api.ExtractProgressInformation;
import fleet.api.ExtractResult;
import fleet.api.ExtractionMode;
import fleet.api.FsApi;
import fleet.api.FsApiKt;
import fleet.api.Os;
import fleet.api.Platform;
import fleet.api.ProtocolPath;
import fleet.common.GlobalProgressProviderKt;
import fleet.common.SimpleProgressProvider;
import fleet.common.download.DownloadingException;
import fleet.dock.api.DockPaths;
import fleet.dock.connectors.DockPathKeys;
import fleet.kernel.ReteExtKt;
import fleet.kernel.TransactorKt;
import fleet.kernel.plugins.ContributionScope;
import fleet.kernel.plugins.WorkerKt;
import fleet.plugins.jcef.frontend.distribution.DistributionKt;
import fleet.plugins.jcef.frontend.distribution.JcefDistribution;
import fleet.util.logging.BaseLogger;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0006*\u00020\u000bH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0080@\u00a2\u0006\u0002\u0010\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0015\u001a\u00020\u0012H\u0080@\u00a2\u0006\u0002\u0010\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001a\u001a&\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001e\u001a\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002\u001a\f\u0010\u001f\u001a\u00020 *\u00020\"H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"logger", "Lfleet/util/logging/KLogger;", "registerCefApplicationDistributionInitializer", "", "Lfleet/kernel/plugins/ContributionScope;", "toJcefDistributionOs", "", "Lfleet/api/Os;", "toJcefDistributionArch", "Lfleet/api/Arch;", "toArtifactPlatformName", "Lfleet/api/Platform;", "supportedPlatforms", "", "JcefArtifactVersion", "obtainJcefDistributionUrl", "platform", "downloadAndUnpackDistribution", "Lfleet/api/ProtocolPath;", "(Lfleet/api/Platform;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "obtainDistributionPath", "obtainCachePath", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadDistribution", "indicator", "Lfleet/common/SimpleProgressProvider;", "(Lfleet/api/Platform;Lfleet/common/SimpleProgressProvider;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unpackDistribution", "source", "destination", "(Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/common/SimpleProgressProvider;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fraction", "", "Lfleet/api/DownloadProgressInformation;", "Lfleet/api/ExtractProgressInformation;", "fleet.plugins.jcef.frontend"})
@SourceDebugExtension(value={"SMAP\nDistribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Distribution.kt\nfleet/plugins/jcef/frontend/distribution/DistributionKt\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,172:1\n326#2:173\n1#3:174\n25#4:175\n*S KotlinDebug\n*F\n+ 1 Distribution.kt\nfleet/plugins/jcef/frontend/distribution/DistributionKt\n*L\n120#1:173\n36#1:175\n*E\n"})
public final class DistributionKt {
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final Set<Platform> supportedPlatforms;
    @NotNull
    private static final String JcefArtifactVersion = "122.1.9.886+gb459d85";

    public static final void registerCefApplicationDistributionInitializer(@NotNull ContributionScope $this$registerCefApplicationDistributionInitializer) {
        Intrinsics.checkNotNullParameter((Object)$this$registerCefApplicationDistributionInitializer, (String)"<this>");
        WorkerKt.worker((ChangeScope)((ChangeScope)$this$registerCefApplicationDistributionInitializer), (String)"Cef distribution initializer", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$worker = (CoroutineScope)this.L$0;
                        Deferred path2 = BuildersKt.async$default((CoroutineScope)$this$worker, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProtocolPath>, Object>(null){
                            int label;

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = DistributionKt.downloadAndUnpackDistribution(Platform.Companion.local(), (Continuation<? super ProtocolPath>)((Continuation)this));
                                        ** if (v0 != var4_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var4_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            distribution = (ProtocolPath)v0;
                                            return distribution.resolveChild("jcef");
                                        }
                                        catch (DownloadingException exception) {
                                            BaseLogger.warn$default((BaseLogger)((BaseLogger)DistributionKt.access$getLogger$p()), (Throwable)exception, null, (int)2, null);
                                            return null;
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super ProtocolPath> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        this.label = 1;
                        Object object3 = TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>((Deferred<ProtocolPath>)path2){
                            final /* synthetic */ Deferred<ProtocolPath> $path;
                            {
                                this.$path = $path;
                                super(1);
                            }

                            public final void invoke(ChangeScope $this$change) {
                                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                                $this$change.new((EntityType)JcefDistribution.Companion, arg_0 -> registerCefApplicationDistributionInitializer.1.invoke$lambda$0(this.$path, arg_0));
                            }

                            private static final void invoke$lambda$0(Deferred $path, EntityBuilder.Target it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.set(JcefDistribution.Companion.getPathAttr(), (Object)$path);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final String toJcefDistributionOs(Os $this$toJcefDistributionOs) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toJcefDistributionOs.ordinal()]) {
            case 1 -> "macos";
            case 2 -> "windows";
            case 3 -> "linux";
            default -> throw new IllegalStateException(($this$toJcefDistributionOs + " os is not supported").toString());
        };
    }

    private static final String toJcefDistributionArch(Arch $this$toJcefDistributionArch) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toJcefDistributionArch.ordinal()]) {
            case 1 -> "aarch64";
            case 2 -> "x64";
            default -> throw new IllegalStateException(($this$toJcefDistributionArch + " arch is not supported").toString());
        };
    }

    private static final String toArtifactPlatformName(Platform $this$toArtifactPlatformName) {
        String string = DistributionKt.toJcefDistributionOs($this$toArtifactPlatformName.getOs()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String osName = string;
        String string2 = DistributionKt.toJcefDistributionArch($this$toArtifactPlatformName.getArch()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String archName = string2;
        return osName + "-" + archName;
    }

    @NotNull
    public static final String obtainJcefDistributionUrl(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        String base = "https://download.jetbrains.com/grazie/fleet-jcef";
        int buildNumber = 4;
        String version = StringsKt.replace$default((String)JcefArtifactVersion, (String)"+", (String)"%2B", (boolean)false, (int)4, null);
        String artifact = "fleet-jcef-" + DistributionKt.toArtifactPlatformName(platform) + "-" + version + ".tar.gz";
        return base + "/build-" + buildNumber + "/" + artifact;
    }

    @Nullable
    public static final Object downloadAndUnpackDistribution(@NotNull Platform platform, @NotNull Continuation<? super ProtocolPath> $completion) {
        return GlobalProgressProviderKt.withProgress$default((String)"Initializing JCEF Distribution", (boolean)false, (Function3)((Function3)new Function3<CoroutineScope, SimpleProgressProvider, Continuation<? super ProtocolPath>, Object>(platform, null){
            Object L$1;
            Object L$2;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ Platform $platform;
            {
                this.$platform = $platform;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        indicator = (SimpleProgressProvider)this.L$0;
                        this.L$0 = indicator;
                        this.label = 1;
                        v0 = ReteExtKt.waitForNotNull((Function0)downloadAndUnpackDistribution.localFs.1.INSTANCE, (Continuation)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        indicator = (SimpleProgressProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        localFs = (FsApi)v0;
                        this.L$0 = indicator;
                        this.L$1 = localFs;
                        this.label = 2;
                        v1 = DistributionKt.access$obtainDistributionPath(this.$platform, (Continuation)this);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        localFs = (FsApi)this.L$1;
                        indicator = (SimpleProgressProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        destination = (ProtocolPath)v1;
                        this.L$0 = indicator;
                        this.L$1 = destination;
                        this.label = 3;
                        v2 = FsApiKt.exists$default((FsApi)localFs, (ProtocolPath)destination, (boolean)false, (Continuation)((Continuation)this), (int)2, null);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl42
                    }
                    case 3: {
                        destination = (ProtocolPath)this.L$1;
                        indicator = (SimpleProgressProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl42:
                        // 2 sources

                        if (((Boolean)v2).booleanValue()) {
                            return destination;
                        }
                        this.L$0 = indicator;
                        this.L$1 = destination;
                        this.label = 4;
                        v3 = indicator.update((Function2)downloadAndUnpackDistribution.1.INSTANCE, (Continuation)this);
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl56
                    }
                    case 4: {
                        destination = (ProtocolPath)this.L$1;
                        indicator = (SimpleProgressProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl56:
                        // 2 sources

                        this.L$0 = indicator;
                        this.L$1 = destination;
                        this.label = 5;
                        v4 = DistributionKt.access$downloadDistribution(this.$platform, indicator, (Continuation)this);
                        if (v4 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl68
                    }
                    case 5: {
                        destination = (ProtocolPath)this.L$1;
                        indicator = (SimpleProgressProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl68:
                        // 2 sources

                        archivePath = (ProtocolPath)v4;
                        this.L$0 = indicator;
                        this.L$1 = destination;
                        this.L$2 = archivePath;
                        this.label = 6;
                        v5 = indicator.update((Function2)downloadAndUnpackDistribution.2.INSTANCE, (Continuation)this);
                        if (v5 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl83
                    }
                    case 6: {
                        archivePath = (ProtocolPath)this.L$2;
                        destination = (ProtocolPath)this.L$1;
                        indicator = (SimpleProgressProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl83:
                        // 2 sources

                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 7;
                        v6 = DistributionKt.access$unpackDistribution(archivePath, destination, indicator, (Continuation)this);
                        if (v6 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl94
                    }
                    case 7: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl94:
                        // 2 sources

                        return v6;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(CoroutineScope p1, SimpleProgressProvider p2, Continuation<? super ProtocolPath> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }), $completion, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object obtainDistributionPath(Platform var0, Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof obtainDistributionPath.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DistributionKt.access$obtainDistributionPath(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = platform;
                $continuation.label = 1;
                v0 = DistributionKt.obtainCachePath((Continuation<? super ProtocolPath>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                platform = (Platform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                cache = (ProtocolPath)v0;
                return cache.resolveChild("fleet-jcef-" + DistributionKt.toArtifactPlatformName(platform) + "-122.1.9.886+gb459d85");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final Object obtainCachePath(@NotNull Continuation<? super ProtocolPath> $completion) {
        boolean $i$f$currentCoroutineContext = false;
        CoroutineContext context = $completion.getContext();
        DockPaths dockPaths = (DockPaths)context.get((CoroutineContext.Key)DockPaths.Companion);
        Path path2 = dockPaths != null ? (Path)dockPaths.getPath(DockPathKeys.INSTANCE.getCachesPath()) : null;
        if (path2 == null) {
            boolean bl = false;
            String string = "Failed to obtain DockPathKeys.CachesPath from current coroutine context";
            throw new IllegalArgumentException(string.toString());
        }
        return ProtocolPath.Companion.fromNioPath(path2);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object downloadDistribution(Platform var0, SimpleProgressProvider var1_1, Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof downloadDistribution.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DistributionKt.access$downloadDistribution(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = platform;
                $continuation.L$1 = indicator;
                $continuation.label = 1;
                v0 = ReteExtKt.waitForNotNull((Function0)downloadDistribution.downloadService.1.INSTANCE, (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                indicator = (SimpleProgressProvider)$continuation.L$1;
                platform = (Platform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                downloadService = (DownloadApi)v0;
                if (!DistributionKt.supportedPlatforms.contains(platform)) {
                    $i$a$-check-DistributionKt$downloadDistribution$2 = false;
                    $i$a$-check-DistributionKt$downloadDistribution$2 = platform + " is not supported";
                    throw new IllegalStateException($i$a$-check-DistributionKt$downloadDistribution$2.toString());
                }
                url = DistributionKt.obtainJcefDistributionUrl(platform);
                $continuation.L$0 = indicator;
                $continuation.L$1 = url;
                $continuation.label = 2;
                v1 = downloadService.download(url, (Checksum)Checksum.NotValidated.INSTANCE, true, (Continuation)$continuation);
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                url = (String)$continuation.L$1;
                indicator = (SimpleProgressProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                states = FlowKt.onEach((Flow)((Flow)v1), (Function2)((Function2)new Function2<DownloadResult, Continuation<? super Unit>, Object>(indicator, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ SimpleProgressProvider $indicator;
                    {
                        this.$indicator = $indicator;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                DownloadResult state = (DownloadResult)this.L$0;
                                if (!(state instanceof DownloadResult.Downloading)) return Unit.INSTANCE;
                                DownloadProgressInformation downloadProgressInformation = ((DownloadResult.Downloading)state).getProgress();
                                if (downloadProgressInformation == null) {
                                    return Unit.INSTANCE;
                                }
                                DownloadProgressInformation progress = downloadProgressInformation;
                                KLogger this_$iv = DistributionKt.access$getLogger$p();
                                boolean $i$f$debug = false;
                                if (this_$iv.isDebugEnabled()) {
                                    KLogger kLogger = this_$iv;
                                    boolean bl = false;
                                    kLogger.debug((Object)("Downloading jcef distribution (" + progress + ")"));
                                }
                                this.label = 1;
                                Object object3 = this.$indicator.update((Function2)new Function2<ChangeScope, BackendProgress, BackendProgress>(progress){
                                    final /* synthetic */ DownloadProgressInformation $progress;
                                    {
                                        this.$progress = $progress;
                                        super(2);
                                    }

                                    public final BackendProgress invoke(ChangeScope $this$update, BackendProgress it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return BackendProgress.copy$default((BackendProgress)it, null, null, null, null, null, (boolean)false, (boolean)false, (Double)DistributionKt.access$fraction(this.$progress), null, (int)383, null);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(DownloadResult p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                $continuation.L$0 = url;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v2 = FlowKt.last((Flow)states, (Continuation)$continuation);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl54
            }
            case 3: {
                url = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl54:
                // 2 sources

                if ((result = (DownloadResult)v2) instanceof DownloadResult.Failed) {
                    throw new DownloadingException("Failed to download jcef distribution from " + url + ". Cause: " + ((DownloadResult.Failed)result).getFailure() + ".");
                }
                if (result instanceof DownloadResult.Downloading) {
                    throw new IllegalStateException("Inconsistent download result".toString());
                }
                if (!(result instanceof DownloadResult.Done)) {
                    throw new NoWhenBranchMatchedException();
                }
                path = ((DownloadResult.Done)result).getPath();
                return path;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object unpackDistribution(ProtocolPath var0, ProtocolPath var1_1, SimpleProgressProvider var2_2, Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof unpackDistribution.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DistributionKt.access$unpackDistribution(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = source;
                $continuation.L$1 = destination;
                $continuation.L$2 = indicator;
                $continuation.label = 1;
                v0 = ReteExtKt.waitForNotNull((Function0)unpackDistribution.archiveService.1.INSTANCE, (Continuation)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                indicator = (SimpleProgressProvider)$continuation.L$2;
                destination = (ProtocolPath)$continuation.L$1;
                source = (ProtocolPath)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                archiveService = (ArchiveApi)v0;
                $continuation.L$0 = source;
                $continuation.L$1 = destination;
                $continuation.L$2 = indicator;
                $continuation.label = 2;
                v1 = archiveService.extract(source, destination, (ExtractionMode)ExtractionMode.CleanTargetDirectoryIfExists.INSTANCE, (Continuation)$continuation);
                if (v1 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl41
            }
            case 2: {
                indicator = (SimpleProgressProvider)$continuation.L$2;
                destination = (ProtocolPath)$continuation.L$1;
                source = (ProtocolPath)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                states = FlowKt.onEach((Flow)((Flow)v1), (Function2)((Function2)new Function2<ExtractResult, Continuation<? super Unit>, Object>(indicator, source, destination, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ SimpleProgressProvider $indicator;
                    final /* synthetic */ ProtocolPath $source;
                    final /* synthetic */ ProtocolPath $destination;
                    {
                        this.$indicator = $indicator;
                        this.$source = $source;
                        this.$destination = $destination;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void this_$iv;
                                ResultKt.throwOnFailure((Object)object);
                                ExtractResult state = (ExtractResult)this.L$0;
                                if (!(state instanceof ExtractResult.Extracting)) return Unit.INSTANCE;
                                ExtractProgressInformation extractProgressInformation = ((ExtractResult.Extracting)state).getProgress();
                                if (extractProgressInformation == null) {
                                    return Unit.INSTANCE;
                                }
                                ExtractProgressInformation progress = extractProgressInformation;
                                KLogger kLogger = DistributionKt.access$getLogger$p();
                                ProtocolPath protocolPath = this.$source;
                                ProtocolPath protocolPath2 = this.$destination;
                                boolean $i$f$debug = false;
                                if (this_$iv.isDebugEnabled()) {
                                    void var9_9 = this_$iv;
                                    boolean bl = false;
                                    var9_9.debug((Object)("Extracting " + protocolPath + " to " + protocolPath2 + " (" + progress + ")"));
                                }
                                this.label = 1;
                                Object object3 = this.$indicator.update((Function2)new Function2<ChangeScope, BackendProgress, BackendProgress>(progress){
                                    final /* synthetic */ ExtractProgressInformation $progress;
                                    {
                                        this.$progress = $progress;
                                        super(2);
                                    }

                                    public final BackendProgress invoke(ChangeScope $this$update, BackendProgress it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return BackendProgress.copy$default((BackendProgress)it, null, null, null, null, null, (boolean)false, (boolean)false, (Double)DistributionKt.access$fraction(this.$progress), null, (int)383, null);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(ExtractResult p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                $continuation.L$0 = source;
                $continuation.L$1 = destination;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v2 = FlowKt.last((Flow)states, (Continuation)$continuation);
                if (v2 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl55
            }
            case 3: {
                destination = (ProtocolPath)$continuation.L$1;
                source = (ProtocolPath)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 2 sources

                if ((result = (ExtractResult)v2) instanceof ExtractResult.Done) {
                    return ((ExtractResult.Done)result).getPath();
                }
                if (result instanceof ExtractResult.Failed) {
                    throw new IllegalStateException(("Cannot decompress " + source + " to " + destination + ". Cause: " + ((ExtractResult.Failed)result).getFailure() + ".").toString());
                }
                if (result instanceof ExtractResult.Extracting) {
                    throw new IllegalStateException(("ExtractResult.Extracting was last state after unzipping: " + ((ExtractResult.Extracting)result).getProgress()).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final double fraction(DownloadProgressInformation $this$fraction) {
        return (double)$this$fraction.getDownloaded() / (double)$this$fraction.getTotal();
    }

    private static final double fraction(ExtractProgressInformation $this$fraction) {
        return (double)$this$fraction.getExtracted() / (double)$this$fraction.getTotal();
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ Object access$obtainDistributionPath(Platform platform, Continuation $completion) {
        return DistributionKt.obtainDistributionPath(platform, (Continuation<? super ProtocolPath>)$completion);
    }

    public static final /* synthetic */ Object access$downloadDistribution(Platform platform, SimpleProgressProvider indicator, Continuation $completion) {
        return DistributionKt.downloadDistribution(platform, indicator, (Continuation<? super ProtocolPath>)$completion);
    }

    public static final /* synthetic */ Object access$unpackDistribution(ProtocolPath source, ProtocolPath destination, SimpleProgressProvider indicator, Continuation $completion) {
        return DistributionKt.unpackDistribution(source, destination, indicator, (Continuation<? super ProtocolPath>)$completion);
    }

    public static final /* synthetic */ double access$fraction(DownloadProgressInformation $receiver) {
        return DistributionKt.fraction($receiver);
    }

    public static final /* synthetic */ double access$fraction(ExtractProgressInformation $receiver) {
        return DistributionKt.fraction($receiver);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(JcefDistribution.class));
        Object[] objectArray = new Platform[]{new Platform(Os.Macos, Arch.aarch64), new Platform(Os.Macos, Arch.x86_64), new Platform(Os.Linux, Arch.aarch64), new Platform(Os.Linux, Arch.x86_64), new Platform(Os.Windows, Arch.aarch64), new Platform(Os.Windows, Arch.x86_64)};
        supportedPlatforms = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Os.values().length];
            try {
                nArray[Os.Macos.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.aarch64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.x86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

