/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.tbe.config.machine;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigCertificates;", "", "<init>", "()V", "saveCertificatePem", "", "certificate", "Ljava/security/cert/X509Certificate;", "loadCertificate", "index", "", "pem", "tbe-config-machine"})
@SourceDebugExtension(value={"SMAP\nTbeMachineConfigCertificates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbeMachineConfigCertificates.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigCertificates\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class TbeMachineConfigCertificates {
    @NotNull
    public static final TbeMachineConfigCertificates INSTANCE = new TbeMachineConfigCertificates();

    private TbeMachineConfigCertificates() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String saveCertificatePem(@NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter sw = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new JcaPEMWriter((Writer)sw);
            Throwable throwable2 = null;
            try {
                JcaPEMWriter it = (JcaPEMWriter)closeable2;
                boolean bl2 = false;
                it.writeObject((Object)certificate);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final X509Certificate loadCertificate(int index, @NotNull String pem) {
        X509Certificate t2;
        X509CertificateHolder x509CertificateHolder;
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        try {
            Object object = new PEMParser((Reader)new StringReader(pem)).readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.cert.X509CertificateHolder");
            x509CertificateHolder = (X509CertificateHolder)object;
        }
        catch (Exception t2) {
            throw new IllegalArgumentException("Failed to parse certificate block at index " + index + ". " + t2.getMessage() + ". PEM encoded certificate is expected, but was: " + StringsKt.take((String)pem, (int)40), t2);
        }
        X509CertificateHolder holder = x509CertificateHolder;
        try {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(holder);
            Intrinsics.checkNotNull((Object)x509Certificate);
            t2 = x509Certificate;
        }
        catch (Exception t3) {
            throw new IllegalArgumentException("Failed to load certificate at index " + index + ". " + t3.getMessage(), t3);
        }
        X509Certificate cert = t2;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return null;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return null;
        }
        catch (Exception t2) {
            throw new IllegalArgumentException("Certificate is no longer valid at index " + index + ". " + t2.getMessage(), t2);
        }
        return cert;
    }
}

