/*
 * Decompiled with CFR 0.152.
 */
package fleet.cpp.workspace;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jetbrains.rhizomedb.Entity;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.HostId;
import fleet.api.topology.ApiKey;
import fleet.common.topology.Service;
import fleet.common.topology.ServiceKt;
import fleet.cpp.common.ClangdApi;
import fleet.cpp.workspace.ClangLanguageClientBase;
import fleet.cpp.workspace.ClangdIndexer;
import fleet.cpp.workspace.ClangdIndexerConfiguration;
import fleet.kernel.SagaKt;
import fleet.kernel.plugins.PluginScope;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.workspace.lsp.LspConnection;
import fleet.workspace.lsp.ProtocolExtsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0019H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lfleet/cpp/workspace/ClangdIndexerLanguageClient;", "Lfleet/cpp/workspace/ClangLanguageClientBase;", "lifetime", "Lcom/jetbrains/rhizomedb/Entity;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "config", "Lfleet/cpp/workspace/ClangdIndexerConfiguration;", "hostId", "Lfleet/api/HostId;", "<init>", "(Lcom/jetbrains/rhizomedb/Entity;Lfleet/kernel/plugins/PluginScope;Lfleet/cpp/workspace/ClangdIndexerConfiguration;Lfleet/api/HostId;)V", "logger", "Lfleet/util/logging/KLogger;", "findClangdService", "Lfleet/common/topology/Service;", "Lfleet/cpp/common/ClangdApi;", "onCompilationDatabaseChanged", "", "newCDBs", "", "Lfleet/api/FileAddress;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexingMessage", "params", "Lcom/google/gson/JsonObject;", "indexingStarted", "indexingTask", "indexDiagsUpdated", "indexingProgress", "graphFinished", "indexPartFinished", "indexingFinished", "indexingFinishedParams", "fleet.plugins.cpp.workspace"})
@SourceDebugExtension(value={"SMAP\nClangdLanguageClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdLanguageClient.kt\nfleet/cpp/workspace/ClangdIndexerLanguageClient\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,182:1\n25#2:183\n295#3,2:184\n1557#3:188\n1628#3,3:189\n10#4,2:186\n10#4,2:192\n10#4,2:194\n*S KotlinDebug\n*F\n+ 1 ClangdLanguageClient.kt\nfleet/cpp/workspace/ClangdIndexerLanguageClient\n*L\n91#1:183\n94#1:184,2\n104#1:188\n104#1:189,3\n100#1:186,2\n106#1:192,2\n112#1:194,2\n*E\n"})
public final class ClangdIndexerLanguageClient
extends ClangLanguageClientBase {
    @NotNull
    private final KLogger logger;

    public ClangdIndexerLanguageClient(@NotNull Entity lifetime, @NotNull PluginScope pluginScope, @NotNull ClangdIndexerConfiguration config, @NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        super(lifetime, pluginScope, config, hostId, null);
        boolean $i$f$logger = false;
        this.logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ClangdIndexerLanguageClient.class));
    }

    private final Service<ClangdApi> findClangdService() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = ServiceKt.all((ApiKey)((ApiKey)ClangdApi.Companion));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Service it = (Service)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((ClangdApi.Meta)ServiceKt.getMeta((Service)it)).getHostId(), (Object)this.getHostId())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object onCompilationDatabaseChanged(@NotNull List<FileAddress> newCDBs, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$debug;
        KLogger this_$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual(newCDBs, this.getClangdConfig().getCompilationDatabases())) {
            return Unit.INSTANCE;
        }
        if (newCDBs.isEmpty()) {
            KLogger this_$iv2 = this.logger;
            boolean $i$f$debug2 = false;
            if (this_$iv2.isDebugEnabled()) {
                KLogger kLogger = this_$iv2;
                boolean bl = false;
                kLogger.debug((Object)"TODO: support dropping of indexer CDB");
            }
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = newCDBs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileAddress fileAddress = (FileAddress)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FileAddress fileAddress2 = FileAddressKt.parent((FileAddress)it);
            Intrinsics.checkNotNull((Object)fileAddress2);
            collection.add(fileAddress2);
        }
        Set newCDBsDirs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (newCDBsDirs.size() > 1) {
            this_$iv = this.logger;
            $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                collection = this_$iv;
                boolean bl = false;
                collection.debug("TODO: support loading CDBs from multiple directories.\nConfiguring indexer with " + CollectionsKt.first((Iterable)newCDBsDirs) + ",\ndropping " + CollectionsKt.drop((Iterable)newCDBsDirs, (int)1));
            }
        }
        this_$iv = this.logger;
        $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            collection = this_$iv;
            boolean bl = false;
            collection.debug("Compilation database changed from '" + this.getClangdConfig().getCompilationDatabases() + "' to '" + newCDBs + "'");
        }
        this.getClangdConfig().setCompilationDatabases(newCDBs);
        Object object = this.getCachedConnection-d1pmJ48();
        LspConnection lspConnection = (LspConnection)(Result.isFailure-impl((Object)object) ? null : object);
        iterable = lspConnection != null && (lspConnection = lspConnection.getLauncher()) != null ? (LanguageServer)lspConnection.getRemoteProxy() : null;
        ClangdIndexer clangdIndexer = iterable instanceof ClangdIndexer ? (ClangdIndexer)((Object)iterable) : null;
        if (clangdIndexer == null) {
            return Unit.INSTANCE;
        }
        ClangdIndexer indexer = clangdIndexer;
        indexer.loadCDB(new TextDocumentIdentifier(ProtocolExtsKt.uri((FileAddress)((FileAddress)CollectionsKt.first((Iterable)newCDBsDirs)))));
        return Unit.INSTANCE;
    }

    @JsonNotification(value="clionIndexingMessage")
    public final void indexingMessage(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.logMessage(new MessageParams(MessageType.Log, params.get("message").getAsString()));
    }

    @JsonNotification(value="clionIndexingStarted")
    public final void indexingStarted(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @JsonNotification(value="clionIndexingTask")
    public final void indexingTask(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @JsonNotification(value="clionIndexDiagsUpdated")
    public final void indexDiagsUpdated(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @JsonNotification(value="clionIndexingProgress")
    public final void indexingProgress(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @JsonNotification(value="clionGraphFinished")
    public final void graphFinished(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Entity[] entityArray = new Entity[]{this.getLifetime()};
        SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.getPluginScope()), (Entity[])entityArray, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, params, null){
            int label;
            final /* synthetic */ ClangdIndexerLanguageClient this$0;
            final /* synthetic */ JsonObject $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Service clangdService = ClangdIndexerLanguageClient.access$findClangdService(this.this$0);
                        if (clangdService == null) {
                            KLogger this_$iv = ClangdIndexerLanguageClient.access$getLogger$p(this.this$0);
                            boolean $i$f$debug = false;
                            if (!this_$iv.isDebugEnabled()) return Unit.INSTANCE;
                            KLogger kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.debug((Object)"graphFinished notification dropped");
                            return Unit.INSTANCE;
                        }
                        String path = this.$params.get("path").getAsString();
                        ClangdApi clangdApi = (ClangdApi)clangdService.getApi();
                        Intrinsics.checkNotNull((Object)path);
                        this.label = 1;
                        Object object3 = clangdApi.notifyLoadGraph(path, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)6, null);
    }

    @JsonNotification(value="clionIndexPartFinished")
    public final void indexPartFinished(@NotNull JsonObject params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Entity[] entityArray = new Entity[]{this.getLifetime()};
        SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.getPluginScope()), (Entity[])entityArray, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, params, null){
            int label;
            final /* synthetic */ ClangdIndexerLanguageClient this$0;
            final /* synthetic */ JsonObject $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Service clangdService = ClangdIndexerLanguageClient.access$findClangdService(this.this$0);
                        if (clangdService == null) {
                            KLogger this_$iv = ClangdIndexerLanguageClient.access$getLogger$p(this.this$0);
                            boolean $i$f$debug = false;
                            if (!this_$iv.isDebugEnabled()) return Unit.INSTANCE;
                            KLogger kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.debug((Object)"indexPartFinished notification dropped");
                            return Unit.INSTANCE;
                        }
                        String path = this.$params.get("path").getAsString();
                        ClangdApi clangdApi = (ClangdApi)clangdService.getApi();
                        Intrinsics.checkNotNull((Object)path);
                        this.label = 1;
                        Object object3 = clangdApi.notifyIndexPartFinished(path, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)6, null);
    }

    @JsonNotification(value="clionIndexingFinished")
    public final void indexingFinished(@NotNull JsonObject indexingFinishedParams) {
        Intrinsics.checkNotNullParameter((Object)indexingFinishedParams, (String)"indexingFinishedParams");
        Entity[] entityArray = new Entity[]{this.getLifetime()};
        SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.getPluginScope()), (Entity[])entityArray, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, indexingFinishedParams, null){
            int label;
            final /* synthetic */ ClangdIndexerLanguageClient this$0;
            final /* synthetic */ JsonObject $indexingFinishedParams;
            {
                this.this$0 = $receiver;
                this.$indexingFinishedParams = $indexingFinishedParams;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Service clangdService = ClangdIndexerLanguageClient.access$findClangdService(this.this$0);
                        if (clangdService == null) {
                            KLogger this_$iv = ClangdIndexerLanguageClient.access$getLogger$p(this.this$0);
                            boolean $i$f$debug = false;
                            if (!this_$iv.isDebugEnabled()) return Unit.INSTANCE;
                            KLogger kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.debug((Object)"indexingFinished notification dropped");
                            return Unit.INSTANCE;
                        }
                        JsonArray jsonArray = this.$indexingFinishedParams.get("deletedModuleFiles").getAsJsonArray();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                        Iterable $this$map$iv = (Iterable)jsonArray;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            JsonElement jsonElement = (JsonElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getAsString());
                        }
                        List deletedFiles = (List)destination$iv$iv;
                        String symbolsDir = this.$indexingFinishedParams.get("symbolsDir").getAsString();
                        ClangdApi clangdApi = (ClangdApi)clangdService.getApi();
                        Intrinsics.checkNotNull((Object)symbolsDir);
                        this.label = 1;
                        Object object3 = clangdApi.notifyLoadIndex(deletedFiles, symbolsDir, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)6, null);
    }

    public static final /* synthetic */ Service access$findClangdService(ClangdIndexerLanguageClient $this) {
        return $this.findClangdService();
    }

    public static final /* synthetic */ KLogger access$getLogger$p(ClangdIndexerLanguageClient $this) {
        return $this.logger;
    }
}

