/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.fus.impl;

import fleet.preferences.FleetPropertiesKt;
import fleet.reporting.fus.impl.LogEventMergeStrategy;
import fleet.reporting.fus.impl.LogEventSurrogate;
import fleet.reporting.shared.config.TracingConfigProperties;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dJ\u0014\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dJ\u0014\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dJ\u0006\u0010\"\u001a\u00020\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006$"}, d2={"Lfleet/reporting/fus/impl/FusFileWriter;", "", "cachesDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "currentFile", "value", "Lfleet/reporting/fus/impl/LogEventSurrogate;", "lastEvent", "setLastEvent", "(Lfleet/reporting/fus/impl/LogEventSurrogate;)V", "lastEventTime", "", "tempDir", "getTempDir", "()Ljava/nio/file/Path;", "tempDir$delegate", "Lkotlin/Lazy;", "tempDirTest", "getTempDirTest", "tempDirTest$delegate", "cleanUpOldFiles", "", "createTempDir", "subdir", "", "generateNewFile", "dir", "prepareFilesForSend", "", "pushBack", "linesToSend", "writeJsonLines", "events", "writeLastEvent", "Companion", "fleet.reporting.fus.impl"})
@SourceDebugExtension(value={"SMAP\nFusFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FusFileWriter.kt\nfleet/reporting/fus/impl/FusFileWriter\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 5 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,146:1\n17#2,2:147\n1855#3,2:149\n113#4:151\n22#5:152\n*S KotlinDebug\n*F\n+ 1 FusFileWriter.kt\nfleet/reporting/fus/impl/FusFileWriter\n*L\n42#1:147,2\n47#1:149,2\n71#1:151\n18#1:152\n*E\n"})
public final class FusFileWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy tempDir$delegate;
    @NotNull
    private final Lazy tempDirTest$delegate;
    @Nullable
    private Path currentFile;
    @Nullable
    private LogEventSurrogate lastEvent;
    private long lastEventTime;
    @NotNull
    private static final KLogger logger;
    private static final long eventMergeTimeoutMs = 10000L;
    private static final long maxFileAgeMs = 604800000L;

    public FusFileWriter(@NotNull Path cachesDirectory) {
        Intrinsics.checkNotNullParameter((Object)cachesDirectory, (String)"cachesDirectory");
        this.tempDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this, cachesDirectory){
            final /* synthetic */ FusFileWriter this$0;
            final /* synthetic */ Path $cachesDirectory;
            {
                this.this$0 = $receiver;
                this.$cachesDirectory = $cachesDirectory;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                return FusFileWriter.access$createTempDir(this.this$0, this.$cachesDirectory, "fus_data");
            }
        }));
        this.tempDirTest$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this, cachesDirectory){
            final /* synthetic */ FusFileWriter this$0;
            final /* synthetic */ Path $cachesDirectory;
            {
                this.this$0 = $receiver;
                this.$cachesDirectory = $cachesDirectory;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                return FusFileWriter.access$createTempDir(this.this$0, this.$cachesDirectory, "fus_data_test");
            }
        }));
        if (TracingConfigProperties.INSTANCE.getFusTestingMode()) {
            KLogger this_$iv = logger;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("Fus directory: " + this.getTempDir()));
            }
        }
    }

    private final Path getTempDir() {
        Lazy lazy = this.tempDir$delegate;
        return (Path)lazy.getValue();
    }

    private final Path getTempDirTest() {
        Lazy lazy = this.tempDirTest$delegate;
        return (Path)lazy.getValue();
    }

    private final void setLastEvent(LogEventSurrogate value) {
        this.lastEvent = value;
        LogEventSurrogate logEventSurrogate = value;
        this.lastEventTime = logEventSurrogate != null ? logEventSurrogate.getTime() : 0L;
    }

    public final void writeJsonLines(@NotNull List<LogEventSurrogate> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogEventSurrogate it = (LogEventSurrogate)element$iv;
            boolean bl = false;
            LogEventSurrogate current = this.lastEvent;
            if (current == null) {
                FusFileWriter $this$writeJsonLines_u24lambda_u242_u24lambda_u241 = this;
                boolean bl2 = false;
                $this$writeJsonLines_u24lambda_u242_u24lambda_u241.setLastEvent(it);
                continue;
            }
            if (it.getTime() - this.lastEventTime <= 10000L && LogEventMergeStrategy.INSTANCE.shouldMerge(current, it)) {
                current.getEvent().increment();
                this.lastEventTime = it.getTime();
                continue;
            }
            this.writeLastEvent();
            this.setLastEvent(it);
        }
    }

    public final void writeLastEvent() {
        LogEventSurrogate current = this.lastEvent;
        this.setLastEvent(null);
        if (current == null) {
            return;
        }
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String eventString = $this$encodeToString$iv.encodeToString((SerializationStrategy)LogEventSurrogate.Companion.serializer(), (Object)current) + "\n";
        if (this.currentFile == null) {
            this.currentFile = this.generateNewFile(this.getTempDir());
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
        Files.writeString(this.currentFile, (CharSequence)eventString, openOptionArray);
        if (FleetPropertiesKt.isFleetInternalDefaultValue()) {
            openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
            Files.writeString(this.generateNewFile(this.getTempDirTest()), (CharSequence)eventString, openOptionArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanUpOldFiles() {
        long oldestAcceptable = System.currentTimeMillis() - 604800000L;
        FusFileWriter fusFileWriter = this;
        try {
            FusFileWriter $this$cleanUpOldFiles_u24lambda_u246 = fusFileWriter;
            boolean bl = false;
            AutoCloseable autoCloseable = Files.list($this$cleanUpOldFiles_u24lambda_u246.getTempDir());
            Throwable throwable = null;
            try {
                Stream files2 = (Stream)autoCloseable;
                boolean bl2 = false;
                files2.filter(arg_0 -> FusFileWriter.cleanUpOldFiles$lambda$6$lambda$5$lambda$3((Function1)new Function1<Path, Boolean>($this$cleanUpOldFiles_u24lambda_u246){
                    final /* synthetic */ FusFileWriter $this_runCatching;
                    {
                        this.$this_runCatching = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(Path it) {
                        return !Intrinsics.areEqual((Object)it, (Object)FusFileWriter.access$getCurrentFile$p(this.$this_runCatching));
                    }
                }, arg_0)).forEach(arg_0 -> FusFileWriter.cleanUpOldFiles$lambda$6$lambda$5$lambda$4((Function1)new Function1<Path, Unit>(oldestAcceptable, $this$cleanUpOldFiles_u24lambda_u246){
                    final /* synthetic */ long $oldestAcceptable;
                    final /* synthetic */ FusFileWriter $this_runCatching;
                    {
                        this.$oldestAcceptable = $oldestAcceptable;
                        this.$this_runCatching = $receiver;
                        super(1);
                    }

                    public final void invoke(Path file) {
                        Intrinsics.checkNotNull((Object)file);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        if (fileTime.toMillis() < this.$oldestAcceptable) {
                            Files.deleteIfExists(file);
                            if (Intrinsics.areEqual((Object)FusFileWriter.access$getCurrentFile$p(this.$this_runCatching), (Object)file)) {
                                FusFileWriter.access$setCurrentFile$p(this.$this_runCatching, null);
                            }
                        }
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final Path createTempDir(Path cachesDirectory, String subdir) {
        Path path = cachesDirectory.resolve(subdir);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        Path path4 = Files.createTempDirectory(path3, "", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createTempDirectory(...)");
        return path4;
    }

    private final Path generateNewFile(Path dir) {
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createDirectories(dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        Path path2 = Files.createTempFile(path, "stats" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("hhmmss")), ".json.log", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempFile(...)");
        return path2;
    }

    @NotNull
    public final List<Path> prepareFilesForSend() {
        this.currentFile = null;
        return PathsKt.listDirectoryEntries$default((Path)this.getTempDir(), null, (int)1, null);
    }

    public final void pushBack(@NotNull List<String> linesToSend) {
        Intrinsics.checkNotNullParameter(linesToSend, (String)"linesToSend");
        Path path = this.generateNewFile(this.getTempDir());
        Charset charset = Charsets.UTF_8;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE};
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)linesToSend, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
    }

    private static final boolean cleanUpOldFiles$lambda$6$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void cleanUpOldFiles$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$getCurrentFile$p(FusFileWriter $this) {
        return $this.currentFile;
    }

    public static final /* synthetic */ void access$setCurrentFile$p(FusFileWriter $this, Path path) {
        $this.currentFile = path;
    }

    public static final /* synthetic */ Path access$createTempDir(FusFileWriter $this, Path cachesDirectory, String subdir) {
        return $this.createTempDir(cachesDirectory, subdir);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(FusFileWriter.class));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lfleet/reporting/fus/impl/FusFileWriter$Companion;", "", "()V", "eventMergeTimeoutMs", "", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "maxFileAgeMs", "fleet.reporting.fus.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

