/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.modules;

import com.intellij.util.lang.ZipFile;
import fleet.util.modules.ClassLoadingStats;
import fleet.util.modules.FleetModuleFinderLogger;
import fleet.util.modules.FleetModuleRuntimeVersion;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FleetModuleReader
implements ModuleReader {
    @NotNull
    private final ZipFile zipFile;
    @NotNull
    private final FleetModuleFinderLogger logger;
    @NotNull
    private final URI location;
    private final Map<String, String> versionedFiles;

    FleetModuleReader(@NotNull ZipFile zipFile, @NotNull FleetModuleFinderLogger logger, @NotNull URI location) {
        if (zipFile == null) {
            FleetModuleReader.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            FleetModuleReader.$$$reportNull$$$0(1);
        }
        if (location == null) {
            FleetModuleReader.$$$reportNull$$$0(2);
        }
        this.zipFile = zipFile;
        this.logger = logger;
        this.location = location;
        this.versionedFiles = FleetModuleReader.loadVersionedFiles(zipFile);
    }

    private static Map<String, String> loadVersionedFiles(@NotNull ZipFile zipFile) {
        if (zipFile == null) {
            FleetModuleReader.$$$reportNull$$$0(3);
        }
        Runtime.Version runtimeVersion = Runtime.version();
        HashMap versions = new HashMap();
        try {
            String versionsPrefix = "META-INF/versions";
            zipFile.processResources(versionsPrefix, n -> {
                String pathToClass;
                FleetModuleRuntimeVersion registeredVersion;
                String rawVersion;
                FleetModuleRuntimeVersion parsedVersion;
                String path = n.substring(versionsPrefix.length() + 1);
                int firstSlash = path.indexOf(47);
                if (firstSlash != -1 && (parsedVersion = FleetModuleRuntimeVersion.parseVersion(rawVersion = path.substring(0, firstSlash))) != null && runtimeVersion.compareTo(parsedVersion.getRuntimeVersion()) >= 0 && ((registeredVersion = (FleetModuleRuntimeVersion)versions.get(pathToClass = path.substring(firstSlash + 1))) == null || parsedVersion.compareTo(registeredVersion) > 0)) {
                    versions.put(pathToClass, parsedVersion);
                }
                return false;
            }, (n, e) -> {});
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return versions.isEmpty() ? null : versions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FleetModuleRuntimeVersion)e.getValue()).getRawVersion()));
    }

    @Override
    public Optional<InputStream> open(String name) throws IOException {
        try {
            return Optional.ofNullable(this.openVersioned(name));
        }
        catch (Throwable e) {
            this.logger.error(e, () -> "Can't open " + name + " in " + this.location);
            return Optional.empty();
        }
    }

    @Nullable
    private InputStream openVersioned(String name) throws IOException {
        String version;
        if (this.versionedFiles != null && !name.startsWith("META-INF/") && (version = this.versionedFiles.get(name)) != null) {
            return this.zipFile.getInputStream("META-INF/versions/" + version + "/" + name);
        }
        return this.zipFile.getInputStream(name);
    }

    @Override
    public Optional<ByteBuffer> read(String name) throws IOException {
        long startTime;
        if (ClassLoadingStats.recordLoadingTime.booleanValue()) {
            if (ClassLoadingStats.doingClassDefineTiming.get() == null) {
                startTime = System.nanoTime();
                ClassLoadingStats.doingClassDefineTiming.set(startTime);
            } else {
                startTime = -1L;
            }
        } else {
            startTime = -1L;
        }
        ByteBuffer result = this.readVersioned(name);
        if (result == null && startTime != -1L) {
            ClassLoadingStats.endReadRecording(startTime);
            ClassLoadingStats.doingClassDefineTiming.remove();
        }
        return Optional.ofNullable(result);
    }

    @Nullable
    private ByteBuffer readVersioned(String name) throws IOException {
        String version;
        if (this.versionedFiles != null && !name.startsWith("META-INF/") && (version = this.versionedFiles.get(name)) != null) {
            return this.zipFile.getByteBuffer("META-INF/versions/" + version + "/" + name);
        }
        return this.zipFile.getByteBuffer(name);
    }

    @Override
    public void release(ByteBuffer bb) {
        Long startTime;
        if (ClassLoadingStats.recordLoadingTime.booleanValue() && (startTime = ClassLoadingStats.doingClassDefineTiming.get()) != null) {
            ClassLoadingStats.doingClassDefineTiming.remove();
            ClassLoadingStats.endReadRecording(startTime);
        }
        this.zipFile.releaseBuffer(bb);
    }

    @Override
    public Optional<URI> find(String name) {
        if (this.zipFile.getResource(name) != null) {
            return this.buildJarUri(name);
        }
        if (name.endsWith("/")) {
            AtomicBoolean hasResourceInDir = new AtomicBoolean(false);
            try {
                this.zipFile.processResources(name.substring(0, name.length() - 1), x -> {
                    hasResourceInDir.set(true);
                    return false;
                }, (n, e) -> {});
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return hasResourceInDir.get() ? this.buildJarUri(name) : Optional.empty();
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<URI> buildJarUri(String name) {
        URI uri;
        try {
            uri = new URI(null, null, name, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Optional<URI> optional = Optional.of(URI.create(String.format("jar:%s!/%s", this.location, uri.toASCIIString())));
        if (optional == null) {
            FleetModuleReader.$$$reportNull$$$0(4);
        }
        return optional;
    }

    @Override
    public Stream<String> list() throws IOException {
        ArrayList list = new ArrayList();
        this.zipFile.processResources("/", x -> true, (name, e) -> list.add(name));
        return list.stream();
    }

    @Override
    public void close() {
        try {
            this.zipFile.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fleet/util/modules/FleetModuleReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fleet/util/modules/FleetModuleReader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildJarUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadVersionedFiles";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

