/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.preview;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lfleet/plugins/markdown/frontend/preview/PreviewContentEncoding;", "", "<init>", "()V", "encodeUrl", "", "url", "encodeContent", "content", "charset", "Ljava/nio/charset/Charset;", "decodeContent", "fleet.plugins.markdown.frontend"})
public final class PreviewContentEncoding {
    @NotNull
    public static final PreviewContentEncoding INSTANCE = new PreviewContentEncoding();

    private PreviewContentEncoding() {
    }

    @NotNull
    public final String encodeUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = URLEncoder.encode(url, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String encodeContent(@NotNull String content2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] byArray = content2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = encoder.encode(byArray);
        Intrinsics.checkNotNull((Object)bytes);
        return new String(bytes, charset);
    }

    @NotNull
    public final String decodeContent(@NotNull String content2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] bytes = decoder.decode(content2);
        Intrinsics.checkNotNull((Object)bytes);
        return new String(bytes, charset);
    }
}

