/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.preview;

import andel.text.TextRange;
import fleet.plugins.markdown.frontend.language.BackendAstKt;
import fleet.plugins.markdown.frontend.preview.PreviewContentEncoding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\f\u001a\u00060\rj\u0002`\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "copyCallback", "", "<init>", "(Ljava/lang/String;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "buildCodeFenceData", "Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$CodeFenceData;", "Lfleet/plugins/markdown/frontend/language/BackendAstNode;", "CodeFenceData", "Companion", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nCodeFenceGeneratingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFenceGeneratingProvider.kt\nfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1#2:111\n774#3:112\n865#3,2:113\n*S KotlinDebug\n*F\n+ 1 CodeFenceGeneratingProvider.kt\nfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider\n*L\n56#1:112\n56#1:113,2\n*E\n"})
public final class CodeFenceGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String copyCallback;

    public CodeFenceGeneratingProvider(@NotNull String copyCallback) {
        Intrinsics.checkNotNullParameter((Object)copyCallback, (String)"copyCallback");
        this.copyCallback = copyCallback;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text2, @NotNull ASTNode node) {
        Companion.Line line;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CodeFenceData codeFenceData = this.buildCodeFenceData(node, text2);
        String language = codeFenceData.component1();
        List<Companion.Line> lines = codeFenceData.component2();
        List<CharSequence> rawLines = codeFenceData.component3();
        StringBuilder $this$processNode_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        char[] cArray = new char[]{'\n'};
        String rawContent = StringsKt.trim((String)CollectionsKt.joinToString$default((Iterable)rawLines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (char[])cArray);
        Companion.Line line2 = (Companion.Line)CollectionsKt.firstOrNull(lines);
        TextRange wholeRange = new TextRange(line2 != null && (line2 = line2.getRange()) != null ? line2.getStart() : (long)node.getStartOffset(), (line = (Companion.Line)CollectionsKt.lastOrNull(lines)) != null && (line = line.getRange()) != null ? line.getEnd() : (long)node.getEndOffset());
        Companion.appendCodeFence$fleet_plugins_markdown_frontend($this$processNode_u24lambda_u240, language, this.copyCallback, rawContent, wholeRange, (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(lines, wholeRange){
            final /* synthetic */ List<Companion.Line> $lines;
            final /* synthetic */ TextRange $wholeRange;
            {
                this.$lines = $lines;
                this.$wholeRange = $wholeRange;
                super(1);
            }

            public final void invoke(StringBuilder $this$appendCodeFence) {
                Intrinsics.checkNotNullParameter((Object)$this$appendCodeFence, (String)"$this$appendCodeFence");
                CodeFenceGeneratingProvider.Companion.appendCodeBlock$fleet_plugins_markdown_frontend($this$appendCodeFence, this.$lines, this.$wholeRange);
            }
        }));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String content2 = string;
        visitor.consumeHtml((CharSequence)content2);
    }

    /*
     * WARNING - void declaration
     */
    private final CodeFenceData buildCodeFenceData(ASTNode node, String text2) {
        void $this$filterTo$iv$iv;
        Object v0;
        Object it;
        List children2;
        block4: {
            children2 = node.getChildren();
            Iterable iterable = children2;
            for (Object t : iterable) {
                it = (ASTNode)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        ASTNode language = v0;
        String languageText = language != null ? ((Object)StringsKt.trim((CharSequence)((Object)HtmlGenerator.Companion.leafText$default((HtmlGenerator.Companion)HtmlGenerator.Companion, (String)text2, (ASTNode)language, (boolean)false, (int)4, null)).toString())).toString() : null;
        Iterable $this$filter$iv = children2;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it2 = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.EOL))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List elements2 = (List)destination$iv$iv;
        int indentBefore = StringsKt.commonPrefixWith$default((CharSequence)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text2), (CharSequence)StringsKt.repeat((CharSequence)" ", (int)10), (boolean)false, (int)2, null).length();
        ArrayList<Companion.Line> lines = new ArrayList<Companion.Line>();
        ArrayList<CharSequence> rawLines = new ArrayList<CharSequence>();
        boolean lastElementWasNewline = false;
        for (ASTNode element : elements2) {
            if (!Intrinsics.areEqual((Object)element.getType(), (Object)MarkdownTokenTypes.EOL) || lastElementWasNewline) {
                CharSequence leafText = HtmlGenerator.Companion.leafText(text2, element, false);
                CharSequence lineText = HtmlGenerator.Companion.trimIndents(leafText, indentBefore);
                lines.add(new Companion.Line(lineText, BackendAstKt.getTextRange(element)));
            }
            rawLines.add(HtmlGenerator.Companion.trimIndents(ASTUtilKt.getTextInNode((ASTNode)element, (CharSequence)text2), indentBefore));
            lastElementWasNewline = Intrinsics.areEqual((Object)element.getType(), (Object)MarkdownTokenTypes.EOL);
        }
        return new CodeFenceData(languageText, (List<Companion.Line>)lines, (List<? extends CharSequence>)rawLines);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$CodeFenceData;", "", "language", "", "lines", "", "Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$Companion$Line;", "rawLines", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getLanguage", "()Ljava/lang/String;", "getLines", "()Ljava/util/List;", "getRawLines", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "fleet.plugins.markdown.frontend"})
    private static final class CodeFenceData {
        @Nullable
        private final String language;
        @NotNull
        private final List<Companion.Line> lines;
        @NotNull
        private final List<CharSequence> rawLines;

        public CodeFenceData(@Nullable String language, @NotNull List<Companion.Line> lines, @NotNull List<? extends CharSequence> rawLines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(rawLines, (String)"rawLines");
            this.language = language;
            this.lines = lines;
            this.rawLines = rawLines;
        }

        @Nullable
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final List<Companion.Line> getLines() {
            return this.lines;
        }

        @NotNull
        public final List<CharSequence> getRawLines() {
            return this.rawLines;
        }

        @Nullable
        public final String component1() {
            return this.language;
        }

        @NotNull
        public final List<Companion.Line> component2() {
            return this.lines;
        }

        @NotNull
        public final List<CharSequence> component3() {
            return this.rawLines;
        }

        @NotNull
        public final CodeFenceData copy(@Nullable String language, @NotNull List<Companion.Line> lines, @NotNull List<? extends CharSequence> rawLines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(rawLines, (String)"rawLines");
            return new CodeFenceData(language, lines, rawLines);
        }

        public static /* synthetic */ CodeFenceData copy$default(CodeFenceData codeFenceData, String string, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = codeFenceData.language;
            }
            if ((n & 2) != 0) {
                list = codeFenceData.lines;
            }
            if ((n & 4) != 0) {
                list2 = codeFenceData.rawLines;
            }
            return codeFenceData.copy(string, list, list2);
        }

        @NotNull
        public String toString() {
            return "CodeFenceData(language=" + this.language + ", lines=" + this.lines + ", rawLines=" + this.rawLines + ")";
        }

        public int hashCode() {
            int result = this.language == null ? 0 : this.language.hashCode();
            result = result * 31 + ((Object)this.lines).hashCode();
            result = result * 31 + ((Object)this.rawLines).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodeFenceData)) {
                return false;
            }
            CodeFenceData codeFenceData = (CodeFenceData)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)codeFenceData.language)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.lines, codeFenceData.lines)) {
                return false;
            }
            return Intrinsics.areEqual(this.rawLines, codeFenceData.rawLines);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJV\u0010\u000e\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\f2\u001b\u0010\u0014\u001a\u0017\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\u0002\b\u0016H\u0000\u00a2\u0006\u0002\b\u0017\u00a8\u0006\u0019"}, d2={"Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$Companion;", "", "<init>", "()V", "appendCodeBlock", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lines", "", "Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$Companion$Line;", "wholeRange", "Landel/text/TextRange;", "appendCodeBlock$fleet_plugins_markdown_frontend", "appendCodeFence", "language", "", "copyCallback", "contentToCopy", "range", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "appendCodeFence$fleet_plugins_markdown_frontend", "Line", "fleet.plugins.markdown.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void appendCodeBlock$fleet_plugins_markdown_frontend(@NotNull StringBuilder $this$appendCodeBlock, @NotNull List<Line> lines, @NotNull TextRange wholeRange) {
            Intrinsics.checkNotNullParameter((Object)$this$appendCodeBlock, (String)"<this>");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)wholeRange, (String)"wholeRange");
            $this$appendCodeBlock.append("<pre class=\"code-fence-content\" " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "=\"" + wholeRange.getStart() + ".." + wholeRange.getEnd() + "\">");
            for (Line line : lines) {
                CharSequence line2 = line.component1();
                TextRange range = line.component2();
                $this$appendCodeBlock.append("<code " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "=\"" + range.getStart() + ".." + range.getEnd() + "\">");
                $this$appendCodeBlock.append(line2);
                $this$appendCodeBlock.append("</code>");
            }
            $this$appendCodeBlock.append("</pre>");
        }

        public final void appendCodeFence$fleet_plugins_markdown_frontend(@NotNull StringBuilder $this$appendCodeFence, @Nullable String language, @NotNull String copyCallback, @NotNull String contentToCopy, @NotNull TextRange range, @NotNull Function1<? super StringBuilder, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$appendCodeFence, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)copyCallback, (String)"copyCallback");
            Intrinsics.checkNotNullParameter((Object)contentToCopy, (String)"contentToCopy");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this$appendCodeFence.append("<div class=\"code-fence\" " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "=\"" + range.getStart() + ".." + range.getEnd() + "\">");
            $this$appendCodeFence.append("<div class=\"code-fence-header\">");
            $this$appendCodeFence.append("<span>");
            String string = language;
            if (string == null) {
                string = "";
            }
            $this$appendCodeFence.append(string);
            $this$appendCodeFence.append("</span>");
            String encodedContent = PreviewContentEncoding.INSTANCE.encodeContent(contentToCopy, Charsets.UTF_8);
            String code = copyCallback + "('" + encodedContent + "')";
            $this$appendCodeFence.append("<a class=\"copy\" onclick=\"" + code + "\"></a>");
            $this$appendCodeFence.append("</div>");
            block.invoke((Object)$this$appendCodeFence);
            $this$appendCodeFence.append("</div>");
        }

        public static /* synthetic */ void appendCodeFence$fleet_plugins_markdown_frontend$default(Companion companion, StringBuilder stringBuilder, String string, String string2, String string3, TextRange textRange, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            companion.appendCodeFence$fleet_plugins_markdown_frontend(stringBuilder, string, string2, string3, textRange, (Function1<? super StringBuilder, Unit>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$Companion$Line;", "", "text", "", "range", "Landel/text/TextRange;", "<init>", "(Ljava/lang/CharSequence;Landel/text/TextRange;)V", "getText", "()Ljava/lang/CharSequence;", "getRange", "()Landel/text/TextRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fleet.plugins.markdown.frontend"})
        public static final class Line {
            @NotNull
            private final CharSequence text;
            @NotNull
            private final TextRange range;

            public Line(@NotNull CharSequence text2, @NotNull TextRange range) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                this.text = text2;
                this.range = range;
            }

            @NotNull
            public final CharSequence getText() {
                return this.text;
            }

            @NotNull
            public final TextRange getRange() {
                return this.range;
            }

            @NotNull
            public final CharSequence component1() {
                return this.text;
            }

            @NotNull
            public final TextRange component2() {
                return this.range;
            }

            @NotNull
            public final Line copy(@NotNull CharSequence text2, @NotNull TextRange range) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return new Line(text2, range);
            }

            public static /* synthetic */ Line copy$default(Line line, CharSequence charSequence, TextRange textRange, int n, Object object) {
                if ((n & 1) != 0) {
                    charSequence = line.text;
                }
                if ((n & 2) != 0) {
                    textRange = line.range;
                }
                return line.copy(charSequence, textRange);
            }

            @NotNull
            public String toString() {
                return "Line(text=" + this.text + ", range=" + this.range + ")";
            }

            public int hashCode() {
                int result = this.text.hashCode();
                result = result * 31 + this.range.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Line)) {
                    return false;
                }
                Line line = (Line)other;
                if (!Intrinsics.areEqual((Object)this.text, (Object)line.text)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.range, (Object)line.range);
            }
        }
    }
}

