/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.preview;

import andel.text.TextRange;
import fleet.plugins.markdown.frontend.language.BackendAstKt;
import fleet.plugins.markdown.frontend.preview.CodeFenceGeneratingProvider;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00100\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lfleet/plugins/markdown/frontend/preview/CodeBlockGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "copyCallback", "", "<init>", "(Ljava/lang/String;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "collectLines", "Lkotlin/Pair;", "", "Lfleet/plugins/markdown/frontend/preview/CodeFenceGeneratingProvider$Companion$Line;", "", "fleet.plugins.markdown.frontend"})
public final class CodeBlockGeneratingProvider
implements GeneratingProvider {
    @NotNull
    private final String copyCallback;

    public CodeBlockGeneratingProvider(@NotNull String copyCallback) {
        Intrinsics.checkNotNullParameter((Object)copyCallback, (String)"copyCallback");
        this.copyCallback = copyCallback;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text2, @NotNull ASTNode node) {
        CodeFenceGeneratingProvider.Companion.Line line;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Pair<List<CodeFenceGeneratingProvider.Companion.Line>, List<CharSequence>> pair = this.collectLines(node, text2);
        List lines = (List)pair.component1();
        List rawLines = (List)pair.component2();
        StringBuilder $this$processNode_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        char[] cArray = new char[]{'\n'};
        String rawContent = StringsKt.trim((String)CollectionsKt.joinToString$default((Iterable)rawLines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (char[])cArray);
        CodeFenceGeneratingProvider.Companion.Line line2 = (CodeFenceGeneratingProvider.Companion.Line)CollectionsKt.firstOrNull((List)lines);
        TextRange wholeRange = new TextRange(line2 != null && (line2 = line2.getRange()) != null ? line2.getStart() : (long)node.getStartOffset(), (line = (CodeFenceGeneratingProvider.Companion.Line)CollectionsKt.lastOrNull((List)lines)) != null && (line = line.getRange()) != null ? line.getEnd() : (long)node.getEndOffset());
        CodeFenceGeneratingProvider.Companion.appendCodeFence$fleet_plugins_markdown_frontend$default(CodeFenceGeneratingProvider.Companion, $this$processNode_u24lambda_u240, null, this.copyCallback, rawContent, wholeRange, (Function1)new Function1<StringBuilder, Unit>((List<CodeFenceGeneratingProvider.Companion.Line>)lines, wholeRange){
            final /* synthetic */ List<CodeFenceGeneratingProvider.Companion.Line> $lines;
            final /* synthetic */ TextRange $wholeRange;
            {
                this.$lines = $lines;
                this.$wholeRange = $wholeRange;
                super(1);
            }

            public final void invoke(StringBuilder $this$appendCodeFence) {
                Intrinsics.checkNotNullParameter((Object)$this$appendCodeFence, (String)"$this$appendCodeFence");
                CodeFenceGeneratingProvider.Companion.appendCodeBlock$fleet_plugins_markdown_frontend($this$appendCodeFence, this.$lines, this.$wholeRange);
            }
        }, 1, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String html2 = string;
        visitor.consumeHtml((CharSequence)html2);
    }

    private final Pair<List<CodeFenceGeneratingProvider.Companion.Line>, List<CharSequence>> collectLines(ASTNode node, String text2) {
        ArrayList<CodeFenceGeneratingProvider.Companion.Line> lines = new ArrayList<CodeFenceGeneratingProvider.Companion.Line>();
        ArrayList<CharSequence> rawLines = new ArrayList<CharSequence>();
        boolean lastElementWasNewline = false;
        for (ASTNode element : node.getChildren()) {
            if (!Intrinsics.areEqual((Object)element.getType(), (Object)MarkdownTokenTypes.EOL) || lastElementWasNewline) {
                CharSequence leafText = HtmlGenerator.Companion.leafText(text2, element, false);
                CharSequence lineText = HtmlGenerator.Companion.trimIndents(leafText, 4);
                lines.add(new CodeFenceGeneratingProvider.Companion.Line(lineText, BackendAstKt.getTextRange(element)));
            }
            CharSequence rawLine = HtmlGenerator.Companion.trimIndents(ASTUtilKt.getTextInNode((ASTNode)element, (CharSequence)text2), 4);
            rawLines.add(rawLine);
            lastElementWasNewline = Intrinsics.areEqual((Object)element.getType(), (Object)MarkdownTokenTypes.EOL);
        }
        return TuplesKt.to(lines, rawLines);
    }
}

