/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language.util;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.Document;
import andel.editor.EditorExtKt;
import andel.editor.MutableDocument;
import andel.editor.MutableEditor;
import andel.editor.TextExtKt;
import andel.editor.TransientEditor;
import andel.editor.TransientEditorExtKt;
import andel.operation.Operation;
import andel.operation.OperationKt;
import andel.text.LineNumber;
import andel.text.LineNumberKt;
import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextLine;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.ast.AST;
import fleet.ast.NodeAspectId;
import fleet.ast.NodeAspectMap;
import fleet.ast.SyntexNodeExtKt;
import fleet.ast.WhitespaceNodeAspect;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.LanguageExtensionPointsKt;
import fleet.frontend.lang.aspects.AspectTreeWalkerUtilKt;
import fleet.plugins.markdown.frontend.language.util.MarkdownTransientEditorUtilsKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a(\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a$\u0010\u000f\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a$\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0000\u001a\u001c\u0010$\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020 H\u0000\u001a\u001c\u0010%\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020 H\u0000\u001a\u0014\u0010&\u001a\u00020\u0018*\u00020\u00022\u0006\u0010'\u001a\u00020\u0014H\u0000\u001a\u0014\u0010(\u001a\u00020\u0018*\u00020\u00022\u0006\u0010'\u001a\u00020\u0014H\u0002\u001a\u0014\u0010)\u001a\u00020\u0018*\u00020\u00022\u0006\u0010'\u001a\u00020\u0014H\u0002\u001a\u0014\u0010*\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\"\u001a\u00020 H\u0002\u001a\u0014\u0010+\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\"\u001a\u00020 H\u0002\u001a\u000e\u0010,\u001a\u0004\u0018\u00010 *\u00020 H\u0002\u00a8\u0006-"}, d2={"getIndentInLine", "", "Landel/editor/TransientEditor;", "ast", "Lfleet/ast/AST;", "line", "Landel/text/TextLine;", "isOnSingleLine", "", "start", "", "Lnoria/windowManagement/api/TextOffset;", "end", "document", "Landel/editor/MutableDocument;", "isRangeSurroundedBy", "Landel/editor/Document;", "regex", "Lkotlin/text/Regex;", "range", "Landel/text/TextRange;", "checkDepth", "", "embraceTextWithEmphasizeSymbols", "", "symbolToEmbraceWith", "leftOffset", "rightOffset", "toggleEmphStyle", "symbol", "removeUrl", "inlineLink", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "hasMatchingTextRange", "leftParent", "rightParent", "tryProcessCodeSpan", "tryProcessCodeFence", "insertCodeSpanOrFence", "textRange", "insertCodeSpan", "insertCodeFence", "removeCodeFence", "removeCodeSpan", "nextSiblingSkipWhitespaces", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nMarkdownTransientEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownTransientEditorUtils.kt\nfleet/plugins/markdown/frontend/language/util/MarkdownTransientEditorUtilsKt\n+ 2 LanguageExtensionPoints.kt\nfleet/frontend/lang/LanguageExtensionPointsKt\n*L\n1#1,179:1\n60#2:180\n*S KotlinDebug\n*F\n+ 1 MarkdownTransientEditorUtils.kt\nfleet/plugins/markdown/frontend/language/util/MarkdownTransientEditorUtilsKt\n*L\n178#1:180\n*E\n"})
public final class MarkdownTransientEditorUtilsKt {
    @NotNull
    public static final String getIndentInLine(@NotNull TransientEditor $this$getIndentInLine, @NotNull AST<?> ast, @NotNull TextLine line) {
        SyntaxNode firstNonWhiteSpaceElement;
        Intrinsics.checkNotNullParameter((Object)$this$getIndentInLine, (String)"<this>");
        Intrinsics.checkNotNullParameter(ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        long lineStart = line.getRange().getStart();
        SyntaxNode syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)ast.root(), (long)lineStart);
        if (syntaxNode == null) {
            return "";
        }
        SyntaxNode firstElementInLine = syntaxNode;
        SyntaxNode syntaxNode2 = firstNonWhiteSpaceElement = Intrinsics.areEqual((Object)firstElementInLine.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE) ? MarkdownTransientEditorUtilsKt.nextSiblingSkipWhitespaces(firstElementInLine) : firstElementInLine;
        if (firstNonWhiteSpaceElement == null) {
            return "";
        }
        return $this$getIndentInLine.getDocument().getText().view().string((int)lineStart, (int)firstNonWhiteSpaceElement.getStartOffset());
    }

    public static final boolean isOnSingleLine(long start, long end, @NotNull MutableDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return TextViewExtKt.textLineAtOffset$default((TextView)document.getText().view(), (int)((int)start), (boolean)false, (int)2, null).getLineNumber() == TextViewExtKt.textLineAtOffset$default((TextView)document.getText().view(), (int)((int)end), (boolean)false, (int)2, null).getLineNumber();
    }

    public static final boolean isRangeSurroundedBy(@NotNull Document $this$isRangeSurroundedBy, @NotNull Regex regex, @NotNull TextRange range, int checkDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$isRangeSurroundedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (range.getStart() - (long)checkDepth < 0L || range.getEnd() + (long)checkDepth > (long)$this$isRangeSurroundedBy.getText().getCharCount()) {
            return false;
        }
        TextRange outsideLeftRange = new TextRange(range.getStart() - (long)checkDepth, range.getStart());
        TextRange outsideRightRange = new TextRange(range.getEnd(), range.getEnd() + (long)checkDepth);
        String outsideRight = TextExtKt.substring((Text)$this$isRangeSurroundedBy.getText(), (TextRange)outsideRightRange);
        String outsideLeft = TextExtKt.substring((Text)$this$isRangeSurroundedBy.getText(), (TextRange)outsideLeftRange);
        return regex.matches((CharSequence)outsideRight) && regex.matches((CharSequence)outsideLeft);
    }

    public static final void embraceTextWithEmphasizeSymbols(@NotNull TransientEditor $this$embraceTextWithEmphasizeSymbols, @NotNull String symbolToEmbraceWith, long leftOffset, long rightOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$embraceTextWithEmphasizeSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbolToEmbraceWith, (String)"symbolToEmbraceWith");
        TransientEditorExtKt.insert((TransientEditor)$this$embraceTextWithEmphasizeSymbols, (long)rightOffset, (String)symbolToEmbraceWith);
        TransientEditorExtKt.insert((TransientEditor)$this$embraceTextWithEmphasizeSymbols, (long)leftOffset, (String)symbolToEmbraceWith);
    }

    public static final void toggleEmphStyle(@NotNull TransientEditor $this$toggleEmphStyle, @NotNull String symbol) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleEmphStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        TextRange range = $this$toggleEmphStyle.getCurrentCaret().getSelection();
        if (!MarkdownTransientEditorUtilsKt.isRangeSurroundedBy((Document)$this$toggleEmphStyle.getDocument(), new Regex(symbol, RegexOption.LITERAL), range, symbol.length())) {
            MarkdownTransientEditorUtilsKt.embraceTextWithEmphasizeSymbols($this$toggleEmphStyle, symbol, range.getStart(), range.getEnd());
            if (range.getLength() == 0L) {
                EditorExtKt.moveAllCarets((MutableEditor)((MutableEditor)$this$toggleEmphStyle), (Function1)((Function1)new Function1<Caret, Caret>(symbol){
                    final /* synthetic */ String $symbol;
                    {
                        this.$symbol = $symbol;
                        super(1);
                    }

                    public final Caret invoke(Caret caret) {
                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                        return Caret.move$default((Caret)caret, (CaretPosition)new CaretPosition(caret.getPosition().getOffset() + (long)this.$symbol.length()), null, (int)2, null);
                    }
                }));
            }
        } else {
            Operation removalOperation = OperationKt.compose((Operation)Operation.Companion.deleteAt(range.getEnd(), symbol, (long)$this$toggleEmphStyle.getDocument().getText().getCharCount()), (Operation)Operation.Companion.deleteAt(range.getStart() - (long)symbol.length(), symbol, (long)$this$toggleEmphStyle.getDocument().getText().getCharCount() - (long)symbol.length()));
            $this$toggleEmphStyle.getDocument().edit(removalOperation);
        }
    }

    public static final void removeUrl(@NotNull TransientEditor $this$removeUrl, @NotNull SyntaxNode inlineLink) {
        SyntaxNode linkText;
        Intrinsics.checkNotNullParameter((Object)$this$removeUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inlineLink, (String)"inlineLink");
        if (!Intrinsics.areEqual((Object)inlineLink.getType(), (Object)MarkdownElementTypes.INLINE_LINK)) {
            return;
        }
        SyntaxNode syntaxNode = linkText = inlineLink.firstChild();
        if (Intrinsics.areEqual((Object)(syntaxNode != null ? syntaxNode.getType() : null), (Object)MarkdownElementTypes.LINK_TEXT)) {
            SyntaxNode text2;
            SyntaxNode syntaxNode2 = text2 = SyntaxNodeExtKt.leafByOffset((SyntaxNode)linkText, (long)(linkText.getStartOffset() + 1L));
            if (Intrinsics.areEqual((Object)(syntaxNode2 != null ? syntaxNode2.getType() : null), (Object)MarkdownTokenTypes.TEXT)) {
                $this$removeUrl.getDocument().edit(Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)inlineLink.getStartOffset(), (String)((Object)inlineLink.getText()).toString(), (String)((Object)text2.getText()).toString(), (long)$this$removeUrl.getDocument().getText().getCharCount(), (boolean)false, (int)16, null));
            } else {
                TransientEditorExtKt.delete((TransientEditor)$this$removeUrl, (TextRange)SyntexNodeExtKt.getTextRange((SyntaxNode)inlineLink));
            }
        }
    }

    public static final boolean hasMatchingTextRange(@NotNull SyntaxNode leftParent, @NotNull SyntaxNode rightParent) {
        Intrinsics.checkNotNullParameter((Object)leftParent, (String)"leftParent");
        Intrinsics.checkNotNullParameter((Object)rightParent, (String)"rightParent");
        return SyntexNodeExtKt.getTextRange((SyntaxNode)leftParent).getStart() == SyntexNodeExtKt.getTextRange((SyntaxNode)rightParent).getStart() && SyntexNodeExtKt.getTextRange((SyntaxNode)leftParent).getEnd() == SyntexNodeExtKt.getTextRange((SyntaxNode)rightParent).getEnd();
    }

    public static final boolean tryProcessCodeSpan(@NotNull TransientEditor $this$tryProcessCodeSpan, @NotNull TextRange range, @NotNull SyntaxNode leftParent) {
        Intrinsics.checkNotNullParameter((Object)$this$tryProcessCodeSpan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)leftParent, (String)"leftParent");
        if (!Intrinsics.areEqual((Object)leftParent.getType(), (Object)MarkdownElementTypes.CODE_SPAN)) {
            return false;
        }
        if (MarkdownTransientEditorUtilsKt.isRangeSurroundedBy((Document)$this$tryProcessCodeSpan.getDocument(), new Regex("`", RegexOption.LITERAL), range, 1)) {
            MarkdownTransientEditorUtilsKt.removeCodeSpan($this$tryProcessCodeSpan, leftParent);
            return true;
        }
        return false;
    }

    public static final boolean tryProcessCodeFence(@NotNull TransientEditor $this$tryProcessCodeFence, @NotNull TextRange range, @NotNull SyntaxNode leftParent) {
        Intrinsics.checkNotNullParameter((Object)$this$tryProcessCodeFence, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)leftParent, (String)"leftParent");
        if (!Intrinsics.areEqual((Object)leftParent.getType(), (Object)MarkdownElementTypes.CODE_FENCE)) {
            return false;
        }
        TextView view = $this$tryProcessCodeFence.getDocument().getText().view();
        int firstRangeToBorderDistance = LineNumber.minus-HtU2Wuk((int)view.lineAt-fZAJ6bk((int)range.getStart()), (int)view.lineAt-fZAJ6bk((int)leftParent.getStartOffset()));
        int secondRangeToBorderDistance = LineNumber.minus-HtU2Wuk((int)view.lineAt-fZAJ6bk((int)leftParent.getEndOffset()), (int)view.lineAt-fZAJ6bk((int)range.getEnd()));
        if (LineNumber.equals-impl0((int)firstRangeToBorderDistance, (int)LineNumberKt.getLine((int)1)) && LineNumber.equals-impl0((int)secondRangeToBorderDistance, (int)LineNumberKt.getLine((int)1))) {
            MarkdownTransientEditorUtilsKt.removeCodeFence($this$tryProcessCodeFence, leftParent);
            return true;
        }
        MarkdownTransientEditorUtilsKt.insertCodeSpan($this$tryProcessCodeFence, range);
        return true;
    }

    public static final void insertCodeSpanOrFence(@NotNull TransientEditor $this$insertCodeSpanOrFence, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)$this$insertCodeSpanOrFence, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        if (MarkdownTransientEditorUtilsKt.isOnSingleLine(textRange.getStart(), textRange.getEnd(), (MutableDocument)$this$insertCodeSpanOrFence.getDocument())) {
            MarkdownTransientEditorUtilsKt.insertCodeSpan($this$insertCodeSpanOrFence, textRange);
        } else {
            MarkdownTransientEditorUtilsKt.insertCodeFence($this$insertCodeSpanOrFence, textRange);
        }
    }

    private static final void insertCodeSpan(TransientEditor $this$insertCodeSpan, TextRange textRange) {
        MarkdownTransientEditorUtilsKt.embraceTextWithEmphasizeSymbols($this$insertCodeSpan, "`", textRange.getStart(), textRange.getEnd());
        if (textRange.getLength() == 0L) {
            EditorExtKt.moveAllCarets((MutableEditor)((MutableEditor)$this$insertCodeSpan), (Function1)insertCodeSpan.1.INSTANCE);
        }
    }

    private static final void insertCodeFence(TransientEditor $this$insertCodeFence, TextRange textRange) {
        TextLine prevLine;
        TextLine nextLine;
        TextRange processRange = textRange;
        TextFragmentCharSequence charSequence = TextViewExtKt.textLineAtOffset$default((TextView)$this$insertCodeFence.getDocument().getText().view(), (int)((int)processRange.getStart()), (boolean)false, (int)2, null).asCharSequence();
        boolean indented = true;
        long l = processRange.getStart() - charSequence.getFromChar();
        for (long i = 0L; i < l; ++i) {
            if (charSequence.get(i) == ' ') continue;
            indented = false;
        }
        if (indented) {
            processRange = new TextRange(charSequence.getFromChar(), processRange.getEnd());
        }
        Object lastFence = "\n```";
        if (processRange.getEnd() < (long)$this$insertCodeFence.getDocument().getText().getCharCount() - 1L && (nextLine = TextViewExtKt.textLineAtOffset$default((TextView)$this$insertCodeFence.getDocument().getText().view(), (int)((int)processRange.getEnd() + 1), (boolean)false, (int)2, null)).getRange().contains(processRange.getEnd())) {
            lastFence = (String)lastFence + "\n";
        }
        TransientEditorExtKt.insert((TransientEditor)$this$insertCodeFence, (long)processRange.getEnd(), (String)lastFence);
        String firstFence = "```\n";
        if (processRange.getStart() > 0L && (prevLine = TextViewExtKt.textLineAtOffset$default((TextView)$this$insertCodeFence.getDocument().getText().view(), (int)((int)processRange.getStart() - 1), (boolean)false, (int)2, null)).getRange().contains(processRange.getStart())) {
            char c = '\n';
            firstFence = c + firstFence;
        }
        TransientEditorExtKt.insert((TransientEditor)$this$insertCodeFence, (long)processRange.getStart(), (String)firstFence);
    }

    private static final void removeCodeFence(TransientEditor $this$removeCodeFence, SyntaxNode leftParent) {
        boolean bl = Intrinsics.areEqual((Object)leftParent.getType(), (Object)MarkdownElementTypes.CODE_FENCE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        SyntaxNode syntaxNode = leftParent.firstChild();
        Intrinsics.checkNotNull((Object)syntaxNode);
        SyntaxNode firstBacktick = syntaxNode;
        SyntaxNode syntaxNode2 = leftParent.lastChild();
        Intrinsics.checkNotNull((Object)syntaxNode2);
        SyntaxNode lastBacktick = syntaxNode2;
        TextLine firstFenceLine = TextViewExtKt.textLineAtOffset((TextView)$this$removeCodeFence.getDocument().getText().view(), (int)((int)firstBacktick.getStartOffset()), (boolean)true);
        TextLine lastFenceLine = TextViewExtKt.textLineAtOffset((TextView)$this$removeCodeFence.getDocument().getText().view(), (int)((int)lastBacktick.getStartOffset()), (boolean)true);
        TransientEditorExtKt.delete((TransientEditor)$this$removeCodeFence, (TextRange)lastFenceLine.getRange());
        TransientEditorExtKt.delete((TransientEditor)$this$removeCodeFence, (TextRange)firstFenceLine.getRange());
    }

    private static final void removeCodeSpan(TransientEditor $this$removeCodeSpan, SyntaxNode leftParent) {
        boolean bl = Intrinsics.areEqual((Object)leftParent.getType(), (Object)MarkdownElementTypes.CODE_SPAN);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        SyntaxNode syntaxNode = leftParent.firstChild();
        Intrinsics.checkNotNull((Object)syntaxNode);
        SyntaxNode firstBacktick = syntaxNode;
        SyntaxNode syntaxNode2 = leftParent.lastChild();
        Intrinsics.checkNotNull((Object)syntaxNode2);
        SyntaxNode lastBacktick = syntaxNode2;
        TransientEditorExtKt.delete((TransientEditor)$this$removeCodeSpan, (TextRange)SyntexNodeExtKt.getTextRange((SyntaxNode)lastBacktick));
        TransientEditorExtKt.delete((TransientEditor)$this$removeCodeSpan, (TextRange)SyntexNodeExtKt.getTextRange((SyntaxNode)firstBacktick));
    }

    private static final SyntaxNode nextSiblingSkipWhitespaces(SyntaxNode $this$nextSiblingSkipWhitespaces) {
        NodeAspectId aspect$iv = (NodeAspectId)WhitespaceNodeAspect.Id;
        boolean $i$f$getAspectMap = false;
        return AspectTreeWalkerUtilKt.nextSiblingSkipWhitespaces((SyntaxNode)$this$nextSiblingSkipWhitespaces, (NodeAspectMap)LanguageExtensionPointsKt.getAspectMap((NodeAspectId)aspect$iv, (KClass)Reflection.getOrCreateKotlinClass(WhitespaceNodeAspect.class)));
    }
}

