/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.plugins.markdown.frontend.language.MarkdownAstNode;
import fleet.plugins.markdown.frontend.language.MarkdownLanguageKt;
import fleet.plugins.markdown.frontend.language.MarkdownTreeWalkerKt;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.intellij.markdown.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010 \u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010\u00012\n\u0010)\u001a\u00060\u0012j\u0002`\u0013H\u0016J\b\u0010*\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0012j\u0002`\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lfleet/plugins/markdown/frontend/language/MarkdownSyntaxNode;", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "node", "Lfleet/plugins/markdown/frontend/language/MarkdownAstNode;", "<init>", "(Lfleet/plugins/markdown/frontend/language/MarkdownAstNode;)V", "type", "Lorg/intellij/markdown/IElementType;", "Lfleet/plugins/markdown/frontend/language/BackendTokenType;", "getType", "()Lorg/intellij/markdown/IElementType;", "text", "", "getText", "()Ljava/lang/CharSequence;", "text$delegate", "Lkotlin/Lazy;", "startOffset", "", "Lfleet/com/jetbrains/lang/syntax/CharOffset;", "getStartOffset", "()J", "endOffset", "getEndOffset", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "language", "", "getLanguage", "()Ljava/lang/Object;", "parent", "firstChild", "lastChild", "nextSibling", "prevSibling", "obtainSiblingFromParent", "indexDiff", "", "childByOffset", "offset", "toString", "fleet.plugins.markdown.frontend"})
public final class MarkdownSyntaxNode
implements SyntaxNode {
    @NotNull
    private final MarkdownAstNode node;
    @NotNull
    private final IElementType type;
    @NotNull
    private final Lazy text$delegate;
    private final long startOffset;
    private final long endOffset;
    @Nullable
    private final String errorMessage;
    @NotNull
    private final Object language;

    public MarkdownSyntaxNode(@NotNull MarkdownAstNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.type = this.node.getType();
        this.text$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CharSequence>(this){
            final /* synthetic */ MarkdownSyntaxNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final CharSequence invoke() {
                return MarkdownSyntaxNode.access$getNode$p(this.this$0).getText();
            }
        }));
        this.startOffset = this.node.getStartOffset();
        this.endOffset = this.node.getEndOffset();
        this.language = MarkdownLanguageKt.getMarkdownLanguageId();
    }

    @NotNull
    public IElementType getType() {
        return this.type;
    }

    @NotNull
    public CharSequence getText() {
        Lazy lazy = this.text$delegate;
        return (CharSequence)lazy.getValue();
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @NotNull
    public Object getLanguage() {
        return this.language;
    }

    @Nullable
    public SyntaxNode parent() {
        MarkdownAstNode markdownAstNode = this.node.parent();
        if (markdownAstNode == null) {
            return null;
        }
        MarkdownAstNode parent = markdownAstNode;
        return new MarkdownSyntaxNode(parent);
    }

    @Nullable
    public SyntaxNode firstChild() {
        List<MarkdownAstNode> children2 = this.node.children();
        MarkdownAstNode markdownAstNode = (MarkdownAstNode)CollectionsKt.firstOrNull(children2);
        if (markdownAstNode == null) {
            return null;
        }
        MarkdownAstNode child = markdownAstNode;
        return new MarkdownSyntaxNode(child);
    }

    @Nullable
    public SyntaxNode lastChild() {
        List<MarkdownAstNode> children2 = this.node.children();
        MarkdownAstNode markdownAstNode = (MarkdownAstNode)CollectionsKt.lastOrNull(children2);
        if (markdownAstNode == null) {
            return null;
        }
        MarkdownAstNode child = markdownAstNode;
        return new MarkdownSyntaxNode(child);
    }

    @Nullable
    public SyntaxNode nextSibling() {
        MarkdownAstNode markdownAstNode = this.obtainSiblingFromParent(1);
        if (markdownAstNode == null) {
            return null;
        }
        MarkdownAstNode child = markdownAstNode;
        return new MarkdownSyntaxNode(child);
    }

    @Nullable
    public SyntaxNode prevSibling() {
        MarkdownAstNode markdownAstNode = this.obtainSiblingFromParent(-1);
        if (markdownAstNode == null) {
            return null;
        }
        MarkdownAstNode child = markdownAstNode;
        return new MarkdownSyntaxNode(child);
    }

    private final MarkdownAstNode obtainSiblingFromParent(int indexDiff) {
        MarkdownAstNode markdownAstNode = this.node.parent();
        if (markdownAstNode == null) {
            return null;
        }
        MarkdownAstNode parent = markdownAstNode;
        List<MarkdownAstNode> children2 = parent.children();
        int index2 = CollectionsKt.binarySearch$default(children2, (Object)this.node, (Comparator)MarkdownTreeWalkerKt.access$getNodeRangeComparator$p(), (int)0, (int)0, (int)12, null);
        if (index2 == -1) {
            return null;
        }
        return (MarkdownAstNode)CollectionsKt.getOrNull(children2, (int)(index2 + indexDiff));
    }

    @Nullable
    public SyntaxNode childByOffset(long offset) {
        List<MarkdownAstNode> children2 = this.node.children();
        int index2 = CollectionsKt.binarySearch$default(children2, (int)0, (int)0, (Function1)((Function1)new Function1<MarkdownAstNode, Integer>(offset){
            final /* synthetic */ long $offset;
            {
                this.$offset = $offset;
                super(1);
            }

            public final Integer invoke(MarkdownAstNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (long)it.getEndOffset() <= this.$offset ? -1 : ((long)it.getStartOffset() > this.$offset ? 1 : 0);
            }
        }), (int)3, null);
        return index2 >= 0 ? (SyntaxNode)new MarkdownSyntaxNode(children2.get(index2)) : null;
    }

    @NotNull
    public String toString() {
        return "MdWalker(node=" + this.node + ", range=" + new LongRange(this.getStartOffset(), this.getEndOffset()) + ")";
    }

    public static final /* synthetic */ MarkdownAstNode access$getNode$p(MarkdownSyntaxNode $this) {
        return $this.node;
    }
}

