/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.pom.java;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3(JavaPsiBundle.message("jdk.1.3.language.level.description", new Object[0]), 3),
    JDK_1_4(JavaPsiBundle.message("jdk.1.4.language.level.description", new Object[0]), 4),
    JDK_1_5(JavaPsiBundle.message("jdk.1.5.language.level.description", new Object[0]), 5),
    JDK_1_6(JavaPsiBundle.message("jdk.1.6.language.level.description", new Object[0]), 6),
    JDK_1_7(JavaPsiBundle.message("jdk.1.7.language.level.description", new Object[0]), 7),
    JDK_1_8(JavaPsiBundle.message("jdk.1.8.language.level.description", new Object[0]), 8),
    JDK_1_9(JavaPsiBundle.message("jdk.1.9.language.level.description", new Object[0]), 9),
    JDK_10(JavaPsiBundle.message("jdk.10.language.level.description", new Object[0]), 10),
    JDK_11(JavaPsiBundle.message("jdk.11.language.level.description", new Object[0]), 11),
    JDK_12(JavaPsiBundle.message("jdk.12.language.level.description", new Object[0]), 12),
    JDK_13(JavaPsiBundle.message("jdk.13.language.level.description", new Object[0]), 13),
    JDK_14(JavaPsiBundle.message("jdk.14.language.level.description", new Object[0]), 14),
    JDK_15(JavaPsiBundle.message("jdk.15.language.level.description", new Object[0]), 15),
    JDK_16(JavaPsiBundle.message("jdk.16.language.level.description", new Object[0]), 16),
    JDK_17(JavaPsiBundle.message("jdk.17.language.level.description", new Object[0]), 17),
    JDK_17_PREVIEW(JavaPsiBundle.message("jdk.17.language.level.description", new Object[0]), 17),
    JDK_18(JavaPsiBundle.message("jdk.18.language.level.description", new Object[0]), 18),
    JDK_18_PREVIEW(JavaPsiBundle.message("jdk.18.language.level.description", new Object[0]), 18),
    JDK_19(JavaPsiBundle.message("jdk.19.language.level.description", new Object[0]), 19),
    JDK_19_PREVIEW(JavaPsiBundle.message("jdk.19.language.level.description", new Object[0]), 19),
    JDK_20(JavaPsiBundle.message("jdk.20.language.level.description", new Object[0]), 20),
    JDK_20_PREVIEW(JavaPsiBundle.message("jdk.20.language.level.description", new Object[0]), 20),
    JDK_21(JavaPsiBundle.message("jdk.21.language.level.description", new Object[0]), 21),
    JDK_21_PREVIEW(JavaPsiBundle.message("jdk.21.preview.language.level.description", new Object[0]), 21),
    JDK_22(JavaPsiBundle.message("jdk.21.language.level.description", new Object[0]), 21),
    JDK_22_PREVIEW(JavaPsiBundle.message("jdk.21.preview.language.level.description", new Object[0]), 21),
    JDK_X(JavaPsiBundle.message("jdk.X.language.level.description", new Object[0]), 21);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    @Nls
    private final String myPresentableText;
    private final JavaVersion myVersion;
    private final boolean myPreview;

    private LanguageLevel(String presentableText, int major) {
        this.myPresentableText = presentableText;
        this.myVersion = JavaVersion.compose(major);
        this.myPreview = this.name().endsWith("_PREVIEW");
    }

    public boolean isPreview() {
        return this.myPreview;
    }

    @Nullable
    public LanguageLevel getPreviewLevel() {
        if (this.myPreview) {
            return this;
        }
        try {
            return LanguageLevel.valueOf(this.name() + "_PREVIEW");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        return this.myPresentableText;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        return this.compareTo(level) >= 0;
    }

    public boolean isLessThan(@NotNull LanguageLevel level) {
        return this.compareTo(level) < 0;
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        return this.myVersion;
    }

    public boolean isUnsupported() {
        return true;
    }

    static {
        HIGHEST = JDK_18;
        KEY = Key.create((String)"LANGUAGE_LEVEL");
    }
}

