/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.AbstractBundle;
import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.java.parser.BasicDeclarationParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParserUtil;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFileParser {
    protected final TokenSet IMPORT_LIST_STOPPER_SET;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final TokenSet IMPLICIT_CLASS_INDICATORS;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;

    public BasicFileParser(@NotNull BasicJavaParser javaParser) {
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.IMPORT_LIST_STOPPER_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{BasicElementTypes.BASIC_MODIFIER_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT})});
        this.IMPLICIT_CLASS_INDICATORS = TokenSet.create((IElementType[])new IElementType[]{this.myJavaElementTypeContainer.METHOD, this.myJavaElementTypeContainer.FIELD, this.myJavaElementTypeContainer.CLASS_INITIALIZER});
    }

    public void parse(@NotNull PsiBuilder builder) {
        this.parseFile(builder, this::stopImportListParsing, JavaPsiBundle.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder, @NotNull Predicate<? super PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        this.parsePackageStatement(builder);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        PsiBuilder.Marker invalidElements = null;
        boolean isImplicitClass = false;
        while (!builder.eof()) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.myParser.getModuleParser().parse(builder);
            if (declaration == null) {
                declaration = this.parseInitial(builder);
            }
            if (declaration != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(BasicFileParser.error(bundle, errorMessageKey), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk == null) {
                    firstDeclarationOk = BasicJavaParserUtil.exprType(declaration) != this.myJavaElementTypeContainer.MODIFIER_LIST;
                }
                if (firstDeclaration == null) {
                    firstDeclaration = declaration;
                }
                if (isImplicitClass || !this.IMPLICIT_CLASS_INDICATORS.contains(BasicJavaParserUtil.exprType(declaration))) continue;
                isImplicitClass = true;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(BasicFileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getPrecedingCommentBinder(), null);
            firstDeclaration.setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getSpecialPrecedingCommentBinder(), null);
        }
        if (isImplicitClass) {
            PsiBuilder.Marker beforeFirst = firstDeclaration.precede();
            BasicJavaParserUtil.done(beforeFirst, this.myJavaElementTypeContainer.IMPLICIT_CLASS, this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private boolean stopImportListParsing(PsiBuilder b) {
        String text;
        IElementType type = b.getTokenType();
        if (this.IMPORT_LIST_STOPPER_SET.contains(type) || BasicDeclarationParser.isRecordToken(b, type)) {
            return true;
        }
        return type == JavaTokenType.IDENTIFIER && ("open".equals(text = b.getTokenText()) || "module".equals(text));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder) {
        return this.myParser.getDeclarationParser().parse(builder, BasicDeclarationParser.BaseContext.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.PACKAGE_KEYWORD)) {
                statement.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false)) == null) {
            statement.error(JavaPsiBundle.message("expected.class.or.interface", new Object[0]));
            return;
        }
        BasicJavaParserUtil.semicolon(builder);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.PACKAGE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
    }

    @NotNull
    protected Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder, Predicate<? super PsiBuilder> stopper) {
        PsiBuilder.Marker list = builder.mark();
        boolean isEmpty = true;
        PsiBuilder.Marker invalidElements = null;
        while (!builder.eof() && !stopper.test((PsiBuilder)builder)) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseImportStatement(builder);
            if (statement != null) {
                isEmpty = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), statement);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.rollbackTo();
        }
        if (isEmpty) {
            PsiBuilder.Marker precede = list.precede();
            list.rollbackTo();
            list = precede;
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.IMPORT_LIST, this.myWhiteSpaceAndCommentSetHolder);
        return Pair.create((Object)list, (Object)isEmpty);
    }

    @Nullable
    protected PsiBuilder.Marker parseImportStatement(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean isStatic = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.STATIC_KEYWORD);
        IElementType type = isStatic ? this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT : this.myJavaElementTypeContainer.IMPORT_STATEMENT;
        boolean isOk = this.myParser.getReferenceParser().parseImportCodeReference(builder, isStatic);
        if (isOk) {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, type, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    @NlsContexts.ParsingError
    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        return bundle.getMessage(errorMessageKey, new Object[0]);
    }
}

