/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lang.java.JavaLanguage;
import fleet.com.intellij.lang.java.lexer.JavaDocLexer;
import fleet.com.intellij.lang.java.lexer.JavaLexer;
import fleet.com.intellij.lang.java.parser.JavaParser;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.pom.java.LanguageLevel;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.impl.source.BasicJavaElementType;
import fleet.com.intellij.psi.java.JavaDocTokenType;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.java.impl.source.tree.ElementType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParserDefinition
implements ParserDefinition {
    public static final IFileElementType JAVA_FILE = new IFileElementType("java.FILE", JavaLanguage.INSTANCE){

        public void parse(@NotNull PsiBuilder builder) {
            PsiBuilder.Marker root = builder.mark();
            JavaParser.INSTANCE.getFileParser().parse(builder);
            root.done((IElementType)this);
        }
    };
    @NotNull
    private LanguageLevel myLanguageLevel = LanguageLevel.HIGHEST;

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void setLanguageLevel(LanguageLevel myLanguageLevel) {
        this.myLanguageLevel = myLanguageLevel;
    }

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return JavaParserDefinition.createLexer(this.myLanguageLevel);
    }

    @NotNull
    public static Lexer createLexer(@NotNull LanguageLevel level) {
        return new JavaLexer(level);
    }

    @NotNull
    public static Lexer createDocLexer(@NotNull LanguageLevel level) {
        return new JavaDocLexer(level);
    }

    public IFileElementType getFileNodeType() {
        return JAVA_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.WHITE_SPACE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return ElementType.JAVA_COMMENT_BIT_SET;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_LITERAL_EXPRESSION});
    }

    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        throw new IllegalStateException();
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        throw new IllegalStateException();
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text;
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN || left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        LanguageLevel level = this.myLanguageLevel;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        ParserDefinition.SpaceRequirements spaceRequirements = JavaParserDefinition.canStickTokensTogetherByLexer(left, right, lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text = left.getText()).length() > 0 && Character.isWhitespace(text.charAt(text.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text = right.getText()).length() > 0 && Character.isWhitespace(text.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }

    private static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start((CharSequence)textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

