/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.codeInsight.editorActions;

import fleet.com.intellij.formatting.Indent;
import fleet.com.intellij.lang.Language;
import fleet.com.intellij.lang.java.JavaLanguage;
import fleet.com.intellij.psi.ITokenSequence;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.codeStyle.IndentOptions;
import fleet.com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import fleet.com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import fleet.com.intellij.psi.java.JavaDocTokenType;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap();

    public JavaLineIndentProvider(@NotNull CharSequence charSequence, @NotNull ITokenSequence tokenSequence, @NotNull IndentOptions indentOptions) {
        super(charSequence, tokenSequence, indentOptions);
    }

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        return SYNTAX_MAP.get(tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        return language.isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Nullable
    protected Indent getIndentInBlock(@NotNull SemanticEditorPosition blockStartPosition) {
        SemanticEditorPosition beforeStart = blockStartPosition.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        if (beforeStart.isAt(JavaTokenType.EQ) || beforeStart.isAt(JavaTokenType.RBRACKET) || beforeStart.isAt(JavaTokenType.LPARENTH)) {
            return JavaLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.CONTINUATION);
        }
        return super.getIndentInBlock(blockStartPosition);
    }

    protected boolean isInsideForLikeConstruction(SemanticEditorPosition position) {
        return position.isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
    }

    protected boolean isInArray(int offset) {
        SemanticEditorPosition position = this.getPosition(offset);
        position.moveBefore();
        if (position.isAt(JavaTokenType.LBRACE) && position.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace).isAt(JavaTokenType.RBRACKET)) {
            return true;
        }
        return super.isInArray(offset);
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        return !position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) || !position.isAt(JavaTokenType.IDENTIFIER);
    }

    static {
        SYNTAX_MAP.put(TokenType.WHITE_SPACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        SYNTAX_MAP.put(JavaTokenType.SEMICOLON, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
        SYNTAX_MAP.put(JavaTokenType.LBRACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        SYNTAX_MAP.put(JavaTokenType.RBRACE, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        SYNTAX_MAP.put(JavaTokenType.LBRACKET, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
        SYNTAX_MAP.put(JavaTokenType.RBRACKET, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
        SYNTAX_MAP.put(JavaTokenType.RPARENTH, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        SYNTAX_MAP.put(JavaTokenType.LPARENTH, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
        SYNTAX_MAP.put(JavaTokenType.COLON, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
        SYNTAX_MAP.put(JavaTokenType.CASE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
        SYNTAX_MAP.put(JavaTokenType.DEFAULT_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
        SYNTAX_MAP.put(JavaTokenType.IF_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put(JavaTokenType.WHILE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put(JavaTokenType.ELSE_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
        SYNTAX_MAP.put(JavaTokenType.FOR_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
        SYNTAX_MAP.put(JavaTokenType.DO_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword);
        SYNTAX_MAP.put(JavaTokenType.C_STYLE_COMMENT, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
        SYNTAX_MAP.put(JavaDocTokenType.DOC_COMMENT_START, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockStart);
        SYNTAX_MAP.put(JavaDocTokenType.DOC_COMMENT_END, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockEnd);
        SYNTAX_MAP.put(JavaTokenType.COMMA, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
        SYNTAX_MAP.put(JavaTokenType.END_OF_LINE_COMMENT, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put(JavaTokenType.TRY_KEYWORD, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
    }
}

