/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.dotnet.frontend.features.aspects;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.lang.PresentableNodeAspect;
import fleet.plugins.dotnet.frontend.features.projectModel.MsBuildProjectType;
import fleet.plugins.dotnet.frontend.features.projectModel.MsprojTypes;
import fleet.plugins.dotnet.frontend.features.projectModel.view.SolutionViewIcons;
import fleet.plugins.dotnet.frontend.features.sln.parser.SlnNode;
import fleet.plugins.dotnet.frontend.features.sln.parser.SlnToken;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u001a\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Lfleet/plugins/dotnet/frontend/features/aspects/SlnProjectPresentation;", "Lfleet/frontend/lang/PresentableNodeAspect;", "()V", "getProjectNameNode", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "node", "getProjectType", "Lfleet/plugins/dotnet/frontend/features/projectModel/MsBuildProjectType;", "icon", "Lnoria/model/ThemeKey;", "", "Lnoria/model/IconKey;", "id", "name", "presentation", "fleet.plugins.dotnet.frontend"})
final class SlnProjectPresentation
implements PresentableNodeAspect {
    @NotNull
    public static final SlnProjectPresentation INSTANCE = new SlnProjectPresentation();

    private SlnProjectPresentation() {
    }

    @Nullable
    public SyntaxNode id(@NotNull SyntaxNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.getProjectNameNode(node2);
    }

    @NotNull
    public String presentation(@NotNull SyntaxNode node2) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        SyntaxNode syntaxNode = this.getProjectNameNode(node2);
        if (syntaxNode != null && (charSequence2 = syntaxNode.getText()) != null) {
            char[] cArray = new char[]{'\"'};
            charSequence = StringsKt.trim((CharSequence)charSequence2, (char[])cArray);
        } else {
            charSequence = null;
        }
        CharSequence projectName = charSequence;
        MsBuildProjectType projectType = this.getProjectType(node2);
        return projectName + " (" + projectType.getPresentationName() + ")";
    }

    private final SyntaxNode getProjectNameNode(SyntaxNode node2) {
        SyntaxNode syntaxNode = SyntaxNodeExtKt.findFirstChild((SyntaxNode)node2, (Object)((Object)SlnNode.PROJECT_NAME.INSTANCE));
        return syntaxNode != null ? SyntaxNodeExtKt.findFirstChild((SyntaxNode)syntaxNode, (Object)((Object)SlnToken.INSTANCE.getText())) : null;
    }

    @NotNull
    public String name(@NotNull SyntaxNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.presentation(node2);
    }

    private final MsBuildProjectType getProjectType(SyntaxNode node2) {
        SyntaxNode syntaxNode;
        SyntaxNode projectTypeGuidToken;
        SyntaxNode syntaxNode2 = SyntaxNodeExtKt.findFirstChild((SyntaxNode)node2, (Object)((Object)SlnNode.SECTION_ATTRIBUTE.INSTANCE));
        SyntaxNode syntaxNode3 = projectTypeGuidToken = syntaxNode2 != null && (syntaxNode = SyntaxNodeExtKt.findFirstChild((SyntaxNode)syntaxNode2, (Object)((Object)SlnNode.PROJECT_TYPE.INSTANCE))) != null ? SyntaxNodeExtKt.findFirstChild((SyntaxNode)syntaxNode, (Object)((Object)SlnToken.INSTANCE.getTextGuid())) : null;
        return MsprojTypes.INSTANCE.ParseProjectType(syntaxNode3 != null ? syntaxNode3.getText() : null);
    }

    @NotNull
    public ThemeKey<String> icon(@NotNull SyntaxNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getProjectType(node2).ordinal()]) {
            case 1 -> SolutionViewIcons.INSTANCE.getCsProject();
            case 2 -> SolutionViewIcons.INSTANCE.getSolutionFolder();
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> IconKeys.INSTANCE.getFolder();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean canContainsPresentableChildren(@NotNull SyntaxNode node2) {
        return PresentableNodeAspect.DefaultImpls.canContainsPresentableChildren((PresentableNodeAspect)this, (SyntaxNode)node2);
    }

    public boolean isFileStructureElement(@NotNull SyntaxNode node2) {
        return PresentableNodeAspect.DefaultImpls.isFileStructureElement((PresentableNodeAspect)this, (SyntaxNode)node2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MsBuildProjectType.values().length];
            try {
                nArray[MsBuildProjectType.csProject.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.solutionFolder.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.vbProject.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.cpsProject.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.cpsCsProject.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.cpsVbProject.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.cpsFsProject.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.vjProject.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.vcProject.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.fsProject.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.dbProject.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.wdProject.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.synProject.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.webProject.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.nodeJsProject.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.sharedProject.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsBuildProjectType.unknown.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

