/*
 * Decompiled with CFR 0.152.
 */
package andel.intervals;

import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.intervals.IntervalsFactory;
import andel.intervals.IntervalsKt;
import andel.intervals.KeyedIntervals;
import andel.operation.Operation;
import fleet.util.AtomicExtensionsKt;
import fleet.util.AtomicRef;
import fleet.util.AtomicRefKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001 B;\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0004\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\u0010H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J#\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J*\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\"\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016R)\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Landel/intervals/KeyedIntervals;", "K", "", "V", "Landel/intervals/Intervals;", "intervals", "", "Lkotlin/Pair;", "keys", "Lkotlinx/collections/immutable/PersistentMap;", "(Landel/intervals/Intervals;Lkotlinx/collections/immutable/PersistentMap;)V", "getIntervals", "()Landel/intervals/Intervals;", "getKeys", "()Lkotlinx/collections/immutable/PersistentMap;", "addIntervals", "", "Landel/intervals/Interval;", "edit", "Landel/operation/Operation;", "factory", "Landel/intervals/IntervalsFactory;", "findById", "id", "(Ljava/lang/Object;)Landel/intervals/Interval;", "query", "Lkotlin/sequences/Sequence;", "start", "end", "queryReversed", "removeByIds", "ids", "Companion", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nKeyedIntervals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyedIntervals.kt\nandel/intervals/KeyedIntervals\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1549#2:67\n1620#2,3:68\n1603#2,9:71\n1855#2:80\n1856#2:82\n1612#2:83\n1#3:81\n*S KotlinDebug\n*F\n+ 1 KeyedIntervals.kt\nandel/intervals/KeyedIntervals\n*L\n43#1:67\n43#1:68,3\n55#1:71,9\n55#1:80\n55#1:82\n55#1:83\n55#1:81\n*E\n"})
public final class KeyedIntervals<K, V>
implements Intervals<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Intervals<Long, Pair<K, V>> intervals;
    @NotNull
    private final PersistentMap<K, Long> keys;
    @NotNull
    private static final AtomicRef<Long> nextId = AtomicRefKt.AtomicRef((Object)0L);

    public KeyedIntervals(@NotNull Intervals<Long, Pair<K, V>> intervals, @NotNull PersistentMap<K, Long> keys) {
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.intervals = intervals;
        this.keys = keys;
    }

    public /* synthetic */ KeyedIntervals(Intervals intervals, PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            persistentMap = ExtensionsKt.persistentHashMapOf();
        }
        this(intervals, persistentMap);
    }

    @NotNull
    public final Intervals<Long, Pair<K, V>> getIntervals() {
        return this.intervals;
    }

    @NotNull
    public final PersistentMap<K, Long> getKeys() {
        return this.keys;
    }

    @Override
    @NotNull
    public IntervalsFactory<K> factory() {
        return IntervalsKt.keyed(this.intervals.factory());
    }

    @Override
    @Nullable
    public Interval<K, V> findById(@NotNull K id) {
        Interval interval;
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Long l = (Long)this.keys.get(id);
        if (l != null) {
            long intKey = ((Number)l).longValue();
            boolean bl = false;
            interval = Companion.fromInner(IntervalsKt.getById(this.intervals, intKey));
        } else {
            interval = null;
        }
        return interval;
    }

    @Override
    @NotNull
    public Sequence<Interval<K, V>> query(long start, long end) {
        return SequencesKt.map(this.intervals.query(start, end), (Function1)query.1.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<Interval<K, V>> queryReversed(long start, long end) {
        return SequencesKt.map(this.intervals.queryReversed(start, end), (Function1)queryReversed.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Intervals<K, V> addIntervals(@NotNull Iterable<? extends Interval<? extends K, ? extends V>> intervals) {
        PersistentMap.Builder builder;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        Iterable<? extends Interval<? extends K, ? extends V>> $this$map$iv = intervals;
        boolean $i$f$map22 = false;
        Iterable<? extends Interval<? extends K, ? extends V>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void interval;
            Interval interval2 = (Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.toInner(AtomicExtensionsKt.incrementAndGet(nextId), interval));
        }
        List inner = (List)destination$iv$iv;
        PersistentMap.Builder $i$f$map22 = builder = this.keys.builder();
        Intervals<Long, Pair<K, V>> intervals2 = this.intervals.addIntervals(inner);
        boolean bl = false;
        for (Interval interval : inner) {
            void $this$addIntervals_u24lambda_u242;
            $this$addIntervals_u24lambda_u242.put(((Pair)interval.data).getFirst(), interval.id);
        }
        PersistentMap persistentMap = builder.build();
        Intervals<Long, Pair<K, V>> intervals3 = intervals2;
        return new KeyedIntervals<K, V>(intervals3, persistentMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Intervals<K, V> removeByIds(@NotNull Iterable<? extends K> ids) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        PersistentMap.Builder builder = ids;
        Intervals<Long, Pair<Long, V>> intervals = this.intervals;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object id = element$iv$iv;
            boolean bl2 = false;
            if ((Long)this.keys.get(id) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        PersistentMap.Builder $i$f$mapNotNull22 = builder = this.keys.builder();
        intervals = intervals.removeByIds((List)destination$iv$iv);
        boolean bl = false;
        for (Object id : ids) {
            void $this$removeByIds_u24lambda_u244;
            $this$removeByIds_u24lambda_u244.remove(id);
        }
        PersistentMap persistentMap = builder.build();
        Intervals<Long, Pair<Long, V>> intervals2 = intervals;
        return new KeyedIntervals<K, V>(intervals2, persistentMap);
    }

    @Override
    @NotNull
    public Intervals<K, V> edit(@NotNull Operation edit) {
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        return new KeyedIntervals<K, V>(this.intervals.edit(edit), this.keys);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\t\"\u0004\b\u0002\u0010\n\"\u0004\b\u0003\u0010\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r0\tJF\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r0\t\"\u0004\b\u0002\u0010\n\"\u0004\b\u0003\u0010\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Landel/intervals/KeyedIntervals$Companion;", "", "()V", "nextId", "Lfleet/util/AtomicRef;", "", "getNextId", "()Lfleet/util/AtomicRef;", "fromInner", "Landel/intervals/Interval;", "K", "V", "i", "Lkotlin/Pair;", "toInner", "id", "fleet.andel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <K, V> Interval<Long, Pair<K, V>> toInner(long id, @NotNull Interval<? extends K, ? extends V> i) {
            Intrinsics.checkNotNullParameter(i, (String)"i");
            return new Interval<Long, Pair<K, V>>(id, i.from, i.to, i.greedyLeft, i.greedyRight, TuplesKt.to(i.id, i.data));
        }

        @NotNull
        public final <K, V> Interval<K, V> fromInner(@NotNull Interval<Long, ? extends Pair<? extends K, ? extends V>> i) {
            Intrinsics.checkNotNullParameter(i, (String)"i");
            return new Interval<Object, Object>(((Pair)i.data).getFirst(), i.from, i.to, i.greedyLeft, i.greedyRight, ((Pair)i.data).getSecond());
        }

        @NotNull
        public final AtomicRef<Long> getNextId() {
            return nextId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

