/*
 * Decompiled with CFR 0.152.
 */
package andel.intervals;

import andel.intervals.Impl;
import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.intervals.IntervalsFactory;
import andel.intervals.IntervalsIterator;
import andel.intervals.OldIntervalsFactory;
import andel.operation.Op;
import andel.operation.Operation;
import io.lacuna.bifurcan.IntMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ.\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00032\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001e0\u001dH\u0016J\u001a\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001e0\u001dH\u0016J\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)H\u0016J\u001e\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020\u0004H\u0016J*\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001e0-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00028\u0000012\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00028\u0000012\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J*\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001e0-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0016J\"\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00032\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dH\u0016J\b\u00106\u001a\u000207H\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00068"}, d2={"Landel/intervals/IntervalsImpl;", "T", "", "Landel/intervals/Intervals;", "", "maxChildren", "", "openRoot", "Landel/intervals/Impl$Node;", "closedRoot", "parentsMap", "Lio/lacuna/bifurcan/IntMap;", "nextInnerId", "dropEmpty", "", "(ILandel/intervals/Impl$Node;Landel/intervals/Impl$Node;Lio/lacuna/bifurcan/IntMap;JZ)V", "getClosedRoot", "()Landel/intervals/Impl$Node;", "getDropEmpty", "()Z", "getMaxChildren", "()I", "getNextInnerId", "()J", "getOpenRoot", "getParentsMap", "()Lio/lacuna/bifurcan/IntMap;", "addIntervals", "intervals", "", "Landel/intervals/Interval;", "asIterable", "batch", "Landel/intervals/Impl$Batch;", "collapse", "offset", "length", "edit", "Landel/operation/Operation;", "expand", "factory", "Landel/intervals/IntervalsFactory;", "findById", "id", "query", "Lkotlin/sequences/Sequence;", "start", "end", "queryBackward", "Landel/intervals/IntervalsIterator;", "queryForward", "queryReversed", "removeByIds", "ids", "toString", "", "fleet.andel"})
public final class IntervalsImpl<T>
implements Intervals<Long, T> {
    private final int maxChildren;
    @NotNull
    private final Impl.Node openRoot;
    @NotNull
    private final Impl.Node closedRoot;
    @NotNull
    private final IntMap<Long> parentsMap;
    private final long nextInnerId;
    private final boolean dropEmpty;

    public IntervalsImpl(int maxChildren, @NotNull Impl.Node openRoot, @NotNull Impl.Node closedRoot, @NotNull IntMap<Long> parentsMap, long nextInnerId, boolean dropEmpty) {
        Intrinsics.checkNotNullParameter((Object)openRoot, (String)"openRoot");
        Intrinsics.checkNotNullParameter((Object)closedRoot, (String)"closedRoot");
        Intrinsics.checkNotNullParameter(parentsMap, (String)"parentsMap");
        this.maxChildren = maxChildren;
        this.openRoot = openRoot;
        this.closedRoot = closedRoot;
        this.parentsMap = parentsMap;
        this.nextInnerId = nextInnerId;
        this.dropEmpty = dropEmpty;
    }

    public final int getMaxChildren() {
        return this.maxChildren;
    }

    @NotNull
    public final Impl.Node getOpenRoot() {
        return this.openRoot;
    }

    @NotNull
    public final Impl.Node getClosedRoot() {
        return this.closedRoot;
    }

    @NotNull
    public final IntMap<Long> getParentsMap() {
        return this.parentsMap;
    }

    public final long getNextInnerId() {
        return this.nextInnerId;
    }

    public final boolean getDropEmpty() {
        return this.dropEmpty;
    }

    @NotNull
    public final Impl.Batch<T> batch() {
        return Impl.INSTANCE.batch(this);
    }

    @Override
    @Nullable
    public Interval<Long, T> findById(long id) {
        return Impl.INSTANCE.getById(this, id);
    }

    @Override
    @NotNull
    public Intervals<Long, T> removeByIds(@NotNull Iterable<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return Impl.INSTANCE.remove(this, ids);
    }

    @NotNull
    public final IntervalsIterator<T> queryForward(long start, long end) {
        return Impl.INSTANCE.query(this, start, end);
    }

    @Override
    @NotNull
    public Sequence<Interval<Long, T>> query(long start, long end) {
        return IntervalsIterator.Companion.toSequence((Function0)new Function0<IntervalsIterator<T>>(this, start, end){
            final /* synthetic */ IntervalsImpl<T> this$0;
            final /* synthetic */ long $start;
            final /* synthetic */ long $end;
            {
                this.this$0 = $receiver;
                this.$start = $start;
                this.$end = $end;
                super(0);
            }

            @NotNull
            public final IntervalsIterator<T> invoke() {
                return this.this$0.queryForward(this.$start, this.$end);
            }
        });
    }

    @Override
    @NotNull
    public Sequence<Interval<Long, T>> queryReversed(long start, long end) {
        return IntervalsIterator.Companion.toSequence((Function0)new Function0<IntervalsIterator<T>>(this, start, end){
            final /* synthetic */ IntervalsImpl<T> this$0;
            final /* synthetic */ long $start;
            final /* synthetic */ long $end;
            {
                this.this$0 = $receiver;
                this.$start = $start;
                this.$end = $end;
                super(0);
            }

            @NotNull
            public final IntervalsIterator<T> invoke() {
                return IntervalsImpl.access$queryBackward(this.this$0, this.$start, this.$end);
            }
        });
    }

    @Override
    @NotNull
    public Iterable<Interval<Long, T>> asIterable() {
        return SequencesKt.asIterable(this.query(0L, 0x3FFFFFFFFFFFFFFEL));
    }

    private final IntervalsIterator<T> queryBackward(long start, long end) {
        return Impl.INSTANCE.queryReverse(this, start, end);
    }

    @NotNull
    public final IntervalsImpl<T> expand(long offset, long length) {
        return Impl.INSTANCE.expand(this, offset, length);
    }

    @NotNull
    public final IntervalsImpl<T> collapse(long offset, long length) {
        return Impl.INSTANCE.collapse(this, offset, length);
    }

    @Override
    @NotNull
    public Intervals<Long, T> edit(@NotNull Operation edit) {
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        long offset = 0L;
        IntervalsImpl<T> res = this;
        for (Op op : edit.getOps()) {
            if (op instanceof Op.Retain) {
                offset += ((Op.Retain)op).getLen();
                continue;
            }
            if (!(op instanceof Op.Replace)) continue;
            String insert = ((Op.Replace)op).getInsert();
            int length = insert.length();
            res = res.expand(offset, length);
            String delete = ((Op.Replace)op).getDelete();
            res = res.collapse(offset += (long)length, delete.length());
        }
        return res;
    }

    @Override
    @NotNull
    public Intervals<Long, T> addIntervals(@NotNull Iterable<? extends Interval<Long, ? extends T>> intervals) {
        Intervals intervals2;
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        ArrayList<Interval<Long, T>> intervalsList = new ArrayList<Interval<Long, T>>();
        for (Interval<Long, T> interval : intervals) {
            intervalsList.add(interval);
        }
        CollectionsKt.sortWith((List)intervalsList, Intervals.Companion.getCompareByStart());
        if (intervalsList.isEmpty()) {
            intervals2 = this;
        } else {
            Impl.Batch batch = this.batch();
            for (Interval interval : intervalsList) {
                long id = ((Number)interval.component1()).longValue();
                long from = interval.component2();
                long to = interval.component3();
                boolean greedyLeft = interval.component4();
                boolean greedyRight = interval.component5();
                Object data = interval.component6();
                batch.add(id, from, to, greedyLeft, greedyRight, data);
            }
            intervals2 = batch.commit();
        }
        return intervals2;
    }

    @Override
    @NotNull
    public IntervalsFactory<Long> factory() {
        return new OldIntervalsFactory(this.dropEmpty);
    }

    @NotNull
    public String toString() {
        return this.queryForward(0L, 0x3FFFFFFFFFFFFFFFL).toList().toString();
    }

    public static final /* synthetic */ IntervalsIterator access$queryBackward(IntervalsImpl $this, long start, long end) {
        return $this.queryBackward(start, end);
    }
}

