/*
 * Decompiled with CFR 0.152.
 */
package andel.intervals;

import andel.intervals.Interval;
import andel.intervals.IntervalsImpl;
import andel.intervals.IntervalsIterator;
import andel.intervals.MergingIterator;
import io.lacuna.bifurcan.IntMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007bcdefghB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0006J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\u001c\u0010 \u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010!\u001a\u00020\u0004H\u0002J.\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J4\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00062\u0006\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004JV\u0010'\u001a4\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040)0(j\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040)j\b\u0012\u0004\u0012\u00020\u0004`+`*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040.H\u0002J \u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u00100\u001a\u00020\u001bH\u0007J(\u00101\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u00102\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001bH\u0007J\u001e\u00103\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J4\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00062\u0006\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J,\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010!\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0001H\u0002J4\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u0018\u0018\u000107\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00062\u0006\u0010!\u001a\u00020\u0004J \u00108\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u00109\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012J(\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004H\u0002J\u0012\u0010?\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010A\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u0012H\u0002J \u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004J\u0010\u0010L\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010M\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004J4\u0010N\u001a\b\u0012\u0004\u0012\u0002H\u00180O\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00062\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004J4\u0010P\u001a\b\u0012\u0004\u0012\u0002H\u00180O\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00062\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004JZ\u0010Q\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010R\u001a\u00020\u000428\u0010S\u001a4\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040)0(j\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040)j\b\u0012\u0004\u0012\u00020\u0004`+`*H\u0002J2\u0010Q\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0006\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00062\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00040.J \u0010U\u001a\u0004\u0018\u00010\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010!\u001a\u00020\u0004H\u0002J \u0010V\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u00109\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u0012J\u001c\u0010X\u001a\u0004\u0018\u00010H2\b\u0010Y\u001a\u0004\u0018\u00010H2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u001a\u0010Z\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010[\u001a\u0012\u0012\u0004\u0012\u00020\u00120\\j\b\u0012\u0004\u0012\u00020\u0012`]2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J@\u0010[\u001a\u00020^2\u0016\u0010_\u001a\u0012\u0012\u0004\u0012\u00020\u00120\\j\b\u0012\u0004\u0012\u00020\u0012`]2\u0006\u0010`\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Landel/intervals/Impl;", "", "()V", "CLOSED_ROOT_ID", "", "EMPTY_DROPPING", "Landel/intervals/IntervalsImpl;", "EMPTY_KEEPING", "FIRST_ID", "MAX_VALUE", "OPEN_ROOT_ID", "adopt", "Lio/lacuna/bifurcan/IntMap;", "parentsMap", "parentId", "childrenIds", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "balanceChildren", "Landel/intervals/Impl$Node;", "ctx", "Landel/intervals/Impl$EditingContext;", "node", "batch", "Landel/intervals/Impl$Batch;", "T", "tree", "childrenNeedMerging", "", "threshold", "", "childrenNeedSplitting", "splitThreshold", "chooseRoot", "id", "collapse", "d", "offset", "len", "start", "deletionSubtree", "Ljava/util/HashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashMap;", "Lkotlin/collections/HashSet;", "parents", "toBeDeleted", "", "empty", "dropEmpty", "emptyImpl", "maxChildren", "expand", "extinct", "child", "getById", "Landel/intervals/Interval;", "growTree", "rootId", "intersects", "s1", "e1", "s2", "e2", "max", "arr", "mergeChildren", "mergeNodes", "leftDelta", "left", "rightDelta", "right", "nextIntersection", "Landel/intervals/Impl$Zipper;", "zipper", "from", "to", "normalize", "prevIntersection", "query", "Landel/intervals/IntervalsIterator;", "queryReverse", "remove", "nodeId", "subtree", "ids", "resolvePath", "shrinkTree", "root", "skipToOffset", "z", "splitChildren", "splitNode", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "", "result", "source", "thresh", "AbstractIterator", "BackwardIterator", "Batch", "EditingContext", "ForwardIterator", "Node", "Zipper", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Impl.kt\nandel/intervals/Impl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1011:1\n1#2:1012\n*E\n"})
public final class Impl {
    @NotNull
    public static final Impl INSTANCE = new Impl();
    private static final long OPEN_ROOT_ID = -1L;
    private static final long CLOSED_ROOT_ID = -2L;
    private static final long FIRST_ID = -3L;
    public static final long MAX_VALUE = 0x3FFFFFFFFFFFFFFEL;
    @NotNull
    private static final IntervalsImpl<?> EMPTY_DROPPING = Impl.emptyImpl(32, true);
    @NotNull
    private static final IntervalsImpl<?> EMPTY_KEEPING = Impl.emptyImpl(32, false);

    private Impl() {
    }

    @JvmStatic
    @NotNull
    public static final <T> IntervalsImpl<T> empty(boolean dropEmpty) {
        IntervalsImpl<?> intervalsImpl;
        if (dropEmpty) {
            IntervalsImpl<?> intervalsImpl2 = EMPTY_DROPPING;
            intervalsImpl = intervalsImpl2;
            Intrinsics.checkNotNull(intervalsImpl2, (String)"null cannot be cast to non-null type andel.intervals.IntervalsImpl<T of andel.intervals.Impl.empty>");
        } else {
            IntervalsImpl<?> intervalsImpl3 = EMPTY_KEEPING;
            intervalsImpl = intervalsImpl3;
            Intrinsics.checkNotNull(intervalsImpl3, (String)"null cannot be cast to non-null type andel.intervals.IntervalsImpl<T of andel.intervals.Impl.empty>");
        }
        return intervalsImpl;
    }

    @JvmStatic
    @NotNull
    public static final <T> IntervalsImpl<T> emptyImpl(int maxChildren, boolean dropEmpty) {
        Node openRoot = Node.Companion.empty(maxChildren / 2);
        Node closedRoot = Node.Companion.empty(maxChildren / 2);
        return new IntervalsImpl(maxChildren, openRoot, closedRoot, (IntMap<Long>)new IntMap(), -3L, dropEmpty);
    }

    private final void splitNode(ArrayList<Node> result, Node source, int from, int to, int thresh) {
        int length = to - from;
        if (length <= thresh) {
            ArrayList<Object> children = new ArrayList<Object>(to - from);
            children.addAll((Collection)source.getChildren().subList(from, to));
            result.add(new Node(new LongArrayList(source.getIds().elements(), from, to - from), new LongArrayList(source.getStarts().elements(), from, to - from), new LongArrayList(source.getEnds().elements(), from, to - from), children));
        } else {
            int half = length / 2;
            this.splitNode(result, source, from, from + half, thresh);
            this.splitNode(result, source, from + half, to, thresh);
        }
    }

    private final ArrayList<Node> splitNode(Node node, int splitThreshold) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.splitNode(result, node, 0, node.getChildren().size(), splitThreshold);
        return result;
    }

    private final boolean childrenNeedSplitting(Node node, int splitThreshold) {
        for (Object child : node.getChildren()) {
            if (child instanceof Node) {
                if (((Node)child).getChildren().size() <= splitThreshold) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private final IntMap<Long> adopt(IntMap<Long> parentsMap, long parentId, LongArrayList childrenIds) {
        IntMap parentsMap2 = parentsMap;
        LongArrayList longArrayList = childrenIds;
        Intrinsics.checkNotNull((Object)longArrayList);
        int n = longArrayList.size();
        for (int k = 0; k < n; ++k) {
            Intrinsics.checkNotNullExpressionValue((Object)parentsMap2.put(childrenIds.getLong(k), (Object)parentId), (String)"put(...)");
        }
        return parentsMap2;
    }

    private final Node splitChildren(EditingContext ctx, Node node) {
        Node node2;
        EditingContext editingContext = ctx;
        Intrinsics.checkNotNull((Object)editingContext);
        int splitThreshold = editingContext.getMaxChildren();
        if (this.childrenNeedSplitting(node, splitThreshold)) {
            Node result = Node.Companion.empty(splitThreshold / 2);
            IntMap m = ctx.getParentsMap();
            long nextId = ctx.getNextId();
            int n = node.getChildren().size();
            for (int i = 0; i < n; ++i) {
                Object object = node.getChildren().get(i);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                Node child = (Node)object;
                long childDelta = node.getStarts().getLong(i);
                long childId = node.getIds().getLong(i);
                Long parentId = (Long)m.get(childId, null);
                if (child.getChildren().size() > splitThreshold) {
                    ArrayList<Node> partition = this.splitNode(child, splitThreshold);
                    int n2 = partition.size();
                    for (int j = 0; j < n2; ++j) {
                        Node p;
                        Intrinsics.checkNotNullExpressionValue((Object)partition.get(j), (String)"get(...)");
                        long delta = this.normalize(p);
                        result.getChildren().add(p);
                        result.getStarts().add(delta + childDelta);
                        result.getEnds().add(this.max(p.getEnds()) + childDelta + delta);
                        if (j == 0) {
                            result.getIds().add(childId);
                            continue;
                        }
                        long l = nextId;
                        nextId = l + -1L;
                        long newId = l;
                        m = this.adopt(m, newId, p.getIds());
                        IntMap intMap = m.put(newId, (Object)parentId);
                        Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"put(...)");
                        m = intMap;
                        result.getIds().add(newId);
                    }
                    continue;
                }
                result.add(childId, node.getStarts().getLong(i), node.getEnds().getLong(i), child);
            }
            ctx.setNextId(nextId);
            ctx.setParentsMap(m);
            node2 = result;
        } else {
            node2 = node;
        }
        return node2;
    }

    private final boolean childrenNeedMerging(Node node, int threshold) {
        for (Object child : node.getChildren()) {
            if (child instanceof Node) {
                if (((Node)child).getChildren().size() >= threshold) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private final Node mergeNodes(long leftDelta, Node left, long rightDelta, Node right) {
        int i;
        int capacity = left.getChildren().size() + right.getChildren().size();
        long delta = rightDelta - leftDelta;
        Node n = Node.Companion.empty(capacity);
        int leftc = left.getChildren().size();
        int rightc = right.getChildren().size();
        for (i = 0; i < leftc; ++i) {
            n.getChildren().add(left.getChildren().get(i));
            n.getStarts().add(left.getStarts().getLong(i));
            n.getEnds().add(left.getEnds().getLong(i));
            n.getIds().add(left.getIds().getLong(i));
        }
        for (i = 0; i < rightc; ++i) {
            n.getChildren().add(right.getChildren().get(i));
            n.getStarts().add(right.getStarts().getLong(i) + delta);
            n.getEnds().add(right.getEnds().getLong(i) + delta);
            n.getIds().add(right.getIds().getLong(i));
        }
        return n;
    }

    private final Node mergeChildren(EditingContext ctx, Node node) {
        Node node2;
        EditingContext editingContext = ctx;
        Intrinsics.checkNotNull((Object)editingContext);
        int splitThreshold = editingContext.getMaxChildren();
        int mergeThreshold = splitThreshold / 2;
        if (this.childrenNeedMerging(node, mergeThreshold)) {
            Node result = Node.Companion.empty(mergeThreshold);
            Object object = node.getChildren().get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
            Node left = (Node)object;
            long leftDelta = node.getStarts().getLong(0);
            long leftId = node.getIds().getLong(0);
            long leftEnd = node.getEnds().getLong(0);
            int n = node.getChildren().size();
            for (int i = 1; i < n; ++i) {
                Object object2 = node.getChildren().get(i);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                Node right = (Node)object2;
                long rightDelta = node.getStarts().getLong(i);
                long rightId = node.getIds().getLong(i);
                long rightEnd = node.getEnds().getLong(i);
                if (left.getChildren().size() < mergeThreshold || right.getChildren().size() < mergeThreshold) {
                    Node merged = this.mergeChildren(ctx, this.mergeNodes(leftDelta, left, rightDelta, right));
                    if (merged.getChildren().size() > splitThreshold) {
                        ArrayList<Node> split = this.splitNode(merged, splitThreshold);
                        if (!(split.size() == 2)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        ctx.setParentsMap(this.adopt(ctx.getParentsMap(), leftId, split.get(0).getIds()));
                        long l = leftDelta + this.max(split.get(0).getEnds());
                        Node node3 = split.get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"get(...)");
                        result.add(leftId, leftDelta, l, node3);
                        ctx.setParentsMap(this.adopt(ctx.getParentsMap(), rightId, split.get(1).getIds()));
                        Intrinsics.checkNotNullExpressionValue((Object)split.get(1), (String)"get(...)");
                        Node node4 = split.get(1);
                        Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"get(...)");
                        leftEnd = (leftDelta += this.normalize(node4)) + this.max(split.get(1).getEnds());
                        leftId = rightId;
                        continue;
                    }
                    left = merged;
                    leftEnd = leftDelta + this.max(merged.getEnds());
                    ctx.setParentsMap(this.adopt(ctx.getParentsMap(), leftId, right.getIds()));
                    continue;
                }
                result.add(leftId, leftDelta, leftEnd, left);
                left = right;
                leftDelta = rightDelta;
                leftId = rightId;
                leftEnd = rightEnd;
            }
            result.add(leftId, leftDelta, leftEnd, left);
            node2 = result;
        } else {
            node2 = node;
        }
        return node2;
    }

    @NotNull
    public final Node balanceChildren(@Nullable EditingContext ctx, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.mergeChildren(ctx, this.splitChildren(ctx, node));
    }

    private final boolean intersects(long s1, long e1, long s2, long e2) {
        return s1 <= s2 ? s2 <= e1 : s1 <= e2;
    }

    @NotNull
    public final Node growTree(@Nullable EditingContext ctx, long rootId, @NotNull Node node) {
        Node node2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node balanced = this.balanceChildren(ctx, node);
        int n = balanced.getChildren().size();
        EditingContext editingContext = ctx;
        Intrinsics.checkNotNull((Object)editingContext);
        if (n > editingContext.getMaxChildren()) {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            newChildren.add(balanced);
            long l = ctx.getNextId();
            ctx.setNextId(l + -1L);
            long newLevelId = l;
            ctx.setParentsMap(this.adopt(ctx.getParentsMap(), newLevelId, balanced.getIds()));
            IntMap intMap = ctx.getParentsMap().put(newLevelId, (Object)rootId);
            Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"put(...)");
            ctx.setParentsMap((IntMap<Long>)intMap);
            long[] lArray = new long[]{newLevelId};
            LongArrayList longArrayList = new LongArrayList(lArray);
            lArray = new long[]{0L};
            LongArrayList longArrayList2 = new LongArrayList(lArray);
            lArray = new long[]{Long.MAX_VALUE};
            Node newRoot = new Node(longArrayList, longArrayList2, new LongArrayList(lArray), newChildren);
            node2 = this.growTree(ctx, rootId, newRoot);
        } else {
            node2 = balanced;
        }
        return node2;
    }

    @NotNull
    public final Node shrinkTree(@Nullable EditingContext ctx, long rootId, @NotNull Node root) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (root.getChildren().size() == 1 && root.getChildren().get(0) instanceof Node) {
            long delta = root.getStarts().getLong(0);
            Object object = root.getChildren().get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
            Node child = (Node)object;
            int n = child.getStarts().size();
            for (int i = 0; i < n; ++i) {
                child.getStarts().set(i, child.getStarts().getLong(i) + delta);
                child.getEnds().set(i, child.getEnds().getLong(i) + delta);
            }
            EditingContext editingContext = ctx;
            Intrinsics.checkNotNull((Object)editingContext);
            editingContext.setParentsMap(this.adopt(ctx.getParentsMap(), rootId, child.getIds()));
            node = this.shrinkTree(ctx, rootId, child);
        } else {
            node = root;
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private final long normalize(Node node) {
        long l;
        if (node.getStarts().size() == 0) {
            l = 0L;
        } else {
            void var2_2;
            long delta = node.getStarts().getLong(0);
            if (delta != 0L) {
                int n = node.getStarts().size();
                for (int i = 0; i < n; ++i) {
                    node.getStarts().set(i, node.getStarts().getLong(i) - delta);
                    node.getEnds().set(i, node.getEnds().getLong(i) - delta);
                }
            }
            l = var2_2;
        }
        return l;
    }

    @NotNull
    public final <T> Batch<T> batch(@NotNull IntervalsImpl<T> tree) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        long l = tree.getNextInnerId();
        int n = tree.getMaxChildren();
        boolean bl = tree.getDropEmpty();
        IntMap intMap = tree.getParentsMap().linear();
        Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"linear(...)");
        EditingContext ctx = new EditingContext(l, n, bl, (IntMap<Long>)intMap);
        return new Batch(Zipper.Companion.create(tree.getOpenRoot(), ctx, true), Zipper.Companion.create(tree.getClosedRoot(), ctx, false), ctx);
    }

    private final Zipper skipToOffset(Zipper z2, long offset) {
        Zipper zipper;
        Intrinsics.checkNotNull((Object)z2);
        int n = z2.getStarts().size();
        for (int i = (v14522).getIdx(); i < n; ++i) {
            Zipper zipper2;
            if (z2.getStarts().getLong(i) + z2.getDelta() < offset) continue;
            if (Zipper.Companion.isBranch(z2)) {
                Zipper down;
                Zipper zipper3 = down = Zipper.Companion.downLeft(z2);
                zipper2 = zipper3 == null ? z2 : this.skipToOffset(zipper3, offset);
            } else {
                z2.setIdx(i - 1);
                zipper2 = z2;
            }
            return zipper2;
        }
        if (z2.getHasRightCousin()) {
            zipper = this.skipToOffset(Zipper.Companion.up(z2), offset);
        } else {
            z2.setIdx(z2.getStarts().size() - 1);
            if (Zipper.Companion.isBranch(z2)) {
                Zipper down;
                Zipper zipper4 = down = Zipper.Companion.downLeft(z2);
                zipper = zipper4 == null ? z2 : this.skipToOffset(zipper4, offset);
            } else {
                zipper = z2;
            }
        }
        return zipper;
    }

    @Nullable
    public final Zipper nextIntersection(@NotNull Zipper zipper, long from, long to) {
        Zipper skip;
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        int n = zipper.getStarts().size();
        for (int i = zipper.getIdx(); i < n; ++i) {
            Zipper down;
            if (!this.intersects(from, to, zipper.getStarts().getLong(i) + zipper.getDelta(), zipper.getEnds().getLong(i) + zipper.getDelta())) continue;
            zipper.setIdx(i);
            return Zipper.Companion.isBranch(zipper) ? ((down = Zipper.Companion.downLeft(zipper)) != null ? this.nextIntersection(down, from, to) : null) : zipper;
        }
        Zipper zipper2 = Zipper.Companion.up(zipper);
        if (zipper2 == null) {
            return null;
        }
        Zipper up = zipper2;
        Zipper zipper3 = skip = Zipper.Companion.skipRight(up);
        return zipper3 == null ? null : this.nextIntersection(zipper3, from, to);
    }

    @Nullable
    public final Zipper prevIntersection(@NotNull Zipper zipper, long from, long to) {
        Zipper skip;
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        for (int i = zipper.getIdx(); -1 < i; --i) {
            Zipper down;
            if (!this.intersects(from, to, zipper.getStarts().getLong(i) + zipper.getDelta(), zipper.getEnds().getLong(i) + zipper.getDelta())) continue;
            zipper.setIdx(i);
            return Zipper.Companion.isBranch(zipper) ? ((down = Zipper.Companion.downRight(zipper)) != null ? this.prevIntersection(down, from, to) : null) : zipper;
        }
        Zipper zipper2 = Zipper.Companion.up(zipper);
        if (zipper2 == null) {
            return null;
        }
        Zipper up = zipper2;
        Zipper zipper3 = skip = Zipper.Companion.skipLeft(up);
        return zipper3 == null ? null : this.prevIntersection(zipper3, from, to);
    }

    @NotNull
    public final <T> IntervalsIterator<T> query(@NotNull IntervalsImpl<T> tree, long from, long to) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        long from2 = 0L;
        from2 = from;
        long to2 = 0L;
        to2 = to;
        if (!(from2 <= to2)) {
            boolean bl = false;
            String string2 = "Not " + from2 + " <= " + to2;
            throw new IllegalArgumentException(string2.toString());
        }
        from2 = Math.min(0x3FFFFFFFFFFFFFFEL, from2);
        to2 = Math.min(0x3FFFFFFFFFFFFFFEL, to2);
        return new MergingIterator(new ForwardIterator(Zipper.Companion.create(tree.getOpenRoot(), null, true), from2 * (long)2, to2 * (long)2), new ForwardIterator(Zipper.Companion.create(tree.getClosedRoot(), null, false), from2 * (long)2, to2 * (long)2), IntervalsIterator.FORWARD_COMPARATOR);
    }

    @NotNull
    public final <T> IntervalsIterator<T> queryReverse(@NotNull IntervalsImpl<T> tree, long from, long to) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        long from2 = from;
        long to2 = to;
        if (!(from2 <= to2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        from2 = Math.min(0x3FFFFFFFFFFFFFFEL, from2);
        to2 = Math.min(0x3FFFFFFFFFFFFFFEL, to2);
        IntervalsIterator intervalsIterator = new BackwardIterator(Zipper.Companion.create(tree.getOpenRoot(), null, true), from2 * (long)2, to2 * (long)2);
        IntervalsIterator intervalsIterator2 = new BackwardIterator(Zipper.Companion.create(tree.getClosedRoot(), null, false), from2 * (long)2, to2 * (long)2);
        Comparator<IntervalsIterator<?>> comparator = IntervalsIterator.BACKWARD_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"BACKWARD_COMPARATOR");
        return new MergingIterator(intervalsIterator, intervalsIterator2, comparator);
    }

    @NotNull
    public final Node expand(@NotNull Node node, long offset, long len) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node result = Node.Companion.empty(node.getChildren().size());
        int n = node.getChildren().size();
        for (int i = 0; i < n; ++i) {
            Object child;
            long id = node.getIds().getLong(i);
            long start = node.getStarts().getLong(i);
            long end = node.getEnds().getLong(i);
            Intrinsics.checkNotNullExpressionValue((Object)node.getChildren().get(i), (String)"get(...)");
            if (start < offset && offset < end) {
                Object c = child instanceof Node ? this.expand((Node)child, offset - start, len) : child;
                result.add(id, start, end + len, c);
                continue;
            }
            if (offset <= start) {
                result.add(id, start + len, end + len, child);
                continue;
            }
            result.add(id, start, end, child);
        }
        return result;
    }

    @NotNull
    public final <T> IntervalsImpl<T> expand(@NotNull IntervalsImpl<T> tree, long start, long len) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        return len == 0L ? tree : new IntervalsImpl(tree.getMaxChildren(), this.expand(tree.getOpenRoot(), start * (long)2, len * (long)2), this.expand(tree.getClosedRoot(), start * (long)2, len * (long)2), tree.getParentsMap(), tree.getNextInnerId(), tree.getDropEmpty());
    }

    private final IntMap<Long> extinct(IntMap<Long> parentsMap, long id, Object child) {
        IntMap<Long> parentsMap2 = parentsMap;
        IntMap<Long> intMap = parentsMap2.remove(id);
        Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"remove(...)");
        parentsMap2 = intMap;
        if (child instanceof Node) {
            int n = ((Node)child).getIds().size();
            for (int i = 0; i < n; ++i) {
                long l = ((Node)child).getIds().getLong(i);
                Object object = ((Node)child).getChildren().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                parentsMap2 = this.extinct(parentsMap2, l, object);
            }
        }
        return parentsMap2;
    }

    @NotNull
    public final Node collapse(@NotNull EditingContext ctx, long d, @NotNull Node node, long offset, long len) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node result = Node.Companion.empty(node.getChildren().size());
        int n = node.getChildren().size();
        for (int i = 0; i < n; ++i) {
            Object child;
            long start = node.getStarts().getLong(i);
            long end = node.getEnds().getLong(i);
            Intrinsics.checkNotNullExpressionValue((Object)node.getChildren().get(i), (String)"get(...)");
            long id = node.getIds().getLong(i);
            if (end <= offset) {
                result.add(id, start, end, child);
                continue;
            }
            if (offset + len <= start) {
                result.add(id, start - len, end - len, child);
                continue;
            }
            if (ctx.getDropEmpty() && offset <= start && end <= offset + len) {
                ctx.setParentsMap(this.extinct(ctx.getParentsMap(), id, child));
                continue;
            }
            if (child instanceof Node) {
                Object c = child;
                c = this.collapse(ctx, d + start, (Node)c, offset - start, len);
                long delta = this.normalize((Node)c);
                long newStart = start + delta;
                result.add(id, newStart, newStart + this.max(((Node)c).getEnds()), c);
                continue;
            }
            long newStart = offset < start ? Math.max(offset - (d + start) % (long)2, start - len) : start;
            long newEnd = Math.max(offset + (d + end) % (long)2, end - len);
            if (ctx.getDropEmpty() && newEnd - newStart < 2L) {
                ctx.setParentsMap(this.extinct(ctx.getParentsMap(), id, child));
                continue;
            }
            result.add(id, newStart, newEnd, child);
        }
        return this.balanceChildren(ctx, result);
    }

    @NotNull
    public final <T> IntervalsImpl<T> collapse(@NotNull IntervalsImpl<T> tree, long start, long len) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        if (len == 0L) {
            return tree;
        }
        long l = tree.getNextInnerId();
        int n = tree.getMaxChildren();
        boolean bl = tree.getDropEmpty();
        IntMap intMap = tree.getParentsMap().linear();
        Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"linear(...)");
        EditingContext ctx = new EditingContext(l, n, bl, (IntMap<Long>)intMap);
        Node openRoot = this.shrinkTree(ctx, -1L, this.growTree(ctx, -1L, this.collapse(ctx, 0L, tree.getOpenRoot(), start * (long)2, len * (long)2)));
        Node closedRoot = this.shrinkTree(ctx, -2L, this.growTree(ctx, -2L, this.collapse(ctx, 0L, tree.getClosedRoot(), start * (long)2, len * (long)2)));
        int n2 = tree.getMaxChildren();
        IntMap intMap2 = ctx.getParentsMap().forked();
        Intrinsics.checkNotNullExpressionValue((Object)intMap2, (String)"forked(...)");
        return new IntervalsImpl(n2, openRoot, closedRoot, (IntMap<Long>)intMap2, ctx.getNextId(), tree.getDropEmpty());
    }

    private final Node remove(EditingContext ctx, Node node, long nodeId, HashMap<Long, HashSet<Long>> subtree) {
        HashSet<Long> hashSet = subtree.get(nodeId);
        if (hashSet == null) {
            return node;
        }
        HashSet<Long> victims = hashSet;
        Node copy = node.copy();
        for (Long vid : victims) {
            Object victim;
            LongArrayList longArrayList = copy.getIds();
            Intrinsics.checkNotNull((Object)vid);
            int vidx = longArrayList.indexOf(vid.longValue());
            Intrinsics.checkNotNullExpressionValue((Object)copy.getChildren().get(vidx), (String)"get(...)");
            if (victim instanceof Node) {
                Node newNode = this.remove(ctx, (Node)victim, vid, subtree);
                long delta = this.normalize(newNode);
                copy.getChildren().set(vidx, newNode);
                long start = copy.getStarts().getLong(vidx) + delta;
                copy.getStarts().set(vidx, start);
                copy.getEnds().set(vidx, this.max(newNode.getEnds()) + start);
                continue;
            }
            copy.getChildren().remove(vidx);
            copy.getStarts().removeLong(vidx);
            copy.getEnds().removeLong(vidx);
            copy.getIds().removeLong(vidx);
            IntMap intMap = ctx.getParentsMap().remove(vid.longValue());
            Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"remove(...)");
            ctx.setParentsMap((IntMap<Long>)intMap);
        }
        return this.balanceChildren(ctx, copy);
    }

    @NotNull
    public final <T> IntervalsImpl<T> remove(@NotNull IntervalsImpl<T> tree, @NotNull Iterable<Long> ids) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (!CollectionsKt.any(ids)) {
            return tree;
        }
        HashMap<Long, HashSet<Long>> deletionSubtree = this.deletionSubtree(tree.getParentsMap(), ids);
        long l = tree.getNextInnerId();
        int n = tree.getMaxChildren();
        boolean bl = tree.getDropEmpty();
        IntMap intMap = tree.getParentsMap().linear();
        Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"linear(...)");
        EditingContext ctx = new EditingContext(l, n, bl, (IntMap<Long>)intMap);
        Node openRoot = this.shrinkTree(ctx, -1L, this.remove(ctx, tree.getOpenRoot(), -1L, deletionSubtree));
        Node closedRoot = this.shrinkTree(ctx, -2L, this.remove(ctx, tree.getClosedRoot(), -2L, deletionSubtree));
        int n2 = tree.getMaxChildren();
        IntMap intMap2 = ctx.getParentsMap().forked();
        Intrinsics.checkNotNullExpressionValue((Object)intMap2, (String)"forked(...)");
        return new IntervalsImpl(n2, openRoot, closedRoot, (IntMap<Long>)intMap2, ctx.getNextId(), tree.getDropEmpty());
    }

    private final LongArrayList resolvePath(IntMap<Long> parents, long id) {
        long l;
        LongArrayList path = new LongArrayList(4);
        Long p = id;
        do {
            if ((p = (Long)parents.get(p, null)) == null) {
                return null;
            }
            path.add(p.longValue());
            l = -1L;
            if (p == l) break;
            l = -2L;
        } while (p != l);
        return path;
    }

    private final Node chooseRoot(IntervalsImpl<?> tree, long id) {
        Node node;
        long l = id;
        if (l == -1L) {
            node = tree.getOpenRoot();
        } else if (l == -2L) {
            node = tree.getClosedRoot();
        } else {
            throw new IllegalArgumentException("given id:" + id);
        }
        return node;
    }

    @Nullable
    public final <T> Interval<Long, T> getById(@NotNull IntervalsImpl<T> tree, long id) {
        Interval<Long, Object> interval;
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        LongArrayList longArrayList = this.resolvePath(tree.getParentsMap(), id);
        if (longArrayList == null) {
            return null;
        }
        LongArrayList path = longArrayList;
        Node n = this.chooseRoot(tree, path.getLong(path.size() - 1));
        int delta = 0;
        for (int i = path.size() - 2; -1 < i; --i) {
            int idx = n.getIds().indexOf(path.getLong(i));
            if (idx == -1) {
                return null;
            }
            delta += (int)n.getStarts().getLong(idx);
            Object object = n.getChildren().get(idx);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
            n = (Node)object;
        }
        int idx = n.getIds().indexOf(id);
        if (idx == -1) {
            interval = null;
        } else {
            long from = n.getStarts().getLong(idx) + (long)delta;
            long to = n.getEnds().getLong(idx) + (long)delta;
            Long l = n.getIds().getLong(idx);
            long l2 = from / (long)2 + Math.max(0L, from % (long)2);
            long l3 = to / (long)2;
            boolean bl = from % (long)2 != 0L;
            boolean bl2 = to % (long)2 != 0L;
            Object object = n.getChildren().get(idx);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of andel.intervals.Impl.getById");
            interval = new Interval<Long, Object>(l, l2, l3, bl, bl2, object);
        }
        return interval;
    }

    private final HashMap<Long, HashSet<Long>> deletionSubtree(IntMap<Long> parents, Iterable<Long> toBeDeleted) {
        HashMap<Long, HashSet<Long>> subtree = new HashMap<Long, HashSet<Long>>();
        Iterator<Long> iterator = toBeDeleted.iterator();
        while (iterator.hasNext()) {
            long id = ((Number)iterator.next()).longValue();
            if (!(id >= 0L)) {
                boolean bl = false;
                String string2 = "id:" + id;
                throw new IllegalArgumentException(string2.toString());
            }
            long cid = id;
            if (parents.get(cid, null) == null) continue;
            while (cid != -1L && cid != -2L) {
                HashSet<Long> sibs;
                Long l = (Long)parents.get(cid, null);
                if (l == null) {
                    throw new NoSuchElementException("id:" + cid);
                }
                long pid = l;
                Intrinsics.checkNotNullExpressionValue(subtree.getOrDefault(pid, new HashSet()), (String)"getOrDefault(...)");
                sibs.add(cid);
                Long l2 = pid;
                ((Map)subtree).put(l2, sibs);
                cid = pid;
            }
        }
        return subtree;
    }

    private final long max(LongArrayList arr) {
        long m = Long.MIN_VALUE;
        LongArrayList longArrayList = arr;
        Intrinsics.checkNotNull((Object)longArrayList);
        int n = longArrayList.size();
        for (int i = 0; i < n; ++i) {
            long l = arr.getLong(i);
            if (l <= m) continue;
            m = l;
        }
        return m;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0012"}, d2={"Landel/intervals/Impl$AbstractIterator;", "T", "Landel/intervals/IntervalsIterator;", "z", "Landel/intervals/Impl$Zipper;", "(Landel/intervals/Impl$Zipper;)V", "getZ", "()Landel/intervals/Impl$Zipper;", "setZ", "data", "()Ljava/lang/Object;", "from", "", "greedyLeft", "", "greedyRight", "id", "to", "fleet.andel"})
    public static abstract class AbstractIterator<T>
    implements IntervalsIterator<T> {
        @Nullable
        private Zipper z;

        public AbstractIterator(@Nullable Zipper z2) {
            this.z = z2;
        }

        @Nullable
        public final Zipper getZ() {
            return this.z;
        }

        public final void setZ(@Nullable Zipper zipper) {
            this.z = zipper;
        }

        @Override
        public boolean greedyLeft() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            long l = zipper.getDelta();
            Zipper zipper2 = this.z;
            Intrinsics.checkNotNull((Object)zipper2);
            LongArrayList longArrayList = zipper2.getStarts();
            Zipper zipper3 = this.z;
            Intrinsics.checkNotNull((Object)zipper3);
            return (l + longArrayList.getLong(zipper3.getIdx())) % (long)2 != 0L;
        }

        @Override
        public boolean greedyRight() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            long l = zipper.getDelta();
            Zipper zipper2 = this.z;
            Intrinsics.checkNotNull((Object)zipper2);
            LongArrayList longArrayList = zipper2.getEnds();
            Zipper zipper3 = this.z;
            Intrinsics.checkNotNull((Object)zipper3);
            return (l + longArrayList.getLong(zipper3.getIdx())) % (long)2 != 0L;
        }

        @Override
        public long from() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.from(zipper);
        }

        @Override
        public long to() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.to(zipper);
        }

        @Override
        public long id() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.id(zipper);
        }

        @Override
        public T data() {
            Zipper zipper = this.z;
            Intrinsics.checkNotNull((Object)zipper);
            return Zipper.Companion.data(zipper);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\nH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landel/intervals/Impl$BackwardIterator;", "T", "Landel/intervals/Impl$AbstractIterator;", "z", "Landel/intervals/Impl$Zipper;", "queryFrom", "", "queryTo", "(Landel/intervals/Impl$Zipper;JJ)V", "next", "", "fleet.andel"})
    public static final class BackwardIterator<T>
    extends AbstractIterator<T> {
        private final long queryFrom;
        private final long queryTo;

        public BackwardIterator(@Nullable Zipper z2, long queryFrom, long queryTo) {
            super(z2);
            this.queryFrom = queryFrom;
            this.queryTo = queryTo;
        }

        @Override
        public boolean next() {
            Zipper next;
            Zipper zipper;
            Zipper zipper2 = this.getZ();
            Intrinsics.checkNotNull((Object)zipper2);
            if (Zipper.Companion.isRoot(zipper2)) {
                zipper = this.getZ();
            } else {
                Zipper zipper3 = this.getZ();
                Intrinsics.checkNotNull((Object)zipper3);
                zipper = Zipper.Companion.skipLeft(zipper3);
            }
            Zipper zipper4 = next = zipper;
            this.setZ(zipper4 == null ? null : INSTANCE.prevIntersection(zipper4, this.queryFrom, this.queryTo));
            return this.getZ() != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ;\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landel/intervals/Impl$Batch;", "T", "", "openZipper", "Landel/intervals/Impl$Zipper;", "closedZipper", "editingContext", "Landel/intervals/Impl$EditingContext;", "(Landel/intervals/Impl$Zipper;Landel/intervals/Impl$Zipper;Landel/intervals/Impl$EditingContext;)V", "lastSeenFrom", "", "add", "", "id", "from", "to", "closedLeft", "", "closedRight", "data", "(JJJZZLjava/lang/Object;)V", "commit", "Landel/intervals/IntervalsImpl;", "fleet.andel"})
    @SourceDebugExtension(value={"SMAP\nImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Impl.kt\nandel/intervals/Impl$Batch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1011:1\n1#2:1012\n*E\n"})
    public static final class Batch<T> {
        @NotNull
        private Zipper openZipper;
        @NotNull
        private Zipper closedZipper;
        @NotNull
        private EditingContext editingContext;
        private long lastSeenFrom;

        public Batch(@NotNull Zipper openZipper, @NotNull Zipper closedZipper, @NotNull EditingContext editingContext) {
            Intrinsics.checkNotNullParameter((Object)openZipper, (String)"openZipper");
            Intrinsics.checkNotNullParameter((Object)closedZipper, (String)"closedZipper");
            Intrinsics.checkNotNullParameter((Object)editingContext, (String)"editingContext");
            this.openZipper = openZipper;
            this.closedZipper = closedZipper;
            this.editingContext = editingContext;
            this.lastSeenFrom = Long.MIN_VALUE;
        }

        public final void add(long id, long from, long to, boolean closedLeft, boolean closedRight, @NotNull T data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (!(from >= this.lastSeenFrom)) {
                boolean bl = false;
                String string2 = "batch is not sorted";
                throw new IllegalArgumentException(string2.toString());
            }
            this.lastSeenFrom = from;
            if (from * (long)2 < from || to * (long)2 < to) {
                throw new ArithmeticException("from: " + from + ", to: " + to);
            }
            if (closedLeft) {
                this.closedZipper = Zipper.Companion.insert(this.closedZipper, id, from, to, true, closedRight, data);
            } else {
                this.openZipper = Zipper.Companion.insert(this.openZipper, id, from, to, false, closedRight, data);
            }
        }

        @NotNull
        public final IntervalsImpl<T> commit() {
            int n = this.editingContext.getMaxChildren();
            Node node = Zipper.Companion.root(this.openZipper);
            Node node2 = Zipper.Companion.root(this.closedZipper);
            IntMap intMap = this.editingContext.getParentsMap().forked();
            Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"forked(...)");
            return new IntervalsImpl(n, node, node2, (IntMap<Long>)intMap, this.editingContext.getNextId(), this.editingContext.getDropEmpty());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Landel/intervals/Impl$EditingContext;", "", "nextId", "", "maxChildren", "", "dropEmpty", "", "parentsMap", "Lio/lacuna/bifurcan/IntMap;", "(JIZLio/lacuna/bifurcan/IntMap;)V", "getDropEmpty", "()Z", "getMaxChildren", "()I", "getNextId", "()J", "setNextId", "(J)V", "getParentsMap", "()Lio/lacuna/bifurcan/IntMap;", "setParentsMap", "(Lio/lacuna/bifurcan/IntMap;)V", "fleet.andel"})
    public static final class EditingContext {
        private long nextId;
        private final int maxChildren;
        private final boolean dropEmpty;
        @NotNull
        private IntMap<Long> parentsMap;

        public EditingContext(long nextId, int maxChildren, boolean dropEmpty, @NotNull IntMap<Long> parentsMap) {
            Intrinsics.checkNotNullParameter(parentsMap, (String)"parentsMap");
            this.nextId = nextId;
            this.maxChildren = maxChildren;
            this.dropEmpty = dropEmpty;
            this.parentsMap = parentsMap;
        }

        public final long getNextId() {
            return this.nextId;
        }

        public final void setNextId(long l) {
            this.nextId = l;
        }

        public final int getMaxChildren() {
            return this.maxChildren;
        }

        public final boolean getDropEmpty() {
            return this.dropEmpty;
        }

        @NotNull
        public final IntMap<Long> getParentsMap() {
            return this.parentsMap;
        }

        public final void setParentsMap(@NotNull IntMap<Long> intMap) {
            Intrinsics.checkNotNullParameter(intMap, (String)"<set-?>");
            this.parentsMap = intMap;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\nH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landel/intervals/Impl$ForwardIterator;", "T", "Landel/intervals/Impl$AbstractIterator;", "z", "Landel/intervals/Impl$Zipper;", "queryFrom", "", "queryTo", "(Landel/intervals/Impl$Zipper;JJ)V", "next", "", "fleet.andel"})
    public static final class ForwardIterator<T>
    extends AbstractIterator<T> {
        private final long queryFrom;
        private final long queryTo;

        public ForwardIterator(@Nullable Zipper z2, long queryFrom, long queryTo) {
            super(z2);
            this.queryFrom = queryFrom;
            this.queryTo = queryTo;
        }

        @Override
        public boolean next() {
            Zipper next;
            Zipper zipper;
            Zipper zipper2 = this.getZ();
            Intrinsics.checkNotNull((Object)zipper2);
            if (Zipper.Companion.isRoot(zipper2)) {
                zipper = this.getZ();
            } else {
                Zipper zipper3 = this.getZ();
                Intrinsics.checkNotNull((Object)zipper3);
                zipper = Zipper.Companion.skipRight(zipper3);
            }
            Zipper zipper4 = next = zipper;
            this.setZ(zipper4 == null ? null : INSTANCE.nextIntersection(zipper4, this.queryFrom, this.queryTo));
            return this.getZ() != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0007j\b\u0012\u0004\u0012\u00020\u0001`\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0001J\u0006\u0010\u0017\u001a\u00020\u0000R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0007j\b\u0012\u0004\u0012\u00020\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"Landel/intervals/Impl$Node;", "", "ids", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "starts", "ends", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "(Lit/unimi/dsi/fastutil/longs/LongArrayList;Lit/unimi/dsi/fastutil/longs/LongArrayList;Lit/unimi/dsi/fastutil/longs/LongArrayList;Ljava/util/ArrayList;)V", "getChildren", "()Ljava/util/ArrayList;", "getEnds", "()Lit/unimi/dsi/fastutil/longs/LongArrayList;", "getIds", "getStarts", "add", "", "id", "", "start", "end", "child", "copy", "Companion", "fleet.andel"})
    public static final class Node {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LongArrayList ids;
        @NotNull
        private final LongArrayList starts;
        @NotNull
        private final LongArrayList ends;
        @NotNull
        private final ArrayList<Object> children;

        public Node(@NotNull LongArrayList ids, @NotNull LongArrayList starts, @NotNull LongArrayList ends, @NotNull ArrayList<Object> children) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)starts, (String)"starts");
            Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.ids = ids;
            this.starts = starts;
            this.ends = ends;
            this.children = children;
        }

        @NotNull
        public final LongArrayList getIds() {
            return this.ids;
        }

        @NotNull
        public final LongArrayList getStarts() {
            return this.starts;
        }

        @NotNull
        public final LongArrayList getEnds() {
            return this.ends;
        }

        @NotNull
        public final ArrayList<Object> getChildren() {
            return this.children;
        }

        public final void add(long id, long start, long end, @NotNull Object child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            this.ids.add(id);
            this.starts.add(start);
            this.ends.add(end);
            this.children.add(child);
        }

        @NotNull
        public final Node copy() {
            LongArrayList longArrayList = this.ids.clone();
            Intrinsics.checkNotNullExpressionValue((Object)longArrayList, (String)"clone(...)");
            LongArrayList longArrayList2 = this.starts.clone();
            Intrinsics.checkNotNullExpressionValue((Object)longArrayList2, (String)"clone(...)");
            LongArrayList longArrayList3 = this.ends.clone();
            Intrinsics.checkNotNullExpressionValue((Object)longArrayList3, (String)"clone(...)");
            List list = CollectionsKt.toMutableList((Collection)this.children);
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Any>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Any> }");
            return new Node(longArrayList, longArrayList2, longArrayList3, (ArrayList)list);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Landel/intervals/Impl$Node$Companion;", "", "()V", "empty", "Landel/intervals/Impl$Node;", "capacity", "", "fleet.andel"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Node empty(int capacity) {
                return new Node(new LongArrayList(capacity), new LongArrayList(capacity), new LongArrayList(capacity), new ArrayList<Object>(capacity));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b!\u0018\u0000 52\u00020\u0001:\u00015B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0010j\b\u0012\u0004\u0012\u00020\u0001`\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR*\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0010j\b\u0012\u0004\u0012\u00020\u0001`\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010$\"\u0004\b*\u0010&R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010 R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010$\"\u0004\b4\u0010&\u00a8\u00066"}, d2={"Landel/intervals/Impl$Zipper;", "", "rootId", "", "changed", "", "hasRightCousin", "hasLeftCousin", "delta", "parent", "rightCousinStart", "starts", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "ends", "ids", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "editingContext", "Landel/intervals/Impl$EditingContext;", "idx", "", "(JZZZJLandel/intervals/Impl$Zipper;JLit/unimi/dsi/fastutil/longs/LongArrayList;Lit/unimi/dsi/fastutil/longs/LongArrayList;Lit/unimi/dsi/fastutil/longs/LongArrayList;Ljava/util/ArrayList;Landel/intervals/Impl$EditingContext;I)V", "getChanged", "()Z", "setChanged", "(Z)V", "getChildren", "()Ljava/util/ArrayList;", "setChildren", "(Ljava/util/ArrayList;)V", "getDelta", "()J", "getEditingContext", "()Landel/intervals/Impl$EditingContext;", "getEnds", "()Lit/unimi/dsi/fastutil/longs/LongArrayList;", "setEnds", "(Lit/unimi/dsi/fastutil/longs/LongArrayList;)V", "getHasLeftCousin", "getHasRightCousin", "getIds", "setIds", "getIdx", "()I", "setIdx", "(I)V", "getParent", "()Landel/intervals/Impl$Zipper;", "getRightCousinStart", "getRootId", "getStarts", "setStarts", "Companion", "fleet.andel"})
    public static final class Zipper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long rootId;
        private boolean changed;
        private final boolean hasRightCousin;
        private final boolean hasLeftCousin;
        private final long delta;
        @Nullable
        private final Zipper parent;
        private final long rightCousinStart;
        @NotNull
        private LongArrayList starts;
        @NotNull
        private LongArrayList ends;
        @NotNull
        private LongArrayList ids;
        @NotNull
        private ArrayList<Object> children;
        @Nullable
        private final EditingContext editingContext;
        private int idx;
        @NotNull
        private static final LongArrayList ROOT_ENDS;
        @NotNull
        private static final LongArrayList ROOT_STARTS;
        @NotNull
        private static final LongArrayList OPEN_ROOT_IDS;
        @NotNull
        private static final LongArrayList CLOSED_ROOT_IDS;

        public Zipper(long rootId, boolean changed, boolean hasRightCousin, boolean hasLeftCousin, long delta, @Nullable Zipper parent, long rightCousinStart, @NotNull LongArrayList starts, @NotNull LongArrayList ends, @NotNull LongArrayList ids, @NotNull ArrayList<Object> children, @Nullable EditingContext editingContext, int idx) {
            Intrinsics.checkNotNullParameter((Object)starts, (String)"starts");
            Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.rootId = rootId;
            this.changed = changed;
            this.hasRightCousin = hasRightCousin;
            this.hasLeftCousin = hasLeftCousin;
            this.delta = delta;
            this.parent = parent;
            this.rightCousinStart = rightCousinStart;
            this.starts = starts;
            this.ends = ends;
            this.ids = ids;
            this.children = children;
            this.editingContext = editingContext;
            this.idx = idx;
        }

        public final long getRootId() {
            return this.rootId;
        }

        public final boolean getChanged() {
            return this.changed;
        }

        public final void setChanged(boolean bl) {
            this.changed = bl;
        }

        public final boolean getHasRightCousin() {
            return this.hasRightCousin;
        }

        public final boolean getHasLeftCousin() {
            return this.hasLeftCousin;
        }

        public final long getDelta() {
            return this.delta;
        }

        @Nullable
        public final Zipper getParent() {
            return this.parent;
        }

        public final long getRightCousinStart() {
            return this.rightCousinStart;
        }

        @NotNull
        public final LongArrayList getStarts() {
            return this.starts;
        }

        public final void setStarts(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.starts = longArrayList;
        }

        @NotNull
        public final LongArrayList getEnds() {
            return this.ends;
        }

        public final void setEnds(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.ends = longArrayList;
        }

        @NotNull
        public final LongArrayList getIds() {
            return this.ids;
        }

        public final void setIds(@NotNull LongArrayList longArrayList) {
            Intrinsics.checkNotNullParameter((Object)longArrayList, (String)"<set-?>");
            this.ids = longArrayList;
        }

        @NotNull
        public final ArrayList<Object> getChildren() {
            return this.children;
        }

        public final void setChildren(@NotNull ArrayList<Object> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.children = arrayList;
        }

        @Nullable
        public final EditingContext getEditingContext() {
            return this.editingContext;
        }

        public final int getIdx() {
            return this.idx;
        }

        public final void setIdx(int n) {
            this.idx = n;
        }

        static {
            long[] lArray = new long[]{Long.MAX_VALUE};
            ROOT_ENDS = new LongArrayList(lArray);
            lArray = new long[]{0L};
            ROOT_STARTS = new LongArrayList(lArray);
            lArray = new long[]{-1L};
            OPEN_ROOT_IDS = new LongArrayList(lArray);
            lArray = new long[]{-2L};
            CLOSED_ROOT_IDS = new LongArrayList(lArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0018\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0019\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tJ\u001a\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\tJE\u0010 \u001a\u00020\t\"\b\b\u0000\u0010\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u0011\u00a2\u0006\u0002\u0010$JM\u0010 \u001a\u00020\t\"\b\b\u0000\u0010\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u0011\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010)\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010+\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u001e\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u001cJ\u0010\u00100\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u00101\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u00102\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u00103\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landel/intervals/Impl$Zipper$Companion;", "", "()V", "CLOSED_ROOT_IDS", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "OPEN_ROOT_IDS", "ROOT_ENDS", "ROOT_STARTS", "create", "Landel/intervals/Impl$Zipper;", "root", "Landel/intervals/Impl$Node;", "editingContext", "Landel/intervals/Impl$EditingContext;", "rootIsOpen", "", "data", "T", "z", "(Landel/intervals/Impl$Zipper;)Ljava/lang/Object;", "down", "idx", "", "downLeft", "downRight", "findInsertionPoint", "ss", "o", "", "from", "hasNext", "id", "insert", "to", "closedLeft", "closedRight", "(Landel/intervals/Impl$Zipper;JJZZLjava/lang/Object;)Landel/intervals/Impl$Zipper;", "(Landel/intervals/Impl$Zipper;JJJZZLjava/lang/Object;)Landel/intervals/Impl$Zipper;", "isBranch", "isRoot", "left", "next", "node", "remove", "replace", "p", "n", "delta", "right", "skipLeft", "skipRight", "up", "fleet.andel"})
        @SourceDebugExtension(value={"SMAP\nImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Impl.kt\nandel/intervals/Impl$Zipper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1011:1\n1#2:1012\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Zipper create(@NotNull Node root, @Nullable EditingContext editingContext, boolean rootIsOpen) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                long l = rootIsOpen ? -1L : -2L;
                LongArrayList longArrayList = ROOT_STARTS;
                LongArrayList longArrayList2 = ROOT_ENDS;
                LongArrayList longArrayList3 = rootIsOpen ? OPEN_ROOT_IDS : CLOSED_ROOT_IDS;
                Object[] objectArray = new Object[]{root};
                ArrayList arrayList = CollectionsKt.arrayListOf((Object[])objectArray);
                return new Zipper(l, false, false, false, 0L, null, Long.MAX_VALUE, longArrayList, longArrayList2, longArrayList3, arrayList, editingContext, 0);
            }

            public final long id(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return z2.getIds().getLong(z2.getIdx());
            }

            public final long from(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                long from = z2.getDelta() + z2.getStarts().getLong(z2.getIdx());
                return from / (long)2 + Math.max(0L, from % (long)2);
            }

            public final long to(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return (z2.getDelta() + z2.getEnds().getLong(z2.getIdx())) / (long)2;
            }

            public final <T> T data(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return (T)z2.getChildren().get(z2.getIdx());
            }

            public final boolean isRoot(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return z2.getParent() == null;
            }

            public final boolean isBranch(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                return z2.getChildren().size() > 0 && z2.getChildren().get(0) instanceof Node;
            }

            @NotNull
            public final Node node(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Object object = z2.getChildren().get(z2.getIdx());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                return (Node)object;
            }

            private final Zipper down(Zipper z2, int idx) {
                long rightCousinStart;
                Object object = z2.getChildren().get(z2.getIdx());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                Node child = (Node)object;
                if (!(0 <= idx && idx < child.getChildren().size())) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                boolean hasRightCousin = z2.getHasRightCousin() || z2.getIdx() < z2.getChildren().size() - 1;
                long l = hasRightCousin ? (z2.getIdx() + 1 < z2.getStarts().size() ? z2.getStarts().getLong(z2.getIdx() + 1) : z2.getRightCousinStart()) - z2.getStarts().getLong(z2.getIdx()) : (rightCousinStart = Long.MAX_VALUE);
                if (!(rightCousinStart >= 0L)) {
                    boolean bl = false;
                    String string3 = "rightCousinStart:" + rightCousinStart;
                    throw new IllegalArgumentException(string3.toString());
                }
                LongArrayList longArrayList = child.getStarts();
                LongArrayList longArrayList2 = child.getEnds();
                LongArrayList longArrayList3 = child.getIds();
                long l2 = z2.getDelta() + z2.getStarts().getLong(z2.getIdx());
                boolean bl = z2.getHasLeftCousin() || z2.getIdx() > 0;
                ArrayList<Object> arrayList = child.getChildren();
                EditingContext editingContext = z2.getEditingContext();
                return new Zipper(0L, false, hasRightCousin, bl, l2, z2, rightCousinStart, longArrayList, longArrayList2, longArrayList3, arrayList, editingContext, idx);
            }

            @Nullable
            public final Zipper downLeft(@NotNull Zipper z2) {
                Node child;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (this.isBranch(z2)) {
                    Object object = z2.getChildren().get(z2.getIdx());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                    child = (Node)object;
                } else {
                    throw new IllegalArgumentException();
                }
                return child.getChildren().size() == 0 ? null : this.down(z2, 0);
            }

            @Nullable
            public final Zipper downRight(@NotNull Zipper z2) {
                Node child;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (this.isBranch(z2)) {
                    Object object = z2.getChildren().get(z2.getIdx());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                    child = (Node)object;
                } else {
                    throw new IllegalArgumentException();
                }
                return child.getChildren().size() == 0 ? null : this.down(z2, child.getChildren().size() - 1);
            }

            @NotNull
            public final Zipper replace(@NotNull Zipper p, @NotNull Node n, long delta) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                if (!p.getChanged()) {
                    LongArrayList longArrayList = p.getIds().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)longArrayList, (String)"clone(...)");
                    p.setIds(longArrayList);
                    LongArrayList longArrayList2 = p.getStarts().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)longArrayList2, (String)"clone(...)");
                    p.setStarts(longArrayList2);
                    LongArrayList longArrayList3 = p.getEnds().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)longArrayList3, (String)"clone(...)");
                    p.setEnds(longArrayList3);
                    p.setChildren(new ArrayList<Object>((Collection)p.getChildren()));
                }
                p.getChildren().set(p.getIdx(), n);
                long newStart = p.getStarts().getLong(p.getIdx()) + delta;
                p.getStarts().set(p.getIdx(), newStart);
                p.getEnds().set(p.getIdx(), newStart + INSTANCE.max(n.getEnds()));
                p.setChanged(true);
                return p;
            }

            @Nullable
            public final Zipper left(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (z2.getIdx() - 1 >= 0) {
                    z2.setIdx(z2.getIdx() - 1);
                    zipper = z2;
                } else {
                    zipper = null;
                }
                return zipper;
            }

            @Nullable
            public final Zipper right(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (z2.getIdx() + 1 < z2.getChildren().size()) {
                    z2.setIdx(z2.getIdx() + 1);
                    zipper = z2;
                } else {
                    zipper = null;
                }
                return zipper;
            }

            @Nullable
            public final Zipper skipRight(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper right = this.right(z2);
                Zipper zipper = right;
                if (zipper == null) {
                    if (z2.getHasRightCousin()) {
                        Zipper zipper2 = this.up(z2);
                        Intrinsics.checkNotNull((Object)zipper2);
                        zipper = this.skipRight(zipper2);
                    } else {
                        zipper = null;
                    }
                }
                return zipper;
            }

            @Nullable
            public final Zipper skipLeft(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper left = this.left(z2);
                Zipper zipper = left;
                if (zipper == null) {
                    if (z2.getHasLeftCousin()) {
                        Zipper zipper2 = this.up(z2);
                        Intrinsics.checkNotNull((Object)zipper2);
                        zipper = this.skipLeft(zipper2);
                    } else {
                        zipper = null;
                    }
                }
                return zipper;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean hasNext(@Nullable Zipper z2) {
                Zipper zipper = z2;
                Intrinsics.checkNotNull((Object)zipper);
                if (zipper.getIdx() + 1 < z2.getChildren().size()) return true;
                if (z2.getHasRightCousin()) return true;
                if (!this.isBranch(z2)) return false;
                Object object = z2.getChildren().get(z2.getIdx());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type andel.intervals.Impl.Node");
                if (((Node)object).getChildren().size() <= 0) return false;
                return true;
            }

            @NotNull
            public final Zipper next(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper z3 = z2;
                if (!this.hasNext(z3)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                do {
                    if (this.isBranch(z3)) {
                        Zipper zipper2 = this.downLeft(z3);
                        zipper = zipper2;
                        Intrinsics.checkNotNull((Object)zipper2);
                        continue;
                    }
                    Zipper zipper3 = this.skipRight(z3);
                    zipper = zipper3;
                    Intrinsics.checkNotNull((Object)zipper3);
                } while (this.isBranch(z3 = zipper));
                return z3;
            }

            @NotNull
            public final Zipper remove(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (!z2.getChanged()) {
                    LongArrayList longArrayList = z2.getIds().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)longArrayList, (String)"clone(...)");
                    z2.setIds(longArrayList);
                    LongArrayList longArrayList2 = z2.getStarts().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)longArrayList2, (String)"clone(...)");
                    z2.setStarts(longArrayList2);
                    LongArrayList longArrayList3 = z2.getEnds().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)longArrayList3, (String)"clone(...)");
                    z2.setEnds(longArrayList3);
                    z2.setChildren(new ArrayList<Object>((Collection)z2.getChildren()));
                }
                z2.setChanged(true);
                z2.getIds().removeLong(z2.getIdx());
                z2.getStarts().removeLong(z2.getIdx());
                z2.getEnds().removeLong(z2.getIdx());
                z2.getChildren().remove(z2.getIdx());
                int n = z2.getIdx();
                z2.setIdx(n + -1);
                return z2;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Zipper up(@NotNull Zipper z2) {
                Zipper zipper;
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                if (z2.getChanged()) {
                    void var2_2;
                    Zipper p = z2.getParent();
                    Node n = new Node(z2.getIds(), z2.getStarts(), z2.getEnds(), z2.getChildren());
                    Zipper zipper2 = p;
                    Intrinsics.checkNotNull((Object)zipper2);
                    long delta = zipper2.getParent() == null ? 0L : INSTANCE.normalize(n);
                    n = INSTANCE.balanceChildren(z2.getEditingContext(), n);
                    this.replace(p, n, delta);
                    zipper = var2_2;
                } else {
                    zipper = z2.getParent();
                }
                return zipper;
            }

            @NotNull
            public final Node root(@NotNull Zipper z2) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Zipper z3 = z2;
                while (!this.isRoot(z3)) {
                    Intrinsics.checkNotNull((Object)this.up(z3));
                }
                return INSTANCE.shrinkTree(z3.getEditingContext(), z3.getRootId(), INSTANCE.growTree(z3.getEditingContext(), z3.getRootId(), this.node(z3)));
            }

            private final int findInsertionPoint(LongArrayList ss, long o) {
                int i = 0;
                while (true) {
                    LongArrayList longArrayList = ss;
                    Intrinsics.checkNotNull((Object)longArrayList);
                    if (i >= longArrayList.size() || ss.getLong(i) > o) break;
                    ++i;
                }
                return i;
            }

            @NotNull
            public final <T> Zipper insert(@NotNull Zipper z2, long from, long to, boolean closedLeft, boolean closedRight, @NotNull T data) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                EditingContext editingContext = z2.getEditingContext();
                Intrinsics.checkNotNull((Object)editingContext);
                EditingContext editingContext2 = editingContext;
                editingContext2.setNextId(editingContext2.getNextId() + -1L);
                return this.insert(z2, editingContext2.getNextId(), from, to, closedLeft, closedRight, data);
            }

            @NotNull
            public final <T> Zipper insert(@NotNull Zipper z2, long id, long from, long to, boolean closedLeft, boolean closedRight, @NotNull T data) {
                Intrinsics.checkNotNullParameter((Object)z2, (String)"z");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Zipper z3 = z2;
                long from2 = from;
                long to2 = to;
                from2 = from2 * (long)2 - (long)(closedLeft ? 1 : 0);
                to2 = to2 * (long)2 + (long)(closedRight ? 1 : 0);
                int retries = 0;
                while (true) {
                    if (!(++retries < 1000)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    Zipper zipper = z3;
                    Intrinsics.checkNotNull((Object)zipper);
                    if (from2 - zipper.getDelta() <= z3.getRightCousinStart()) {
                        int insertIdx = this.findInsertionPoint(z3.getStarts(), from2 - z3.getDelta());
                        if (this.isBranch(z3)) {
                            z3.setIdx(Math.max(0, insertIdx - 1));
                            Zipper down = this.downLeft(z3);
                            if (down == null) {
                                if (!this.isRoot(z3)) {
                                    String string3 = "Failed requirement.";
                                    throw new IllegalArgumentException(string3.toString());
                                }
                                EditingContext editingContext = z3.getEditingContext();
                                Intrinsics.checkNotNull((Object)editingContext);
                                Node newRoot = Node.Companion.empty(editingContext.getMaxChildren());
                                newRoot.add(id, from2, to2, data);
                                EditingContext editingContext2 = z3.getEditingContext();
                                Intrinsics.checkNotNull((Object)editingContext2);
                                EditingContext editingContext3 = z3.getEditingContext();
                                Intrinsics.checkNotNull((Object)editingContext3);
                                IntMap intMap = editingContext3.getParentsMap().put(id, (Object)z3.getRootId());
                                Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"put(...)");
                                editingContext2.setParentsMap((IntMap<Long>)intMap);
                                return this.replace(z3, newRoot, 0L);
                            }
                            z3 = down;
                            continue;
                        }
                        if (!z3.getChanged()) {
                            LongArrayList longArrayList = z3.getIds().clone();
                            Intrinsics.checkNotNullExpressionValue((Object)longArrayList, (String)"clone(...)");
                            z3.setIds(longArrayList);
                            LongArrayList longArrayList2 = z3.getStarts().clone();
                            Intrinsics.checkNotNullExpressionValue((Object)longArrayList2, (String)"clone(...)");
                            z3.setStarts(longArrayList2);
                            LongArrayList longArrayList3 = z3.getEnds().clone();
                            Intrinsics.checkNotNullExpressionValue((Object)longArrayList3, (String)"clone(...)");
                            z3.setEnds(longArrayList3);
                            z3.setChildren(new ArrayList<Object>((Collection)z3.getChildren()));
                        }
                        EditingContext editingContext = z3.getEditingContext();
                        Intrinsics.checkNotNull((Object)editingContext);
                        if (!(editingContext.getParentsMap().get(id, null) == null)) {
                            boolean bl = false;
                            String string4 = "id is not unique:" + id;
                            throw new IllegalArgumentException(string4.toString());
                        }
                        z3.getStarts().add(insertIdx, from2 - z3.getDelta());
                        z3.getEnds().add(insertIdx, to2 - z3.getDelta());
                        z3.getIds().add(insertIdx, id);
                        z3.getChildren().add(insertIdx, data);
                        Zipper zipper2 = z3.getParent();
                        Intrinsics.checkNotNull((Object)zipper2);
                        LongArrayList longArrayList = zipper2.getIds();
                        Zipper zipper3 = z3.getParent();
                        Intrinsics.checkNotNull((Object)zipper3);
                        long currentId = longArrayList.getLong(zipper3.getIdx());
                        EditingContext editingContext4 = z3.getEditingContext();
                        Intrinsics.checkNotNull((Object)editingContext4);
                        EditingContext editingContext5 = z3.getEditingContext();
                        Intrinsics.checkNotNull((Object)editingContext5);
                        IntMap intMap = editingContext5.getParentsMap().put(id, (Object)currentId);
                        Intrinsics.checkNotNullExpressionValue((Object)intMap, (String)"put(...)");
                        editingContext4.setParentsMap((IntMap<Long>)intMap);
                        z3.setChanged(true);
                        z3.setIdx(insertIdx <= z3.getIdx() ? z3.getIdx() + 1 : z3.getIdx());
                        return z3;
                    }
                    z3 = this.up(z3);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

