/*
 * Decompiled with CFR 0.152.
 */
package andel.editor;

import andel.AnchorStorage;
import andel.EditLog;
import andel.editor.AnchorId;
import andel.editor.AnchorLifetime;
import andel.editor.CaretId;
import andel.editor.CaretPosition;
import andel.editor.DocumentComponent;
import andel.editor.DocumentMeta;
import andel.editor.MultiCaretData;
import andel.editor.MultiCaretDataKt;
import andel.editor.MutableDocument;
import andel.editor.PasswordComponent;
import andel.editor.RangeMarkerId;
import andel.editor.SimpleDocumentState;
import andel.editor.SimpleEditorKt;
import andel.editor.SimpleEditorLayoutComponentKey;
import andel.editor.SimpleMultiCaretState;
import andel.editor.SimpleMutableEditor;
import andel.editor.SimpleMutableMultiCaret;
import andel.operation.Operation;
import andel.operation.Sticky;
import andel.text.Text;
import andel.text.TextRange;
import andel.undo.DocumentUndoGroup;
import andel.undo.UndoGroupAttributes;
import andel.undo.UndoGroupKey;
import andel.undo.UndoKt;
import andel.undo.UndoLogData;
import fleet.util.UID;
import fleet.util.openmap.Key;
import fleet.util.openmap.MutableBoundedOpenMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\fJ:\u00100\u001a\u00020.2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000b2\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u000b2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000bH\u0016J0\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u000b2\u0012\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0\u000b0>J \u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0016J \u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020$2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010H\u001a\u00020.2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u000202H\u0016J\u0010\u0010M\u001a\u00020.2\u0006\u0010N\u001a\u000206H\u0016J\u0017\u0010O\u001a\u0004\u0018\u00010$2\u0006\u0010L\u001a\u000202H\u0016\u00a2\u0006\u0002\u0010PJ\u0012\u0010Q\u001a\u0004\u0018\u0001082\u0006\u0010N\u001a\u000206H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0006j\b\u0012\u0004\u0012\u00020\u0016`\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u0004R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R$\u0010'\u001a\u00020(2\u0006\u0010'\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006R"}, d2={"Landel/editor/SimpleMutableDocument;", "Landel/editor/MutableDocument;", "state", "Landel/editor/SimpleDocumentState;", "(Landel/editor/SimpleDocumentState;)V", "components", "Lfleet/util/openmap/MutableBoundedOpenMap;", "Landel/editor/DocumentComponent;", "getComponents", "()Lfleet/util/openmap/MutableBoundedOpenMap;", "editors", "", "Landel/editor/SimpleMutableEditor;", "getEditors", "()Ljava/util/List;", "edits", "Landel/EditLog;", "getEdits", "()Landel/EditLog;", "intermediateAnchorStorage", "Landel/AnchorStorage;", "meta", "Landel/editor/DocumentMeta;", "", "Lfleet/util/openmap/MutableOpenMap;", "getMeta", "mutableEditors", "", "getState$fleet_andel", "()Landel/editor/SimpleDocumentState;", "setState$fleet_andel", "text", "Landel/text/Text;", "getText", "()Landel/text/Text;", "timestamp", "", "getTimestamp", "()J", "undoLog", "Landel/undo/UndoLogData;", "getUndoLog", "()Landel/undo/UndoLogData;", "setUndoLog", "(Landel/undo/UndoLogData;)V", "addEditor", "", "editor", "batchUpdateAnchors", "anchorIds", "Landel/editor/AnchorId;", "anchorOffsets", "", "rangeIds", "Landel/editor/RangeMarkerId;", "ranges", "Landel/text/TextRange;", "command", "groupKey", "Landel/undo/UndoGroupKey;", "caretsBefore", "Landel/editor/CaretPosition;", "Lkotlin/Function0;", "createAnchor", "offset", "lifetime", "Landel/editor/AnchorLifetime;", "sticky", "Landel/operation/Sticky;", "createRangeMarker", "rangeStart", "rangeEnd", "edit", "operation", "Landel/operation/Operation;", "removeAnchor", "anchorId", "removeRangeMarker", "markerId", "resolveAnchor", "(Landel/editor/AnchorId;)Ljava/lang/Long;", "resolveRangeMarker", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nSimpleEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleEditor.kt\nandel/editor/SimpleMutableDocument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,488:1\n1045#2:489\n*S KotlinDebug\n*F\n+ 1 SimpleEditor.kt\nandel/editor/SimpleMutableDocument\n*L\n359#1:489\n*E\n"})
public final class SimpleMutableDocument
implements MutableDocument {
    @NotNull
    private SimpleDocumentState state;
    @NotNull
    private final List<SimpleMutableEditor> mutableEditors;
    @NotNull
    private AnchorStorage intermediateAnchorStorage;
    @NotNull
    private final MutableBoundedOpenMap<MutableDocument, DocumentComponent> components;
    @NotNull
    private final MutableBoundedOpenMap<DocumentMeta, Object> meta;

    public SimpleMutableDocument(@NotNull SimpleDocumentState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.mutableEditors = new ArrayList();
        this.intermediateAnchorStorage = AnchorStorage.Companion.empty();
        this.components = this.state.getComponents().mutable().persistent().mutable();
        this.meta = MutableBoundedOpenMap.Companion.empty();
    }

    @NotNull
    public final SimpleDocumentState getState$fleet_andel() {
        return this.state;
    }

    public final void setState$fleet_andel(@NotNull SimpleDocumentState simpleDocumentState) {
        Intrinsics.checkNotNullParameter((Object)simpleDocumentState, (String)"<set-?>");
        this.state = simpleDocumentState;
    }

    @NotNull
    public final List<SimpleMutableEditor> getEditors() {
        return this.mutableEditors;
    }

    public final void addEditor(@NotNull SimpleMutableEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.mutableEditors.add(editor);
        this.getComponents().set((Key)SimpleEditorLayoutComponentKey.INSTANCE, (Object)editor.getEditorLayout());
    }

    @Override
    @NotNull
    public Text getText() {
        return this.state.getText();
    }

    @Override
    public long getTimestamp() {
        return this.state.getTimestamp();
    }

    @Override
    @NotNull
    public EditLog getEdits() {
        return this.state.getEdits();
    }

    @NotNull
    public final UndoLogData getUndoLog() {
        return this.state.getUndoLog();
    }

    public final void setUndoLog(@NotNull UndoLogData undoLog) {
        Intrinsics.checkNotNullParameter((Object)undoLog, (String)"undoLog");
        this.state = SimpleDocumentState.copy$default(this.state, null, null, null, undoLog, null, 23, null);
    }

    @NotNull
    public MutableBoundedOpenMap<MutableDocument, DocumentComponent> getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public MutableBoundedOpenMap<DocumentMeta, Object> getMeta() {
        return this.meta;
    }

    @Override
    public void edit(@NotNull Operation operation) {
        Text textAfter;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Text textBefore = this.state.getText();
        Text visibleTextBefore = SimpleEditorKt.visibleText(this.state);
        Text visibleTextAfter = textAfter = this.state.getText().edit(operation);
        Operation visibleOperation = operation;
        Iterable $this$sortedBy$iv = this.getComponents().asMap().values();
        boolean $i$f$sortedBy = false;
        for (DocumentComponent component : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DocumentComponent it = (DocumentComponent)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOrder());
                it = (DocumentComponent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrder()));
            }
        })) {
            component.edit(visibleTextBefore, visibleTextAfter, visibleOperation);
            if (!(component instanceof PasswordComponent)) continue;
            visibleTextAfter = ((PasswordComponent)component).getPasswordText();
            visibleOperation = Operation.Companion.replaceAt$default(Operation.Companion, 0L, textBefore.charSequence().toString(), textAfter.charSequence().toString(), textBefore.charsCount(), false, 16, null);
        }
        this.state = SimpleDocumentState.copy$default(this.state, textAfter, EditLog.trim$default(this.state.getEdits().append(UID.Companion.random(), operation), 0, 0L, 3, null), this.state.getAnchorStorage().edit(textBefore, textAfter, operation), null, null, 24, null);
        this.intermediateAnchorStorage = this.intermediateAnchorStorage.edit(textBefore, textAfter, operation);
        for (SimpleMutableEditor editor : this.getEditors()) {
            MultiCaretData updatedCarets = MultiCaretData.transformOnto$default(editor.getMultiCaret().getState$fleet_andel().getMultiCaretData(), operation, Sticky.LEFT, false, 4, null);
            SimpleMutableMultiCaret simpleMutableMultiCaret = editor.getMultiCaret();
            SimpleMultiCaretState simpleMultiCaretState = editor.getMultiCaret().getState$fleet_andel();
            MultiCaretData multiCaretData = MultiCaretDataKt.mergeCoincidingCarets(updatedCarets);
            CaretId caretId = updatedCarets.getMergedAnchors().get(editor.getMultiCaret().getState$fleet_andel().getPrimaryCaretId());
            if (caretId == null) {
                caretId = editor.getMultiCaret().getState$fleet_andel().getPrimaryCaretId();
            }
            simpleMutableMultiCaret.setState$fleet_andel(SimpleMultiCaretState.copy$default(simpleMultiCaretState, multiCaretData, caretId, null, 4, null));
        }
    }

    public final void command(@NotNull UndoGroupKey groupKey, @NotNull List<CaretPosition> caretsBefore, @NotNull Function0<? extends List<CaretPosition>> command2) {
        Intrinsics.checkNotNullParameter((Object)groupKey, (String)"groupKey");
        Intrinsics.checkNotNullParameter(caretsBefore, (String)"caretsBefore");
        Intrinsics.checkNotNullParameter(command2, (String)"command");
        long idBefore = this.state.getEdits().getTimestamp();
        UndoLogData undoLogBefore = this.state.getUndoLog();
        List caretsAfter = (List)command2.invoke();
        long idAfter = this.state.getEdits().getTimestamp();
        List list = CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((long)idBefore, (long)idAfter)));
        UndoGroupAttributes undoGroupAttributes = groupKey.toAttributes();
        DocumentUndoGroup undoGroup = new DocumentUndoGroup(undoGroupAttributes, idBefore, list, caretsBefore, caretsAfter);
        this.state = SimpleDocumentState.copy$default(this.state, null, null, null, UndoKt.addGroup(undoLogBefore, undoGroup, this.state), null, 23, null);
    }

    @Override
    @NotNull
    public AnchorId createAnchor(long offset, @NotNull AnchorLifetime lifetime, @NotNull Sticky sticky) {
        Intrinsics.checkNotNullParameter((Object)((Object)lifetime), (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)sticky), (String)"sticky");
        AnchorId anchorId = new AnchorId(UID.Companion.random());
        switch (WhenMappings.$EnumSwitchMapping$0[lifetime.ordinal()]) {
            case 1: {
                this.intermediateAnchorStorage = this.intermediateAnchorStorage.addAnchor(anchorId, offset, sticky);
                break;
            }
            case 2: {
                this.state = SimpleDocumentState.copy$default(this.state, null, null, this.state.getAnchorStorage().addAnchor(anchorId, offset, sticky), null, null, 27, null);
            }
        }
        return anchorId;
    }

    @Override
    public void removeAnchor(@NotNull AnchorId anchorId) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        this.intermediateAnchorStorage = this.intermediateAnchorStorage.removeAnchor(anchorId);
        this.state = SimpleDocumentState.copy$default(this.state, null, null, this.state.getAnchorStorage().removeAnchor(anchorId), null, null, 27, null);
    }

    @Override
    @Nullable
    public Long resolveAnchor(@NotNull AnchorId anchorId) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        Long l = this.intermediateAnchorStorage.resolveAnchor(anchorId);
        if (l == null) {
            l = this.state.resolveAnchor(anchorId);
        }
        return l;
    }

    @Override
    @NotNull
    public RangeMarkerId createRangeMarker(long rangeStart, long rangeEnd, @NotNull AnchorLifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)lifetime), (String)"lifetime");
        RangeMarkerId markerId = new RangeMarkerId(UID.Companion.random());
        switch (WhenMappings.$EnumSwitchMapping$0[lifetime.ordinal()]) {
            case 1: {
                this.intermediateAnchorStorage = this.intermediateAnchorStorage.addRangeMarker(markerId, rangeStart, rangeEnd, false, false);
                break;
            }
            case 2: {
                this.state = SimpleDocumentState.copy$default(this.state, null, null, this.state.getAnchorStorage().addRangeMarker(markerId, rangeStart, rangeEnd, false, false), null, null, 27, null);
            }
        }
        return markerId;
    }

    @Override
    public void removeRangeMarker(@NotNull RangeMarkerId markerId) {
        Intrinsics.checkNotNullParameter((Object)markerId, (String)"markerId");
        this.intermediateAnchorStorage = this.intermediateAnchorStorage.removeRangeMarker(markerId);
        this.state = SimpleDocumentState.copy$default(this.state, null, null, this.state.getAnchorStorage().removeRangeMarker(markerId), null, null, 27, null);
    }

    @Override
    @Nullable
    public TextRange resolveRangeMarker(@NotNull RangeMarkerId markerId) {
        Intrinsics.checkNotNullParameter((Object)markerId, (String)"markerId");
        TextRange textRange = this.intermediateAnchorStorage.resolveRangeMarker(markerId);
        if (textRange == null) {
            textRange = this.state.resolveRangeMarker(markerId);
        }
        return textRange;
    }

    @Override
    public void batchUpdateAnchors(@NotNull List<AnchorId> anchorIds, @NotNull long[] anchorOffsets, @NotNull List<RangeMarkerId> rangeIds, @NotNull List<TextRange> ranges) {
        Intrinsics.checkNotNullParameter(anchorIds, (String)"anchorIds");
        Intrinsics.checkNotNullParameter((Object)anchorOffsets, (String)"anchorOffsets");
        Intrinsics.checkNotNullParameter(rangeIds, (String)"rangeIds");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.state = SimpleDocumentState.copy$default(this.state, null, null, this.state.getAnchorStorage().batchUpdate(anchorIds, anchorOffsets, rangeIds, ranges), null, null, 27, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnchorLifetime.values().length];
            try {
                nArray[AnchorLifetime.MUTATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnchorLifetime.DOCUMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

