/*
 * Decompiled with CFR 0.152.
 */
package andel.editor;

import andel.editor.EditorLayout;
import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.intervals.IntervalsQuery;
import andel.lines.Fold;
import andel.lines.Inlay;
import andel.lines.Interline;
import andel.lines.LinesCache;
import andel.lines.LinesCacheKt;
import andel.lines.Postline;
import andel.operation.Operation;
import andel.text.Text;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005H\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005H\u00c6\u0003Jk\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00052\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005H\u00c6\u0001J\u001e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010!\u001a\u00020%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001J \u0010.\u001a\u00020/2\u0016\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\r0201H\u0016R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012\u00a8\u00063"}, d2={"Landel/editor/SimpleEditorLayout;", "Landel/editor/EditorLayout;", "linesCache", "Landel/lines/LinesCache;", "inlays", "Landel/intervals/Intervals;", "", "Landel/lines/Inlay;", "interlines", "Landel/lines/Interline;", "postlines", "Landel/lines/Postline;", "folds", "Landel/lines/Fold;", "(Landel/lines/LinesCache;Landel/intervals/Intervals;Landel/intervals/Intervals;Landel/intervals/Intervals;Landel/intervals/Intervals;)V", "getFolds", "()Landel/intervals/Intervals;", "setFolds", "(Landel/intervals/Intervals;)V", "getInlays", "setInlays", "getInterlines", "setInterlines", "getLinesCache", "()Landel/lines/LinesCache;", "getPostlines", "setPostlines", "component1", "component2", "component3", "component4", "component5", "copy", "edit", "before", "Landel/text/Text;", "after", "Landel/operation/Operation;", "equals", "", "other", "", "hashCode", "", "toString", "", "unfold", "", "affectedFolds", "", "Landel/intervals/Interval;", "fleet.andel"})
public final class SimpleEditorLayout
implements EditorLayout {
    @NotNull
    private final LinesCache linesCache;
    @NotNull
    private Intervals<Long, Inlay> inlays;
    @NotNull
    private Intervals<Long, Interline> interlines;
    @NotNull
    private Intervals<Long, Postline> postlines;
    @NotNull
    private Intervals<Long, Fold> folds;

    public SimpleEditorLayout(@NotNull LinesCache linesCache, @NotNull Intervals<Long, Inlay> inlays, @NotNull Intervals<Long, Interline> interlines, @NotNull Intervals<Long, Postline> postlines, @NotNull Intervals<Long, Fold> folds) {
        Intrinsics.checkNotNullParameter((Object)linesCache, (String)"linesCache");
        Intrinsics.checkNotNullParameter(inlays, (String)"inlays");
        Intrinsics.checkNotNullParameter(interlines, (String)"interlines");
        Intrinsics.checkNotNullParameter(postlines, (String)"postlines");
        Intrinsics.checkNotNullParameter(folds, (String)"folds");
        this.linesCache = linesCache;
        this.inlays = inlays;
        this.interlines = interlines;
        this.postlines = postlines;
        this.folds = folds;
    }

    @Override
    @NotNull
    public LinesCache getLinesCache() {
        return this.linesCache;
    }

    @NotNull
    public Intervals<Long, Inlay> getInlays() {
        return this.inlays;
    }

    public void setInlays(@NotNull Intervals<Long, Inlay> intervals) {
        Intrinsics.checkNotNullParameter(intervals, (String)"<set-?>");
        this.inlays = intervals;
    }

    @NotNull
    public Intervals<Long, Interline> getInterlines() {
        return this.interlines;
    }

    public void setInterlines(@NotNull Intervals<Long, Interline> intervals) {
        Intrinsics.checkNotNullParameter(intervals, (String)"<set-?>");
        this.interlines = intervals;
    }

    @NotNull
    public Intervals<Long, Postline> getPostlines() {
        return this.postlines;
    }

    public void setPostlines(@NotNull Intervals<Long, Postline> intervals) {
        Intrinsics.checkNotNullParameter(intervals, (String)"<set-?>");
        this.postlines = intervals;
    }

    @NotNull
    public Intervals<Long, Fold> getFolds() {
        return this.folds;
    }

    public void setFolds(@NotNull Intervals<Long, Fold> intervals) {
        Intrinsics.checkNotNullParameter(intervals, (String)"<set-?>");
        this.folds = intervals;
    }

    @NotNull
    public final SimpleEditorLayout edit(@NotNull Text before, @NotNull Text after, @NotNull Operation edit) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        Intervals<Long, Inlay> newInlays = this.getInlays().edit(edit);
        Intervals<Long, Interline> newInterlines = this.getInterlines().edit(edit);
        Intervals<Long, Postline> newPostlines = this.getPostlines().edit(edit);
        Intervals<Long, Fold> newFolds = this.getFolds().edit(edit);
        return new SimpleEditorLayout(LinesCacheKt.edit(this.getLinesCache(), before, after, edit, (IntervalsQuery)newInlays, (IntervalsQuery)newInterlines, (IntervalsQuery)newFolds), newInlays, newInterlines, newPostlines, newFolds);
    }

    @Override
    public void unfold(@NotNull List<? extends Interval<?, ? extends Fold>> affectedFolds) {
        Intrinsics.checkNotNullParameter(affectedFolds, (String)"affectedFolds");
    }

    @NotNull
    public final LinesCache component1() {
        return this.linesCache;
    }

    @NotNull
    public final Intervals<Long, Inlay> component2() {
        return this.inlays;
    }

    @NotNull
    public final Intervals<Long, Interline> component3() {
        return this.interlines;
    }

    @NotNull
    public final Intervals<Long, Postline> component4() {
        return this.postlines;
    }

    @NotNull
    public final Intervals<Long, Fold> component5() {
        return this.folds;
    }

    @NotNull
    public final SimpleEditorLayout copy(@NotNull LinesCache linesCache, @NotNull Intervals<Long, Inlay> inlays, @NotNull Intervals<Long, Interline> interlines, @NotNull Intervals<Long, Postline> postlines, @NotNull Intervals<Long, Fold> folds) {
        Intrinsics.checkNotNullParameter((Object)linesCache, (String)"linesCache");
        Intrinsics.checkNotNullParameter(inlays, (String)"inlays");
        Intrinsics.checkNotNullParameter(interlines, (String)"interlines");
        Intrinsics.checkNotNullParameter(postlines, (String)"postlines");
        Intrinsics.checkNotNullParameter(folds, (String)"folds");
        return new SimpleEditorLayout(linesCache, inlays, interlines, postlines, folds);
    }

    public static /* synthetic */ SimpleEditorLayout copy$default(SimpleEditorLayout simpleEditorLayout, LinesCache linesCache, Intervals intervals, Intervals intervals2, Intervals intervals3, Intervals intervals4, int n, Object object) {
        if ((n & 1) != 0) {
            linesCache = simpleEditorLayout.linesCache;
        }
        if ((n & 2) != 0) {
            intervals = simpleEditorLayout.inlays;
        }
        if ((n & 4) != 0) {
            intervals2 = simpleEditorLayout.interlines;
        }
        if ((n & 8) != 0) {
            intervals3 = simpleEditorLayout.postlines;
        }
        if ((n & 0x10) != 0) {
            intervals4 = simpleEditorLayout.folds;
        }
        return simpleEditorLayout.copy(linesCache, intervals, intervals2, intervals3, intervals4);
    }

    @NotNull
    public String toString() {
        return "SimpleEditorLayout(linesCache=" + this.linesCache + ", inlays=" + this.inlays + ", interlines=" + this.interlines + ", postlines=" + this.postlines + ", folds=" + this.folds + ")";
    }

    public int hashCode() {
        int result = this.linesCache.hashCode();
        result = result * 31 + this.inlays.hashCode();
        result = result * 31 + this.interlines.hashCode();
        result = result * 31 + this.postlines.hashCode();
        result = result * 31 + this.folds.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleEditorLayout)) {
            return false;
        }
        SimpleEditorLayout simpleEditorLayout = (SimpleEditorLayout)other;
        if (!Intrinsics.areEqual((Object)this.linesCache, (Object)simpleEditorLayout.linesCache)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inlays, simpleEditorLayout.inlays)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.interlines, simpleEditorLayout.interlines)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.postlines, simpleEditorLayout.postlines)) {
            return false;
        }
        return Intrinsics.areEqual(this.folds, simpleEditorLayout.folds);
    }
}

