/*
 * Decompiled with CFR 0.152.
 */
package fleet.aiCompletion.frontend;

import fleet.aiCompletion.frontend.AiCompletionData;
import fleet.aiCompletion.frontend.AiCompletionUtilsKt;
import fleet.api.FileAddress;
import fleet.frontend.editor.editorconfig.EditorConfigExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigs;
import fleet.util.logging.KLogger;
import fleet.util.openmap.BoundedOpenMap;
import fleet.util.openmap.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a \u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0012\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u001a \u0010\u0012\u001a\u00020\u0013*\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0017\u001a \u0010\u0018\u001a\u00020\u0013*\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0017\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0019"}, d2={"logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "trimSuffix", "", "suffix", "trimMarkdownCodefence", "content", "cleanupAiCompletion", "rawCompletion", "linePrefix", "trimLinePrefix", "longestCommonPrefixSuffix", "", "completion", "isAtCompletablePosition", "", "Lfleet/util/openmap/BoundedOpenMap;", "Lfleet/aiCompletion/frontend/AiCompletionData;", "", "Lfleet/util/openmap/OpenMap;", "isSuitableForMultiline", "fleet.plugins.aiCompletion.frontend"})
@SourceDebugExtension(value={"SMAP\nAiCompletionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiCompletionUtils.kt\nfleet/aiCompletion/frontend/AiCompletionUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,132:1\n209#2,8:133\n183#2,2:150\n6#3,2:141\n6#3,2:143\n6#3,2:145\n6#3,2:148\n1#4:147\n648#5,5:152\n*S KotlinDebug\n*F\n+ 1 AiCompletionUtils.kt\nfleet/aiCompletion/frontend/AiCompletionUtilsKt\n*L\n20#1:133,8\n126#1:150,2\n61#1:141,2\n64#1:143,2\n67#1:145,2\n70#1:148,2\n121#1:152,5\n*E\n"})
public final class AiCompletionUtilsKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    private static final String trimSuffix(String $this$trimSuffix, String suffix) {
        int n;
        String suggestedCompletion;
        block3: {
            suggestedCompletion = $this$trimSuffix;
            String suffixFirstLine = (String)CollectionsKt.getOrNull((List)StringsKt.lines((CharSequence)suffix), (int)1);
            Sequence $this$indexOfFirst$iv = SequencesKt.filter((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)suggestedCompletion), (int)1), (Function1)trimSuffix.matchingLineIndex.1.INSTANCE);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String it = (String)item$iv;
                boolean bl = false;
                String string = suffixFirstLine;
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null))) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int matchingLineIndex2 = n;
        String withoutSuffix = matchingLineIndex2 != -1 ? SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)StringsKt.lineSequence((CharSequence)suggestedCompletion), (int)(matchingLineIndex2 + 1)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : suggestedCompletion;
        return withoutSuffix;
    }

    private static final String trimMarkdownCodefence(String content) {
        ASTNode ast = new MarkdownParser((MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor(false, false, 3, null)).buildMarkdownTreeFromString(content);
        Ref.ObjectRef cleanedUpContent = new Ref.ObjectRef();
        Visitor visitor2 = new Visitor((Ref.ObjectRef<String>)cleanedUpContent, content){
            final /* synthetic */ Ref.ObjectRef<String> $cleanedUpContent;
            final /* synthetic */ String $content;
            {
                this.$cleanedUpContent = $cleanedUpContent;
                this.$content = $content;
            }

            /*
             * WARNING - void declaration
             */
            public void visitNode(ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getType().getName(), (Object)"CODE_FENCE")) {
                    List list;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = node.getChildren();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        ASTNode it = (ASTNode)element$iv$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getType().getName(), (Object)"CODE_FENCE_CONTENT") || Intrinsics.areEqual((Object)it.getType().getName(), (Object)"EOL"))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$dropWhile$iv = (List)destination$iv$iv;
                    boolean $i$f$dropWhile = false;
                    boolean yielding$iv = false;
                    ArrayList<T> list$iv = new ArrayList<T>();
                    for (T item$iv : $this$dropWhile$iv) {
                        if (yielding$iv) {
                            list$iv.add(item$iv);
                            continue;
                        }
                        ASTNode it = (ASTNode)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getType().getName(), (Object)"EOL")) continue;
                        list$iv.add(item$iv);
                        yielding$iv = true;
                    }
                    List $this$dropLastWhile$iv = list$iv;
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            ASTNode it = (ASTNode)iterator$iv.previous();
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getType().getName(), (Object)"EOL")) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List codeFenceContentNode = list;
                    String snippetContent2 = CollectionsKt.joinToString$default((Iterable)codeFenceContentNode, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<ASTNode, CharSequence>(this.$content){
                        final /* synthetic */ String $content;
                        {
                            this.$content = $content;
                            super(1);
                        }

                        public final CharSequence invoke(ASTNode n) {
                            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                            String string = this.$content.substring(n.getStartOffset(), n.getEndOffset());
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            return string;
                        }
                    }), (int)30, null);
                    this.$cleanedUpContent.element = snippetContent2;
                } else if (node instanceof CompositeASTNode) {
                    Iterable $this$forEach$iv = ((CompositeASTNode)node).getChildren();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ASTNode child = (ASTNode)element$iv;
                        boolean bl = false;
                        this.visitNode(child);
                    }
                }
            }
        };
        ASTNodeKt.accept((ASTNode)ast, (Visitor)visitor2);
        String string = (String)cleanedUpContent.element;
        if (string == null) {
            string = content;
        }
        return string;
    }

    @Nullable
    public static final String cleanupAiCompletion(@NotNull String rawCompletion, @NotNull String linePrefix, @NotNull String suffix) {
        KLogger kLogger;
        Intrinsics.checkNotNullParameter((Object)rawCompletion, (String)"rawCompletion");
        Intrinsics.checkNotNullParameter((Object)linePrefix, (String)"linePrefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        KLogger this_$iv = AiCompletionUtilsKt.getLogger();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.trace((Object)("raw completion received:\n" + rawCompletion + "\n"));
        }
        String cleanedUpMarkdown = AiCompletionUtilsKt.trimMarkdownCodefence(rawCompletion);
        if (!Intrinsics.areEqual((Object)cleanedUpMarkdown, (Object)rawCompletion)) {
            KLogger this_$iv2 = AiCompletionUtilsKt.getLogger();
            boolean $i$f$trace2 = false;
            if (this_$iv2.isTraceEnabled()) {
                kLogger = this_$iv2;
                boolean bl = false;
                kLogger.trace((Object)("after markdown cleanup: \n" + cleanedUpMarkdown + "\n"));
            }
        }
        String withTrimmedSuffix = AiCompletionUtilsKt.trimSuffix(cleanedUpMarkdown, suffix);
        KLogger this_$iv3 = AiCompletionUtilsKt.getLogger();
        boolean $i$f$trace3 = false;
        if (this_$iv3.isTraceEnabled()) {
            kLogger = this_$iv3;
            boolean bl = false;
            kLogger.trace((Object)("after trimming suffix:\n" + withTrimmedSuffix + "\n"));
        }
        String it = $i$f$trace3 = withTrimmedSuffix;
        boolean bl = false;
        String isNotBlank = !StringsKt.isBlank((CharSequence)it) ? $i$f$trace3 : null;
        KLogger this_$iv4 = AiCompletionUtilsKt.getLogger();
        boolean $i$f$trace4 = false;
        if (this_$iv4.isTraceEnabled()) {
            kLogger = this_$iv4;
            boolean bl2 = false;
            kLogger.trace((Object)("after filtering blank:\n" + isNotBlank + "\n"));
        }
        return isNotBlank;
    }

    @NotNull
    public static final String trimLinePrefix(@NotNull String $this$trimLinePrefix, @NotNull String linePrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$trimLinePrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)linePrefix, (String)"linePrefix");
        String suggestedCompletion = $this$trimLinePrefix;
        int commonSuffixLength = AiCompletionUtilsKt.longestCommonPrefixSuffix(linePrefix, suggestedCompletion);
        String string = suggestedCompletion.substring(commonSuffixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String withoutPrefix = string;
        return withoutPrefix;
    }

    public static final int longestCommonPrefixSuffix(@NotNull String linePrefix, @NotNull String completion) {
        Intrinsics.checkNotNullParameter((Object)linePrefix, (String)"linePrefix");
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        for (int length = Math.min(linePrefix.length(), completion.length()); 0 < length; --length) {
            if (!Intrinsics.areEqual((Object)StringsKt.takeLast((String)linePrefix, (int)length), (Object)StringsKt.take((String)completion, (int)length))) continue;
            return length;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAtCompletablePosition(@NotNull BoundedOpenMap<AiCompletionData, Object> $this$isAtCompletablePosition) {
        Intrinsics.checkNotNullParameter($this$isAtCompletablePosition, (String)"<this>");
        Object object = $this$isAtCompletablePosition.get((Key)AiCompletionData.DocumentText.INSTANCE);
        Intrinsics.checkNotNull((Object)object);
        String text2 = (String)object;
        Object object2 = $this$isAtCompletablePosition.get((Key)AiCompletionData.DocumentOffset.INSTANCE);
        Intrinsics.checkNotNull((Object)object2);
        int offset = ((Number)object2).intValue();
        Character c = StringsKt.getOrNull((CharSequence)text2, (int)offset);
        if (c == null) return true;
        char nextChar = c.charValue();
        if (Character.isLetterOrDigit(nextChar)) return false;
        if (nextChar == '_') return false;
        if (Intrinsics.areEqual((Object)$this$isAtCompletablePosition.get((Key)AiCompletionData.IsEdge.INSTANCE), (Object)true)) return true;
        if (Intrinsics.areEqual((Object)$this$isAtCompletablePosition.get((Key)AiCompletionData.LeftIsWhitespace.INSTANCE), (Object)true)) return true;
        if (Intrinsics.areEqual((Object)$this$isAtCompletablePosition.get((Key)AiCompletionData.RightIsWhitespace.INSTANCE), (Object)true)) return true;
        String string = (String)$this$isAtCompletablePosition.get((Key)AiCompletionData.Suffix.INSTANCE);
        if (string == null) return false;
        if (((CharSequence)string).length() != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuitableForMultiline(@NotNull BoundedOpenMap<AiCompletionData, Object> $this$isSuitableForMultiline) {
        Object v10;
        String string;
        int currentLineIndent;
        int tabWidth;
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter($this$isSuitableForMultiline, (String)"<this>");
            FileAddress fileAddress = (FileAddress)$this$isSuitableForMultiline.get((Key)AiCompletionData.FileAddress.INSTANCE);
            if (fileAddress == null) {
                return false;
            }
            FileAddress fileAddress2 = fileAddress;
            String string2 = (String)$this$isSuitableForMultiline.get((Key)AiCompletionData.LinePrefix.INSTANCE);
            if (string2 == null) {
                return false;
            }
            String linePrefix = string2;
            String suffix = (String)$this$isSuitableForMultiline.get((Key)AiCompletionData.Suffix.INSTANCE);
            if (!StringsKt.isBlank((CharSequence)linePrefix)) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) {
                return false;
            }
            String string3 = suffix;
            if (string3 != null && (string3 = StringsKt.lineSequence((CharSequence)string3)) != null && (string3 = (String)SequencesKt.firstOrNull((Sequence)string3)) != null) {
                if (!StringsKt.isBlank((CharSequence)string3)) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return false;
            }
            EditorConfigs editorConfigs = (EditorConfigs)$this$isSuitableForMultiline.get((Key)AiCompletionData.EditorConfig.INSTANCE);
            tabWidth = editorConfigs != null ? EditorConfigExtKt.tabWidth((EditorConfigs)editorConfigs, (FileAddress)fileAddress2) : 4;
            currentLineIndent = AiCompletionUtilsKt.isSuitableForMultiline$lineIndentSize(linePrefix, tabWidth);
            String string4 = suffix;
            string = string4;
            if (string4 == null) return true;
            Sequence sequence = StringsKt.lineSequence((CharSequence)string);
            string = sequence;
            if (sequence == null) return true;
            String $this$firstOrNull$iv = string;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl3 = false;
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                if (!bl4) continue;
                v10 = element$iv;
                break block9;
            }
            v10 = null;
        }
        String string5 = v10;
        string = string5;
        if (string5 == null) return true;
        Integer n = AiCompletionUtilsKt.isSuitableForMultiline$lineIndentSize(string, tabWidth);
        Integer nextLineIndent = n;
        if (nextLineIndent == null) return true;
        if (currentLineIndent > nextLineIndent) return true;
        return false;
    }

    private static final int isSuitableForMultiline$lineIndentSize(String $this$isSuitableForMultiline_u24lineIndentSize, int tabWidth) {
        CharSequence charSequence;
        String string;
        int n;
        block2: {
            String $this$takeWhile$iv = $this$isSuitableForMultiline_u24lineIndentSize;
            boolean $i$f$takeWhile = false;
            n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                int n2 = 0;
                Object[] objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\t')};
                if (CollectionsKt.listOf((Object[])objectArray).contains(Character.valueOf(it22))) continue;
                String it22 = $this$takeWhile$iv;
                n2 = 0;
                String string2 = it22.substring(n2, index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block2;
            }
            string = charSequence;
        }
        charSequence = string;
        int n3 = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            int it22 = n = (int)charSequence.charAt(i);
            int n4 = n3;
            boolean bl = false;
            int n5 = it22 == 32 ? 1 : tabWidth;
            n3 = n4 + n5;
        }
        return n3;
    }
}

