/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.pass;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.llvm.ir.Attribute;
import org.llvm.ir.FPPassManager;
import org.llvm.ir.Function;
import org.llvm.ir.PMDataManager;
import org.llvm.ir.PMStack;
import org.llvm.ir.PMTopLevelManager;
import org.llvm.ir.impl.IRPrintingPassesLlvmGlobals;
import org.llvm.pass.Pass;
import org.llvm.pass.PassKind;
import org.llvm.pass.PassManagerType;
import org.llvm.support.raw_ostream;

public abstract class FunctionPass
extends Pass
implements Destructors.ClassWithDestructor {
    public FunctionPass(Class<? extends FunctionPass> pid) {
        super(PassKind.PT_Function, pid);
    }

    @Override
    public Pass createPrinterPass(raw_ostream O, std.string Banner) {
        return IRPrintingPassesLlvmGlobals.createPrintFunctionPass(O, Banner);
    }

    public abstract boolean runOnFunction(Function var1);

    @Override
    public void assignPassManager(PMStack PMS, PassManagerType PreferredType) {
        FPPassManager FPP;
        while (!PMS.empty() && PMS.top().getPassManagerType().getValue() > PassManagerType.PMT_FunctionPassManager.getValue()) {
            PMS.pop();
        }
        if (PMS.top().getPassManagerType() == PassManagerType.PMT_FunctionPassManager) {
            FPP = (FPPassManager)PMS.top();
        } else {
            assert (!PMS.empty()) : "Unable to create Function Pass Manager";
            PMDataManager PMD = PMS.top();
            FPP = new FPPassManager();
            FPP.populateInheritedAnalysis(PMS);
            PMTopLevelManager TPM = PMD.getTopLevelManager();
            TPM.addIndirectPassManager(FPP);
            FPP.assignPassManager(PMS, PMD.getPassManagerType());
            PMS.push(FPP);
        }
        FPP.add(this);
    }

    @Override
    public PassManagerType getPotentialPassManagerType() {
        return PassManagerType.PMT_FunctionPassManager;
    }

    protected boolean skipFunction(Function F) {
        if (!F.getContext().getOptBisect().shouldRunPass((Pass)this, F)) {
            return true;
        }
        return F.hasFnAttribute(Attribute.AttrKind.OptimizeNone);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

