/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.pass;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.llvm.ir.Attribute;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Function;
import org.llvm.ir.PMDataManager;
import org.llvm.ir.PMStack;
import org.llvm.ir.PMTopLevelManager;
import org.llvm.ir.impl.BBPassManager;
import org.llvm.ir.impl.IRPrintingPassesLlvmGlobals;
import org.llvm.pass.Pass;
import org.llvm.pass.PassKind;
import org.llvm.pass.PassManagerType;
import org.llvm.support.raw_ostream;

public abstract class BasicBlockPass
extends Pass
implements Destructors.ClassWithDestructor {
    public BasicBlockPass(Class<? extends BasicBlockPass> pid) {
        super(PassKind.PT_BasicBlock, pid);
    }

    @Override
    public Pass createPrinterPass(raw_ostream O, std.string Banner) {
        return IRPrintingPassesLlvmGlobals.createPrintBasicBlockPass(O, Banner);
    }

    public boolean doInitialization(Function $Prm0) {
        return false;
    }

    public abstract boolean runOnBasicBlock(BasicBlock var1);

    public boolean doFinalization(Function $Prm0) {
        return false;
    }

    @Override
    public void assignPassManager(PMStack PMS, PassManagerType PreferredType) {
        BBPassManager BBP;
        if (!PMS.empty() && PMS.top().getPassManagerType() == PassManagerType.PMT_BasicBlockPassManager) {
            BBP = (BBPassManager)PMS.top();
        } else {
            assert (!PMS.empty()) : "Unable to create BasicBlock Pass Manager";
            PMDataManager PMD = PMS.top();
            BBP = new BBPassManager();
            PMTopLevelManager TPM = PMD.getTopLevelManager();
            TPM.addIndirectPassManager(BBP);
            BBP.assignPassManager(PMS, PreferredType);
            PMS.push(BBP);
        }
        BBP.add(this);
    }

    @Override
    public PassManagerType getPotentialPassManagerType() {
        return PassManagerType.PMT_BasicBlockPassManager;
    }

    protected boolean skipBasicBlock(BasicBlock BB) {
        Function F = BB.getParent$Const();
        if (F == null) {
            return false;
        }
        if (!F.getContext().getOptBisect().shouldRunPass((Pass)this, BB)) {
            return true;
        }
        if (F.hasFnAttribute(Attribute.AttrKind.OptimizeNone)) {
            if (Native.$AddrOf((Object)BB) == Native.$AddrOf((Object)F.getEntryBlock$Const())) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

