/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.java;

import java.util.concurrent.ConcurrentHashMap;
import org.llvm.ir.AddrSpaceCastInst;
import org.llvm.ir.AllocaInst;
import org.llvm.ir.AtomicCmpXchgInst;
import org.llvm.ir.AtomicRMWInst;
import org.llvm.ir.BinaryOperator;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.BlockAddress;
import org.llvm.ir.BranchInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.CastInst;
import org.llvm.ir.CatchReturnInst;
import org.llvm.ir.CatchSwitchInst;
import org.llvm.ir.CleanupReturnInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.ConstantAggregate;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ExtractElementInst;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.FPExtInst;
import org.llvm.ir.FPToSIInst;
import org.llvm.ir.FPToUIInst;
import org.llvm.ir.FPTruncInst;
import org.llvm.ir.FuncletPadInst;
import org.llvm.ir.Function;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.GlobalIndirectSymbol;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.IndirectBrInst;
import org.llvm.ir.InsertElementInst;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.IntToPtrInst;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.LoadInst;
import org.llvm.ir.OperandTraits;
import org.llvm.ir.OperandTraitsAtomicCmpXchgInst;
import org.llvm.ir.OperandTraitsAtomicRMWInst;
import org.llvm.ir.OperandTraitsBinaryOperator;
import org.llvm.ir.OperandTraitsBlockAddress;
import org.llvm.ir.OperandTraitsBranchInst;
import org.llvm.ir.OperandTraitsCallInst;
import org.llvm.ir.OperandTraitsCatchReturnInst;
import org.llvm.ir.OperandTraitsCatchSwitchInst;
import org.llvm.ir.OperandTraitsCleanupReturnInst;
import org.llvm.ir.OperandTraitsCmpInst;
import org.llvm.ir.OperandTraitsConstantAggregate;
import org.llvm.ir.OperandTraitsConstantExpr;
import org.llvm.ir.OperandTraitsExtractElementInst;
import org.llvm.ir.OperandTraitsFuncletPadInst;
import org.llvm.ir.OperandTraitsFunction;
import org.llvm.ir.OperandTraitsGetElementPtrInst;
import org.llvm.ir.OperandTraitsGlobalIndirectSymbol;
import org.llvm.ir.OperandTraitsGlobalVariable;
import org.llvm.ir.OperandTraitsIndirectBrInst;
import org.llvm.ir.OperandTraitsInsertElementInst;
import org.llvm.ir.OperandTraitsInsertValueInst;
import org.llvm.ir.OperandTraitsInvokeInst;
import org.llvm.ir.OperandTraitsLandingPadInst;
import org.llvm.ir.OperandTraitsPHINode;
import org.llvm.ir.OperandTraitsResumeInst;
import org.llvm.ir.OperandTraitsReturnInst;
import org.llvm.ir.OperandTraitsSelectInst;
import org.llvm.ir.OperandTraitsShuffleVectorInst;
import org.llvm.ir.OperandTraitsStoreInst;
import org.llvm.ir.OperandTraitsSwitchInst;
import org.llvm.ir.OperandTraitsUnaryInstruction;
import org.llvm.ir.PHINode;
import org.llvm.ir.PtrToIntInst;
import org.llvm.ir.ResumeInst;
import org.llvm.ir.ReturnInst;
import org.llvm.ir.SExtInst;
import org.llvm.ir.SIToFPInst;
import org.llvm.ir.SelectInst;
import org.llvm.ir.ShuffleVectorInst;
import org.llvm.ir.StoreInst;
import org.llvm.ir.SwitchInst;
import org.llvm.ir.TruncInst;
import org.llvm.ir.UIToFPInst;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.User;
import org.llvm.ir.VAArgInst;
import org.llvm.ir.ZExtInst;
import org.llvm.ir.impl.BinaryConstantExpr;
import org.llvm.ir.impl.CompareConstantExpr;
import org.llvm.ir.impl.ExtractElementConstantExpr;
import org.llvm.ir.impl.ExtractValueConstantExpr;
import org.llvm.ir.impl.GetElementPtrConstantExpr;
import org.llvm.ir.impl.InsertElementConstantExpr;
import org.llvm.ir.impl.OperandTraitsBinaryConstantExpr;
import org.llvm.ir.impl.OperandTraitsCompareConstantExpr;
import org.llvm.ir.impl.OperandTraitsExtractElementConstantExpr;
import org.llvm.ir.impl.OperandTraitsExtractValueConstantExpr;
import org.llvm.ir.impl.OperandTraitsGetElementPtrConstantExpr;
import org.llvm.ir.impl.OperandTraitsInsertElementConstantExpr;
import org.llvm.ir.impl.OperandTraitsSelectConstantExpr;
import org.llvm.ir.impl.OperandTraitsShuffleVectorConstantExpr;
import org.llvm.ir.impl.OperandTraitsUnaryConstantExpr;
import org.llvm.ir.impl.SelectConstantExpr;
import org.llvm.ir.impl.ShuffleVectorConstantExpr;
import org.llvm.ir.impl.UnaryConstantExpr;

public class OperandTraitsRegistry {
    private static final ConcurrentHashMap<Class, OperandTraits> traitsMap = new ConcurrentHashMap();

    public static void register(Class<? extends User> clazz, OperandTraits<? extends User> trait) {
        OperandTraits<? extends User> prev = traitsMap.putIfAbsent(clazz, trait);
        assert (prev == null || prev == trait) : "Two different trait instances registered for " + clazz.getName() + " prev: " + prev + " curr: " + trait;
    }

    public static OperandTraits<User> get(Class<? extends User> clazz) {
        return traitsMap.get(clazz);
    }

    static {
        OperandTraitsRegistry.register(GlobalVariable.class, new OperandTraitsGlobalVariable());
        OperandTraitsRegistry.register(BlockAddress.class, new OperandTraitsBlockAddress());
        OperandTraitsRegistry.register(AtomicCmpXchgInst.class, new OperandTraitsAtomicCmpXchgInst());
        OperandTraitsRegistry.register(AtomicRMWInst.class, new OperandTraitsAtomicRMWInst());
        OperandTraitsRegistry.register(BinaryOperator.class, new OperandTraitsBinaryOperator());
        OperandTraitsRegistry.register(BranchInst.class, new OperandTraitsBranchInst());
        OperandTraitsRegistry.register(CallInst.class, new OperandTraitsCallInst());
        OperandTraitsRegistry.register(CatchReturnInst.class, new OperandTraitsCatchReturnInst());
        OperandTraitsRegistry.register(CatchSwitchInst.class, new OperandTraitsCatchSwitchInst());
        OperandTraitsRegistry.register(CleanupReturnInst.class, new OperandTraitsCleanupReturnInst());
        OperandTraitsRegistry.register(CmpInst.class, new OperandTraitsCmpInst());
        OperandTraitsRegistry.register(ConstantAggregate.class, new OperandTraitsConstantAggregate());
        OperandTraitsRegistry.register(ConstantExpr.class, new OperandTraitsConstantExpr());
        OperandTraitsRegistry.register(ExtractElementInst.class, new OperandTraitsExtractElementInst());
        OperandTraitsRegistry.register(FuncletPadInst.class, new OperandTraitsFuncletPadInst());
        OperandTraitsRegistry.register(Function.class, new OperandTraitsFunction());
        OperandTraitsRegistry.register(GetElementPtrInst.class, new OperandTraitsGetElementPtrInst());
        OperandTraitsRegistry.register(GlobalIndirectSymbol.class, new OperandTraitsGlobalIndirectSymbol());
        OperandTraitsRegistry.register(IndirectBrInst.class, new OperandTraitsIndirectBrInst());
        OperandTraitsRegistry.register(InsertElementInst.class, new OperandTraitsInsertElementInst());
        OperandTraitsRegistry.register(InsertValueInst.class, new OperandTraitsInsertValueInst());
        OperandTraitsRegistry.register(InvokeInst.class, new OperandTraitsInvokeInst());
        OperandTraitsRegistry.register(LandingPadInst.class, new OperandTraitsLandingPadInst());
        OperandTraitsRegistry.register(PHINode.class, new OperandTraitsPHINode());
        OperandTraitsRegistry.register(ResumeInst.class, new OperandTraitsResumeInst());
        OperandTraitsRegistry.register(ReturnInst.class, new OperandTraitsReturnInst());
        OperandTraitsRegistry.register(SelectInst.class, new OperandTraitsSelectInst());
        OperandTraitsRegistry.register(ShuffleVectorInst.class, new OperandTraitsShuffleVectorInst());
        OperandTraitsRegistry.register(StoreInst.class, new OperandTraitsStoreInst());
        OperandTraitsRegistry.register(SwitchInst.class, new OperandTraitsSwitchInst());
        OperandTraitsRegistry.register(UnaryInstruction.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(AllocaInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(CastInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(AddrSpaceCastInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(BitCastInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(FPExtInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(FPToSIInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(FPToUIInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(FPTruncInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(IntToPtrInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(PtrToIntInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(SExtInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(SIToFPInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(TruncInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(UIToFPInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(ZExtInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(ExtractValueInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(LoadInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(VAArgInst.class, new OperandTraitsUnaryInstruction());
        OperandTraitsRegistry.register(BinaryConstantExpr.class, new OperandTraitsBinaryConstantExpr());
        OperandTraitsRegistry.register(CompareConstantExpr.class, new OperandTraitsCompareConstantExpr());
        OperandTraitsRegistry.register(ExtractElementConstantExpr.class, new OperandTraitsExtractElementConstantExpr());
        OperandTraitsRegistry.register(ExtractValueConstantExpr.class, new OperandTraitsExtractValueConstantExpr());
        OperandTraitsRegistry.register(GetElementPtrConstantExpr.class, new OperandTraitsGetElementPtrConstantExpr());
        OperandTraitsRegistry.register(InsertElementConstantExpr.class, new OperandTraitsInsertElementConstantExpr());
        OperandTraitsRegistry.register(SelectConstantExpr.class, new OperandTraitsSelectConstantExpr());
        OperandTraitsRegistry.register(ShuffleVectorConstantExpr.class, new OperandTraitsShuffleVectorConstantExpr());
        OperandTraitsRegistry.register(UnaryConstantExpr.class, new OperandTraitsUnaryConstantExpr());
    }
}

