/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl.gen;

import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.ir.Attribute;
import org.llvm.ir.Function;
import org.llvm.ir.impl.AttributesStatics;
import org.llvm.ir.impl.gen.LessPreciseFPMADAttr;
import org.llvm.ir.impl.gen.NoImplicitFloatAttr;
import org.llvm.ir.impl.gen.NoInfsFPMathAttr;
import org.llvm.ir.impl.gen.NoJumpTablesAttr;
import org.llvm.ir.impl.gen.NoNansFPMathAttr;
import org.llvm.ir.impl.gen.SafeStackAttr;
import org.llvm.ir.impl.gen.SanitizeAddressAttr;
import org.llvm.ir.impl.gen.SanitizeMemoryAttr;
import org.llvm.ir.impl.gen.SanitizeThreadAttr;
import org.llvm.ir.impl.gen.UnsafeFPMathAttr;

public final class AttributesCompatFuncStatics {
    public static boolean hasCompatibleFnAttrs(Function Caller, Function Callee) {
        boolean Ret = true;
        Ret &= AttributesStatics.isEqual(SanitizeAddressAttr.getKind(), Caller, Callee);
        Ret &= AttributesStatics.isEqual(SanitizeThreadAttr.getKind(), Caller, Callee);
        Ret &= AttributesStatics.isEqual(SanitizeMemoryAttr.getKind(), Caller, Callee);
        return Ret &= AttributesStatics.isEqual(SafeStackAttr.getKind(), Caller, Callee);
    }

    public static void mergeFnAttrs(Function Caller, Function Callee) {
        AttributesStatics.adjustCallerSSPLevel(Caller, Callee);
        AttributesStatics.setAND(LessPreciseFPMADAttr.getKind(), Caller, Callee);
        AttributesStatics.setAND(NoInfsFPMathAttr.getKind(), Caller, Callee);
        AttributesStatics.setAND(NoNansFPMathAttr.getKind(), Caller, Callee);
        AttributesStatics.setAND(UnsafeFPMathAttr.getKind(), Caller, Callee);
        AttributesStatics.setOR(NoImplicitFloatAttr.getKind(), Caller, Callee);
        AttributesStatics.setOR(NoJumpTablesAttr.getKind(), Caller, Callee);
    }

    public static Attribute.AttrKind getAttrKindFromName(StringRef AttrName) {
        return (Attribute.AttrKind)((Object)new StringSwitch(AttrName).Case("align", (Object)Attribute.AttrKind.Alignment).Case("allocsize", (Object)Attribute.AttrKind.AllocSize).Case("alwaysinline", (Object)Attribute.AttrKind.AlwaysInline).Case("argmemonly", (Object)Attribute.AttrKind.ArgMemOnly).Case("builtin", (Object)Attribute.AttrKind.Builtin).Case("byval", (Object)Attribute.AttrKind.ByVal).Case("cold", (Object)Attribute.AttrKind.Cold).Case("convergent", (Object)Attribute.AttrKind.Convergent).Case("dereferenceable", (Object)Attribute.AttrKind.Dereferenceable).Case("dereferenceable_or_null", (Object)Attribute.AttrKind.DereferenceableOrNull).Case("inalloca", (Object)Attribute.AttrKind.InAlloca).Case("inreg", (Object)Attribute.AttrKind.InReg).Case("inaccessiblememonly", (Object)Attribute.AttrKind.InaccessibleMemOnly).Case("inaccessiblemem_or_argmemonly", (Object)Attribute.AttrKind.InaccessibleMemOrArgMemOnly).Case("inlinehint", (Object)Attribute.AttrKind.InlineHint).Case("jumptable", (Object)Attribute.AttrKind.JumpTable).Case("minsize", (Object)Attribute.AttrKind.MinSize).Case("naked", (Object)Attribute.AttrKind.Naked).Case("nest", (Object)Attribute.AttrKind.Nest).Case("noalias", (Object)Attribute.AttrKind.NoAlias).Case("nobuiltin", (Object)Attribute.AttrKind.NoBuiltin).Case("nocapture", (Object)Attribute.AttrKind.NoCapture).Case("noduplicate", (Object)Attribute.AttrKind.NoDuplicate).Case("noimplicitfloat", (Object)Attribute.AttrKind.NoImplicitFloat).Case("noinline", (Object)Attribute.AttrKind.NoInline).Case("norecurse", (Object)Attribute.AttrKind.NoRecurse).Case("noredzone", (Object)Attribute.AttrKind.NoRedZone).Case("noreturn", (Object)Attribute.AttrKind.NoReturn).Case("nounwind", (Object)Attribute.AttrKind.NoUnwind).Case("nonlazybind", (Object)Attribute.AttrKind.NonLazyBind).Case("nonnull", (Object)Attribute.AttrKind.NonNull).Case("optsize", (Object)Attribute.AttrKind.OptimizeForSize).Case("optnone", (Object)Attribute.AttrKind.OptimizeNone).Case("readnone", (Object)Attribute.AttrKind.ReadNone).Case("readonly", (Object)Attribute.AttrKind.ReadOnly).Case("returned", (Object)Attribute.AttrKind.Returned).Case("returns_twice", (Object)Attribute.AttrKind.ReturnsTwice).Case("signext", (Object)Attribute.AttrKind.SExt).Case("safestack", (Object)Attribute.AttrKind.SafeStack).Case("sanitize_address", (Object)Attribute.AttrKind.SanitizeAddress).Case("sanitize_memory", (Object)Attribute.AttrKind.SanitizeMemory).Case("sanitize_thread", (Object)Attribute.AttrKind.SanitizeThread).Case("alignstack", (Object)Attribute.AttrKind.StackAlignment).Case("ssp", (Object)Attribute.AttrKind.StackProtect).Case("sspreq", (Object)Attribute.AttrKind.StackProtectReq).Case("sspstrong", (Object)Attribute.AttrKind.StackProtectStrong).Case("sret", (Object)Attribute.AttrKind.StructRet).Case("swifterror", (Object)Attribute.AttrKind.SwiftError).Case("swiftself", (Object)Attribute.AttrKind.SwiftSelf).Case("uwtable", (Object)Attribute.AttrKind.UWTable).Case("writeonly", (Object)Attribute.AttrKind.WriteOnly).Case("zeroext", (Object)Attribute.AttrKind.ZExt).Default((Object)Attribute.AttrKind.None));
    }
}

