/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.llvm.adt.Optional;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.ir.Comdat;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.MDTupleTypedArrayWrapper;
import org.llvm.ir.Metadata;
import org.llvm.ir.Module$IR;
import org.llvm.ir.ModuleSlotTracker;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class VerifierSupport
implements Destructors.ClassWithDestructor {
    public raw_ostream OS;
    public Module$IR M;
    public Optional<ModuleSlotTracker> MST;
    public boolean Broken;
    public boolean BrokenDebugInfo;
    public boolean TreatBrokenDebugInfoAsError;

    public VerifierSupport(raw_ostream OS) {
        this.OS = OS;
        this.M = null;
        this.MST = new Optional();
        this.Broken = false;
        this.BrokenDebugInfo = false;
        this.TreatBrokenDebugInfoAsError = true;
    }

    private <NodeTy extends ilist_node<NodeTy>> void Write$T(ilist_iterator<NodeTy> I) {
        this.Write((ilist_node)Native.$AddrOf((Object)((ilist_node)Native.$Deref(I))));
    }

    private void Write(Module$IR M) {
        if (M == null) {
            return;
        }
        ((raw_ostream)Native.$Deref((Object)this.OS)).$out("; ModuleID = '").$out(M.getModuleIdentifier()).$out("'\n");
    }

    private void Write(Value V) {
        if (V == null) {
            return;
        }
        if (IrRTTI.isa_Instruction(V)) {
            V.print((raw_ostream)Native.$Deref((Object)this.OS), (ModuleSlotTracker)this.MST.$star());
            ((raw_ostream)Native.$Deref((Object)this.OS)).$out_char((byte)10);
        } else {
            V.printAsOperand((raw_ostream)Native.$Deref((Object)this.OS), true, (ModuleSlotTracker)this.MST.$star());
            ((raw_ostream)Native.$Deref((Object)this.OS)).$out_char((byte)10);
        }
    }

    private void Write(ImmutableCallSite CS) {
        this.Write((Value)CS.getInstruction());
    }

    private void Write(Metadata MD) {
        if (MD == null) {
            return;
        }
        MD.print((raw_ostream)Native.$Deref((Object)this.OS), (ModuleSlotTracker)this.MST.$star(), this.M);
        ((raw_ostream)Native.$Deref((Object)this.OS)).$out_char((byte)10);
    }

    private <T> void Write$T(MDTupleTypedArrayWrapper<T> MD) {
        this.Write(MD.get());
    }

    private void Write(NamedMDNode NMD) {
        if (NMD == null) {
            return;
        }
        NMD.print((raw_ostream)Native.$Deref((Object)this.OS), (ModuleSlotTracker)this.MST.$star());
        ((raw_ostream)Native.$Deref((Object)this.OS)).$out_char((byte)10);
    }

    private void Write(Type T2) {
        if (T2 == null) {
            return;
        }
        IrLlvmGlobals.$out_raw_ostream_Type(((raw_ostream)Native.$Deref((Object)this.OS)).$out_char((byte)32), (Type)Native.$Deref((Object)T2));
    }

    private void Write(Comdat C2) {
        if (C2 == null) {
            return;
        }
        IrLlvmGlobals.$out_raw_ostream_Comdat$C((raw_ostream)Native.$Deref((Object)this.OS), (Comdat)Native.$Deref((Object)C2));
    }

    private <T> void Write$T(ArrayRef<T> Vs) {
        for (Object V : Vs) {
            this.Write(V);
        }
    }

    private <T1, Ts> void WriteTs(T1 V1, Ts ... Vs) {
        this.Write(V1);
        for (Ts V : Vs) {
            this.WriteTs(V, new Object[0]);
        }
    }

    private <Ts> void WriteTs() {
    }

    public void CheckFailed(Twine Message) {
        if (this.OS != null) {
            llvm.$out_raw_ostream_Twine$C((raw_ostream)((raw_ostream)Native.$Deref((Object)this.OS)), (Twine)Message).$out_char((byte)10);
        }
        this.Broken = true;
    }

    public <T1, Ts> void CheckFailed$T(Twine Message, T1 V1, Ts ... Vs) {
        this.CheckFailed(Message);
        if (this.OS != null) {
            this.WriteTs(V1, Vs);
        }
    }

    public void DebugInfoCheckFailed(Twine Message) {
        if (this.OS != null) {
            llvm.$out_raw_ostream_Twine$C((raw_ostream)((raw_ostream)Native.$Deref((Object)this.OS)), (Twine)Message).$out_char((byte)10);
        }
        this.Broken |= this.TreatBrokenDebugInfoAsError;
        this.BrokenDebugInfo = true;
    }

    public <T1, Ts> void DebugInfoCheckFailed$T(Twine Message, T1 V1, Ts ... Vs) {
        this.DebugInfoCheckFailed(Message);
        if (this.OS != null) {
            this.WriteTs(V1, Vs);
        }
    }

    public void $destroy() {
        this.MST.$destroy();
    }

    private <T> void Write(T t) {
        if (t instanceof Module$IR) {
            this.Write((Module$IR)t);
        } else if (t instanceof Value) {
            this.Write((Value)t);
        } else if (t instanceof ImmutableCallSite) {
            this.Write((ImmutableCallSite)t);
        } else if (t instanceof Metadata) {
            this.Write((Metadata)t);
        } else if (t instanceof NamedMDNode) {
            this.Write((NamedMDNode)t);
        } else if (t instanceof Type) {
            this.Write((Type)t);
        } else if (t instanceof Comdat) {
            this.Write((Comdat)t);
        }
        throw new UnsupportedOperationException("EmptyBody: Write(" + t.getClass().getName() + ")");
    }

    public String toString() {
        return "OS=" + this.OS + ", M=" + this.M + ", MST=" + this.MST + ", Broken=" + this.Broken + ", BrokenDebugInfo=" + this.BrokenDebugInfo + ", TreatBrokenDebugInfoAsError=" + this.TreatBrokenDebugInfoAsError;
    }
}

