/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallPtrSetImpl;
import org.llvm.adt.SmallSetT;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.MapVectorPtrPtr;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.AddrSpaceCastInst;
import org.llvm.ir.AllocaInst;
import org.llvm.ir.Argument;
import org.llvm.ir.ArrayType;
import org.llvm.ir.AtomicCmpXchgInst;
import org.llvm.ir.AtomicRMWInst;
import org.llvm.ir.AttrBuilder;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeFuncs;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BinaryOperator;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.BlockAddress;
import org.llvm.ir.BranchInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.CallSite;
import org.llvm.ir.CallSiteBase;
import org.llvm.ir.CastInst;
import org.llvm.ir.CatchPadInst;
import org.llvm.ir.CatchReturnInst;
import org.llvm.ir.CatchSwitchInst;
import org.llvm.ir.CleanupPadInst;
import org.llvm.ir.CleanupReturnInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Comdat;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantArray;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantRange;
import org.llvm.ir.ConstantTokenNone;
import org.llvm.ir.DIBasicType;
import org.llvm.ir.DICompileUnit;
import org.llvm.ir.DICompositeType;
import org.llvm.ir.DIDerivedType;
import org.llvm.ir.DIEnumerator;
import org.llvm.ir.DIExpression;
import org.llvm.ir.DIFile;
import org.llvm.ir.DIGlobalVariable;
import org.llvm.ir.DIImportedEntity;
import org.llvm.ir.DILexicalBlock;
import org.llvm.ir.DILexicalBlockBase;
import org.llvm.ir.DILexicalBlockFile;
import org.llvm.ir.DILocalScope;
import org.llvm.ir.DILocalVariable;
import org.llvm.ir.DILocation;
import org.llvm.ir.DIMacro;
import org.llvm.ir.DIMacroFile;
import org.llvm.ir.DIModule;
import org.llvm.ir.DINamespace;
import org.llvm.ir.DIObjCProperty;
import org.llvm.ir.DIScope;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.DISubrange;
import org.llvm.ir.DISubroutineType;
import org.llvm.ir.DITemplateParameter;
import org.llvm.ir.DITemplateTypeParameter;
import org.llvm.ir.DITemplateValueParameter;
import org.llvm.ir.DIVariable;
import org.llvm.ir.DbgDeclareInst;
import org.llvm.ir.DbgInfoIntrinsic;
import org.llvm.ir.DbgValueInst;
import org.llvm.ir.DominatorTree;
import org.llvm.ir.ExtractElementInst;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.FCmpInst;
import org.llvm.ir.FPExtInst;
import org.llvm.ir.FPToSIInst;
import org.llvm.ir.FPToUIInst;
import org.llvm.ir.FPTruncInst;
import org.llvm.ir.FenceInst;
import org.llvm.ir.FuncletPadInst;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.GCRelocateInst;
import org.llvm.ir.GenericDINode;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.GraphTraitsFunction$P;
import org.llvm.ir.ICmpInst;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.IndirectBrInst;
import org.llvm.ir.InsertElementInst;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.InstVisitorVoid;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntToPtrInst;
import org.llvm.ir.IntrinsicInst;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.LoadInst;
import org.llvm.ir.LocalAsMetadata;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDOperand;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.Module$IR;
import org.llvm.ir.ModuleSlotTracker;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.OperandBundleUse;
import org.llvm.ir.PHINode;
import org.llvm.ir.PointerType;
import org.llvm.ir.PtrToIntInst;
import org.llvm.ir.ReturnInst;
import org.llvm.ir.SExtInst;
import org.llvm.ir.SIToFPInst;
import org.llvm.ir.SelectInst;
import org.llvm.ir.ShuffleVectorInst;
import org.llvm.ir.StatepointFlags;
import org.llvm.ir.StoreInst;
import org.llvm.ir.StructType;
import org.llvm.ir.SwitchInst;
import org.llvm.ir.SynchronizationScope;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.TruncInst;
import org.llvm.ir.Type;
import org.llvm.ir.UIToFPInst;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.VAArgInst;
import org.llvm.ir.Value;
import org.llvm.ir.ValueAsMetadata;
import org.llvm.ir.VectorType;
import org.llvm.ir.ZExtInst;
import org.llvm.ir.impl.VerifierStatics;
import org.llvm.ir.impl.VerifierSupport;
import org.llvm.ir.intrinsic.IITDescriptor;
import org.llvm.ir.intrinsic.IntrinsicGlobals;
import org.llvm.ir.java.IRFunctionPointers;
import org.llvm.ir.java.IVariableAndExprOwner;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.mdconst.MdconstGlobals;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.AtomicOrdering;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class Verifier
extends VerifierSupport
implements InstVisitorVoid<Verifier>,
Destructors.ClassWithDestructor {
    private LLVMContext Context;
    private DominatorTree DT;
    private SmallPtrSet<Instruction> InstsInThisBlock;
    private SmallPtrSet<Metadata> MDNodes;
    private SmallPtrSet<Metadata> CUVisited;
    private Type LandingPadResultTy;
    private boolean SawFrameEscape;
    private DenseMap<Function, std_pair.pairUIntUInt> FrameEscapeInfo;
    private MapVectorPtrPtr<Instruction, TerminatorInst> SiblingFuncletInfo;
    private SmallPtrSet<Constant> ConstantExprVisited;
    private SmallVector<Function> DeoptimizeDeclarations;
    private SmallPtrSet<Value> GlobalValueVisited;

    private void checkAtomicMemAccessSize(Module$IR M, Type Ty, Instruction I) {
        int Size = Unsigned.$ulong2uint((long)M.getDataLayout().getTypeSizeInBits(Ty));
        if (!Unsigned.$greatereq_uint((int)Size, (int)8)) {
            this.CheckFailed$T(new Twine("atomic memory access' size must be byte-sized"), Ty, I);
            return;
        }
        if ((Size & Size - 1) != 0) {
            this.CheckFailed$T(new Twine("atomic memory access' operand must have a power-of-two size"), Ty, I);
            return;
        }
    }

    private void updateModule(Module$IR NewM) {
        if (this.M == NewM) {
            return;
        }
        this.MST.emplace((Object[])new ModuleSlotTracker[]{new ModuleSlotTracker(NewM)});
        this.M = NewM;
    }

    public Verifier(raw_ostream OS, boolean ShouldTreatBrokenDebugInfoAsError) {
        super(OS);
        this.$InstVisitor();
        this.Context = null;
        this.DT = new DominatorTree();
        this.InstsInThisBlock = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 16);
        this.MDNodes = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 32);
        this.CUVisited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 2);
        this.LandingPadResultTy = null;
        this.SawFrameEscape = false;
        this.FrameEscapeInfo = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), (Object)new std_pair.pairUIntUInt());
        this.SiblingFuncletInfo = new MapVectorPtrPtr((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), (Object)null);
        this.ConstantExprVisited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 32);
        this.DeoptimizeDeclarations = new SmallVector(4, (Object)null);
        this.GlobalValueVisited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 32);
        this.TreatBrokenDebugInfoAsError = ShouldTreatBrokenDebugInfoAsError;
    }

    public boolean hasBrokenDebugInfo() {
        return this.BrokenDebugInfo;
    }

    public boolean verify(Function F) {
        this.updateModule(F.getParent$Const());
        this.Context = (LLVMContext)Native.$AddrOf((Object)this.M.getContext());
        if (!F.empty()) {
            this.DT.recalculate(GraphTraitsFunction$P.$GTraits(), F);
        }
        for (BasicBlock BB : F) {
            if (!BB.empty() && BB.back$Const().isTerminator()) continue;
            if (this.OS != null) {
                ((raw_ostream)Native.$Deref((Object)this.OS)).$out("Basic Block in function '").$out(F.getName()).$out("' does not have terminator!\n");
                BB.printAsOperand((raw_ostream)Native.$Deref((Object)this.OS), true, (ModuleSlotTracker)this.MST.$star());
                ((raw_ostream)Native.$Deref((Object)this.OS)).$out(NativePointer.$LF);
            }
            return false;
        }
        this.Broken = false;
        this.visit_Function(F);
        this.verifySiblingFuncletUnwinds();
        this.InstsInThisBlock.clear();
        this.LandingPadResultTy = null;
        this.SawFrameEscape = false;
        this.SiblingFuncletInfo.clear();
        return !this.Broken;
    }

    public boolean verify(Module$IR M) {
        this.updateModule((Module$IR)Native.$AddrOf((Object)M));
        this.Context = (LLVMContext)Native.$AddrOf((Object)M.getContext());
        this.Broken = false;
        for (Function F : M) {
            if (F.getIntrinsicID() != 45) continue;
            this.DeoptimizeDeclarations.push_back((Object)((Function)Native.$AddrOf((Object)F)));
        }
        this.verifyFrameRecoverIndices();
        for (GlobalVariable GV : M.globals$Const()) {
            this.visitGlobalVariable(GV);
        }
        for (GlobalAlias GA : M.aliases$Const()) {
            this.visitGlobalAlias(GA);
        }
        for (NamedMDNode NMD : M.named_metadata$Const()) {
            this.visitNamedMDNode(NMD);
        }
        for (StringMapEntry SMEC : M.getComdatSymbolTable$Const()) {
            this.visitComdat((Comdat)SMEC.getValue$Const());
        }
        this.visitModuleFlags(M);
        this.visitModuleIdents(M);
        this.verifyCompileUnits();
        this.verifyDeoptimizeCallingConvs();
        return !this.Broken;
    }

    private void visitGlobalValue(GlobalValue GV) {
        GlobalVariable GVar;
        if (GV.isDeclaration() && !GV.hasValidDeclarationLinkage()) {
            this.CheckFailed$T(new Twine("Global is external, but doesn't have external or weak linkage!"), (GlobalValue)Native.$AddrOf((Object)GV), new Object[0]);
            return;
        }
        if (!Unsigned.$lesseq_uint((int)GV.getAlignment(), (int)Value.MaximumAlignment)) {
            this.CheckFailed$T(new Twine("huge alignment values are unsupported"), (GlobalValue)Native.$AddrOf((Object)GV), new Object[0]);
            return;
        }
        if (GV.hasAppendingLinkage() && !IrRTTI.isa_GlobalVariable(GV)) {
            this.CheckFailed$T(new Twine("Only global variables can have appending linkage!"), (GlobalValue)Native.$AddrOf((Object)GV), new Object[0]);
            return;
        }
        if (GV.hasAppendingLinkage() && ((GVar = IrRTTI.dyn_cast_GlobalVariable((Value)Native.$AddrOf((Object)GV))) == null || !GVar.getValueType().isArrayTy())) {
            this.CheckFailed$T(new Twine("Only global arrays can have appending linkage!"), GVar, new Object[0]);
            return;
        }
        if (GV.isDeclarationForLinker() && GV.hasComdat()) {
            this.CheckFailed$T(new Twine("Declaration may not be in a Comdat!"), (GlobalValue)Native.$AddrOf((Object)GV), new Object[0]);
            return;
        }
        VerifierStatics.forEachUser((Value)Native.$AddrOf((Object)GV), this.GlobalValueVisited, (NativeCallback.BoolPredicate<Value>)((NativeCallback.BoolPredicate)V -> {
            Instruction I = IrRTTI.dyn_cast_Instruction(V);
            if (I != null) {
                if (I.getParent$Const() == null || I.getParent$Const().getParent$Const() == null) {
                    this.CheckFailed$T(new Twine("Global is referenced by parentless instruction!"), (GlobalValue)Native.$AddrOf((Object)GV), this.M, I);
                } else if (I.getParent$Const().getParent$Const().getParent$Const() != this.M) {
                    this.CheckFailed$T(new Twine("Global is referenced in a different module!"), (GlobalValue)Native.$AddrOf((Object)GV), this.M, I, I.getParent$Const().getParent$Const(), I.getParent$Const().getParent$Const().getParent$Const());
                }
                return false;
            }
            Function F = IrRTTI.dyn_cast_Function(V);
            if (F != null) {
                if (F.getParent$Const() != this.M) {
                    this.CheckFailed$T(new Twine("Global is used by function in a different module"), (GlobalValue)Native.$AddrOf((Object)GV), this.M, F, F.getParent$Const());
                }
                return false;
            }
            return true;
        }));
    }

    private void visitGlobalVariable(GlobalVariable GV) {
        if (GV.hasInitializer()) {
            if (GV.getInitializer$Const().getType() != GV.getValueType()) {
                this.CheckFailed$T(new Twine("Global variable initializer type does not match global variable type!"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                return;
            }
            if (GV.hasCommonLinkage()) {
                if (!GV.getInitializer$Const().isNullValue()) {
                    this.CheckFailed$T(new Twine("'common' global must have a zero initializer!"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                    return;
                }
                if (GV.isConstant()) {
                    this.CheckFailed$T(new Twine("'common' global may not be marked constant!"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                    return;
                }
                if (GV.hasComdat()) {
                    this.CheckFailed$T(new Twine("'common' global may not be in a Comdat!"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                    return;
                }
            }
        }
        if (GV.hasName() && (llvm.$eq_StringRef((StringRef)GV.getName(), (String)"llvm.global_ctors") || llvm.$eq_StringRef((StringRef)GV.getName(), (String)"llvm.global_dtors"))) {
            if (GV.hasInitializer() && !GV.hasAppendingLinkage()) {
                this.CheckFailed$T(new Twine("invalid linkage for intrinsic global variable"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                return;
            }
            ArrayType ATy = IrRTTI.dyn_cast_ArrayType(GV.getValueType());
            if (ATy != null) {
                Type ETy;
                StructType STy = IrRTTI.dyn_cast_StructType(ATy.getElementType());
                PointerType FuncPtrTy = FunctionType.get(Type.getVoidTy((LLVMContext)Native.$Deref((Object)this.Context)), false).getPointerTo();
                if (STy == null || STy.getNumElements() != 2 && STy.getNumElements() != 3 || !STy.getTypeAtIndex(0).isIntegerTy(32) || STy.getTypeAtIndex(1) != FuncPtrTy) {
                    this.CheckFailed$T(new Twine("wrong type for intrinsic global variable"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                    return;
                }
                if (!(STy.getNumElements() != 3 || (ETy = STy.getTypeAtIndex(2)).isPointerTy() && IrRTTI.cast_PointerType(ETy).getElementType().isIntegerTy(8))) {
                    this.CheckFailed$T(new Twine("wrong type for intrinsic global variable"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                    return;
                }
            }
        }
        if (GV.hasName() && (llvm.$eq_StringRef((StringRef)GV.getName(), (String)"llvm.used") || llvm.$eq_StringRef((StringRef)GV.getName(), (String)"llvm.compiler.used"))) {
            if (GV.hasInitializer() && !GV.hasAppendingLinkage()) {
                this.CheckFailed$T(new Twine("invalid linkage for intrinsic global variable"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                return;
            }
            Type GVType = GV.getValueType();
            ArrayType ATy = IrRTTI.dyn_cast_ArrayType(GVType);
            if (ATy != null) {
                PointerType PTy = IrRTTI.dyn_cast_PointerType(ATy.getElementType());
                if (PTy == null) {
                    this.CheckFailed$T(new Twine("wrong type for intrinsic global variable"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
                    return;
                }
                if (GV.hasInitializer()) {
                    Constant Init = GV.getInitializer$Const();
                    ConstantArray InitArray = IrRTTI.dyn_cast_ConstantArray(Init);
                    if (InitArray == null) {
                        this.CheckFailed$T(new Twine("wrong initalizer for intrinsic global variable"), Init, new Object[0]);
                        return;
                    }
                    for (Use U : InitArray.operands$Const()) {
                        Value Op = U.$Value$P();
                        Value V = Op.stripPointerCastsNoFollowAliases();
                        if (!(IrRTTI.isa_GlobalVariable(V) || IrRTTI.isa_Function(V) || IrRTTI.isa_GlobalAlias(V))) {
                            this.CheckFailed$T(new Twine("invalid llvm.used member"), V, new Object[0]);
                            return;
                        }
                        if (V.hasName()) continue;
                        this.CheckFailed$T(new Twine("members of llvm.used must be named"), V, new Object[0]);
                        return;
                    }
                }
            }
        }
        if (!(!GV.hasDLLImportStorageClass() || GV.isDeclaration() && GV.hasExternalLinkage() || GV.hasAvailableExternallyLinkage())) {
            this.CheckFailed$T(new Twine("Global is marked as dllimport, but not external"), (GlobalVariable)Native.$AddrOf((Object)GV), new Object[0]);
            return;
        }
        if (!GV.hasInitializer()) {
            this.visitGlobalValue(GV);
            return;
        }
        this.visitConstantExprsRecursively(GV.getInitializer$Const());
        this.visitGlobalValue(GV);
    }

    private void visitGlobalAlias(GlobalAlias GA) {
        if (!GlobalAlias.isValidLinkage(GA.getLinkage())) {
            this.CheckFailed$T(new Twine("Alias should have private, internal, linkonce, weak, linkonce_odr, weak_odr, or external linkage!"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
            return;
        }
        Constant Aliasee = GA.getAliasee$Const();
        if (Aliasee == null) {
            this.CheckFailed$T(new Twine("Aliasee cannot be NULL!"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
            return;
        }
        if (GA.getType() != Aliasee.getType()) {
            this.CheckFailed$T(new Twine("Alias and aliasee types should match!"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
            return;
        }
        if (!IrRTTI.isa_GlobalValue(Aliasee) && !IrRTTI.isa_ConstantExpr(Aliasee)) {
            this.CheckFailed$T(new Twine("Aliasee should be either GlobalValue or ConstantExpr"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
            return;
        }
        this.visitAliaseeSubExpr(GA, (Constant)Native.$Deref((Object)Aliasee));
        this.visitGlobalValue(GA);
    }

    private void visitAliaseeSubExpr(GlobalAlias GA, Constant C2) {
        SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
        Visited.insert((Object)((GlobalAlias)Native.$AddrOf((Object)GA)));
        this.visitAliaseeSubExpr((SmallPtrSetImpl<GlobalAlias>)Visited, GA, C2);
    }

    private void visitAliaseeSubExpr(SmallPtrSetImpl<GlobalAlias> Visited, GlobalAlias GA, Constant C2) {
        ConstantExpr CE;
        GlobalValue GV = IrRTTI.dyn_cast_GlobalValue((Value)Native.$AddrOf((Object)C2));
        if (GV != null) {
            if (GV.isDeclarationForLinker()) {
                this.CheckFailed$T(new Twine("Alias must point to a definition"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
                return;
            }
            GlobalAlias GA2 = IrRTTI.dyn_cast_GlobalAlias(GV);
            if (GA2 != null) {
                if (!Visited.insert((Object)GA2).second) {
                    this.CheckFailed$T(new Twine("Aliases cannot form a cycle"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
                    return;
                }
                if (GA2.isInterposable()) {
                    this.CheckFailed$T(new Twine("Alias cannot point to an interposable alias"), (GlobalAlias)Native.$AddrOf((Object)GA), new Object[0]);
                    return;
                }
            } else {
                return;
            }
        }
        if ((CE = IrRTTI.dyn_cast_ConstantExpr((Value)Native.$AddrOf((Object)C2))) != null) {
            this.visitConstantExprsRecursively(CE);
        }
        for (Use U : C2.operands$Const()) {
            Value V = (Value)Native.$AddrOf((Object)((Value)Native.$Deref((Object)U.$Value$P())));
            GlobalAlias GA2 = IrRTTI.dyn_cast_GlobalAlias(V);
            if (GA2 != null) {
                this.visitAliaseeSubExpr(Visited, GA, (Constant)Native.$Deref((Object)GA2.getAliasee$Const()));
                continue;
            }
            Constant C22 = IrRTTI.dyn_cast_Constant(V);
            if (C22 == null) continue;
            this.visitAliaseeSubExpr(Visited, GA, (Constant)Native.$Deref((Object)C22));
        }
    }

    private void visitNamedMDNode(NamedMDNode NMD) {
        for (MDNode MD : NMD.operands$Const()) {
            if (llvm.$eq_StringRef((StringRef)NMD.getName(), (String)"llvm.dbg.cu") && (MD == null || !IrRTTI.isa_DICompileUnit(MD))) {
                this.DebugInfoCheckFailed$T(new Twine("invalid compile unit"), (NamedMDNode)Native.$AddrOf((Object)NMD), MD);
                return;
            }
            if (MD == null) continue;
            this.visitMDNode((MDNode)Native.$Deref((Object)MD));
        }
    }

    private void visitMDNode(MDNode MD) {
        if (!this.MDNodes.insert((Object)((Metadata)Native.$AddrOf((Object)MD))).second) {
            return;
        }
        switch (Metadata.MetadataKind.valueOf(MD.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Invalid MDNode subclass");
            }
            case MDTupleKind: {
                break;
            }
            case DILocationKind: {
                this.visitDILocation(IrRTTI.cast_DILocation(MD));
                break;
            }
            case DIExpressionKind: {
                this.visitDIExpression(IrRTTI.cast_DIExpression(MD));
                break;
            }
            case GenericDINodeKind: {
                this.visitGenericDINode(IrRTTI.cast_GenericDINode(MD));
                break;
            }
            case DISubrangeKind: {
                this.visitDISubrange(IrRTTI.cast_DISubrange(MD));
                break;
            }
            case DIEnumeratorKind: {
                this.visitDIEnumerator(IrRTTI.cast_DIEnumerator(MD));
                break;
            }
            case DIBasicTypeKind: {
                this.visitDIBasicType(IrRTTI.cast_DIBasicType(MD));
                break;
            }
            case DIDerivedTypeKind: {
                this.visitDIDerivedType(IrRTTI.cast_DIDerivedType(MD));
                break;
            }
            case DICompositeTypeKind: {
                this.visitDICompositeType(IrRTTI.cast_DICompositeType(MD));
                break;
            }
            case DISubroutineTypeKind: {
                this.visitDISubroutineType(IrRTTI.cast_DISubroutineType(MD));
                break;
            }
            case DIFileKind: {
                this.visitDIFile(IrRTTI.cast_DIFile(MD));
                break;
            }
            case DICompileUnitKind: {
                this.visitDICompileUnit(IrRTTI.cast_DICompileUnit(MD));
                break;
            }
            case DISubprogramKind: {
                this.visitDISubprogram(IrRTTI.cast_DISubprogram(MD));
                break;
            }
            case DILexicalBlockKind: {
                this.visitDILexicalBlock(IrRTTI.cast_DILexicalBlock(MD));
                break;
            }
            case DILexicalBlockFileKind: {
                this.visitDILexicalBlockFile(IrRTTI.cast_DILexicalBlockFile(MD));
                break;
            }
            case DINamespaceKind: {
                this.visitDINamespace(IrRTTI.cast_DINamespace(MD));
                break;
            }
            case DIModuleKind: {
                this.visitDIModule(IrRTTI.cast_DIModule(MD));
                break;
            }
            case DITemplateTypeParameterKind: {
                this.visitDITemplateTypeParameter(IrRTTI.cast_DITemplateTypeParameter(MD));
                break;
            }
            case DITemplateValueParameterKind: {
                this.visitDITemplateValueParameter(IrRTTI.cast_DITemplateValueParameter(MD));
                break;
            }
            case DIGlobalVariableKind: {
                this.visitDIGlobalVariable(IrRTTI.cast_DIGlobalVariable(MD));
                break;
            }
            case DILocalVariableKind: {
                this.visitDILocalVariable(IrRTTI.cast_DILocalVariable(MD));
                break;
            }
            case DIObjCPropertyKind: {
                this.visitDIObjCProperty(IrRTTI.cast_DIObjCProperty(MD));
                break;
            }
            case DIImportedEntityKind: {
                this.visitDIImportedEntity(IrRTTI.cast_DIImportedEntity(MD));
                break;
            }
            case DIMacroKind: {
                this.visitDIMacro(IrRTTI.cast_DIMacro(MD));
                break;
            }
            case DIMacroFileKind: {
                this.visitDIMacroFile(IrRTTI.cast_DIMacroFile(MD));
            }
        }
        for (MDOperand M : MD.operands()) {
            Metadata Op = M.$Metadata$P();
            if (Op == null) continue;
            if (IrRTTI.isa_LocalAsMetadata(Op)) {
                this.CheckFailed$T(new Twine("Invalid operand for global metadata!"), (MDNode)Native.$AddrOf((Object)MD), Op);
                return;
            }
            MDNode N = IrRTTI.dyn_cast_MDNode(Op);
            if (N != null) {
                this.visitMDNode((MDNode)Native.$Deref((Object)N));
                continue;
            }
            ValueAsMetadata V = IrRTTI.dyn_cast_ValueAsMetadata(Op);
            if (V == null) continue;
            this.visitValueAsMetadata((ValueAsMetadata)Native.$Deref((Object)V), null);
        }
        if (MD.isTemporary()) {
            this.CheckFailed$T(new Twine("Expected no forward declarations!"), (MDNode)Native.$AddrOf((Object)MD), new Object[0]);
            return;
        }
        if (!MD.isResolved()) {
            this.CheckFailed$T(new Twine("All nodes should be resolved!"), (MDNode)Native.$AddrOf((Object)MD), new Object[0]);
            return;
        }
    }

    private void visitMetadataAsValue(MetadataAsValue MDV, Function F) {
        Metadata MD = MDV.getMetadata();
        MDNode N = IrRTTI.dyn_cast_MDNode(MD);
        if (N != null) {
            this.visitMDNode((MDNode)Native.$Deref((Object)N));
            return;
        }
        if (!this.MDNodes.insert((Object)MD).second) {
            return;
        }
        ValueAsMetadata V = IrRTTI.dyn_cast_ValueAsMetadata(MD);
        if (V != null) {
            this.visitValueAsMetadata((ValueAsMetadata)Native.$Deref((Object)V), F);
        }
    }

    private void visitValueAsMetadata(ValueAsMetadata MD, Function F) {
        if (MD.getValue() == null) {
            this.CheckFailed$T(new Twine("Expected valid value"), (ValueAsMetadata)Native.$AddrOf((Object)MD), new Object[0]);
            return;
        }
        if (MD.getValue().getType().isMetadataTy()) {
            this.CheckFailed$T(new Twine("Unexpected metadata round-trip through values"), (ValueAsMetadata)Native.$AddrOf((Object)MD), MD.getValue());
            return;
        }
        LocalAsMetadata L = IrRTTI.dyn_cast_LocalAsMetadata((Metadata)Native.$AddrOf((Object)MD));
        if (L == null) {
            return;
        }
        if (F == null) {
            this.CheckFailed$T(new Twine("function-local metadata used outside a function"), L, new Object[0]);
            return;
        }
        Function ActualF = null;
        Instruction I = IrRTTI.dyn_cast_Instruction(L.getValue());
        if (I != null) {
            if (I.getParent() == null) {
                this.CheckFailed$T(new Twine("function-local metadata not in basic block"), L, I);
                return;
            }
            ActualF = I.getParent().getParent();
        } else {
            BasicBlock BB = IrRTTI.dyn_cast_BasicBlock(L.getValue());
            if (BB != null) {
                ActualF = BB.getParent();
            } else {
                Argument A2 = IrRTTI.dyn_cast_Argument(L.getValue());
                if (A2 != null) {
                    ActualF = A2.getParent();
                }
            }
        }
        assert (ActualF != null) : "Unimplemented function local metadata case!";
        if (ActualF != F) {
            this.CheckFailed$T(new Twine("function-local metadata used in wrong function"), L, new Object[0]);
            return;
        }
    }

    private void visitComdat(Comdat C2) {
        GlobalValue GV = this.M.getNamedValue(C2.getName());
        if (GV != null && GV.hasPrivateLinkage()) {
            this.CheckFailed$T(new Twine("comdat global value has private linkage"), GV, new Object[0]);
            return;
        }
    }

    private void visitModuleIdents(Module$IR M) {
        NamedMDNode Idents = M.getNamedMetadata(new Twine("llvm.ident"));
        if (Idents == null) {
            return;
        }
        for (MDNode N : Idents.operands$Const()) {
            if (N.getNumOperands() != 1) {
                this.CheckFailed$T(new Twine("incorrect number of operands in llvm.ident metadata"), N, new Object[0]);
                return;
            }
            if (IrRTTI.dyn_cast_or_null_MDString(N.getOperand(0)) != null) continue;
            this.CheckFailed$T(new Twine("invalid value for llvm.ident metadata entry operand(the operand should be a string)"), N.getOperand(0), new Object[0]);
            return;
        }
    }

    private void visitModuleFlags(Module$IR M) {
        NamedMDNode Flags = M.getModuleFlagsMetadata();
        if (Flags == null) {
            return;
        }
        DenseMap SeenIDs = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), (Object)null);
        SmallVector Requirements = new SmallVector(16, (Object)null);
        for (MDNode MDN : Flags.operands$Const()) {
            this.visitModuleFlag(MDN, (DenseMap<MDString, MDNode>)SeenIDs, (SmallVectorImpl<MDNode>)Requirements);
        }
        for (MDNode Requirement : Requirements) {
            MDString Flag = IrRTTI.cast_MDString(Requirement.getOperand(0));
            Metadata ReqValue = Requirement.getOperand(1).$Metadata$P();
            MDNode Op = (MDNode)SeenIDs.lookup((Object)Flag);
            if (Op == null) {
                this.CheckFailed$T(new Twine("invalid requirement on flag, flag is not present in module"), Flag, new Object[0]);
                continue;
            }
            if (Op.getOperand(2).$Metadata$P() == ReqValue) continue;
            this.CheckFailed$T(new Twine("invalid requirement on flag, flag does not have the required value"), Flag, new Object[0]);
        }
    }

    private void visitModuleFlag(MDNode Op, DenseMap<MDString, MDNode> SeenIDs, SmallVectorImpl<MDNode> Requirements) {
        boolean Inserted;
        if (Op.getNumOperands() != 3) {
            this.CheckFailed$T(new Twine("incorrect number of operands in module flag"), Op, new Object[0]);
            return;
        }
        type.ref MFB = NativePointer.create_type$ref();
        if (!Module$IR.isValidModFlagBehavior(Op.getOperand(0).$Metadata$P(), (type.ref<Module$IR.ModFlagBehavior>)MFB)) {
            if (MdconstGlobals.dyn_extract_or_null$ValidPointer(ConstantInt.class, Op.getOperand(0)) == null) {
                this.CheckFailed$T(new Twine("invalid behavior operand in module flag (expected constant integer)"), Op.getOperand(0), new Object[0]);
                return;
            }
            this.CheckFailed$T(new Twine("invalid behavior operand in module flag (unexpected constant)"), Op.getOperand(0), new Object[0]);
            return;
        }
        MDString ID2 = IrRTTI.dyn_cast_or_null_MDString(Op.getOperand(1));
        if (ID2 == null) {
            this.CheckFailed$T(new Twine("invalid ID operand in module flag (expected metadata string)"), Op.getOperand(1), new Object[0]);
            return;
        }
        switch ((Module$IR.ModFlagBehavior)((Object)MFB.$deref())) {
            case Error: 
            case Warning: 
            case Override: {
                break;
            }
            case Require: {
                MDNode Value2 = IrRTTI.dyn_cast_MDNode(Op.getOperand(2));
                if (Value2 == null || Value2.getNumOperands() != 2) {
                    this.CheckFailed$T(new Twine("invalid value for 'require' module flag (expected metadata pair)"), Op.getOperand(2), new Object[0]);
                    return;
                }
                if (!IrRTTI.isa_MDString(Value2.getOperand(0))) {
                    this.CheckFailed$T(new Twine("invalid value for 'require' module flag (first value operand should be a string)"), Value2.getOperand(0), new Object[0]);
                    return;
                }
                Requirements.push_back((Object)Value2);
                break;
            }
            case Append: 
            case AppendUnique: {
                if (IrRTTI.isa_MDNode(Op.getOperand(2))) break;
                this.CheckFailed$T(new Twine("invalid value for 'append'-type module flag (expected a metadata node)"), Op.getOperand(2), new Object[0]);
                return;
            }
        }
        if (MFB.$deref() != Module$IR.ModFlagBehavior.Require && !(Inserted = SeenIDs.insert_pair$KeyT$ValueT((std_pair.pair)new std_pair.pairPtrPtr((JavaDifferentiators.JD$Pair$_U1$_U2)JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)ID2, (Object)Op)).second)) {
            this.CheckFailed$T(new Twine("module flag identifiers must be unique (or of 'require' type)"), ID2, new Object[0]);
            return;
        }
    }

    @Override
    public void visitFunction(Function F) {
        type.ptr U;
        Object Per;
        this.visitGlobalValue(F);
        FunctionType FT = F.getFunctionType();
        int NumArgs = F.arg_size();
        if (this.Context != Native.$AddrOf((Object)F.getContext())) {
            this.CheckFailed$T(new Twine("Function context does not match Module context!"), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        if (F.hasCommonLinkage()) {
            this.CheckFailed$T(new Twine("Functions may not have common linkage"), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        if (FT.getNumParams() != NumArgs) {
            this.CheckFailed$T(new Twine("# formal arguments must match # of arguments for function type!"), (Function)Native.$AddrOf((Object)F), FT);
            return;
        }
        if (!(F.getReturnType().isFirstClassType() || F.getReturnType().isVoidTy() || F.getReturnType().isStructTy())) {
            this.CheckFailed$T(new Twine("Functions cannot return aggregate values!"), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        if (F.hasStructRetAttr() && !F.getReturnType().isVoidTy()) {
            this.CheckFailed$T(new Twine("Invalid struct return type!"), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        AttributeSet Attrs = F.getAttributes();
        if (!this.verifyAttributeCount(new AttributeSet(Attrs), FT.getNumParams())) {
            this.CheckFailed$T(new Twine("Attribute after last parameter!"), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        this.verifyFunctionAttrs(FT, new AttributeSet(Attrs), (Value)Native.$AddrOf((Object)F));
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.Builtin)) {
            this.CheckFailed$T(new Twine("Attribute 'builtin' can only be applied to a callsite."), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        switch (F.getCallingConv()) {
            default: {
                break;
            }
            case 8: 
            case 9: 
            case 71: 
            case 72: 
            case 77: {
                if (!F.isVarArg()) break;
                this.CheckFailed$T(new Twine("Calling convention does not support varargs or perfect forwarding!"), (Function)Native.$AddrOf((Object)F), new Object[0]);
                return;
            }
        }
        boolean isLLVMdotName = Unsigned.$greatereq_uint((int)F.getName().size(), (int)5) && llvm.$eq_StringRef((StringRef)F.getName().substr(0, 5), (String)"llvm.");
        int i = 0;
        for (Argument Arg : F.args$Const()) {
            if (Arg.getType() != FT.getParamType(i)) {
                this.CheckFailed$T(new Twine("Argument value does not match function argument type!"), (Argument)Native.$AddrOf((Object)Arg), FT.getParamType(i));
                return;
            }
            if (!Arg.getType().isFirstClassType()) {
                this.CheckFailed$T(new Twine("Function arguments must have first-class types!"), (Argument)Native.$AddrOf((Object)Arg), new Object[0]);
                return;
            }
            if (!isLLVMdotName) {
                if (Arg.getType().isMetadataTy()) {
                    this.CheckFailed$T(new Twine("Function takes metadata but isn't an intrinsic"), (Argument)Native.$AddrOf((Object)Arg), (Function)Native.$AddrOf((Object)F));
                    return;
                }
                if (Arg.getType().isTokenTy()) {
                    this.CheckFailed$T(new Twine("Function takes token but isn't an intrinsic"), (Argument)Native.$AddrOf((Object)Arg), (Function)Native.$AddrOf((Object)F));
                    return;
                }
            }
            if (Attrs.hasAttribute(i + 1, Attribute.AttrKind.SwiftError)) {
                this.verifySwiftErrorValue((Value)Native.$AddrOf((Object)Arg));
            }
            ++i;
        }
        if (!isLLVMdotName && F.getReturnType().isTokenTy()) {
            this.CheckFailed$T(new Twine("Functions returns a token but isn't an intrinsic"), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        SmallVector MDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
        F.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
        assert (F.hasMetadata() != MDs.empty()) : "Bit out-of-sync";
        this.verifyFunctionMetadata((ArrayRef<std_pair.pairUIntPtr<MDNode>>)new ArrayRef((SmallVectorImplCommon)MDs, false));
        if (F.hasPersonalityFn() && (Per = IrRTTI.dyn_cast_Function(F.getPersonalityFn().stripPointerCasts())) != null && ((Function)Per).getParent() != F.getParent$Const()) {
            this.CheckFailed$T(new Twine("Referencing personality function in another module!"), (Function)Native.$AddrOf((Object)F), F.getParent$Const(), Per, ((Function)Per).getParent());
            return;
        }
        if (F.isMaterializable()) {
            if (!MDs.empty()) {
                this.CheckFailed$T(new Twine("unmaterialized function cannot have metadata"), (Function)Native.$AddrOf((Object)F), MDs.empty() ? (MDNode)null : (MDNode)((std_pair.pairUIntPtr)MDs.front()).second);
                return;
            }
        } else if (F.isDeclaration()) {
            for (std_pair.pairUIntPtr I : MDs) {
                if (I.first == LLVMContext.Unnamed_enum.MD_dbg.getValue()) {
                    this.DebugInfoCheckFailed$T(new Twine("function declaration may not have a !dbg attachment"), (Function)Native.$AddrOf((Object)F), new Object[0]);
                    return;
                }
                if (I.first == LLVMContext.Unnamed_enum.MD_prof.getValue()) {
                    this.CheckFailed$T(new Twine("function declaration may not have a !prof attachment"), (Function)Native.$AddrOf((Object)F), new Object[0]);
                    return;
                }
                this.visitMDNode((MDNode)Native.$Deref((Object)((MDNode)I.second)));
            }
            if (F.hasPersonalityFn()) {
                this.CheckFailed$T(new Twine("Function declaration shouldn't have a personality routine"), (Function)Native.$AddrOf((Object)F), new Object[0]);
                return;
            }
        } else {
            if (isLLVMdotName) {
                this.CheckFailed$T(new Twine("llvm intrinsics cannot be defined!"), (Function)Native.$AddrOf((Object)F), new Object[0]);
                return;
            }
            BasicBlock Entry2 = (BasicBlock)Native.$AddrOf((Object)F.getEntryBlock$Const());
            if (!IrLlvmGlobals.pred_empty(Entry2)) {
                this.CheckFailed$T(new Twine("Entry block to function must not have predecessors!"), Entry2, new Object[0]);
                return;
            }
            if (Entry2.hasAddressTaken() && BlockAddress.lookup(Entry2).isConstantUsed()) {
                this.CheckFailed$T(new Twine("blockaddress may not be used with the entry block!"), Entry2, new Object[0]);
                return;
            }
            int NumDebugAttachments = 0;
            int NumProfAttachments = 0;
            for (std_pair.pairUIntPtr I : MDs) {
                switch (LLVMContext.Unnamed_enum.valueOf(I.first)) {
                    default: {
                        break;
                    }
                    case MD_dbg: {
                        if (++NumDebugAttachments != 1) {
                            this.DebugInfoCheckFailed$T(new Twine("function must have a single !dbg attachment"), (Function)Native.$AddrOf((Object)F), (MDNode)I.second);
                            return;
                        }
                        if (IrRTTI.isa_DISubprogram((Metadata)I.second)) break;
                        this.DebugInfoCheckFailed$T(new Twine("function !dbg attachment must be a subprogram"), (Function)Native.$AddrOf((Object)F), (MDNode)I.second);
                        return;
                    }
                    case MD_prof: {
                        if (++NumProfAttachments == 1) break;
                        this.CheckFailed$T(new Twine("function must have a single !prof attachment"), (Function)Native.$AddrOf((Object)F), (MDNode)I.second);
                        return;
                    }
                }
                this.visitMDNode((MDNode)Native.$Deref((Object)((MDNode)I.second)));
            }
        }
        if (F.getIntrinsicID() != 0 && F.getParent$Const().isMaterialized() && F.hasAddressTaken((type.ptr<User>)((type.ptr)Native.$AddrOf((Object)(U = NativePointer.create_type$null$ptr()))))) {
            this.CheckFailed$T(new Twine("Invalid user of intrinsic instruction!"), U, new Object[0]);
            return;
        }
        if (!(!F.hasDLLImportStorageClass() || F.isDeclaration() && F.hasExternalLinkage() || F.hasAvailableExternallyLinkage())) {
            this.CheckFailed$T(new Twine("Function is marked as dllimport, but not external."), (Function)Native.$AddrOf((Object)F), new Object[0]);
            return;
        }
        DISubprogram N = F.getSubprogram();
        if (N == null) {
            return;
        }
        this.visitDISubprogram((DISubprogram)Native.$Deref((Object)N));
        SmallPtrSet Seen = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 32);
        for (BasicBlock BB : F) {
            for (Instruction I : BB) {
                DISubprogram SP;
                DILocalScope Scope;
                DILocation DL = IrRTTI.dyn_cast_or_null_DILocation(I.getDebugLoc().getAsMDNode());
                if (DL == null || !Seen.insert((Object)DL).second || (Scope = DL.getInlinedAtScope()) != null && !Seen.insert((Object)Scope).second) continue;
                DISubprogram dISubprogram = SP = Scope != null ? Scope.getSubprogram() : null;
                if (SP != null && Scope != SP && !Seen.insert((Object)SP).second || SP.describes((Function)Native.$AddrOf((Object)F))) continue;
                this.CheckFailed$T(new Twine("!dbg attachment points at wrong subprogram for function"), N, (Destructors.ClassWithDestructor)Native.$AddrOf((Object)F), (Destructors.ClassWithDestructor)Native.$AddrOf((Object)I), DL, Scope, SP);
                return;
            }
        }
    }

    @Override
    public void visitBasicBlock(BasicBlock BB) {
        this.InstsInThisBlock.clear();
        if (BB.getTerminator() == null) {
            this.CheckFailed$T(new Twine("Basic Block does not have terminator!"), (BasicBlock)Native.$AddrOf((Object)BB), new Object[0]);
            return;
        }
        if (IrRTTI.isa_PHINode(BB.front())) {
            PHINode PN;
            SmallVector Preds = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, IrLlvmGlobals.pred_begin_BasicBlock$P((BasicBlock)Native.$AddrOf((Object)BB)), IrLlvmGlobals.pred_end_BasicBlock$P((BasicBlock)Native.$AddrOf((Object)BB)), (Object)null);
            SmallVector Values2 = new SmallVector(8, (Object)new std_pair.pairPtrPtr());
            std.sort((type.iterator)Preds.begin(), (type.iterator)Preds.end(), (LHS, RHS) -> Native.compare$JavaRef((Object)LHS, (Object)RHS) < 0);
            ilist_iterator<Instruction> I = BB.begin();
            while ((PN = IrRTTI.dyn_cast_PHINode((Instruction)I.$star())) != null) {
                int i;
                if (PN.getNumIncomingValues() == 0) {
                    this.CheckFailed$T(new Twine("PHI nodes must have at least one entry.  If the block is dead, the PHI should be removed!"), PN, new Object[0]);
                    return;
                }
                if (PN.getNumIncomingValues() != Preds.size()) {
                    this.CheckFailed$T(new Twine("PHINode should have one entry for each predecessor of its parent basic block!"), PN, new Object[0]);
                    return;
                }
                Values2.clear();
                Values2.reserve(PN.getNumIncomingValues());
                int e = PN.getNumIncomingValues();
                for (i = 0; i != e; ++i) {
                    Values2.push_back((Object)std.make_pair_Ptr_Ptr((Object)PN.getIncomingBlock(i), (Object)PN.getIncomingValue(i)));
                }
                std.sort((type.iterator)Values2.begin(), (type.iterator)Values2.end());
                e = Values2.size();
                for (i = 0; i != e; ++i) {
                    if (i != 0 && ((std_pair.pairPtrPtr)Values2.$at((int)i)).first == ((std_pair.pairPtrPtr)Values2.$at((int)(i - 1))).first && ((std_pair.pairPtrPtr)Values2.$at((int)i)).second != ((std_pair.pairPtrPtr)Values2.$at((int)(i - 1))).second) {
                        this.CheckFailed$T(new Twine("PHI node has multiple entries for the same basic block with different incoming values!"), PN, (Value)((std_pair.pairPtrPtr)Values2.$at((int)i)).first, (Value)((std_pair.pairPtrPtr)Values2.$at((int)i)).second, (Value)((std_pair.pairPtrPtr)Values2.$at((int)(i - 1))).second);
                        return;
                    }
                    if (((std_pair.pairPtrPtr)Values2.$at((int)i)).first == Preds.$at(i)) continue;
                    this.CheckFailed$T(new Twine("PHI node entries do not match predecessors!"), PN, (BasicBlock)((std_pair.pairPtrPtr)Values2.$at((int)i)).first, (BasicBlock)Preds.$at(i));
                    return;
                }
                I.$preInc();
            }
        }
        for (Instruction I : BB) {
            if (I.getParent() == Native.$AddrOf((Object)BB)) continue;
            this.CheckFailed(new Twine("Instruction has bogus parent pointer!"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void visitRangeMetadata(Instruction I, MDNode Range, Type Ty) {
        ConstantRange LastRange = null;
        try {
            int NumOperands;
            if (!$assertionsDisabled) {
                if (Range == null) throw new AssertionError((Object)"precondition violation");
                if (Range != I.getMetadata(LLVMContext.Unnamed_enum.MD_range.getValue())) {
                    throw new AssertionError((Object)"precondition violation");
                }
            }
            if (Unsigned.$rem_uint((int)(NumOperands = Range.getNumOperands()), (int)2) != 0) {
                this.CheckFailed$T(new Twine("Unfinished range!"), Range, new Object[0]);
                return;
            }
            int NumRanges = Unsigned.$div_uint((int)NumOperands, (int)2);
            if (!Unsigned.$greatereq_uint((int)NumRanges, (int)1)) {
                this.CheckFailed$T(new Twine("It should have at least one range!"), Range, new Object[0]);
                return;
            }
            LastRange = new ConstantRange(1);
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)NumRanges)) {
                ConstantRange CurRange = null;
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    ConstantInt Low = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, Range.getOperand(2 * i));
                    if (Low == null) {
                        this.CheckFailed$T(new Twine("The lower limit must be an integer!"), Low, new Object[0]);
                        return;
                    }
                    ConstantInt High = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, Range.getOperand(2 * i + 1));
                    if (High == null) {
                        this.CheckFailed$T(new Twine("The upper limit must be an integer!"), High, new Object[0]);
                        return;
                    }
                    if (High.getType() != Low.getType() || High.getType() != Ty) {
                        this.CheckFailed$T(new Twine("Range types must match instruction type!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                        return;
                    }
                    APInt HighV = new APInt(High.getValue());
                    APInt LowV = new APInt(Low.getValue());
                    CurRange = new ConstantRange(new APInt(LowV), new APInt(HighV));
                    if (CurRange.isEmptySet() || CurRange.isFullSet()) {
                        this.CheckFailed$T(new Twine("Range must not be empty!"), Range, new Object[0]);
                        return;
                    }
                    if (i != 0) {
                        if ($c$.clean(!((ConstantRange)$c$.track((Object)CurRange.intersectWith(LastRange))).isEmptySet())) {
                            this.CheckFailed$T(new Twine("Intervals are overlapping"), Range, new Object[0]);
                            return;
                        }
                        if (!LowV.sgt(LastRange.getLower())) {
                            this.CheckFailed$T(new Twine("Intervals are not in order"), Range, new Object[0]);
                            return;
                        }
                        if (VerifierStatics.isContiguous(CurRange, LastRange)) {
                            this.CheckFailed$T(new Twine("Intervals are contiguous"), Range, new Object[0]);
                            return;
                        }
                    }
                    $c$.clean((Object)LastRange.$assignMove((ConstantRange)$c$.track((Object)new ConstantRange(new APInt(LowV), new APInt(HighV)))));
                }
                finally {
                    if (CurRange != null) {
                        CurRange.$destroy();
                    }
                    $c$.$destroy();
                }
                ++i;
            }
            if (!Unsigned.$greater_uint((int)NumRanges, (int)2)) return;
            ConstantRange FirstRange = null;
            try {
                APInt FirstLow = new APInt(MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, Range.getOperand(0)).getValue());
                APInt FirstHigh = new APInt(MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, Range.getOperand(1)).getValue());
                FirstRange = new ConstantRange(new APInt(FirstLow), new APInt(FirstHigh));
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    if ($c$.clean(!((ConstantRange)$c$.track((Object)FirstRange.intersectWith(LastRange))).isEmptySet())) {
                        this.CheckFailed$T(new Twine("Intervals are overlapping"), Range, new Object[0]);
                        return;
                    }
                }
                finally {
                    $c$.$destroy();
                }
                if (!VerifierStatics.isContiguous(FirstRange, LastRange)) return;
                this.CheckFailed$T(new Twine("Intervals are contiguous"), Range, new Object[0]);
                return;
            }
            finally {
                if (FirstRange != null) {
                    FirstRange.$destroy();
                }
            }
        }
        finally {
            if (LastRange != null) {
                LastRange.$destroy();
            }
        }
    }

    private void visitDereferenceableMetadata(Instruction I, MDNode MD) {
        if (!I.getType().isPointerTy()) {
            this.CheckFailed$T(new Twine("dereferenceable, dereferenceable_or_null apply only to pointer types"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!IrRTTI.isa_LoadInst(I)) {
            this.CheckFailed$T(new Twine("dereferenceable, dereferenceable_or_null apply only to load instructions, use attributes for calls or invokes"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (MD.getNumOperands() != 1) {
            this.CheckFailed$T(new Twine("dereferenceable, dereferenceable_or_null take one operand!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        ConstantInt CI = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, MD.getOperand(0));
        if (CI == null || !CI.getType().isIntegerTy(64)) {
            this.CheckFailed$T(new Twine("dereferenceable, dereferenceable_or_null metadata value must be an i64!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
    }

    private <Ty> boolean isValidMetadataArray(MDTuple N) {
        throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
    }

    private void visitDILocation(DILocation N) {
        if (N.getRawScope() == null || !IrRTTI.isa_DILocalScope(N.getRawScope())) {
            this.DebugInfoCheckFailed$T(new Twine("location requires a valid scope"), (DILocation)Native.$AddrOf((Object)N), N.getRawScope());
            return;
        }
        Metadata IA = N.getRawInlinedAt();
        if (IA != null && !IrRTTI.isa_DILocation(IA)) {
            this.DebugInfoCheckFailed$T(new Twine("inlined-at should be a location"), (DILocation)Native.$AddrOf((Object)N), IA);
            return;
        }
    }

    private void visitDIExpression(DIExpression N) {
        if (!N.isValid()) {
            this.DebugInfoCheckFailed$T(new Twine("invalid expression"), (DIExpression)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitGenericDINode(GenericDINode N) {
        if (N.getTag() == 0) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (GenericDINode)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDISubrange(DISubrange N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'!')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DISubrange)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getCount() < -1L) {
            this.DebugInfoCheckFailed$T(new Twine("invalid subrange count"), (DISubrange)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDIEnumerator(DIEnumerator N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'(')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIEnumerator)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDIBasicType(DIBasicType N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'$') && N.getTag() != Unsigned.$ushort2uint((char)';')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIBasicType)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDIDerivedType(DIDerivedType N) {
        this.visitDIScope(N);
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u0016') && N.getTag() != Unsigned.$ushort2uint((char)'\u000f') && N.getTag() != Unsigned.$ushort2uint((char)'\u001f') && N.getTag() != Unsigned.$ushort2uint((char)'\u0010') && N.getTag() != Unsigned.$ushort2uint((char)'B') && N.getTag() != Unsigned.$ushort2uint((char)'&') && N.getTag() != Unsigned.$ushort2uint((char)'5') && N.getTag() != Unsigned.$ushort2uint((char)'7') && N.getTag() != Unsigned.$ushort2uint((char)'\r') && N.getTag() != Unsigned.$ushort2uint((char)'\u001c') && N.getTag() != Unsigned.$ushort2uint((char)'*')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIDerivedType)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getTag() == Unsigned.$ushort2uint((char)'\u001f') && !VerifierStatics.isType(N.getRawExtraData())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid pointer to member type"), (DIDerivedType)Native.$AddrOf((Object)N), N.getRawExtraData());
            return;
        }
        if (!VerifierStatics.isScope(N.getRawScope())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid scope"), (DIDerivedType)Native.$AddrOf((Object)N), N.getRawScope());
            return;
        }
        if (!VerifierStatics.isType(N.getRawBaseType())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid base type"), (DIDerivedType)Native.$AddrOf((Object)N), N.getRawBaseType());
            return;
        }
    }

    private void visitDICompositeType(DICompositeType N) {
        this.visitDIScope(N);
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u0001') && N.getTag() != Unsigned.$ushort2uint((char)'\u0013') && N.getTag() != Unsigned.$ushort2uint((char)'\u0017') && N.getTag() != Unsigned.$ushort2uint((char)'\u0004') && N.getTag() != Unsigned.$ushort2uint((char)'\u0002')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DICompositeType)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (!VerifierStatics.isScope(N.getRawScope())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid scope"), (DICompositeType)Native.$AddrOf((Object)N), N.getRawScope());
            return;
        }
        if (!VerifierStatics.isType(N.getRawBaseType())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid base type"), (DICompositeType)Native.$AddrOf((Object)N), N.getRawBaseType());
            return;
        }
        if (N.getRawElements() != null && !IrRTTI.isa_MDTuple(N.getRawElements())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid composite elements"), (DICompositeType)Native.$AddrOf((Object)N), N.getRawElements());
            return;
        }
        if (!VerifierStatics.isType(N.getRawVTableHolder())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid vtable holder"), (DICompositeType)Native.$AddrOf((Object)N), N.getRawVTableHolder());
            return;
        }
        if (VerifierStatics.hasConflictingReferenceFlags(N.getFlags())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid reference flags"), (DICompositeType)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata Params = N.getRawTemplateParams();
        if (Params != null) {
            this.visitTemplateParams(N, (Metadata)Native.$Deref((Object)Params));
        }
        if (!(N.getTag() != Unsigned.$ushort2uint((char)'\u0002') && N.getTag() != Unsigned.$ushort2uint((char)'\u0017') || N.getFile() != null && !N.getFile().getFilename().empty())) {
            this.DebugInfoCheckFailed$T(new Twine("class/union requires a filename"), (DICompositeType)Native.$AddrOf((Object)N), N.getFile());
            return;
        }
    }

    private void visitDISubroutineType(DISubroutineType N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u0015')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DISubroutineType)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata Types = N.getRawTypeArray();
        if (Types != null) {
            if (!IrRTTI.isa_MDTuple(Types)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid composite elements"), (DISubroutineType)Native.$AddrOf((Object)N), Types);
                return;
            }
            for (MDOperand O : N.getTypeArray().$arrow().operands()) {
                Metadata Ty = O.$Metadata$P();
                if (VerifierStatics.isType(Ty)) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid subroutine type ref"), (DISubroutineType)Native.$AddrOf((Object)N), Types, Ty);
                return;
            }
        }
        if (VerifierStatics.hasConflictingReferenceFlags(N.getFlags())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid reference flags"), (DISubroutineType)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDIFile(DIFile N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)')')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIFile)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDICompileUnit(DICompileUnit N) {
        Metadata Op;
        if (!N.isDistinct()) {
            this.DebugInfoCheckFailed$T(new Twine("compile units must be distinct"), (DICompileUnit)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u0011')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DICompileUnit)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getRawFile() == null || !IrRTTI.isa_DIFile(N.getRawFile())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid file"), (DICompileUnit)Native.$AddrOf((Object)N), N.getRawFile());
            return;
        }
        if (N.getFile().getFilename().empty()) {
            this.DebugInfoCheckFailed$T(new Twine("invalid filename"), (DICompileUnit)Native.$AddrOf((Object)N), N.getFile());
            return;
        }
        if (!Unsigned.$lesseq_uint((int)N.getEmissionKind().getValue(), (int)DICompileUnit.DebugEmissionKind.LastEmissionKind.getValue())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid emission kind"), (DICompileUnit)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata Array = N.getRawEnumTypes();
        if (Array != null) {
            if (!IrRTTI.isa_MDTuple(Array)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid enum list"), (DICompileUnit)Native.$AddrOf((Object)N), Array);
                return;
            }
            for (MDOperand O : N.getEnumTypes().$arrow().operands()) {
                Op = O.$Metadata$P();
                DICompositeType Enum2 = IrRTTI.dyn_cast_or_null_DICompositeType(Op);
                if (Enum2 != null && Enum2.getTag() == Unsigned.$ushort2uint((char)'\u0004')) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid enum type"), (DICompileUnit)Native.$AddrOf((Object)N), N.getEnumTypes(), Op);
                return;
            }
        }
        if ((Array = N.getRawRetainedTypes()) != null) {
            if (!IrRTTI.isa_MDTuple(Array)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid retained type list"), (DICompileUnit)Native.$AddrOf((Object)N), Array);
                return;
            }
            for (MDOperand O : N.getRetainedTypes().$arrow().operands()) {
                Op = O.$Metadata$P();
                if (Op != null && (IrRTTI.isa_DIType(Op) || IrRTTI.isa_DISubprogram(Op) && !IrRTTI.cast_DISubprogram(Op).isDefinition())) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid retained type"), (DICompileUnit)Native.$AddrOf((Object)N), Op);
                return;
            }
        }
        if ((Array = N.getRawGlobalVariables()) != null) {
            if (!IrRTTI.isa_MDTuple(Array)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid global variable list"), (DICompileUnit)Native.$AddrOf((Object)N), Array);
                return;
            }
            for (MDOperand O : N.getGlobalVariables().$arrow().operands()) {
                Op = O.$Metadata$P();
                if (Op != null && IrRTTI.isa_DIGlobalVariable(Op)) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid global variable ref"), (DICompileUnit)Native.$AddrOf((Object)N), Op);
                return;
            }
        }
        if ((Array = N.getRawImportedEntities()) != null) {
            if (!IrRTTI.isa_MDTuple(Array)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid imported entity list"), (DICompileUnit)Native.$AddrOf((Object)N), Array);
                return;
            }
            for (MDOperand O : N.getImportedEntities().$arrow().operands()) {
                Op = O.$Metadata$P();
                if (Op != null && IrRTTI.isa_DIImportedEntity(Op)) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid imported entity ref"), (DICompileUnit)Native.$AddrOf((Object)N), Op);
                return;
            }
        }
        if ((Array = N.getRawMacros()) != null) {
            if (!IrRTTI.isa_MDTuple(Array)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid macro list"), (DICompileUnit)Native.$AddrOf((Object)N), Array);
                return;
            }
            for (MDOperand O : N.getMacros().$arrow().operands()) {
                Op = O.$Metadata$P();
                if (Op != null && IrRTTI.isa_DIMacroNode(Op)) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid macro ref"), (DICompileUnit)Native.$AddrOf((Object)N), Op);
                return;
            }
        }
        this.CUVisited.insert((Object)((Metadata)Native.$AddrOf((Object)N)));
    }

    private void visitDISubprogram(DISubprogram N) {
        Metadata S;
        if (N.getTag() != Unsigned.$ushort2uint((char)'.')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DISubprogram)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (!VerifierStatics.isScope(N.getRawScope())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid scope"), (DISubprogram)Native.$AddrOf((Object)N), N.getRawScope());
            return;
        }
        Metadata F = N.getRawFile();
        if (F != null && !IrRTTI.isa_DIFile(F)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid file"), (DISubprogram)Native.$AddrOf((Object)N), F);
            return;
        }
        Metadata T2 = N.getRawType();
        if (T2 != null && !IrRTTI.isa_DISubroutineType(T2)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid subroutine type"), (DISubprogram)Native.$AddrOf((Object)N), T2);
            return;
        }
        if (!VerifierStatics.isType(N.getRawContainingType())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid containing type"), (DISubprogram)Native.$AddrOf((Object)N), N.getRawContainingType());
            return;
        }
        Metadata Params = N.getRawTemplateParams();
        if (Params != null) {
            this.visitTemplateParams(N, (Metadata)Native.$Deref((Object)Params));
        }
        if ((S = N.getRawDeclaration()) != null && (!IrRTTI.isa_DISubprogram(S) || IrRTTI.cast_DISubprogram(S).isDefinition())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid subprogram declaration"), (DISubprogram)Native.$AddrOf((Object)N), S);
            return;
        }
        Metadata RawVars = N.getRawVariables();
        if (RawVars != null) {
            MDTuple Vars = IrRTTI.dyn_cast_MDTuple(RawVars);
            if (Vars == null) {
                this.DebugInfoCheckFailed$T(new Twine("invalid variable list"), (DISubprogram)Native.$AddrOf((Object)N), RawVars);
                return;
            }
            for (MDOperand O : Vars.operands()) {
                Metadata Op = O.$Metadata$P();
                if (Op != null && IrRTTI.isa_DILocalVariable(Op)) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid local variable"), (DISubprogram)Native.$AddrOf((Object)N), Vars, Op);
                return;
            }
        }
        if (VerifierStatics.hasConflictingReferenceFlags(N.getFlags())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid reference flags"), (DISubprogram)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata Unit = N.getRawUnit();
        if (N.isDefinition()) {
            if (!N.isDistinct()) {
                this.DebugInfoCheckFailed$T(new Twine("subprogram definitions must be distinct"), (DISubprogram)Native.$AddrOf((Object)N), new Object[0]);
                return;
            }
            if (Unit == null) {
                this.DebugInfoCheckFailed$T(new Twine("subprogram definitions must have a compile unit"), (DISubprogram)Native.$AddrOf((Object)N), new Object[0]);
                return;
            }
            if (!IrRTTI.isa_DICompileUnit(Unit)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid unit type"), (DISubprogram)Native.$AddrOf((Object)N), Unit);
                return;
            }
        } else if (Unit != null) {
            this.DebugInfoCheckFailed$T(new Twine("subprogram declarations must not have a compile unit"), (DISubprogram)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDILexicalBlock(DILexicalBlock N) {
        this.visitDILexicalBlockBase(N);
        if (N.getLine() == 0 && N.getColumn() != 0) {
            this.DebugInfoCheckFailed$T(new Twine("cannot have column info without line info"), (DILexicalBlock)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDILexicalBlockFile(DILexicalBlockFile N) {
        this.visitDILexicalBlockBase(N);
    }

    private void visitDINamespace(DINamespace N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'9')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DINamespace)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata S = N.getRawScope();
        if (S != null && !IrRTTI.isa_DIScope(S)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid scope ref"), (DINamespace)Native.$AddrOf((Object)N), S);
            return;
        }
    }

    private void visitDIModule(DIModule N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u001e')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIModule)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getName().empty()) {
            this.DebugInfoCheckFailed$T(new Twine("anonymous module"), (DIModule)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDITemplateTypeParameter(DITemplateTypeParameter N) {
        this.visitDITemplateParameter(N);
        if (N.getTag() != Unsigned.$ushort2uint((char)'/')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DITemplateTypeParameter)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDITemplateValueParameter(DITemplateValueParameter N) {
        this.visitDITemplateParameter(N);
        if (N.getTag() != Unsigned.$ushort2uint((char)'0') && N.getTag() != Unsigned.$ushort2uint((char)'\u4106') && N.getTag() != Unsigned.$ushort2uint((char)'\u4107')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DITemplateValueParameter)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
    }

    private void visitDIGlobalVariable(DIGlobalVariable N) {
        Metadata Member;
        this.visitDIVariable(N);
        if (N.getTag() != Unsigned.$ushort2uint((char)'4')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIGlobalVariable)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getName().empty()) {
            this.DebugInfoCheckFailed$T(new Twine("missing global variable name"), (DIGlobalVariable)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata V = N.getRawVariable();
        if (V != null) {
            if (!IrRTTI.isa_ConstantAsMetadata(V) || IrRTTI.isa_Function(IrRTTI.cast_ConstantAsMetadata(V).getValue())) {
                this.DebugInfoCheckFailed$T(new Twine("invalid global varaible ref"), (DIGlobalVariable)Native.$AddrOf((Object)N), V);
                return;
            }
            this.visitConstantExprsRecursively(IrRTTI.cast_ConstantAsMetadata(V).getValue());
        }
        if ((Member = N.getRawStaticDataMemberDeclaration()) != null && !IrRTTI.isa_DIDerivedType(Member)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid static data member declaration"), (DIGlobalVariable)Native.$AddrOf((Object)N), Member);
            return;
        }
    }

    private void visitDILocalVariable(DILocalVariable N) {
        this.visitDIVariable(N);
        if (N.getTag() != Unsigned.$ushort2uint((char)'4')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DILocalVariable)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getRawScope() == null || !IrRTTI.isa_DILocalScope(N.getRawScope())) {
            this.DebugInfoCheckFailed$T(new Twine("local variable requires a valid scope"), (DILocalVariable)Native.$AddrOf((Object)N), N.getRawScope());
            return;
        }
    }

    private void visitDIObjCProperty(DIObjCProperty N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u4200')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIObjCProperty)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata T2 = N.getRawType();
        if (T2 != null && !VerifierStatics.isType(T2)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid type ref"), (DIObjCProperty)Native.$AddrOf((Object)N), T2);
            return;
        }
        Metadata F = N.getRawFile();
        if (F != null && !IrRTTI.isa_DIFile(F)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid file"), (DIObjCProperty)Native.$AddrOf((Object)N), F);
            return;
        }
    }

    private void visitDIImportedEntity(DIImportedEntity N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)':') && N.getTag() != Unsigned.$ushort2uint((char)'\b')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DIImportedEntity)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata S = N.getRawScope();
        if (S != null && !IrRTTI.isa_DIScope(S)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid scope for imported entity"), (DIImportedEntity)Native.$AddrOf((Object)N), S);
            return;
        }
        if (!VerifierStatics.isDINode(N.getRawEntity())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid imported entity"), (DIImportedEntity)Native.$AddrOf((Object)N), N.getRawEntity());
            return;
        }
    }

    private void visitDIMacro(DIMacro N) {
        if (N.getMacinfoType() != 1 && N.getMacinfoType() != 2) {
            this.DebugInfoCheckFailed$T(new Twine("invalid macinfo type"), (DIMacro)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getName().empty()) {
            this.DebugInfoCheckFailed$T(new Twine("anonymous macro"), (DIMacro)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (!N.getValue().empty()) assert (N.getValue().data().$at(0) != 32) : "Macro value has a space prefix";
    }

    private void visitDIMacroFile(DIMacroFile N) {
        if (N.getMacinfoType() != 3) {
            this.DebugInfoCheckFailed$T(new Twine("invalid macinfo type"), (DIMacroFile)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        Metadata F = N.getRawFile();
        if (F != null && !IrRTTI.isa_DIFile(F)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid file"), (DIMacroFile)Native.$AddrOf((Object)N), F);
            return;
        }
        Metadata Array = N.getRawElements();
        if (Array != null) {
            if (!IrRTTI.isa_MDTuple(Array)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid macro list"), (DIMacroFile)Native.$AddrOf((Object)N), Array);
                return;
            }
            for (MDOperand O : N.getElements().$arrow().operands()) {
                Metadata Op = O.$Metadata$P();
                if (Op != null && IrRTTI.isa_DIMacroNode(Op)) continue;
                this.DebugInfoCheckFailed$T(new Twine("invalid macro ref"), (DIMacroFile)Native.$AddrOf((Object)N), Op);
                return;
            }
        }
    }

    private void visitDIScope(DIScope N) {
        Metadata F = N.getRawFile();
        if (F != null && !IrRTTI.isa_DIFile(F)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid file"), (DIScope)Native.$AddrOf((Object)N), F);
            return;
        }
    }

    private void visitDIVariable(DIVariable N) {
        Metadata S = N.getRawScope();
        if (S != null && !IrRTTI.isa_DIScope(S)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid scope"), (DIVariable)Native.$AddrOf((Object)N), S);
            return;
        }
        if (!VerifierStatics.isType(N.getRawType())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid type ref"), (DIVariable)Native.$AddrOf((Object)N), N.getRawType());
            return;
        }
        Metadata F = N.getRawFile();
        if (F != null && !IrRTTI.isa_DIFile(F)) {
            this.DebugInfoCheckFailed$T(new Twine("invalid file"), (DIVariable)Native.$AddrOf((Object)N), F);
            return;
        }
    }

    private void visitDILexicalBlockBase(DILexicalBlockBase N) {
        if (N.getTag() != Unsigned.$ushort2uint((char)'\u000b')) {
            this.DebugInfoCheckFailed$T(new Twine("invalid tag"), (DILexicalBlockBase)Native.$AddrOf((Object)N), new Object[0]);
            return;
        }
        if (N.getRawScope() == null || !IrRTTI.isa_DILocalScope(N.getRawScope())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid local scope"), (DILexicalBlockBase)Native.$AddrOf((Object)N), N.getRawScope());
            return;
        }
    }

    private void visitDITemplateParameter(DITemplateParameter N) {
        if (!VerifierStatics.isType(N.getRawType())) {
            this.DebugInfoCheckFailed$T(new Twine("invalid type ref"), (DITemplateParameter)Native.$AddrOf((Object)N), N.getRawType());
            return;
        }
    }

    private void visitTemplateParams(MDNode N, Metadata RawParams) {
        MDTuple Params = IrRTTI.dyn_cast_MDTuple((Metadata)Native.$AddrOf((Object)RawParams));
        if (Params == null) {
            this.DebugInfoCheckFailed$T(new Twine("invalid template params"), (MDNode)Native.$AddrOf((Object)N), (Metadata)Native.$AddrOf((Object)RawParams));
            return;
        }
        for (MDOperand O : Params.operands()) {
            Metadata Op = O.$Metadata$P();
            if (Op != null && IrRTTI.isa_DITemplateParameter(Op)) continue;
            this.DebugInfoCheckFailed$T(new Twine("invalid template parameter"), (MDNode)Native.$AddrOf((Object)N), Params, Op);
            return;
        }
    }

    private void visit(Instruction I) {
        int e = I.getNumOperands$User();
        for (int i = 0; i != e; ++i) {
            if (I.getOperand(i) != null) continue;
            this.CheckFailed$T(new Twine("Operand is null"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        InstVisitorVoid.super.visit_Instruction(I);
    }

    @Override
    public void visitTruncInst(TruncInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        int SrcBitSize = SrcTy.getScalarSizeInBits();
        int DestBitSize = DestTy.getScalarSizeInBits();
        if (!SrcTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("Trunc only operates on integer"), (TruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("Trunc only produces integer"), (TruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("trunc source and destination must both be a vector or neither"), (TruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!Unsigned.$greater_uint((int)SrcBitSize, (int)DestBitSize)) {
            this.CheckFailed$T(new Twine("DestTy too big for Trunc"), (TruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitZExtInst(ZExtInst I) {
        int DestBitSize;
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        if (!SrcTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("ZExt only operates on integer"), (ZExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("ZExt only produces an integer"), (ZExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("zext source and destination must both be a vector or neither"), (ZExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        int SrcBitSize = SrcTy.getScalarSizeInBits();
        if (!Unsigned.$less_uint((int)SrcBitSize, (int)(DestBitSize = DestTy.getScalarSizeInBits()))) {
            this.CheckFailed$T(new Twine("Type too small for ZExt"), (ZExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitSExtInst(SExtInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        int SrcBitSize = SrcTy.getScalarSizeInBits();
        int DestBitSize = DestTy.getScalarSizeInBits();
        if (!SrcTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("SExt only operates on integer"), (SExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("SExt only produces an integer"), (SExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("sext source and destination must both be a vector or neither"), (SExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!Unsigned.$less_uint((int)SrcBitSize, (int)DestBitSize)) {
            this.CheckFailed$T(new Twine("Type too small for SExt"), (SExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitFPTruncInst(FPTruncInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        int SrcBitSize = SrcTy.getScalarSizeInBits();
        int DestBitSize = DestTy.getScalarSizeInBits();
        if (!SrcTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("FPTrunc only operates on FP"), (FPTruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("FPTrunc only produces an FP"), (FPTruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("fptrunc source and destination must both be a vector or neither"), (FPTruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!Unsigned.$greater_uint((int)SrcBitSize, (int)DestBitSize)) {
            this.CheckFailed$T(new Twine("DestTy too big for FPTrunc"), (FPTruncInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitFPExtInst(FPExtInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        int SrcBitSize = SrcTy.getScalarSizeInBits();
        int DestBitSize = DestTy.getScalarSizeInBits();
        if (!SrcTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("FPExt only operates on FP"), (FPExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("FPExt only produces an FP"), (FPExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("fpext source and destination must both be a vector or neither"), (FPExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!Unsigned.$less_uint((int)SrcBitSize, (int)DestBitSize)) {
            this.CheckFailed$T(new Twine("DestTy too small for FPExt"), (FPExtInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitFPToUIInst(FPToUIInst I) {
        boolean DstVec;
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        boolean SrcVec = SrcTy.isVectorTy();
        if (SrcVec != (DstVec = DestTy.isVectorTy())) {
            this.CheckFailed$T(new Twine("FPToUI source and dest must both be vector or scalar"), (FPToUIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!SrcTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("FPToUI source must be FP or FP vector"), (FPToUIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("FPToUI result must be integer or integer vector"), (FPToUIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcVec && DstVec && IrRTTI.cast_VectorType(SrcTy).getNumElements() != IrRTTI.cast_VectorType(DestTy).getNumElements()) {
            this.CheckFailed$T(new Twine("FPToUI source and dest vector length mismatch"), (FPToUIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitFPToSIInst(FPToSIInst I) {
        boolean DstVec;
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        boolean SrcVec = SrcTy.isVectorTy();
        if (SrcVec != (DstVec = DestTy.isVectorTy())) {
            this.CheckFailed$T(new Twine("FPToSI source and dest must both be vector or scalar"), (FPToSIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!SrcTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("FPToSI source must be FP or FP vector"), (FPToSIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("FPToSI result must be integer or integer vector"), (FPToSIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcVec && DstVec && IrRTTI.cast_VectorType(SrcTy).getNumElements() != IrRTTI.cast_VectorType(DestTy).getNumElements()) {
            this.CheckFailed$T(new Twine("FPToSI source and dest vector length mismatch"), (FPToSIInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitUIToFPInst(UIToFPInst I) {
        boolean DstVec;
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        boolean SrcVec = SrcTy.isVectorTy();
        if (SrcVec != (DstVec = DestTy.isVectorTy())) {
            this.CheckFailed$T(new Twine("UIToFP source and dest must both be vector or scalar"), (UIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!SrcTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("UIToFP source must be integer or integer vector"), (UIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("UIToFP result must be FP or FP vector"), (UIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcVec && DstVec && IrRTTI.cast_VectorType(SrcTy).getNumElements() != IrRTTI.cast_VectorType(DestTy).getNumElements()) {
            this.CheckFailed$T(new Twine("UIToFP source and dest vector length mismatch"), (UIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitSIToFPInst(SIToFPInst I) {
        boolean DstVec;
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        boolean SrcVec = SrcTy.isVectorTy();
        if (SrcVec != (DstVec = DestTy.isVectorTy())) {
            this.CheckFailed$T(new Twine("SIToFP source and dest must both be vector or scalar"), (SIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!SrcTy.isIntOrIntVectorTy()) {
            this.CheckFailed$T(new Twine("SIToFP source must be integer or integer vector"), (SIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("SIToFP result must be FP or FP vector"), (SIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcVec && DstVec && IrRTTI.cast_VectorType(SrcTy).getNumElements() != IrRTTI.cast_VectorType(DestTy).getNumElements()) {
            this.CheckFailed$T(new Twine("SIToFP source and dest vector length mismatch"), (SIToFPInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitIntToPtrInst(IntToPtrInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        if (!SrcTy.getScalarType().isIntegerTy()) {
            this.CheckFailed$T(new Twine("IntToPtr source must be an integral"), (IntToPtrInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.getScalarType().isPointerTy()) {
            this.CheckFailed$T(new Twine("IntToPtr result must be a pointer"), (IntToPtrInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("IntToPtr type mismatch"), (IntToPtrInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy()) {
            VectorType VSrc = IrRTTI.dyn_cast_VectorType(SrcTy);
            VectorType VDest = IrRTTI.dyn_cast_VectorType(DestTy);
            if (VSrc.getNumElements() != VDest.getNumElements()) {
                this.CheckFailed$T(new Twine("IntToPtr Vector width mismatch"), (IntToPtrInst)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitPtrToIntInst(PtrToIntInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        if (!SrcTy.getScalarType().isPointerTy()) {
            this.CheckFailed$T(new Twine("PtrToInt source must be pointer"), (PtrToIntInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.getScalarType().isIntegerTy()) {
            this.CheckFailed$T(new Twine("PtrToInt result must be integral"), (PtrToIntInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() != DestTy.isVectorTy()) {
            this.CheckFailed$T(new Twine("PtrToInt type mismatch"), (PtrToIntInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy()) {
            VectorType VSrc = IrRTTI.dyn_cast_VectorType(SrcTy);
            VectorType VDest = IrRTTI.dyn_cast_VectorType(DestTy);
            if (VSrc.getNumElements() != VDest.getNumElements()) {
                this.CheckFailed$T(new Twine("PtrToInt Vector width mismatch"), (PtrToIntInst)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitBitCastInst(BitCastInst I) {
        if (!CastInst.castIsValid(47, I.getOperand(0), I.getType())) {
            this.CheckFailed$T(new Twine("Invalid bitcast"), (BitCastInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitAddrSpaceCastInst(AddrSpaceCastInst I) {
        Type SrcTy = I.getOperand(0).getType();
        Type DestTy = I.getType();
        if (!SrcTy.isPtrOrPtrVectorTy()) {
            this.CheckFailed$T(new Twine("AddrSpaceCast source must be a pointer"), (AddrSpaceCastInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!DestTy.isPtrOrPtrVectorTy()) {
            this.CheckFailed$T(new Twine("AddrSpaceCast result must be a pointer"), (AddrSpaceCastInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.getPointerAddressSpace() == DestTy.getPointerAddressSpace()) {
            this.CheckFailed$T(new Twine("AddrSpaceCast must be between different address spaces"), (AddrSpaceCastInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (SrcTy.isVectorTy() && SrcTy.getVectorNumElements() != DestTy.getVectorNumElements()) {
            this.CheckFailed$T(new Twine("AddrSpaceCast vector pointer number of elements mismatch"), (AddrSpaceCastInst)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitPHINode(PHINode PN) {
        if (Native.$AddrOf((Object)PN) != Native.$AddrOf((Object)PN.getParent().front()) && !IrRTTI.isa_PHINode((type.ptr)PN.$This$Ptr().$preDec())) {
            this.CheckFailed$T(new Twine("PHI nodes not grouped at top of basic block!"), (PHINode)Native.$AddrOf((Object)PN), PN.getParent());
            return;
        }
        if (PN.getType().isTokenTy()) {
            this.CheckFailed(new Twine("PHI nodes cannot have token type!"));
            return;
        }
        for (Use U : PN.incoming_values()) {
            Value IncValue = U.$Value$P();
            if (PN.getType() == IncValue.getType()) continue;
            this.CheckFailed$T(new Twine("PHI node operands are not the same type as the result!"), (PHINode)Native.$AddrOf((Object)PN), new Object[0]);
            return;
        }
        this.visitInstruction(PN);
    }

    @Override
    public void visitBinaryOperator(BinaryOperator B2) {
        if (B2.getOperand(0).getType() != B2.getOperand(1).getType()) {
            this.CheckFailed$T(new Twine("Both operands to a binary operator are not of the same type!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
            return;
        }
        switch (B2.getOpcode()) {
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                if (!B2.getType().isIntOrIntVectorTy()) {
                    this.CheckFailed$T(new Twine("Integer arithmetic operators only work with integral types!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                    return;
                }
                if (B2.getType() == B2.getOperand(0).getType()) break;
                this.CheckFailed$T(new Twine("Integer arithmetic operators must have same type for operands and result!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                return;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: {
                if (!B2.getType().isFPOrFPVectorTy()) {
                    this.CheckFailed$T(new Twine("Floating-point arithmetic operators only work with floating-point types!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                    return;
                }
                if (B2.getType() == B2.getOperand(0).getType()) break;
                this.CheckFailed$T(new Twine("Floating-point arithmetic operators must have same type for operands and result!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                return;
            }
            case 26: 
            case 27: 
            case 28: {
                if (!B2.getType().isIntOrIntVectorTy()) {
                    this.CheckFailed$T(new Twine("Logical operators only work with integral types!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                    return;
                }
                if (B2.getType() == B2.getOperand(0).getType()) break;
                this.CheckFailed$T(new Twine("Logical operators must have same type for operands and result!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                return;
            }
            case 23: 
            case 24: 
            case 25: {
                if (!B2.getType().isIntOrIntVectorTy()) {
                    this.CheckFailed$T(new Twine("Shifts only work with integral types!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                    return;
                }
                if (B2.getType() == B2.getOperand(0).getType()) break;
                this.CheckFailed$T(new Twine("Shift return type must be same as operands!"), (BinaryOperator)Native.$AddrOf((Object)B2), new Object[0]);
                return;
            }
            default: {
                throw new llvm_unreachable("Unknown BinaryOperator opcode!");
            }
        }
        this.visitInstruction(B2);
    }

    @Override
    public void visitICmpInst(ICmpInst IC) {
        Type Op1Ty;
        Type Op0Ty = IC.getOperand(0).getType();
        if (Op0Ty != (Op1Ty = IC.getOperand(1).getType())) {
            this.CheckFailed$T(new Twine("Both operands to ICmp instruction are not of the same type!"), (ICmpInst)Native.$AddrOf((Object)IC), new Object[0]);
            return;
        }
        if (!Op0Ty.isIntOrIntVectorTy() && !Op0Ty.getScalarType().isPointerTy()) {
            this.CheckFailed$T(new Twine("Invalid operand types for ICmp instruction"), (ICmpInst)Native.$AddrOf((Object)IC), new Object[0]);
            return;
        }
        if (IC.getPredicate().getValue() < CmpInst.Predicate.FIRST_ICMP_PREDICATE.getValue() || IC.getPredicate().getValue() > CmpInst.Predicate.LAST_ICMP_PREDICATE.getValue()) {
            this.CheckFailed$T(new Twine("Invalid predicate in ICmp instruction!"), (ICmpInst)Native.$AddrOf((Object)IC), new Object[0]);
            return;
        }
        this.visitInstruction(IC);
    }

    @Override
    public void visitFCmpInst(FCmpInst FC) {
        Type Op1Ty;
        Type Op0Ty = FC.getOperand(0).getType();
        if (Op0Ty != (Op1Ty = FC.getOperand(1).getType())) {
            this.CheckFailed$T(new Twine("Both operands to FCmp instruction are not of the same type!"), (FCmpInst)Native.$AddrOf((Object)FC), new Object[0]);
            return;
        }
        if (!Op0Ty.isFPOrFPVectorTy()) {
            this.CheckFailed$T(new Twine("Invalid operand types for FCmp instruction"), (FCmpInst)Native.$AddrOf((Object)FC), new Object[0]);
            return;
        }
        if (FC.getPredicate().getValue() < CmpInst.Predicate.FIRST_FCMP_PREDICATE.getValue() || FC.getPredicate().getValue() > CmpInst.Predicate.LAST_FCMP_PREDICATE.getValue()) {
            this.CheckFailed$T(new Twine("Invalid predicate in FCmp instruction!"), (FCmpInst)Native.$AddrOf((Object)FC), new Object[0]);
            return;
        }
        this.visitInstruction(FC);
    }

    @Override
    public void visitExtractElementInst(ExtractElementInst EI) {
        if (!ExtractElementInst.isValidOperands(EI.getOperand(0), EI.getOperand(1))) {
            this.CheckFailed$T(new Twine("Invalid extractelement operands!"), (ExtractElementInst)Native.$AddrOf((Object)EI), new Object[0]);
            return;
        }
        this.visitInstruction(EI);
    }

    @Override
    public void visitInsertElementInst(InsertElementInst IE) {
        if (!InsertElementInst.isValidOperands(IE.getOperand(0), IE.getOperand(1), IE.getOperand(2))) {
            this.CheckFailed$T(new Twine("Invalid insertelement operands!"), (InsertElementInst)Native.$AddrOf((Object)IE), new Object[0]);
            return;
        }
        this.visitInstruction(IE);
    }

    @Override
    public void visitShuffleVectorInst(ShuffleVectorInst SV) {
        if (!ShuffleVectorInst.isValidOperands(SV.getOperand(0), SV.getOperand(1), SV.getOperand(2))) {
            this.CheckFailed$T(new Twine("Invalid shufflevector operands!"), (ShuffleVectorInst)Native.$AddrOf((Object)SV), new Object[0]);
            return;
        }
        this.visitInstruction(SV);
    }

    @Override
    public void visitVAArgInst(VAArgInst VAA) {
        this.visitInstruction(VAA);
    }

    @Override
    public void visitCallInst(CallInst CI) {
        this.verifyCallSite(new CallSite((CallInst)Native.$AddrOf((Object)CI)));
        if (CI.isMustTailCall()) {
            this.verifyMustTailCall(CI);
        }
    }

    @Override
    public void visitInvokeInst(InvokeInst II) {
        this.verifyCallSite(new CallSite((InvokeInst)Native.$AddrOf((Object)II)));
        if (!II.getUnwindDest().isEHPad()) {
            this.CheckFailed$T(new Twine("The unwind destination does not have an exception handling instruction!"), (InvokeInst)Native.$AddrOf((Object)II), new Object[0]);
            return;
        }
        this.visitTerminatorInst(II);
    }

    @Override
    public void visitGetElementPtrInst(GetElementPtrInst GEP) {
        Type TargetTy = GEP.getPointerOperandType().getScalarType();
        if (!IrRTTI.isa_PointerType(TargetTy)) {
            this.CheckFailed$T(new Twine("GEP base pointer is not a vector or a vector of pointers"), (GetElementPtrInst)Native.$AddrOf((Object)GEP), new Object[0]);
            return;
        }
        if (!GEP.getSourceElementType().isSized()) {
            this.CheckFailed$T(new Twine("GEP into unsized type!"), (GetElementPtrInst)Native.$AddrOf((Object)GEP), new Object[0]);
            return;
        }
        SmallVector Idxs = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 16, GEP.idx_begin(), GEP.idx_end(), (Object)null, U -> U.$Value$P());
        Type ElTy = GetElementPtrInst.getIndexedType_Type$P_ArrayRef$Value$P(GEP.getSourceElementType(), (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)Idxs, true));
        if (ElTy == null) {
            this.CheckFailed$T(new Twine("Invalid indices for GEP pointer type!"), (GetElementPtrInst)Native.$AddrOf((Object)GEP), new Object[0]);
            return;
        }
        if (!GEP.getType().getScalarType().isPointerTy() || GEP.getResultElementType() != ElTy) {
            this.CheckFailed$T(new Twine("GEP is not of right type for indices!"), (GetElementPtrInst)Native.$AddrOf((Object)GEP), ElTy);
            return;
        }
        if (GEP.getType().isVectorTy()) {
            int GEPWidth = GEP.getType().getVectorNumElements();
            if (GEP.getPointerOperandType().isVectorTy() && GEPWidth != GEP.getPointerOperandType().getVectorNumElements()) {
                this.CheckFailed$T(new Twine("Vector GEP result width doesn't match operand's"), (GetElementPtrInst)Native.$AddrOf((Object)GEP), new Object[0]);
                return;
            }
            for (Value Idx : Idxs) {
                int IndexWidth;
                Type IndexTy = Idx.getType();
                if (IndexTy.isVectorTy() && (IndexWidth = IndexTy.getVectorNumElements()) != GEPWidth) {
                    this.CheckFailed$T(new Twine("Invalid GEP index vector width"), (GetElementPtrInst)Native.$AddrOf((Object)GEP), new Object[0]);
                    return;
                }
                if (IndexTy.getScalarType().isIntegerTy()) continue;
                this.CheckFailed(new Twine("All GEP indices should be of integer type"));
                return;
            }
        }
        this.visitInstruction(GEP);
    }

    @Override
    public void visitLoadInst(LoadInst LI) {
        PointerType PTy = IrRTTI.dyn_cast_PointerType(LI.getOperand(0).getType());
        if (PTy == null) {
            this.CheckFailed$T(new Twine("Load operand must be a pointer."), (LoadInst)Native.$AddrOf((Object)LI), new Object[0]);
            return;
        }
        Type ElTy = LI.getType();
        if (!Unsigned.$lesseq_uint((int)LI.getAlignment(), (int)Value.MaximumAlignment)) {
            this.CheckFailed$T(new Twine("huge alignment values are unsupported"), (LoadInst)Native.$AddrOf((Object)LI), new Object[0]);
            return;
        }
        if (!ElTy.isSized()) {
            this.CheckFailed$T(new Twine("loading unsized types is not allowed"), (LoadInst)Native.$AddrOf((Object)LI), new Object[0]);
            return;
        }
        if (LI.isAtomic()) {
            if (LI.getOrdering() == AtomicOrdering.Release || LI.getOrdering() == AtomicOrdering.AcquireRelease) {
                this.CheckFailed$T(new Twine("Load cannot have Release ordering"), (LoadInst)Native.$AddrOf((Object)LI), new Object[0]);
                return;
            }
            if (LI.getAlignment() == 0) {
                this.CheckFailed$T(new Twine("Atomic load must specify explicit alignment"), (LoadInst)Native.$AddrOf((Object)LI), new Object[0]);
                return;
            }
            if (!(ElTy.isIntegerTy() || ElTy.isPointerTy() || ElTy.isFloatingPointTy())) {
                this.CheckFailed$T(new Twine("atomic load operand must have integer, pointer, or floating point type!"), ElTy, (LoadInst)Native.$AddrOf((Object)LI));
                return;
            }
            this.checkAtomicMemAccessSize(this.M, ElTy, (Instruction)Native.$AddrOf((Object)LI));
        } else if (LI.getSynchScope() != SynchronizationScope.CrossThread) {
            this.CheckFailed$T(new Twine("Non-atomic load cannot have SynchronizationScope specified"), (LoadInst)Native.$AddrOf((Object)LI), new Object[0]);
            return;
        }
        this.visitInstruction(LI);
    }

    @Override
    public void visitStoreInst(StoreInst SI) {
        PointerType PTy = IrRTTI.dyn_cast_PointerType(SI.getOperand(1).getType());
        if (PTy == null) {
            this.CheckFailed$T(new Twine("Store operand must be a pointer."), (StoreInst)Native.$AddrOf((Object)SI), new Object[0]);
            return;
        }
        Type ElTy = PTy.getElementType();
        if (ElTy != SI.getOperand(0).getType()) {
            this.CheckFailed$T(new Twine("Stored value type does not match pointer operand type!"), (StoreInst)Native.$AddrOf((Object)SI), ElTy);
            return;
        }
        if (!Unsigned.$lesseq_uint((int)SI.getAlignment(), (int)Value.MaximumAlignment)) {
            this.CheckFailed$T(new Twine("huge alignment values are unsupported"), (StoreInst)Native.$AddrOf((Object)SI), new Object[0]);
            return;
        }
        if (!ElTy.isSized()) {
            this.CheckFailed$T(new Twine("storing unsized types is not allowed"), (StoreInst)Native.$AddrOf((Object)SI), new Object[0]);
            return;
        }
        if (SI.isAtomic()) {
            if (SI.getOrdering() == AtomicOrdering.Acquire || SI.getOrdering() == AtomicOrdering.AcquireRelease) {
                this.CheckFailed$T(new Twine("Store cannot have Acquire ordering"), (StoreInst)Native.$AddrOf((Object)SI), new Object[0]);
                return;
            }
            if (SI.getAlignment() == 0) {
                this.CheckFailed$T(new Twine("Atomic store must specify explicit alignment"), (StoreInst)Native.$AddrOf((Object)SI), new Object[0]);
                return;
            }
            if (!(ElTy.isIntegerTy() || ElTy.isPointerTy() || ElTy.isFloatingPointTy())) {
                this.CheckFailed$T(new Twine("atomic store operand must have integer, pointer, or floating point type!"), ElTy, (StoreInst)Native.$AddrOf((Object)SI));
                return;
            }
            this.checkAtomicMemAccessSize(this.M, ElTy, (Instruction)Native.$AddrOf((Object)SI));
        } else if (SI.getSynchScope() != SynchronizationScope.CrossThread) {
            this.CheckFailed$T(new Twine("Non-atomic store cannot have SynchronizationScope specified"), (StoreInst)Native.$AddrOf((Object)SI), new Object[0]);
            return;
        }
        this.visitInstruction(SI);
    }

    private void verifyDominatesUse(Instruction I, int i) {
        Instruction Op = IrRTTI.cast_Instruction(I.getOperand(i));
        InvokeInst II = IrRTTI.dyn_cast_InvokeInst(Op);
        if (II != null && II.getNormalDest() == II.getUnwindDest()) {
            return;
        }
        if (!IrRTTI.isa_PHINode(I) && this.InstsInThisBlock.count((Object)Op) != 0) {
            return;
        }
        Use U = I.getOperandUse(i);
        if (!this.DT.dominates(Op, U)) {
            this.CheckFailed$T(new Twine("Instruction does not dominate all uses!"), Op, (Instruction)Native.$AddrOf((Object)I));
            return;
        }
    }

    @Override
    public void visitInstruction(Instruction I) {
        DbgInfoIntrinsic DII;
        MDNode N;
        MDNode AlignMD;
        MDNode Range;
        BasicBlock BB = I.getParent();
        if (BB == null) {
            this.CheckFailed$T(new Twine("Instruction not embedded in basic block!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!IrRTTI.isa_PHINode(I)) {
            for (Destructors.ClassWithDestructor U : I.users()) {
                if (U != (User)Native.$AddrOf((Object)I) || !this.DT.isReachableFromEntry(BB)) continue;
                this.CheckFailed$T(new Twine("Only PHI nodes may reference their own value!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
        }
        if (I.getType().isVoidTy() && I.hasName()) {
            this.CheckFailed$T(new Twine("Instruction has a name, but provides a void value!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (!I.getType().isVoidTy() && !I.getType().isFirstClassType()) {
            this.CheckFailed$T(new Twine("Instruction returns a non-scalar type!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        if (I.getType().isMetadataTy() && !IrRTTI.isa_CallInst(I) && !IrRTTI.isa_InvokeInst(I)) {
            this.CheckFailed$T(new Twine("Invalid use of metadata!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        for (Destructors.ClassWithDestructor U : I.uses()) {
            Instruction Used = IrRTTI.dyn_cast_Instruction(U.getUser());
            if (Used != null) {
                if (Used.getParent() != null) continue;
                this.CheckFailed$T(new Twine("Instruction referencing instruction not embedded in a basic block!"), (Instruction)Native.$AddrOf((Object)I), Used);
                return;
            }
            this.CheckFailed$T(new Twine("Use of instruction is not an instruction!"), U, new Object[0]);
            return;
        }
        int e = I.getNumOperands$User();
        for (int i = 0; i != e; ++i) {
            if (I.getOperand(i) == null) {
                this.CheckFailed$T(new Twine("Instruction has null operand!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            if (!I.getOperand(i).getType().isFirstClassType()) {
                this.CheckFailed$T(new Twine("Instruction operands must be first-class values!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            Function F = IrRTTI.dyn_cast_Function(I.getOperand(i));
            if (F != null) {
                if (F.isIntrinsic() && i != (IrRTTI.isa_CallInst(I) ? e - 1 : (IrRTTI.isa_InvokeInst(I) ? e - 3 : 0))) {
                    this.CheckFailed$T(new Twine("Cannot take the address of an intrinsic!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                    return;
                }
                if (F.isIntrinsic() && !IrRTTI.isa_CallInst(I) && F.getIntrinsicID() != 28 && F.getIntrinsicID() != 51 && F.getIntrinsicID() != 50 && F.getIntrinsicID() != 48) {
                    this.CheckFailed$T(new Twine("Cannot invoke an intrinsic other than donothing, patchpoint or statepoint"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                    return;
                }
                if (F.getParent() == this.M) continue;
                this.CheckFailed$T(new Twine("Referencing function in another module!"), (Instruction)Native.$AddrOf((Object)I), this.M, F, F.getParent());
                return;
            }
            BasicBlock OpBB = IrRTTI.dyn_cast_BasicBlock(I.getOperand(i));
            if (OpBB != null) {
                if (OpBB.getParent() == BB.getParent()) continue;
                this.CheckFailed$T(new Twine("Referring to a basic block in another function!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            Argument OpArg = IrRTTI.dyn_cast_Argument(I.getOperand(i));
            if (OpArg != null) {
                if (OpArg.getParent() == BB.getParent()) continue;
                this.CheckFailed$T(new Twine("Referring to an argument in another function!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(I.getOperand(i));
            if (GV != null) {
                if (GV.getParent() == this.M) continue;
                this.CheckFailed$T(new Twine("Referencing global in another module!"), (Instruction)Native.$AddrOf((Object)I), this.M, GV, GV.getParent());
                return;
            }
            if (IrRTTI.isa_Instruction(I.getOperand(i))) {
                this.verifyDominatesUse(I, i);
                continue;
            }
            if (IrRTTI.isa_InlineAsm(I.getOperand(i))) {
                if (i + 1 == e && IrRTTI.isa_CallInst(I) || i + 3 == e && IrRTTI.isa_InvokeInst(I)) continue;
                this.CheckFailed$T(new Twine("Cannot take the address of an inline asm!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(I.getOperand(i));
            if (CE == null || !CE.getType().isPtrOrPtrVectorTy()) continue;
            this.visitConstantExprsRecursively(CE);
        }
        MDNode MD = I.getMetadata(LLVMContext.Unnamed_enum.MD_fpmath.getValue());
        if (MD != null) {
            if (!I.getType().isFPOrFPVectorTy()) {
                this.CheckFailed$T(new Twine("fpmath requires a floating point result!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            if (MD.getNumOperands() != 1) {
                this.CheckFailed$T(new Twine("fpmath takes one operand!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            ConstantFP CFP0 = MdconstGlobals.dyn_extract_or_null$ValidPointer(ConstantFP.class, MD.getOperand(0));
            if (CFP0 != null) {
                APFloat Accuracy = CFP0.getValueAPF();
                if (Native.$AddrOf((Object)Accuracy.getSemantics()) != Native.$AddrOf((Object)APFloat.IEEEsingle)) {
                    this.CheckFailed$T(new Twine("fpmath accuracy must have float type"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                    return;
                }
                if (!Accuracy.isFiniteNonZero() || Accuracy.isNegative()) {
                    this.CheckFailed$T(new Twine("fpmath accuracy not a positive number!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                    return;
                }
            } else {
                this.CheckFailed$T(new Twine("invalid fpmath accuracy!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
        }
        if ((Range = I.getMetadata(LLVMContext.Unnamed_enum.MD_range.getValue())) != null) {
            if (!(IrRTTI.isa_LoadInst(I) || IrRTTI.isa_CallInst(I) || IrRTTI.isa_InvokeInst(I))) {
                this.CheckFailed$T(new Twine("Ranges are only for loads, calls and invokes!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            this.visitRangeMetadata(I, Range, I.getType());
        }
        if (I.getMetadata(LLVMContext.Unnamed_enum.MD_nonnull.getValue()) != null) {
            if (!I.getType().isPointerTy()) {
                this.CheckFailed$T(new Twine("nonnull applies only to pointer types"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            if (!IrRTTI.isa_LoadInst(I)) {
                this.CheckFailed$T(new Twine("nonnull applies only to load instructions, use attributes for calls or invokes"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
        }
        if ((MD = I.getMetadata(LLVMContext.Unnamed_enum.MD_dereferenceable.getValue())) != null) {
            this.visitDereferenceableMetadata(I, MD);
        }
        if ((MD = I.getMetadata(LLVMContext.Unnamed_enum.MD_dereferenceable_or_null.getValue())) != null) {
            this.visitDereferenceableMetadata(I, MD);
        }
        if ((AlignMD = I.getMetadata(LLVMContext.Unnamed_enum.MD_align.getValue())) != null) {
            if (!I.getType().isPointerTy()) {
                this.CheckFailed$T(new Twine("align applies only to pointer types"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            if (!IrRTTI.isa_LoadInst(I)) {
                this.CheckFailed$T(new Twine("align applies only to load instructions, use attributes for calls or invokes"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            if (AlignMD.getNumOperands() != 1) {
                this.CheckFailed$T(new Twine("align takes one operand!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            ConstantInt CI = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, AlignMD.getOperand(0));
            if (CI == null || !CI.getType().isIntegerTy(64)) {
                this.CheckFailed$T(new Twine("align metadata value must be an i64!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            long Align = CI.getZExtValue();
            if (!llvm.isPowerOf2_64((long)Align)) {
                this.CheckFailed$T(new Twine("align metadata value must be a power of 2!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
            if (!Unsigned.$lesseq_ulong_uint((long)Align, (int)Value.MaximumAlignment)) {
                this.CheckFailed$T(new Twine("alignment is larger that implementation defined limit"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
                return;
            }
        }
        if ((N = I.getDebugLoc().getAsMDNode()) != null) {
            if (!IrRTTI.isa_DILocation(N)) {
                this.DebugInfoCheckFailed$T(new Twine("invalid !dbg metadata attachment"), (Instruction)Native.$AddrOf((Object)I), N);
                return;
            }
            this.visitMDNode((MDNode)Native.$Deref((Object)N));
        }
        if ((DII = IrRTTI.dyn_cast_DbgInfoIntrinsic((Instruction)Native.$AddrOf((Object)I))) != null) {
            this.verifyBitPieceExpression((DbgInfoIntrinsic)Native.$Deref((Object)DII));
        }
        this.InstsInThisBlock.insert((Object)((Instruction)Native.$AddrOf((Object)I)));
    }

    @Override
    public void visitTerminatorInst(TerminatorInst I) {
        if (Native.$AddrOf((Object)I) != I.getParent().getTerminator()) {
            this.CheckFailed$T(new Twine("Terminator found in the middle of a basic block!"), I.getParent(), new Object[0]);
            return;
        }
        this.visitInstruction(I);
    }

    @Override
    public void visitBranchInst(BranchInst BI) {
        if (BI.isConditional() && !BI.getCondition().getType().isIntegerTy(1)) {
            this.CheckFailed$T(new Twine("Branch condition is not 'i1' type!"), (BranchInst)Native.$AddrOf((Object)BI), BI.getCondition());
            return;
        }
        this.visitTerminatorInst(BI);
    }

    @Override
    public void visitReturnInst(ReturnInst RI) {
        Function F = RI.getParent().getParent();
        int N = RI.getNumOperands();
        if (F.getReturnType().isVoidTy()) {
            if (N != 0) {
                this.CheckFailed$T(new Twine("Found return instr that returns non-void in Function of void return type!"), (ReturnInst)Native.$AddrOf((Object)RI), F.getReturnType());
                return;
            }
        } else if (N != 1 || F.getReturnType() != RI.getOperand(0).getType()) {
            this.CheckFailed$T(new Twine("Function return type does not match operand type of return inst!"), (ReturnInst)Native.$AddrOf((Object)RI), F.getReturnType());
            return;
        }
        this.visitTerminatorInst(RI);
    }

    @Override
    public void visitSwitchInst(SwitchInst SI) {
        Type SwitchTy = SI.getCondition().getType();
        SmallPtrSet Constants = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 32);
        for (SwitchInst.CaseIteratorT Case : SI.cases()) {
            if (((ConstantInt)Case.getCaseValue()).getType() != SwitchTy) {
                this.CheckFailed$T(new Twine("Switch constants must all be same type as switch value!"), (SwitchInst)Native.$AddrOf((Object)SI), new Object[0]);
                return;
            }
            if (Constants.insert((Object)((ConstantInt)Case.getCaseValue())).second) continue;
            this.CheckFailed$T(new Twine("Duplicate integer as switch case"), (SwitchInst)Native.$AddrOf((Object)SI), (ConstantInt)Case.getCaseValue());
            return;
        }
        this.visitTerminatorInst(SI);
    }

    @Override
    public void visitIndirectBrInst(IndirectBrInst BI) {
        if (!BI.getAddress().getType().isPointerTy()) {
            this.CheckFailed$T(new Twine("Indirectbr operand must have pointer type!"), (IndirectBrInst)Native.$AddrOf((Object)BI), new Object[0]);
            return;
        }
        int e = BI.getNumDestinations();
        for (int i = 0; i != e; ++i) {
            if (BI.getDestination(i).getType().isLabelTy()) continue;
            this.CheckFailed$T(new Twine("Indirectbr destinations must all have pointer type!"), (IndirectBrInst)Native.$AddrOf((Object)BI), new Object[0]);
            return;
        }
        this.visitTerminatorInst(BI);
    }

    @Override
    public void visitSelectInst(SelectInst SI) {
        if (Native.$bool((Native.Native$Bool)SelectInst.areInvalidOperands(SI.getOperand(0), SI.getOperand(1), SI.getOperand(2)))) {
            this.CheckFailed$T(new Twine("Invalid operands for select instruction!"), (SelectInst)Native.$AddrOf((Object)SI), new Object[0]);
            return;
        }
        if (SI.getTrueValue().getType() != SI.getType()) {
            this.CheckFailed$T(new Twine("Select values must have same type as select instruction!"), (SelectInst)Native.$AddrOf((Object)SI), new Object[0]);
            return;
        }
        this.visitInstruction(SI);
    }

    @Override
    public void visitUserOp1(Instruction I) {
        this.CheckFailed$T(new Twine("User-defined operators should not live outside of a pass!"), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
    }

    @Override
    public void visitUserOp2(Instruction I) {
        this.visitUserOp1(I);
    }

    private void visitIntrinsicCallSite(int _ID, CallSite CS) {
        Function IF = (Function)CS.getCalledFunction();
        if (!IF.isDeclaration()) {
            this.CheckFailed$T(new Twine("Intrinsic functions should never be defined!"), IF, new Object[0]);
            return;
        }
        FunctionType IFTy = IF.getFunctionType();
        boolean IsVarArg = IFTy.isVarArg();
        SmallVector Table = new SmallVector(8, (Object)new IITDescriptor());
        IntrinsicGlobals.getIntrinsicInfoTableEntries(_ID, (SmallVectorImpl<IITDescriptor>)Table);
        ArrayRef TableRef = new ArrayRef((SmallVectorImplCommon)Table, false);
        SmallVector ArgTys = new SmallVector(4, (Object)null);
        if (IntrinsicGlobals.matchIntrinsicType(IFTy.getReturnType(), (ArrayRef<IITDescriptor>)TableRef, (SmallVectorImpl<Type>)ArgTys)) {
            this.CheckFailed$T(new Twine("Intrinsic has incorrect return type!"), IF, new Object[0]);
            return;
        }
        int e = IFTy.getNumParams();
        for (int i = 0; i != e; ++i) {
            if (!IntrinsicGlobals.matchIntrinsicType(IFTy.getParamType(i), (ArrayRef<IITDescriptor>)TableRef, (SmallVectorImpl<Type>)ArgTys)) continue;
            this.CheckFailed$T(new Twine("Intrinsic has incorrect argument type!"), IF, new Object[0]);
            return;
        }
        if (IsVarArg) {
            if (IntrinsicGlobals.matchIntrinsicVarArg(IsVarArg, (ArrayRef<IITDescriptor>)TableRef)) {
                this.CheckFailed$T(new Twine("Intrinsic was not defined with variable arguments!"), IF, new Object[0]);
                return;
            }
        } else if (IntrinsicGlobals.matchIntrinsicVarArg(IsVarArg, (ArrayRef<IITDescriptor>)TableRef)) {
            this.CheckFailed$T(new Twine("Callsite was not defined with variable arguments!"), IF, new Object[0]);
            return;
        }
        if (!TableRef.empty()) {
            this.CheckFailed$T(new Twine("Intrinsic has too few arguments!"), IF, new Object[0]);
            return;
        }
        std.string ExpectedName = IntrinsicGlobals.getName(_ID, (ArrayRef<Type>)new ArrayRef((SmallVectorImplCommon)ArgTys, true));
        if (!llvm.$eq_StringRef((StringRef)new StringRef(ExpectedName), (StringRef)IF.getName())) {
            this.CheckFailed$T(new Twine(std.$add_T$C$P_string$C((String)"Intrinsic name not mangled correctly for type arguments! Should be: ", (std.string)ExpectedName)), IF, new Object[0]);
            return;
        }
        for (Use U : CS.args()) {
            Value V = U.$Value$P();
            MetadataAsValue MD = IrRTTI.dyn_cast_MetadataAsValue(V);
            if (MD == null) continue;
            this.visitMetadataAsValue((MetadataAsValue)Native.$Deref((Object)MD), (Function)CS.getCaller());
        }
        switch (_ID) {
            default: {
                break;
            }
            case 22: 
            case 24: {
                if (IrRTTI.isa_ConstantInt(CS.getArgOperand(1))) break;
                this.CheckFailed$T(new Twine("is_zero_undef argument of bit counting intrinsics must be a constant int"), CS, new Object[0]);
                return;
            }
            case 25: {
                if (!IrRTTI.isa_MetadataAsValue(CS.getArgOperand(0))) {
                    this.CheckFailed$T(new Twine("invalid llvm.dbg.declare intrinsic call 1"), CS, new Object[0]);
                    return;
                }
                this.visitDbgIntrinsic(new StringRef("declare"), IrRTTI.cast_DbgDeclareInst((Instruction)Native.$Deref(CS.getInstruction())));
                break;
            }
            case 26: {
                this.visitDbgIntrinsic(new StringRef("value"), IrRTTI.cast_DbgValueInst((Instruction)Native.$Deref(CS.getInstruction())));
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                ConstantInt AlignCI = IrRTTI.dyn_cast_ConstantInt(CS.getArgOperand(3));
                if (AlignCI == null) {
                    this.CheckFailed$T(new Twine("alignment argument of memory intrinsics must be a constant int"), CS, new Object[0]);
                    return;
                }
                APInt AlignVal = AlignCI.getValue();
                if (!AlignCI.isZero() && !AlignVal.isPowerOf2()) {
                    this.CheckFailed$T(new Twine("alignment argument of memory intrinsics must be a power of 2"), CS, new Object[0]);
                    return;
                }
                if (IrRTTI.isa_ConstantInt(CS.getArgOperand(4))) break;
                this.CheckFailed$T(new Twine("isvolatile argument of memory intrinsics must be a constant int"), CS, new Object[0]);
                return;
            }
            case 59: 
            case 60: 
            case 61: {
                if (_ID == 60) {
                    AllocaInst AI = IrRTTI.dyn_cast_AllocaInst(((Value)CS.getArgOperand(0)).stripPointerCasts());
                    if (AI == null) {
                        this.CheckFailed$T(new Twine("llvm.gcroot parameter #1 must be an alloca."), CS, new Object[0]);
                        return;
                    }
                    if (!IrRTTI.isa_Constant(CS.getArgOperand(1))) {
                        this.CheckFailed$T(new Twine("llvm.gcroot parameter #2 must be a constant."), CS, new Object[0]);
                        return;
                    }
                    if (!AI.getAllocatedType().isPointerTy() && IrRTTI.isa_ConstantPointerNull(CS.getArgOperand(1))) {
                        this.CheckFailed$T(new Twine("llvm.gcroot parameter #1 must either be a pointer alloca, or argument #2 must be a non-null constant."), CS, new Object[0]);
                        return;
                    }
                }
                if (((BasicBlock)CS.getParent()).getParent().hasGC()) break;
                this.CheckFailed$T(new Twine("Enclosing function does not use GC."), CS, new Object[0]);
                return;
            }
            case 63: {
                if (IrRTTI.isa_Function(((Value)CS.getArgOperand(1)).stripPointerCasts())) break;
                this.CheckFailed$T(new Twine("llvm.init_trampoline parameter #2 must resolve to a function."), CS, new Object[0]);
                return;
            }
            case 93: {
                if (IrRTTI.isa_ConstantInt(CS.getArgOperand(1)) && IrRTTI.isa_ConstantInt(CS.getArgOperand(2)) && Unsigned.$less_ulong_ullong((long)IrRTTI.cast_ConstantInt(CS.getArgOperand(1)).getZExtValue(), (long)Unsigned.$int2ullong((int)2)) && Unsigned.$less_ulong_ullong((long)IrRTTI.cast_ConstantInt(CS.getArgOperand(2)).getZExtValue(), (long)Unsigned.$int2ullong((int)4))) break;
                this.CheckFailed$T(new Twine("invalid arguments to llvm.prefetch"), CS, new Object[0]);
                return;
            }
            case 109: {
                if (IrRTTI.isa_AllocaInst(((Value)CS.getArgOperand(1)).stripPointerCasts())) break;
                this.CheckFailed$T(new Twine("llvm.stackprotector parameter #2 must resolve to an alloca."), CS, new Object[0]);
                return;
            }
            case 68: 
            case 69: 
            case 70: {
                if (IrRTTI.isa_ConstantInt(CS.getArgOperand(0))) break;
                this.CheckFailed$T(new Twine("size argument of memory use markers must be a constant integer"), CS, new Object[0]);
                return;
            }
            case 66: {
                if (IrRTTI.isa_ConstantInt(CS.getArgOperand(1))) break;
                this.CheckFailed$T(new Twine("llvm.invariant.end parameter #2 must be a constant integer"), CS, new Object[0]);
                return;
            }
            case 73: {
                Object BB = CS.getParent();
                if (BB != Native.$AddrOf((Object)((BasicBlock)BB).getParent().front())) {
                    this.CheckFailed$T(new Twine("llvm.localescape used outside of entry block"), CS, new Object[0]);
                    return;
                }
                if (this.SawFrameEscape) {
                    this.CheckFailed$T(new Twine("multiple calls to llvm.localescape in one function"), CS, new Object[0]);
                    return;
                }
                for (Use U : CS.args()) {
                    AllocaInst AI;
                    Value Arg = U.$Value$P();
                    if (IrRTTI.isa_ConstantPointerNull(Arg) || (AI = IrRTTI.dyn_cast_AllocaInst(Arg.stripPointerCasts())) != null && AI.isStaticAlloca()) continue;
                    this.CheckFailed$T(new Twine("llvm.localescape only accepts static allocas"), CS, new Object[0]);
                    return;
                }
                ((std_pair.pairUIntUInt)this.FrameEscapeInfo.$at_T1$RR((Object)((BasicBlock)BB).getParent())).first = CS.getNumArgOperands();
                this.SawFrameEscape = true;
                break;
            }
            case 74: {
                Value FnArg = ((Value)CS.getArgOperand(0)).stripPointerCasts();
                Function Fn = IrRTTI.dyn_cast_Function(FnArg);
                if (Fn == null || Fn.isDeclaration()) {
                    this.CheckFailed$T(new Twine("llvm.localrecover first argument must be function defined in this module"), CS, new Object[0]);
                    return;
                }
                ConstantInt IdxArg = IrRTTI.dyn_cast_ConstantInt(CS.getArgOperand(2));
                if (IdxArg == null) {
                    this.CheckFailed$T(new Twine("idx argument of llvm.localrecover must be a constant int"), CS, new Object[0]);
                    return;
                }
                std_pair.pairUIntUInt Entry2 = (std_pair.pairUIntUInt)this.FrameEscapeInfo.$at_T1$C$R((Object)Fn);
                Entry2.second = Unsigned.$ullong2uint((long)std.max((long)Unsigned.$uint2ulong((int)Entry2.second), (long)(IdxArg.getLimitedValue(Unsigned.$uint2ulong((int)-1)) + Unsigned.$int2ullong((int)1))));
                break;
            }
            case 48: {
                if (CS.isInlineAsm()) {
                    this.CheckFailed$T(new Twine("gc.statepoint support for inline assembly unimplemented"), CS, new Object[0]);
                    return;
                }
                if (!((BasicBlock)CS.getParent()).getParent().hasGC()) {
                    this.CheckFailed$T(new Twine("Enclosing function does not use GC."), CS, new Object[0]);
                    return;
                }
                this.verifyStatepoint(new ImmutableCallSite(new CallSite(CS)));
                break;
            }
            case 47: {
                Function StatepointFn;
                if (!((BasicBlock)CS.getParent()).getParent().hasGC()) {
                    this.CheckFailed$T(new Twine("Enclosing function does not use GC."), CS, new Object[0]);
                    return;
                }
                CallSiteBase StatepointCS = new CallSite((Value)CS.getArgOperand(0));
                Function function = StatepointFn = StatepointCS.getInstruction() != null ? (Function)StatepointCS.getCalledFunction() : null;
                if (StatepointFn == null || !StatepointFn.isDeclaration() || StatepointFn.getIntrinsicID() != 48) {
                    this.CheckFailed$T(new Twine("gc.result operand #1 must be from a statepoint"), CS, CS.getArgOperand(0));
                    return;
                }
                Object Target = StatepointCS.getArgument(2);
                PointerType PT = IrRTTI.cast_PointerType(((Value)Target).getType());
                FunctionType TargetFuncType = IrRTTI.cast_FunctionType(PT.getElementType());
                if (CS.getType() == TargetFuncType.getReturnType()) break;
                this.CheckFailed$T(new Twine("gc.result result type does not match wrapped callee"), CS, new Object[0]);
                return;
            }
            case 46: {
                if (CS.getNumArgOperands() != 3) {
                    this.CheckFailed$T(new Twine("wrong number of arguments"), CS, new Object[0]);
                    return;
                }
                if (!IrRTTI.isa_PointerType(CS.getType().getScalarType())) {
                    this.CheckFailed$T(new Twine("gc.relocate must return a pointer or a vector of pointers"), CS, new Object[0]);
                    return;
                }
                LandingPadInst LandingPad = IrRTTI.dyn_cast_LandingPadInst(CS.getArgOperand(0));
                if (LandingPad != null) {
                    BasicBlock InvokeBB = LandingPad.getParent().getUniquePredecessor();
                    if (InvokeBB == null) {
                        this.CheckFailed$T(new Twine("safepoints should have unique landingpads"), LandingPad.getParent(), new Object[0]);
                        return;
                    }
                    if (InvokeBB.getTerminator$Const() == null) {
                        this.CheckFailed$T(new Twine("safepoint block should be well formed"), InvokeBB, new Object[0]);
                        return;
                    }
                    if (!IrLlvmGlobals.isStatepoint_Value$C$P(InvokeBB.getTerminator$Const())) {
                        this.CheckFailed$T(new Twine("gc relocate should be linked to a statepoint"), InvokeBB, new Object[0]);
                        return;
                    }
                } else {
                    Object Token = CS.getArgOperand(0);
                    if (!IrRTTI.isa_Instruction(Token) || !IrLlvmGlobals.isStatepoint_Value$C$P(IrRTTI.cast_Instruction(Token))) {
                        this.CheckFailed$T(new Twine("gc relocate is incorrectly tied to the statepoint"), CS, Token);
                        return;
                    }
                }
                CallSiteBase StatepointCS = new ImmutableCallSite(IrRTTI.cast_GCRelocateInst((Instruction)Native.$Deref(CS.getInstruction())).getStatepoint());
                Object Base = CS.getArgOperand(1);
                if (!IrRTTI.isa_ConstantInt(Base)) {
                    this.CheckFailed$T(new Twine("gc.relocate operand #2 must be integer offset"), CS, new Object[0]);
                    return;
                }
                Object Derived = CS.getArgOperand(2);
                if (!IrRTTI.isa_ConstantInt(Derived)) {
                    this.CheckFailed$T(new Twine("gc.relocate operand #3 must be integer offset"), CS, new Object[0]);
                    return;
                }
                int BaseIndex = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(Base).getZExtValue());
                int DerivedIndex = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(Derived).getZExtValue());
                if (0 > BaseIndex || BaseIndex >= StatepointCS.arg_size()) {
                    this.CheckFailed$T(new Twine("gc.relocate: statepoint base index out of bounds"), CS, new Object[0]);
                    return;
                }
                if (0 > DerivedIndex || DerivedIndex >= StatepointCS.arg_size()) {
                    this.CheckFailed$T(new Twine("gc.relocate: statepoint derived index out of bounds"), CS, new Object[0]);
                    return;
                }
                if (!Unsigned.$greater_uint((int)StatepointCS.arg_size(), (int)0)) {
                    this.CheckFailed(new Twine("gc.statepoint: insufficient arguments"));
                    return;
                }
                if (!IrRTTI.isa_ConstantInt(StatepointCS.getArgument(3))) {
                    this.CheckFailed(new Twine("gc.statement: number of call arguments must be constant integer"));
                    return;
                }
                int NumCallArgs = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(StatepointCS.getArgument(3)).getZExtValue());
                if (!Unsigned.$greater_uint((int)StatepointCS.arg_size(), (int)(NumCallArgs + 5))) {
                    this.CheckFailed(new Twine("gc.statepoint: mismatch in number of call arguments"));
                    return;
                }
                if (!IrRTTI.isa_ConstantInt(StatepointCS.getArgument(NumCallArgs + 5))) {
                    this.CheckFailed(new Twine("gc.statepoint: number of transition arguments must be a constant integer"));
                    return;
                }
                int NumTransitionArgs = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(StatepointCS.getArgument(NumCallArgs + 5)).getZExtValue());
                int DeoptArgsStart = 4 + NumCallArgs + 1 + NumTransitionArgs + 1;
                if (!IrRTTI.isa_ConstantInt(StatepointCS.getArgument(DeoptArgsStart))) {
                    this.CheckFailed(new Twine("gc.statepoint: number of deoptimization arguments must be a constant integer"));
                    return;
                }
                int NumDeoptArgs = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(StatepointCS.getArgument(DeoptArgsStart)).getZExtValue());
                int GCParamArgsStart = DeoptArgsStart + 1 + NumDeoptArgs;
                int GCParamArgsEnd = StatepointCS.arg_size();
                if (GCParamArgsStart > BaseIndex || BaseIndex >= GCParamArgsEnd) {
                    this.CheckFailed$T(new Twine("gc.relocate: statepoint base index doesn't fall within the 'gc parameters' section of the statepoint call"), CS, new Object[0]);
                    return;
                }
                if (GCParamArgsStart > DerivedIndex || DerivedIndex >= GCParamArgsEnd) {
                    this.CheckFailed$T(new Twine("gc.relocate: statepoint derived index doesn't fall within the 'gc parameters' section of the statepoint call"), CS, new Object[0]);
                    return;
                }
                GCRelocateInst Relocate = IrRTTI.cast_GCRelocateInst((Instruction)Native.$Deref(CS.getInstruction()));
                if (!Relocate.getDerivedPtr().getType().getScalarType().isPointerTy()) {
                    this.CheckFailed$T(new Twine("gc.relocate: relocated value must be a gc pointer"), CS, new Object[0]);
                    return;
                }
                Type ResultType = CS.getType();
                Type DerivedType = Relocate.getDerivedPtr().getType();
                if (ResultType.isVectorTy() != DerivedType.isVectorTy()) {
                    this.CheckFailed$T(new Twine("gc.relocate: vector relocates to vector and pointer to pointer"), CS, new Object[0]);
                    return;
                }
                if (ResultType.getPointerAddressSpace() == DerivedType.getPointerAddressSpace()) break;
                this.CheckFailed$T(new Twine("gc.relocate: relocating a pointer shouldn't change its address space"), CS, new Object[0]);
                return;
            }
            case 30: 
            case 31: {
                if (IrRTTI.isa_CatchPadInst(CS.getArgOperand(0))) break;
                this.CheckFailed$T(new Twine("eh.exceptionpointer argument must be a catchpad"), CS, new Object[0]);
                return;
            }
            case 80: {
                if (!CS.getType().isVectorTy()) {
                    this.CheckFailed$T(new Twine("masked_load: must return a vector"), CS, new Object[0]);
                    return;
                }
                Object Ptr = CS.getArgOperand(0);
                Object Mask = CS.getArgOperand(2);
                Object PassThru = CS.getArgOperand(3);
                if (!((Value)Mask).getType().isVectorTy()) {
                    this.CheckFailed$T(new Twine("masked_load: mask must be vector"), CS, new Object[0]);
                    return;
                }
                Type DataTy = IrRTTI.cast_PointerType(((Value)Ptr).getType()).getElementType();
                if (DataTy != CS.getType()) {
                    this.CheckFailed$T(new Twine("masked_load: return must match pointer type"), CS, new Object[0]);
                    return;
                }
                if (((Value)PassThru).getType() != DataTy) {
                    this.CheckFailed$T(new Twine("masked_load: pass through and data type must match"), CS, new Object[0]);
                    return;
                }
                if (((Value)Mask).getType().getVectorNumElements() == DataTy.getVectorNumElements()) break;
                this.CheckFailed$T(new Twine("masked_load: vector mask must be same length as data"), CS, new Object[0]);
                return;
            }
            case 82: {
                Object Val = CS.getArgOperand(0);
                Object Ptr = CS.getArgOperand(1);
                Object Mask = CS.getArgOperand(3);
                if (!((Value)Mask).getType().isVectorTy()) {
                    this.CheckFailed$T(new Twine("masked_store: mask must be vector"), CS, new Object[0]);
                    return;
                }
                Type DataTy = IrRTTI.cast_PointerType(((Value)Ptr).getType()).getElementType();
                if (DataTy != ((Value)Val).getType()) {
                    this.CheckFailed$T(new Twine("masked_store: storee must match pointer type"), CS, new Object[0]);
                    return;
                }
                if (((Value)Mask).getType().getVectorNumElements() == DataTy.getVectorNumElements()) break;
                this.CheckFailed$T(new Twine("masked_store: vector mask must be same length as data"), CS, new Object[0]);
                return;
            }
            case 49: {
                if (!CS.isCall()) {
                    this.CheckFailed$T(new Twine("experimental_guard cannot be invoked"), CS, new Object[0]);
                    return;
                }
                if (CS.countOperandBundlesOfType(LLVMContext.Unnamed_enum1.OB_deopt.getValue()) == 1) break;
                this.CheckFailed(new Twine("experimental_guard must have exactly one \"deopt\" operand bundle"));
                return;
            }
            case 45: {
                if (!CS.isCall()) {
                    this.CheckFailed$T(new Twine("experimental_deoptimize cannot be invoked"), CS, new Object[0]);
                    return;
                }
                if (CS.countOperandBundlesOfType(LLVMContext.Unnamed_enum1.OB_deopt.getValue()) != 1) {
                    this.CheckFailed(new Twine("experimental_deoptimize must have exactly one \"deopt\" operand bundle"));
                    return;
                }
                if (CS.getType() != ((Instruction)CS.getInstruction()).getFunction().getReturnType()) {
                    this.CheckFailed(new Twine("experimental_deoptimize return type must match caller return type"));
                    return;
                }
                if (!CS.isCall()) break;
                Object DeoptCI = CS.getInstruction();
                ReturnInst RI = IrRTTI.dyn_cast_ReturnInst((Instruction)DeoptCI.getNextNode());
                if (RI == null) {
                    this.CheckFailed(new Twine("calls to experimental_deoptimize must be followed by a return"));
                    return;
                }
                if (CS.getType().isVoidTy() || RI == null || RI.getReturnValue() == DeoptCI) break;
                this.CheckFailed(new Twine("calls to experimental_deoptimize must be followed by a return of the value computed by experimental_deoptimize"));
                return;
            }
        }
    }

    private <DbgIntrinsicTy extends DbgInfoIntrinsic> void visitDbgIntrinsic(StringRef Kind2, DbgIntrinsicTy DII) {
        Metadata MD = IrRTTI.cast_MetadataAsValue(DII.getArgOperand(0)).getMetadata();
        if (Native.$not((Native.$bool((boolean)IrRTTI.isa_ValueAsMetadata(MD)) || Native.$bool((Native.$bool((boolean)IrRTTI.isa_MDNode(MD)) && Native.$not((int)IrRTTI.cast_MDNode(MD).getNumOperands()) ? 1 : 0) != 0) ? 1 : 0) != 0)) {
            this.DebugInfoCheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"invalid llvm.dbg.", (StringRef)Kind2), (Twine)new Twine(" intrinsic address/value")), (DbgInfoIntrinsic)Native.$AddrOf(DII), MD);
            return;
        }
        if (Native.$not((boolean)IrRTTI.isa_DILocalVariable(((IVariableAndExprOwner)((Object)DII)).getRawVariable()))) {
            this.DebugInfoCheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"invalid llvm.dbg.", (StringRef)Kind2), (Twine)new Twine(" intrinsic variable")), (DbgInfoIntrinsic)Native.$AddrOf(DII), ((IVariableAndExprOwner)((Object)DII)).getRawVariable());
            return;
        }
        if (Native.$not((boolean)IrRTTI.isa_DIExpression(((IVariableAndExprOwner)((Object)DII)).getRawExpression()))) {
            this.DebugInfoCheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"invalid llvm.dbg.", (StringRef)Kind2), (Twine)new Twine(" intrinsic expression")), (DbgInfoIntrinsic)Native.$AddrOf(DII), ((IVariableAndExprOwner)((Object)DII)).getRawExpression());
            return;
        }
        MDNode N = DII.getDebugLoc().getAsMDNode();
        if (N != null && !IrRTTI.isa_DILocation(N)) {
            return;
        }
        BasicBlock BB = DII.getParent();
        Function F = BB != null ? BB.getParent() : null;
        DILocalVariable Var = ((IVariableAndExprOwner)((Object)DII)).getVariable();
        DILocation Loc = DII.getDebugLoc().$DILocation$P();
        if (Loc == null) {
            this.CheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"llvm.dbg.", (StringRef)Kind2), (Twine)new Twine(" intrinsic requires a !dbg attachment")), (DbgInfoIntrinsic)Native.$AddrOf(DII), BB, F);
            return;
        }
        DISubprogram VarSP = VerifierStatics.getSubprogram(Var.getRawScope());
        DISubprogram LocSP = VerifierStatics.getSubprogram(Loc.getRawScope());
        if (VarSP == null || LocSP == null) {
            return;
        }
        if (VarSP != LocSP) {
            this.CheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"mismatched subprogram between llvm.dbg.", (StringRef)Kind2), (Twine)new Twine(" variable and !dbg attachment")), (DbgInfoIntrinsic)Native.$AddrOf(DII), BB, F, Var, Var.getScope().getSubprogram(), Loc, Loc.getScope().getSubprogram());
            return;
        }
    }

    @Override
    public void visitAtomicCmpXchgInst(AtomicCmpXchgInst CXI) {
        if (CXI.getSuccessOrdering() == AtomicOrdering.NotAtomic) {
            this.CheckFailed$T(new Twine("cmpxchg instructions must be atomic."), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        if (CXI.getFailureOrdering() == AtomicOrdering.NotAtomic) {
            this.CheckFailed$T(new Twine("cmpxchg instructions must be atomic."), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        if (CXI.getSuccessOrdering() == AtomicOrdering.Unordered) {
            this.CheckFailed$T(new Twine("cmpxchg instructions cannot be unordered."), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        if (CXI.getFailureOrdering() == AtomicOrdering.Unordered) {
            this.CheckFailed$T(new Twine("cmpxchg instructions cannot be unordered."), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        if (AdtsupportLlvmGlobals.isStrongerThan((AtomicOrdering)CXI.getFailureOrdering(), (AtomicOrdering)CXI.getSuccessOrdering())) {
            this.CheckFailed$T(new Twine("cmpxchg instructions failure argument shall be no stronger than the success argument"), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        if (CXI.getFailureOrdering() == AtomicOrdering.Release || CXI.getFailureOrdering() == AtomicOrdering.AcquireRelease) {
            this.CheckFailed$T(new Twine("cmpxchg failure ordering cannot include release semantics"), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        PointerType PTy = IrRTTI.dyn_cast_PointerType(CXI.getOperand(0).getType());
        if (PTy == null) {
            this.CheckFailed$T(new Twine("First cmpxchg operand must be a pointer."), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), new Object[0]);
            return;
        }
        Type ElTy = PTy.getElementType();
        if (!ElTy.isIntegerTy() && !ElTy.isPointerTy()) {
            this.CheckFailed$T(new Twine("cmpxchg operand must have integer or pointer type"), ElTy, (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI));
            return;
        }
        this.checkAtomicMemAccessSize(this.M, ElTy, (Instruction)Native.$AddrOf((Object)CXI));
        if (ElTy != CXI.getOperand(1).getType()) {
            this.CheckFailed$T(new Twine("Expected value type does not match pointer operand type!"), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), ElTy);
            return;
        }
        if (ElTy != CXI.getOperand(2).getType()) {
            this.CheckFailed$T(new Twine("Stored value type does not match pointer operand type!"), (AtomicCmpXchgInst)Native.$AddrOf((Object)CXI), ElTy);
            return;
        }
        this.visitInstruction(CXI);
    }

    @Override
    public void visitAtomicRMWInst(AtomicRMWInst RMWI) {
        if (RMWI.getOrdering() == AtomicOrdering.NotAtomic) {
            this.CheckFailed$T(new Twine("atomicrmw instructions must be atomic."), (AtomicRMWInst)Native.$AddrOf((Object)RMWI), new Object[0]);
            return;
        }
        if (RMWI.getOrdering() == AtomicOrdering.Unordered) {
            this.CheckFailed$T(new Twine("atomicrmw instructions cannot be unordered."), (AtomicRMWInst)Native.$AddrOf((Object)RMWI), new Object[0]);
            return;
        }
        PointerType PTy = IrRTTI.dyn_cast_PointerType(RMWI.getOperand(0).getType());
        if (PTy == null) {
            this.CheckFailed$T(new Twine("First atomicrmw operand must be a pointer."), (AtomicRMWInst)Native.$AddrOf((Object)RMWI), new Object[0]);
            return;
        }
        Type ElTy = PTy.getElementType();
        if (!ElTy.isIntegerTy()) {
            this.CheckFailed$T(new Twine("atomicrmw operand must have integer type!"), (AtomicRMWInst)Native.$AddrOf((Object)RMWI), ElTy);
            return;
        }
        this.checkAtomicMemAccessSize(this.M, ElTy, (Instruction)Native.$AddrOf((Object)RMWI));
        if (ElTy != RMWI.getOperand(1).getType()) {
            this.CheckFailed$T(new Twine("Argument value type does not match pointer operand type!"), (AtomicRMWInst)Native.$AddrOf((Object)RMWI), ElTy);
            return;
        }
        if (AtomicRMWInst.BinOp.FIRST_BINOP.getValue() > RMWI.getOperation().getValue() || RMWI.getOperation().getValue() > AtomicRMWInst.BinOp.LAST_BINOP.getValue()) {
            this.CheckFailed$T(new Twine("Invalid binary operation!"), (AtomicRMWInst)Native.$AddrOf((Object)RMWI), new Object[0]);
            return;
        }
        this.visitInstruction(RMWI);
    }

    @Override
    public void visitFenceInst(FenceInst FI) {
        AtomicOrdering Ordering = FI.getOrdering();
        if (Ordering != AtomicOrdering.Acquire && Ordering != AtomicOrdering.Release && Ordering != AtomicOrdering.AcquireRelease && Ordering != AtomicOrdering.SequentiallyConsistent) {
            this.CheckFailed$T(new Twine("fence instructions may only have acquire, release, acq_rel, or seq_cst ordering."), (FenceInst)Native.$AddrOf((Object)FI), new Object[0]);
            return;
        }
        this.visitInstruction(FI);
    }

    @Override
    public void visitAllocaInst(AllocaInst AI) {
        SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
        PointerType PTy = AI.getType();
        if (PTy.getAddressSpace() != 0) {
            this.CheckFailed$T(new Twine("Allocation instruction pointer not in the generic address space!"), (AllocaInst)Native.$AddrOf((Object)AI), new Object[0]);
            return;
        }
        if (!AI.getAllocatedType().isSized((SmallPtrSetImpl<Type>)((SmallPtrSetImpl)Native.$AddrOf((Object)Visited)))) {
            this.CheckFailed$T(new Twine("Cannot allocate unsized type"), (AllocaInst)Native.$AddrOf((Object)AI), new Object[0]);
            return;
        }
        if (!AI.getArraySize().getType().isIntegerTy()) {
            this.CheckFailed$T(new Twine("Alloca array size must have integer type"), (AllocaInst)Native.$AddrOf((Object)AI), new Object[0]);
            return;
        }
        if (!Unsigned.$lesseq_uint((int)AI.getAlignment(), (int)Value.MaximumAlignment)) {
            this.CheckFailed$T(new Twine("huge alignment values are unsupported"), (AllocaInst)Native.$AddrOf((Object)AI), new Object[0]);
            return;
        }
        if (AI.isSwiftError()) {
            this.verifySwiftErrorValue((Value)Native.$AddrOf((Object)AI));
        }
        this.visitInstruction(AI);
    }

    @Override
    public void visitExtractValueInst(ExtractValueInst EVI) {
        if (ExtractValueInst.getIndexedType(EVI.getAggregateOperand().getType(), EVI.getIndices()) != EVI.getType()) {
            this.CheckFailed$T(new Twine("Invalid ExtractValueInst operands!"), (ExtractValueInst)Native.$AddrOf((Object)EVI), new Object[0]);
            return;
        }
        this.visitInstruction(EVI);
    }

    @Override
    public void visitInsertValueInst(InsertValueInst IVI) {
        if (ExtractValueInst.getIndexedType(IVI.getAggregateOperand().getType(), IVI.getIndices()) != IVI.getOperand(1).getType()) {
            this.CheckFailed$T(new Twine("Invalid InsertValueInst operands!"), (InsertValueInst)Native.$AddrOf((Object)IVI), new Object[0]);
            return;
        }
        this.visitInstruction(IVI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitEHPadPredecessors(Instruction I) {
        Function F;
        assert (I.isEHPad());
        BasicBlock BB = I.getParent();
        if (BB == Native.$AddrOf((Object)(F = BB.getParent()).getEntryBlock())) {
            this.CheckFailed$T(new Twine("EH pad cannot be in entry block."), (Instruction)Native.$AddrOf((Object)I), new Object[0]);
            return;
        }
        LandingPadInst LPI = IrRTTI.dyn_cast_LandingPadInst((Instruction)Native.$AddrOf((Object)I));
        if (LPI != null) {
            for (BasicBlock PredBB : IrLlvmGlobals.predecessors_BasicBlock$P(BB)) {
                InvokeInst II = IrRTTI.dyn_cast_InvokeInst(PredBB.getTerminator());
                if (II != null && II.getUnwindDest() == BB && II.getNormalDest() != BB) continue;
                this.CheckFailed$T(new Twine("Block containing LandingPadInst must be jumped to only by the unwind edge of an invoke."), LPI, new Object[0]);
                return;
            }
            return;
        }
        CatchPadInst CPI = IrRTTI.dyn_cast_CatchPadInst((Instruction)Native.$AddrOf((Object)I));
        if (CPI != null) {
            if (!IrLlvmGlobals.pred_empty(BB) && BB.getUniquePredecessor() != CPI.getCatchSwitch().getParent()) {
                this.CheckFailed$T(new Twine("Block containg CatchPadInst must be jumped to only by its catchswitch."), CPI, new Object[0]);
                return;
            }
            if (BB == CPI.getCatchSwitch().getUnwindDest()) {
                this.CheckFailed$T(new Twine("Catchswitch cannot unwind to one of its catchpads"), CPI.getCatchSwitch(), CPI);
                return;
            }
            return;
        }
        Instruction ToPad = (Instruction)Native.$AddrOf((Object)I);
        Value ToPadParent = VerifierStatics.getParentPad(ToPad);
        block10: for (BasicBlock PredBB : IrLlvmGlobals.predecessors_BasicBlock$P(BB)) {
            SmallSetT.PLess.T.P Seen = null;
            try {
                Value FromPad;
                TerminatorInst TI = PredBB.getTerminator();
                InvokeInst II = IrRTTI.dyn_cast_InvokeInst(TI);
                if (II != null) {
                    if (II.getUnwindDest() != BB || II.getNormalDest() == BB) {
                        this.CheckFailed$T(new Twine("EH pad must be jumped to via an unwind edge"), ToPad, II);
                        return;
                    }
                    Optional Bundle = II.getOperandBundle(LLVMContext.Unnamed_enum1.OB_funclet.getValue());
                    FromPad = Bundle.$bool() ? ((Use)((OperandBundleUse)Bundle.$arrow()).Inputs.$at(0)).$Value$P() : ConstantTokenNone.get(II.getContext());
                } else {
                    CleanupReturnInst CRI = IrRTTI.dyn_cast_CleanupReturnInst(TI);
                    if (CRI != null) {
                        FromPad = CRI.getOperand(0);
                        if (FromPad == ToPadParent) {
                            this.CheckFailed$T(new Twine("A cleanupret must exit its cleanup"), CRI, new Object[0]);
                            return;
                        }
                    } else {
                        CatchSwitchInst CSI = IrRTTI.dyn_cast_CatchSwitchInst(TI);
                        if (CSI != null) {
                            FromPad = CSI;
                        } else {
                            this.CheckFailed$T(new Twine("EH pad must be jumped to via an unwind edge"), ToPad, TI);
                            return;
                        }
                    }
                }
                Seen = new SmallSetT.PLess.T.P(8);
                while (true) {
                    if (FromPad == ToPad) {
                        this.CheckFailed$T(new Twine("EH pad cannot handle exceptions raised within it"), FromPad, TI);
                        return;
                    }
                    if (FromPad == ToPadParent) continue block10;
                    if (IrRTTI.isa_ConstantTokenNone(FromPad)) {
                        this.CheckFailed$T(new Twine("A single unwind edge may only enter one EH pad"), TI, new Object[0]);
                        return;
                    }
                    if (!Seen.insert((Object)FromPad).second) {
                        this.CheckFailed$T(new Twine("EH pad jumps through a cycle of pads"), FromPad, new Object[0]);
                        return;
                    }
                    FromPad = VerifierStatics.getParentPad(FromPad);
                }
            }
            finally {
                if (Seen == null) continue;
                Seen.$destroy();
            }
        }
    }

    @Override
    public void visitLandingPadInst(LandingPadInst LPI) {
        if (!Unsigned.$greater_uint((int)LPI.getNumClauses(), (int)0) && !LPI.isCleanup()) {
            this.CheckFailed$T(new Twine("LandingPadInst needs at least one clause or to be a cleanup."), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
            return;
        }
        this.visitEHPadPredecessors(LPI);
        if (this.LandingPadResultTy == null) {
            this.LandingPadResultTy = LPI.getType();
        } else if (this.LandingPadResultTy != LPI.getType()) {
            this.CheckFailed$T(new Twine("The landingpad instruction should have a consistent result type inside a function."), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
            return;
        }
        Function F = LPI.getParent().getParent();
        if (!F.hasPersonalityFn()) {
            this.CheckFailed$T(new Twine("LandingPadInst needs to be in a function with a personality."), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
            return;
        }
        if (LPI.getParent().getLandingPadInst() != Native.$AddrOf((Object)LPI)) {
            this.CheckFailed$T(new Twine("LandingPadInst not the first non-PHI instruction in the block."), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
            return;
        }
        int i = 0;
        int e = LPI.getNumClauses();
        while (Unsigned.$less_uint((int)i, (int)e)) {
            Constant Clause = LPI.getClause(i);
            if (LPI.isCatch(i)) {
                if (!IrRTTI.isa_PointerType(Clause.getType())) {
                    this.CheckFailed$T(new Twine("Catch operand does not have pointer type!"), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
                    return;
                }
            } else {
                if (!LPI.isFilter(i)) {
                    this.CheckFailed$T(new Twine("Clause is neither catch nor filter!"), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
                    return;
                }
                if (!IrRTTI.isa_ConstantArray(Clause) && !IrRTTI.isa_ConstantAggregateZero(Clause)) {
                    this.CheckFailed$T(new Twine("Filter operand is not an array of constants!"), (LandingPadInst)Native.$AddrOf((Object)LPI), new Object[0]);
                    return;
                }
            }
            ++i;
        }
        this.visitInstruction(LPI);
    }

    @Override
    public void visitCatchPadInst(CatchPadInst CPI) {
        BasicBlock BB = CPI.getParent();
        Function F = BB.getParent();
        if (!F.hasPersonalityFn()) {
            this.CheckFailed$T(new Twine("CatchPadInst needs to be in a function with a personality."), (CatchPadInst)Native.$AddrOf((Object)CPI), new Object[0]);
            return;
        }
        if (!IrRTTI.isa_CatchSwitchInst(CPI.getParentPad())) {
            this.CheckFailed$T(new Twine("CatchPadInst needs to be directly nested in a CatchSwitchInst."), CPI.getParentPad(), new Object[0]);
            return;
        }
        if (BB.getFirstNonPHI() != Native.$AddrOf((Object)CPI)) {
            this.CheckFailed$T(new Twine("CatchPadInst not the first non-PHI instruction in the block."), (CatchPadInst)Native.$AddrOf((Object)CPI), new Object[0]);
            return;
        }
        this.visitEHPadPredecessors(CPI);
        this.visitFuncletPadInst(CPI);
    }

    @Override
    public void visitCatchReturnInst(CatchReturnInst CatchReturn) {
        if (!IrRTTI.isa_CatchPadInst(CatchReturn.getOperand(0))) {
            this.CheckFailed$T(new Twine("CatchReturnInst needs to be provided a CatchPad"), (CatchReturnInst)Native.$AddrOf((Object)CatchReturn), CatchReturn.getOperand(0));
            return;
        }
        this.visitTerminatorInst(CatchReturn);
    }

    @Override
    public void visitCleanupPadInst(CleanupPadInst CPI) {
        BasicBlock BB = CPI.getParent();
        Function F = BB.getParent();
        if (!F.hasPersonalityFn()) {
            this.CheckFailed$T(new Twine("CleanupPadInst needs to be in a function with a personality."), (CleanupPadInst)Native.$AddrOf((Object)CPI), new Object[0]);
            return;
        }
        if (BB.getFirstNonPHI() != Native.$AddrOf((Object)CPI)) {
            this.CheckFailed$T(new Twine("CleanupPadInst not the first non-PHI instruction in the block."), (CleanupPadInst)Native.$AddrOf((Object)CPI), new Object[0]);
            return;
        }
        Value ParentPad = CPI.getParentPad();
        if (!IrRTTI.isa_ConstantTokenNone(ParentPad) && !IrRTTI.isa_FuncletPadInst(ParentPad)) {
            this.CheckFailed$T(new Twine("CleanupPadInst has an invalid parent."), (CleanupPadInst)Native.$AddrOf((Object)CPI), new Object[0]);
            return;
        }
        this.visitEHPadPredecessors(CPI);
        this.visitFuncletPadInst(CPI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFuncletPadInst(FuncletPadInst FPI) {
        SmallSetT.PLess.T.P Seen = null;
        try {
            BasicBlock SwitchUnwindDest;
            User SwitchUnwindPad;
            CatchSwitchInst CatchSwitch;
            User FirstUser = null;
            User FirstUnwindPad = null;
            SmallVector Worklist = new SmallVector(8, (Object[])new FuncletPadInst[]{(FuncletPadInst)Native.$AddrOf((Object)FPI)}, (Object)null);
            Seen = new SmallSetT.PLess.T.P(8);
            block7: while (!Worklist.empty()) {
                FuncletPadInst CurrentPad = (FuncletPadInst)Worklist.pop_back_val();
                if (!Seen.insert((Object)CurrentPad).second) {
                    this.CheckFailed$T(new Twine("FuncletPadInst must not be nested within itself"), CurrentPad, new Object[0]);
                    return;
                }
                Value UnresolvedAncestorPad = null;
                for (User U : CurrentPad.users()) {
                    boolean ExitsFPI;
                    User UnwindPad;
                    BasicBlock UnwindDest;
                    CleanupReturnInst CRI = IrRTTI.dyn_cast_CleanupReturnInst(U);
                    if (CRI != null) {
                        UnwindDest = CRI.getUnwindDest();
                    } else {
                        CatchSwitchInst CSI = IrRTTI.dyn_cast_CatchSwitchInst(U);
                        if (CSI != null) {
                            if (CSI.unwindsToCaller()) continue;
                            UnwindDest = CSI.getUnwindDest();
                        } else {
                            InvokeInst II = IrRTTI.dyn_cast_InvokeInst(U);
                            if (II != null) {
                                UnwindDest = II.getUnwindDest();
                            } else {
                                if (IrRTTI.isa_CallInst(U)) continue;
                                CleanupPadInst CPI = IrRTTI.dyn_cast_CleanupPadInst(U);
                                if (CPI != null) {
                                    Worklist.push_back((Object)CPI);
                                    continue;
                                }
                                if (IrRTTI.isa_CatchReturnInst(U)) continue;
                                this.CheckFailed$T(new Twine("Bogus funclet pad use"), U, new Object[0]);
                                return;
                            }
                        }
                    }
                    if (UnwindDest != null) {
                        Value ExitedParent;
                        Value UnwindParent;
                        UnwindPad = UnwindDest.getFirstNonPHI();
                        if (!IrRTTI.cast_Instruction(UnwindPad).isEHPad() || (UnwindParent = VerifierStatics.getParentPad(UnwindPad)) == CurrentPad) continue;
                        Value ExitedPad = CurrentPad;
                        ExitsFPI = false;
                        do {
                            if (ExitedPad == Native.$AddrOf((Object)FPI)) {
                                ExitsFPI = true;
                                UnresolvedAncestorPad = (Value)Native.$AddrOf((Object)FPI);
                            } else {
                                ExitedParent = VerifierStatics.getParentPad(ExitedPad);
                                if (ExitedParent != UnwindParent) continue;
                                UnresolvedAncestorPad = ExitedParent;
                            }
                            break;
                        } while (!IrRTTI.isa_ConstantTokenNone(ExitedPad = ExitedParent));
                    } else {
                        UnwindPad = ConstantTokenNone.get(FPI.getContext());
                        ExitsFPI = true;
                        UnresolvedAncestorPad = (Value)Native.$AddrOf((Object)FPI);
                    }
                    if (ExitsFPI) {
                        if (FirstUser != null) {
                            if (UnwindPad != FirstUnwindPad) {
                                this.CheckFailed$T(new Twine("Unwind edges out of a funclet pad must have the same unwind dest"), (FuncletPadInst)Native.$AddrOf((Object)FPI), U, FirstUser);
                                return;
                            }
                        } else {
                            FirstUser = U;
                            FirstUnwindPad = UnwindPad;
                            if (IrRTTI.isa_CleanupPadInst((Instruction)Native.$AddrOf((Object)FPI)) && !IrRTTI.isa_ConstantTokenNone(UnwindPad) && VerifierStatics.getParentPad(UnwindPad) == VerifierStatics.getParentPad((Value)Native.$AddrOf((Object)FPI))) {
                                this.SiblingFuncletInfo.$set((Object)((Instruction)Native.$AddrOf((Object)FPI)), (Object)IrRTTI.cast_TerminatorInst(U));
                            }
                        }
                    }
                    if (CurrentPad == Native.$AddrOf((Object)FPI)) continue;
                    break;
                }
                if (UnresolvedAncestorPad == null) continue;
                if (CurrentPad == UnresolvedAncestorPad) {
                    assert (CurrentPad == Native.$AddrOf((Object)FPI));
                    continue;
                }
                Value ResolvedPad = CurrentPad;
                while (!Worklist.empty()) {
                    Value ResolvedParent;
                    Value UnclePad = (Value)Worklist.back();
                    Value AncestorPad = VerifierStatics.getParentPad(UnclePad);
                    while (ResolvedPad != AncestorPad && (ResolvedParent = VerifierStatics.getParentPad(ResolvedPad)) != UnresolvedAncestorPad) {
                        ResolvedPad = ResolvedParent;
                    }
                    if (ResolvedPad != AncestorPad) continue block7;
                    Worklist.pop_back();
                }
            }
            if (FirstUnwindPad != null && (CatchSwitch = IrRTTI.dyn_cast_CatchSwitchInst(FPI.getParentPad())) != null && (SwitchUnwindPad = (SwitchUnwindDest = CatchSwitch.getUnwindDest()) != null ? SwitchUnwindDest.getFirstNonPHI() : ConstantTokenNone.get(FPI.getContext())) != FirstUnwindPad) {
                this.CheckFailed$T(new Twine("Unwind edges out of a catch must have the same unwind dest as the parent catchswitch"), (FuncletPadInst)Native.$AddrOf((Object)FPI), FirstUser, CatchSwitch);
                return;
            }
            this.visitInstruction(FPI);
        }
        finally {
            if (Seen != null) {
                Seen.$destroy();
            }
        }
    }

    @Override
    public void visitCatchSwitchInst(CatchSwitchInst CatchSwitch) {
        BasicBlock BB = CatchSwitch.getParent();
        Function F = BB.getParent();
        if (!F.hasPersonalityFn()) {
            this.CheckFailed$T(new Twine("CatchSwitchInst needs to be in a function with a personality."), (CatchSwitchInst)Native.$AddrOf((Object)CatchSwitch), new Object[0]);
            return;
        }
        if (BB.getFirstNonPHI() != Native.$AddrOf((Object)CatchSwitch)) {
            this.CheckFailed$T(new Twine("CatchSwitchInst not the first non-PHI instruction in the block."), (CatchSwitchInst)Native.$AddrOf((Object)CatchSwitch), new Object[0]);
            return;
        }
        Value ParentPad = CatchSwitch.getParentPad();
        if (!IrRTTI.isa_ConstantTokenNone(ParentPad) && !IrRTTI.isa_FuncletPadInst(ParentPad)) {
            this.CheckFailed$T(new Twine("CatchSwitchInst has an invalid parent."), ParentPad, new Object[0]);
            return;
        }
        BasicBlock UnwindDest = CatchSwitch.getUnwindDest();
        if (UnwindDest != null) {
            Instruction I = UnwindDest.getFirstNonPHI();
            if (!I.isEHPad() || IrRTTI.isa_LandingPadInst(I)) {
                this.CheckFailed$T(new Twine("CatchSwitchInst must unwind to an EH block which is not a landingpad."), (CatchSwitchInst)Native.$AddrOf((Object)CatchSwitch), new Object[0]);
                return;
            }
            if (VerifierStatics.getParentPad(I) == ParentPad) {
                this.SiblingFuncletInfo.$set((Object)((Instruction)Native.$AddrOf((Object)CatchSwitch)), (Object)((TerminatorInst)Native.$AddrOf((Object)CatchSwitch)));
            }
        }
        if (CatchSwitch.getNumHandlers() == 0) {
            this.CheckFailed$T(new Twine("CatchSwitchInst cannot have empty handler list"), (CatchSwitchInst)Native.$AddrOf((Object)CatchSwitch), new Object[0]);
            return;
        }
        for (BasicBlock Handler2 : CatchSwitch.handlers()) {
            if (IrRTTI.isa_CatchPadInst(Handler2.getFirstNonPHI())) continue;
            this.CheckFailed$T(new Twine("CatchSwitchInst handlers must be catchpads"), (CatchSwitchInst)Native.$AddrOf((Object)CatchSwitch), Handler2);
            return;
        }
        this.visitEHPadPredecessors(CatchSwitch);
        this.visitTerminatorInst(CatchSwitch);
    }

    @Override
    public void visitCleanupReturnInst(CleanupReturnInst CRI) {
        Instruction I;
        if (!IrRTTI.isa_CleanupPadInst(CRI.getOperand(0))) {
            this.CheckFailed$T(new Twine("CleanupReturnInst needs to be provided a CleanupPad"), (CleanupReturnInst)Native.$AddrOf((Object)CRI), CRI.getOperand(0));
            return;
        }
        BasicBlock UnwindDest = CRI.getUnwindDest();
        if (UnwindDest != null && (!(I = UnwindDest.getFirstNonPHI()).isEHPad() || IrRTTI.isa_LandingPadInst(I))) {
            this.CheckFailed$T(new Twine("CleanupReturnInst must unwind to an EH block which is not a landingpad."), (CleanupReturnInst)Native.$AddrOf((Object)CRI), new Object[0]);
            return;
        }
        this.visitTerminatorInst(CRI);
    }

    private void verifyCallSite(CallSite CS) {
        int ID2;
        Object InAllocaArg;
        AllocaInst AI;
        Object I = CS.getInstruction();
        if (!((Value)CS.getCalledValue()).getType().isPointerTy()) {
            this.CheckFailed$T(new Twine("Called function must be a pointer!"), I, new Object[0]);
            return;
        }
        PointerType FPTy = IrRTTI.cast_PointerType(((Value)CS.getCalledValue()).getType());
        if (!FPTy.getElementType().isFunctionTy()) {
            this.CheckFailed$T(new Twine("Called function is not pointer to function type!"), I, new Object[0]);
            return;
        }
        if (FPTy.getElementType() != CS.getFunctionType()) {
            this.CheckFailed$T(new Twine("Called function is not the same type as the call!"), I, new Object[0]);
            return;
        }
        FunctionType FTy = CS.getFunctionType();
        if (FTy.isVarArg()) {
            if (!Unsigned.$greatereq_uint((int)CS.arg_size(), (int)FTy.getNumParams())) {
                this.CheckFailed$T(new Twine("Called function requires more parameters than were provided!"), I, new Object[0]);
                return;
            }
        } else if (CS.arg_size() != FTy.getNumParams()) {
            this.CheckFailed$T(new Twine("Incorrect number of arguments passed to called function!"), I, new Object[0]);
            return;
        }
        int e = FTy.getNumParams();
        for (int i = 0; i != e; ++i) {
            if (((Value)CS.getArgument(i)).getType() == FTy.getParamType(i)) continue;
            this.CheckFailed$T(new Twine("Call parameter type does not match function signature!"), CS.getArgument(i), FTy.getParamType(i), I);
            return;
        }
        AttributeSet Attrs = new AttributeSet(CS.getAttributes());
        if (!this.verifyAttributeCount(new AttributeSet(Attrs), CS.arg_size())) {
            this.CheckFailed$T(new Twine("Attribute after last parameter!"), I, new Object[0]);
            return;
        }
        this.verifyFunctionAttrs(FTy, new AttributeSet(Attrs), (Value)I);
        if (CS.hasInAllocaArgument() && (AI = IrRTTI.dyn_cast_AllocaInst(((Value)(InAllocaArg = CS.getArgument(FTy.getNumParams() - 1))).stripInBoundsOffsets())) != null && !AI.isUsedWithInAlloca()) {
            this.CheckFailed$T(new Twine("inalloca argument for call has mismatched alloca"), AI, I);
            return;
        }
        int e2 = FTy.getNumParams();
        for (int i = 0; i != e2; ++i) {
            if (!CS.paramHasAttr(i + 1, Attribute.AttrKind.SwiftError)) continue;
            Object SwiftErrorArg = CS.getArgument(i);
            AllocaInst AI2 = IrRTTI.dyn_cast_AllocaInst(((Value)SwiftErrorArg).stripInBoundsOffsets());
            if (AI2 == null) {
                this.CheckFailed$T(new Twine("swifterror argument should come from alloca"), AI2, I);
                return;
            }
            if (AI2 == null || AI2.isSwiftError()) continue;
            this.CheckFailed$T(new Twine("swifterror argument for call has mismatched alloca"), AI2, I);
            return;
        }
        if (FTy.isVarArg()) {
            boolean SawNest = false;
            boolean SawReturned = false;
            int Idx = 1;
            while (Unsigned.$less_uint((int)Idx, (int)(1 + FTy.getNumParams()))) {
                if (Attrs.hasAttribute(Idx, Attribute.AttrKind.Nest)) {
                    SawNest = true;
                }
                if (Attrs.hasAttribute(Idx, Attribute.AttrKind.Returned)) {
                    SawReturned = true;
                }
                ++Idx;
            }
            Idx = 1 + FTy.getNumParams();
            while (Unsigned.$lesseq_uint((int)Idx, (int)CS.arg_size())) {
                Type Ty = ((Value)CS.getArgument(Idx - 1)).getType();
                this.verifyParameterAttrs(new AttributeSet(Attrs), Idx, Ty, false, (Value)I);
                if (Attrs.hasAttribute(Idx, Attribute.AttrKind.Nest)) {
                    if (SawNest) {
                        this.CheckFailed$T(new Twine("More than one parameter has attribute nest!"), I, new Object[0]);
                        return;
                    }
                    SawNest = true;
                }
                if (Attrs.hasAttribute(Idx, Attribute.AttrKind.Returned)) {
                    if (SawReturned) {
                        this.CheckFailed$T(new Twine("More than one parameter has attribute returned!"), I, new Object[0]);
                        return;
                    }
                    if (!Ty.canLosslesslyBitCastTo(FTy.getReturnType())) {
                        this.CheckFailed$T(new Twine("Incompatible argument and return types for 'returned' attribute"), I, new Object[0]);
                        return;
                    }
                    SawReturned = true;
                }
                if (Attrs.hasAttribute(Idx, Attribute.AttrKind.StructRet)) {
                    this.CheckFailed$T(new Twine("Attribute 'sret' cannot be used for vararg call arguments!"), I, new Object[0]);
                    return;
                }
                if (Attrs.hasAttribute(Idx, Attribute.AttrKind.InAlloca) && Idx != CS.arg_size()) {
                    this.CheckFailed$T(new Twine("inalloca isn't on the last argument!"), I, new Object[0]);
                    return;
                }
                ++Idx;
            }
        }
        if (CS.getCalledFunction() == null || !((Function)CS.getCalledFunction()).getName().startswith("llvm.")) {
            for (Type ParamTy : FTy.params()) {
                if (ParamTy.isMetadataTy()) {
                    this.CheckFailed$T(new Twine("Function has metadata parameter but isn't an intrinsic"), I, new Object[0]);
                    return;
                }
                if (!ParamTy.isTokenTy()) continue;
                this.CheckFailed$T(new Twine("Function has token parameter but isn't an intrinsic"), I, new Object[0]);
                return;
            }
        }
        if (CS.getCalledFunction() == null && FTy.getReturnType().isTokenTy()) {
            this.CheckFailed(new Twine("Return type cannot be token for indirect call!"));
            return;
        }
        Function F = (Function)CS.getCalledFunction();
        if (F != null && (ID2 = F.getIntrinsicID()) != 0) {
            this.visitIntrinsicCallSite(ID2, new CallSite(CS));
        }
        boolean FoundDeoptBundle = false;
        boolean FoundFuncletBundle = false;
        boolean FoundGCTransitionBundle = false;
        int i = 0;
        int e3 = CS.getNumOperandBundles();
        while (Unsigned.$less_uint((int)i, (int)e3)) {
            OperandBundleUse BU = CS.getOperandBundleAt(i);
            int Tag = BU.getTagID();
            if (Tag == LLVMContext.Unnamed_enum1.OB_deopt.getValue()) {
                if (FoundDeoptBundle) {
                    this.CheckFailed$T(new Twine("Multiple deopt operand bundles"), I, new Object[0]);
                    return;
                }
                FoundDeoptBundle = true;
            } else if (Tag == LLVMContext.Unnamed_enum1.OB_gc_transition.getValue()) {
                if (FoundGCTransitionBundle) {
                    this.CheckFailed$T(new Twine("Multiple gc-transition operand bundles"), I, new Object[0]);
                    return;
                }
                FoundGCTransitionBundle = true;
            } else if (Tag == LLVMContext.Unnamed_enum1.OB_funclet.getValue()) {
                if (FoundFuncletBundle) {
                    this.CheckFailed$T(new Twine("Multiple funclet operand bundles"), I, new Object[0]);
                    return;
                }
                FoundFuncletBundle = true;
                if (BU.Inputs.size() != 1) {
                    this.CheckFailed$T(new Twine("Expected exactly one funclet bundle operand"), I, new Object[0]);
                    return;
                }
                if (!IrRTTI.isa_FuncletPadInst((Use)BU.Inputs.front())) {
                    this.CheckFailed$T(new Twine("Funclet bundle operands should correspond to a FuncletPadInst"), I, new Object[0]);
                    return;
                }
            }
            ++i;
        }
        if (((Instruction)I).getFunction().getSubprogram() != null && CS.getCalledFunction() != null && ((Function)CS.getCalledFunction()).getSubprogram() != null && !((Instruction)I).getDebugLoc().$bool()) {
            this.CheckFailed$T(new Twine("inlinable function call in a function with debug info must have a !dbg location"), I, new Object[0]);
            return;
        }
        this.visitInstruction((Instruction)Native.$Deref(I));
    }

    private void verifySwiftErrorCallSite(CallSite CS, Value SwiftErrorVal) {
        int Idx = 0;
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)CS.arg_begin()));
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)CS.arg_end()));
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            if (((Use)I.$star()).$Value$P() == SwiftErrorVal && !CS.paramHasAttr(Idx + 1, Attribute.AttrKind.SwiftError)) {
                this.CheckFailed$T(new Twine("swifterror value when used in a callsite should be marked with swifterror attribute"), SwiftErrorVal, CS);
                return;
            }
            I.$preInc();
            ++Idx;
        }
    }

    private void verifySwiftErrorValue(Value SwiftErrorVal) {
        for (User U : SwiftErrorVal.users$Const()) {
            InvokeInst II;
            if (!(IrRTTI.isa_LoadInst(U) || IrRTTI.isa_StoreInst(U) || IrRTTI.isa_CallInst(U) || IrRTTI.isa_InvokeInst(U))) {
                this.CheckFailed$T(new Twine("swifterror value can only be loaded and stored from, or as a swifterror argument!"), SwiftErrorVal, U);
                return;
            }
            StoreInst StoreI = IrRTTI.dyn_cast_StoreInst(U);
            if (StoreI != null && StoreI.getOperand(1) != SwiftErrorVal) {
                this.CheckFailed$T(new Twine("swifterror value should be the second operand when used by stores"), SwiftErrorVal, U);
                return;
            }
            CallInst CallI = IrRTTI.dyn_cast_CallInst(U);
            if (CallI != null) {
                this.verifySwiftErrorCallSite(new CallSite(CallI), SwiftErrorVal);
            }
            if ((II = IrRTTI.dyn_cast_InvokeInst(U)) == null) continue;
            this.verifySwiftErrorCallSite(new CallSite(II), SwiftErrorVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMustTailCall(CallInst CI) {
        ReturnInst Ret;
        if (CI.isInlineAsm()) {
            this.CheckFailed$T(new Twine("cannot use musttail call with inline asm"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        Function F = CI.getParent().getParent();
        FunctionType CallerTy = F.getFunctionType();
        FunctionType CalleeTy = CI.getFunctionType();
        if (CallerTy.getNumParams() != CalleeTy.getNumParams()) {
            this.CheckFailed$T(new Twine("cannot guarantee tail call due to mismatched parameter counts"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        if (CallerTy.isVarArg() != CalleeTy.isVarArg()) {
            this.CheckFailed$T(new Twine("cannot guarantee tail call due to mismatched varargs"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        if (!VerifierStatics.isTypeCongruent(CallerTy.getReturnType(), CalleeTy.getReturnType())) {
            this.CheckFailed$T(new Twine("cannot guarantee tail call due to mismatched return types"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int E = CallerTy.getNumParams();
        for (int I = 0; I != E; ++I) {
            if (VerifierStatics.isTypeCongruent(CallerTy.getParamType(I), CalleeTy.getParamType(I))) continue;
            this.CheckFailed$T(new Twine("cannot guarantee tail call due to mismatched parameter types"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        if (F.getCallingConv() != CI.getCallingConv()) {
            this.CheckFailed$T(new Twine("cannot guarantee tail call due to mismatched calling conv"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        AttributeSet CallerAttrs = F.getAttributes();
        AttributeSet CalleeAttrs = new AttributeSet(CI.getAttributes());
        int E2 = CallerTy.getNumParams();
        for (int I = 0; I != E2; ++I) {
            AttrBuilder CallerABIAttrs = null;
            AttrBuilder CalleeABIAttrs = null;
            try {
                CallerABIAttrs = VerifierStatics.getParameterABIAttributes(I, new AttributeSet(CallerAttrs));
                CalleeABIAttrs = VerifierStatics.getParameterABIAttributes(I, new AttributeSet(CalleeAttrs));
                if (CallerABIAttrs.$eq(CalleeABIAttrs)) continue;
                this.CheckFailed$T(new Twine("cannot guarantee tail call due to mismatched ABI impacting function attributes"), (CallInst)Native.$AddrOf((Object)CI), CI.getOperand(I));
                return;
            }
            finally {
                if (CalleeABIAttrs != null) {
                    CalleeABIAttrs.$destroy();
                }
                if (CallerABIAttrs != null) {
                    CallerABIAttrs.$destroy();
                }
            }
        }
        Value RetVal = (Value)Native.$AddrOf((Object)CI);
        Instruction Next = (Instruction)CI.getNextNode();
        BitCastInst BI = IrRTTI.dyn_cast_or_null_BitCastInst(Next);
        if (BI != null) {
            if (BI.getOperand(0) != RetVal) {
                this.CheckFailed$T(new Twine("bitcast following musttail call must use the call"), BI, new Object[0]);
                return;
            }
            RetVal = BI;
            Next = (Instruction)BI.getNextNode();
        }
        if ((Ret = IrRTTI.dyn_cast_or_null_ReturnInst(Next)) == null) {
            this.CheckFailed$T(new Twine("musttail call must be precede a ret with an optional bitcast"), (CallInst)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        if (Ret.getReturnValue() != null && Ret.getReturnValue() != RetVal) {
            this.CheckFailed$T(new Twine("musttail call result must be returned"), Ret, new Object[0]);
            return;
        }
    }

    private boolean performTypeCheck(int ID2, Function F, Type Ty, int VT, int ArgNo, std.string Suffix) {
        throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
    }

    private boolean verifyAttributeCount(AttributeSet Attrs, int Params) {
        if (Attrs.getNumSlots() == 0) {
            return true;
        }
        int LastSlot = Attrs.getNumSlots() - 1;
        int LastIndex = Attrs.getSlotIndex(LastSlot);
        return Unsigned.$lesseq_uint((int)LastIndex, (int)Params) || LastIndex == AttributeSet.AttrIndex.FunctionIndex.getValue() && (LastSlot == 0 || Unsigned.$lesseq_uint((int)Attrs.getSlotIndex(LastSlot - 1), (int)Params));
    }

    private void verifyAttributeTypes(AttributeSet Attrs, int Idx, boolean isFunction, Value V) {
        int Slot = -1;
        int E = Attrs.getNumSlots();
        for (int I = 0; I != E; ++I) {
            if (Attrs.getSlotIndex(I) != Idx) continue;
            Slot = I;
            break;
        }
        assert (Slot != -1) : "Attribute set inconsistency!";
        type.ptr I = (type.ptr)Native.$tryClone(Attrs.begin(Slot));
        type.ptr E2 = (type.ptr)Native.$tryClone(Attrs.end(Slot));
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E2)) {
            if (!((Attribute)I.$star()).isStringAttribute()) {
                if (((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoReturn || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoUnwind || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoInline || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.AlwaysInline || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.OptimizeForSize || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.StackProtect || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.StackProtectReq || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.StackProtectStrong || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.SafeStack || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoRedZone || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoImplicitFloat || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.Naked || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.InlineHint || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.StackAlignment || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.UWTable || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NonLazyBind || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.ReturnsTwice || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.SanitizeAddress || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.SanitizeThread || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.SanitizeMemory || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.MinSize || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoDuplicate || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.Builtin || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoBuiltin || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.Cold || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.OptimizeNone || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.JumpTable || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.Convergent || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.ArgMemOnly || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.NoRecurse || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.InaccessibleMemOnly || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.InaccessibleMemOrArgMemOnly || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.AllocSize) {
                    if (!isFunction) {
                        this.CheckFailed$T(new Twine(std.$add_string_T$C$P((std.string)std.$add_T$C$P_string((String)"Attribute '", (std.string)((Attribute)I.$star()).getAsString()), (String)"' only applies to functions!")), V, new Object[0]);
                        return;
                    }
                } else if (((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.ReadOnly || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.WriteOnly || ((Attribute)I.$star()).getKindAsEnum() == Attribute.AttrKind.ReadNone) {
                    if (Idx == 0) {
                        this.CheckFailed(new Twine(std.$add_string_T$C$P((std.string)std.$add_T$C$P_string((String)"Attribute '", (std.string)((Attribute)I.$star()).getAsString()), (String)"' does not apply to function returns")));
                        return;
                    }
                } else if (isFunction) {
                    this.CheckFailed$T(new Twine(std.$add_string_T$C$P((std.string)std.$add_T$C$P_string((String)"Attribute '", (std.string)((Attribute)I.$star()).getAsString()), (String)"' does not apply to functions!")), V, new Object[0]);
                    return;
                }
            }
            I.$preInc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyParameterAttrs(AttributeSet Attrs, int Idx, Type Ty, boolean isReturnValue, Value V) {
        if (!Attrs.hasAttributes(Idx)) {
            return;
        }
        this.verifyAttributeTypes(new AttributeSet(Attrs), Idx, false, V);
        if (isReturnValue && (Attrs.hasAttribute(Idx, Attribute.AttrKind.ByVal) || Attrs.hasAttribute(Idx, Attribute.AttrKind.Nest) || Attrs.hasAttribute(Idx, Attribute.AttrKind.StructRet) || Attrs.hasAttribute(Idx, Attribute.AttrKind.NoCapture) || Attrs.hasAttribute(Idx, Attribute.AttrKind.Returned) || Attrs.hasAttribute(Idx, Attribute.AttrKind.InAlloca) || Attrs.hasAttribute(Idx, Attribute.AttrKind.SwiftSelf) || Attrs.hasAttribute(Idx, Attribute.AttrKind.SwiftError))) {
            this.CheckFailed$T(new Twine("Attributes 'byval', 'inalloca', 'nest', 'sret', 'nocapture', 'returned', 'swiftself', and 'swifterror' do not apply to return values!"), V, new Object[0]);
            return;
        }
        int AttrCount = 0;
        AttrCount += Attrs.hasAttribute(Idx, Attribute.AttrKind.ByVal) ? 1 : 0;
        AttrCount += Attrs.hasAttribute(Idx, Attribute.AttrKind.InAlloca) ? 1 : 0;
        AttrCount += Attrs.hasAttribute(Idx, Attribute.AttrKind.StructRet) || Attrs.hasAttribute(Idx, Attribute.AttrKind.InReg) ? 1 : 0;
        if (!Unsigned.$lesseq_uint((int)(AttrCount += Attrs.hasAttribute(Idx, Attribute.AttrKind.Nest) ? 1 : 0), (int)1)) {
            this.CheckFailed$T(new Twine("Attributes 'byval', 'inalloca', 'inreg', 'nest', and 'sret' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.InAlloca) && Attrs.hasAttribute(Idx, Attribute.AttrKind.ReadOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'inalloca and readonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.StructRet) && Attrs.hasAttribute(Idx, Attribute.AttrKind.Returned)) {
            this.CheckFailed$T(new Twine("Attributes 'sret and returned' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.ZExt) && Attrs.hasAttribute(Idx, Attribute.AttrKind.SExt)) {
            this.CheckFailed$T(new Twine("Attributes 'zeroext and signext' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.ReadNone) && Attrs.hasAttribute(Idx, Attribute.AttrKind.ReadOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readnone and readonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.ReadNone) && Attrs.hasAttribute(Idx, Attribute.AttrKind.WriteOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readnone and writeonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.ReadOnly) && Attrs.hasAttribute(Idx, Attribute.AttrKind.WriteOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readonly and writeonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(Idx, Attribute.AttrKind.NoInline) && Attrs.hasAttribute(Idx, Attribute.AttrKind.AlwaysInline)) {
            this.CheckFailed$T(new Twine("Attributes 'noinline and alwaysinline' are incompatible!"), V, new Object[0]);
            return;
        }
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if ($c$.clean(((AttrBuilder)$c$.track((Object)new AttrBuilder(new AttributeSet(Attrs), Idx))).overlaps((AttrBuilder)$c$.track((Object)AttributeFuncs.typeIncompatible(Ty))))) {
                this.CheckFailed$T(new Twine(std.$add_T$C$P_string((String)"Wrong types for attribute: ", (std.string)AttributeSet.get((LLVMContext)Native.$Deref((Object)this.Context), Idx, (AttrBuilder)$c$.track((Object)AttributeFuncs.typeIncompatible(Ty))).getAsString(Idx))), V, new Object[0]);
                $c$.clean();
                return;
            }
        }
        finally {
            $c$.$destroy();
        }
        PointerType PTy = IrRTTI.dyn_cast_PointerType(Ty);
        if (PTy != null) {
            SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
            if (!PTy.getElementType().isSized((SmallPtrSetImpl<Type>)((SmallPtrSetImpl)Native.$AddrOf((Object)Visited))) && (Attrs.hasAttribute(Idx, Attribute.AttrKind.ByVal) || Attrs.hasAttribute(Idx, Attribute.AttrKind.InAlloca))) {
                this.CheckFailed$T(new Twine("Attributes 'byval' and 'inalloca' do not support unsized types!"), V, new Object[0]);
                return;
            }
            if (!IrRTTI.isa_PointerType(PTy.getElementType()) && Attrs.hasAttribute(Idx, Attribute.AttrKind.SwiftError)) {
                this.CheckFailed$T(new Twine("Attribute 'swifterror' only applies to parameters with pointer to pointer type!"), V, new Object[0]);
                return;
            }
        } else {
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.ByVal)) {
                this.CheckFailed$T(new Twine("Attribute 'byval' only applies to parameters with pointer type!"), V, new Object[0]);
                return;
            }
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.SwiftError)) {
                this.CheckFailed$T(new Twine("Attribute 'swifterror' only applies to parameters with pointer type!"), V, new Object[0]);
                return;
            }
        }
    }

    private void verifyFunctionAttrs(FunctionType FT, AttributeSet Attrs, Value V) {
        GlobalValue GV;
        if (Attrs.isEmpty()) {
            return;
        }
        boolean SawNest = false;
        boolean SawReturned = false;
        boolean SawSRet = false;
        boolean SawSwiftSelf = false;
        boolean SawSwiftError = false;
        int e = Attrs.getNumSlots();
        for (int i = 0; i != e; ++i) {
            Type Ty;
            int Idx = Attrs.getSlotIndex(i);
            if (Idx == 0) {
                Ty = FT.getReturnType();
            } else {
                if (!Unsigned.$less_uint((int)(Idx - 1), (int)FT.getNumParams())) break;
                Ty = FT.getParamType(Idx - 1);
            }
            this.verifyParameterAttrs(new AttributeSet(Attrs), Idx, Ty, Idx == 0, V);
            if (Idx == 0) continue;
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.Nest)) {
                if (SawNest) {
                    this.CheckFailed$T(new Twine("More than one parameter has attribute nest!"), V, new Object[0]);
                    return;
                }
                SawNest = true;
            }
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.Returned)) {
                if (SawReturned) {
                    this.CheckFailed$T(new Twine("More than one parameter has attribute returned!"), V, new Object[0]);
                    return;
                }
                if (!Ty.canLosslesslyBitCastTo(FT.getReturnType())) {
                    this.CheckFailed$T(new Twine("Incompatible argument and return types for 'returned' attribute"), V, new Object[0]);
                    return;
                }
                SawReturned = true;
            }
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.StructRet)) {
                if (SawSRet) {
                    this.CheckFailed$T(new Twine("Cannot have multiple 'sret' parameters!"), V, new Object[0]);
                    return;
                }
                if (Idx != 1 && Idx != 2) {
                    this.CheckFailed$T(new Twine("Attribute 'sret' is not on first or second parameter!"), V, new Object[0]);
                    return;
                }
                SawSRet = true;
            }
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.SwiftSelf)) {
                if (SawSwiftSelf) {
                    this.CheckFailed$T(new Twine("Cannot have multiple 'swiftself' parameters!"), V, new Object[0]);
                    return;
                }
                SawSwiftSelf = true;
            }
            if (Attrs.hasAttribute(Idx, Attribute.AttrKind.SwiftError)) {
                if (SawSwiftError) {
                    this.CheckFailed$T(new Twine("Cannot have multiple 'swifterror' parameters!"), V, new Object[0]);
                    return;
                }
                SawSwiftError = true;
            }
            if (!Attrs.hasAttribute(Idx, Attribute.AttrKind.InAlloca) || Idx == FT.getNumParams()) continue;
            this.CheckFailed$T(new Twine("inalloca isn't on the last parameter!"), V, new Object[0]);
            return;
        }
        if (!Attrs.hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) {
            return;
        }
        this.verifyAttributeTypes(new AttributeSet(Attrs), AttributeSet.AttrIndex.FunctionIndex.getValue(), true, V);
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadNone) && Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readnone and readonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadNone) && Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.WriteOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readnone and writeonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadOnly) && Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.WriteOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readonly and writeonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadNone) && Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.InaccessibleMemOrArgMemOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readnone and inaccessiblemem_or_argmemonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadNone) && Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.InaccessibleMemOnly)) {
            this.CheckFailed$T(new Twine("Attributes 'readnone and inaccessiblememonly' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoInline) && Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.AlwaysInline)) {
            this.CheckFailed$T(new Twine("Attributes 'noinline and alwaysinline' are incompatible!"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.OptimizeNone)) {
            if (!Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoInline)) {
                this.CheckFailed$T(new Twine("Attribute 'optnone' requires 'noinline'!"), V, new Object[0]);
                return;
            }
            if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.OptimizeForSize)) {
                this.CheckFailed$T(new Twine("Attributes 'optsize and optnone' are incompatible!"), V, new Object[0]);
                return;
            }
            if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.MinSize)) {
                this.CheckFailed$T(new Twine("Attributes 'minsize and optnone' are incompatible!"), V, new Object[0]);
                return;
            }
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.JumpTable) && !(GV = IrRTTI.cast_GlobalValue(V)).hasGlobalUnnamedAddr()) {
            this.CheckFailed$T(new Twine("Attribute 'jumptable' requires 'unnamed_addr'"), V, new Object[0]);
            return;
        }
        if (Attrs.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.AllocSize)) {
            std_pair.pairUIntType<ADTAliases.OptionalUInt> Args = Attrs.getAllocSizeArgs(AttributeSet.AttrIndex.FunctionIndex.getValue());
            IRFunctionPointers.StringRefUInt2Bool CheckParam = (Name, ParamNo) -> {
                if (Unsigned.$greatereq_uint((int)ParamNo, (int)FT.getNumParams())) {
                    this.CheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"'allocsize' ", (StringRef)Name), (Twine)new Twine(" argument is out of bounds")), V, new Object[0]);
                    return false;
                }
                if (!FT.getParamType(ParamNo).isIntegerTy()) {
                    this.CheckFailed$T(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"'allocsize' ", (StringRef)Name), (Twine)new Twine(" argument must refer to an integer parameter")), V, new Object[0]);
                    return false;
                }
                return true;
            };
            if (!CheckParam.$call(new StringRef("element size"), Args.first)) {
                return;
            }
            if (((ADTAliases.OptionalUInt)Args.second).$bool() && !CheckParam.$call(new StringRef("number of elements"), ((ADTAliases.OptionalUInt)Args.second).$star())) {
                return;
            }
        }
    }

    private void verifyFunctionMetadata(ArrayRef<std_pair.pairUIntPtr<MDNode>> MDs) {
        for (std_pair.pairUIntPtr Pair : MDs) {
            if (Pair.first != LLVMContext.Unnamed_enum.MD_prof.getValue()) continue;
            MDNode MD = (MDNode)Pair.second;
            if (MD.getNumOperands() != 2) {
                this.CheckFailed$T(new Twine("!prof annotations should have exactly 2 operands"), MD, new Object[0]);
                return;
            }
            if (MD.getOperand(0).$Metadata$P() == null) {
                this.CheckFailed$T(new Twine("first operand should not be null"), MD, new Object[0]);
                return;
            }
            if (!IrRTTI.isa_MDString(MD.getOperand(0))) {
                this.CheckFailed$T(new Twine("expected string with name of the !prof annotation"), MD, new Object[0]);
                return;
            }
            MDString MDS = IrRTTI.cast_MDString(MD.getOperand(0));
            StringRef ProfName = MDS.getString();
            if (!ProfName.equals("function_entry_count")) {
                this.CheckFailed$T(new Twine("first operand should be 'function_entry_count'"), MD, new Object[0]);
                return;
            }
            if (MD.getOperand(1).$Metadata$P() == null) {
                this.CheckFailed$T(new Twine("second operand should not be null"), MD, new Object[0]);
                return;
            }
            if (IrRTTI.isa_ConstantAsMetadata(MD.getOperand(1))) continue;
            this.CheckFailed$T(new Twine("expected integer argument to function_entry_count"), MD, new Object[0]);
            return;
        }
    }

    private void visitConstantExprsRecursively(Constant EntryC) {
        if (!this.ConstantExprVisited.insert((Object)EntryC).second) {
            return;
        }
        SmallVector Stack = new SmallVector(16, (Object)null);
        Stack.push_back((Object)EntryC);
        while (!Stack.empty()) {
            GlobalValue GV;
            Constant C2 = (Constant)Stack.pop_back_val();
            ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(C2);
            if (CE != null) {
                this.visitConstantExpr(CE);
            }
            if ((GV = IrRTTI.dyn_cast_GlobalValue(C2)) != null) {
                if (GV.getParent$Const() == this.M) continue;
                this.CheckFailed$T(new Twine("Referencing global in another module!"), EntryC, this.M, GV, GV.getParent$Const());
                return;
            }
            for (Use U : C2.operands$Const()) {
                Constant OpC = IrRTTI.dyn_cast_Constant(U);
                if (OpC == null || !this.ConstantExprVisited.insert((Object)OpC).second) continue;
                Stack.push_back((Object)OpC);
            }
        }
    }

    private void visitConstantExpr(ConstantExpr CE) {
        if (CE.getOpcode() != 47) {
            return;
        }
        if (!CastInst.castIsValid(47, CE.getOperand_Constant(0), CE.getType())) {
            this.CheckFailed$T(new Twine("Invalid bitcast"), CE, new Object[0]);
            return;
        }
    }

    private void verifyStatepoint(ImmutableCallSite CS) {
        Object FlagsV;
        assert (CS.getCalledFunction() != null && ((Function)CS.getCalledFunction()).getIntrinsicID() == 48);
        Instruction CI = (Instruction)Native.$Deref(CS.getInstruction());
        if (CS.doesNotAccessMemory() || CS.onlyReadsMemory() || CS.onlyAccessesArgMemory()) {
            this.CheckFailed$T(new Twine("gc.statepoint must read and write all memory to preserve reordering restrictions required by safepoint semantics"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        Object IDV = CS.getArgument(0);
        if (!IrRTTI.isa_ConstantInt(IDV)) {
            this.CheckFailed$T(new Twine("gc.statepoint ID must be a constant integer"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        Object NumPatchBytesV = CS.getArgument(1);
        if (!IrRTTI.isa_ConstantInt(NumPatchBytesV)) {
            this.CheckFailed$T(new Twine("gc.statepoint number of patchable bytes must be a constant integer"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        long NumPatchBytes = IrRTTI.cast_ConstantInt(NumPatchBytesV).getSExtValue();
        assert (llvm.isInt((long)32L, (int)((int)NumPatchBytes))) : "NumPatchBytesV is an i32!";
        if (NumPatchBytes < 0L) {
            this.CheckFailed$T(new Twine("gc.statepoint number of patchable bytes must be positive"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        Object Target = CS.getArgument(2);
        PointerType PT = IrRTTI.dyn_cast_PointerType(((Value)Target).getType());
        if (PT == null || !PT.getElementType().isFunctionTy()) {
            this.CheckFailed$T(new Twine("gc.statepoint callee must be of function pointer type"), (Instruction)Native.$AddrOf((Object)CI), Target);
            return;
        }
        FunctionType TargetFuncType = IrRTTI.cast_FunctionType(PT.getElementType());
        Object NumCallArgsV = CS.getArgument(3);
        if (!IrRTTI.isa_ConstantInt(NumCallArgsV)) {
            this.CheckFailed$T(new Twine("gc.statepoint number of arguments to underlying call must be constant integer"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int NumCallArgs = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(NumCallArgsV).getZExtValue());
        if (NumCallArgs < 0) {
            this.CheckFailed$T(new Twine("gc.statepoint number of arguments to underlying call must be positive"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int NumParams = TargetFuncType.getNumParams();
        if (TargetFuncType.isVarArg()) {
            if (NumCallArgs < NumParams) {
                this.CheckFailed$T(new Twine("gc.statepoint mismatch in number of vararg call args"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
                return;
            }
            if (!TargetFuncType.getReturnType().isVoidTy()) {
                this.CheckFailed$T(new Twine("gc.statepoint doesn't support wrapping non-void vararg functions yet"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
                return;
            }
        } else if (NumCallArgs != NumParams) {
            this.CheckFailed$T(new Twine("gc.statepoint mismatch in number of call args"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        if (!IrRTTI.isa_ConstantInt(FlagsV = CS.getArgument(4))) {
            this.CheckFailed$T(new Twine("gc.statepoint flags must be constant integer"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        long Flags = IrRTTI.cast_ConstantInt(FlagsV).getZExtValue();
        if ((Flags & ((long)StatepointFlags.MaskAll.getValue() ^ 0xFFFFFFFFFFFFFFFFL)) != Unsigned.$int2ullong((int)0)) {
            this.CheckFailed$T(new Twine("unknown flag used in gc.statepoint flags argument"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        for (int i = 0; i < NumParams; ++i) {
            Type ParamType = TargetFuncType.getParamType(i);
            Type ArgType = ((Value)CS.getArgument(5 + i)).getType();
            if (ArgType == ParamType) continue;
            this.CheckFailed$T(new Twine("gc.statepoint call argument does not match wrapped function type"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int EndCallArgsInx = 4 + NumCallArgs;
        Object NumTransitionArgsV = CS.getArgument(EndCallArgsInx + 1);
        if (!IrRTTI.isa_ConstantInt(NumTransitionArgsV)) {
            this.CheckFailed$T(new Twine("gc.statepoint number of transition arguments must be constant integer"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int NumTransitionArgs = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(NumTransitionArgsV).getZExtValue());
        if (NumTransitionArgs < 0) {
            this.CheckFailed$T(new Twine("gc.statepoint number of transition arguments must be positive"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int EndTransitionArgsInx = EndCallArgsInx + 1 + NumTransitionArgs;
        Object NumDeoptArgsV = CS.getArgument(EndTransitionArgsInx + 1);
        if (!IrRTTI.isa_ConstantInt(NumDeoptArgsV)) {
            this.CheckFailed$T(new Twine("gc.statepoint number of deoptimization arguments must be constant integer"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int NumDeoptArgs = Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(NumDeoptArgsV).getZExtValue());
        if (NumDeoptArgs < 0) {
            this.CheckFailed$T(new Twine("gc.statepoint number of deoptimization arguments must be positive"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        int ExpectedNumArgs = 7 + NumCallArgs + NumTransitionArgs + NumDeoptArgs;
        if (ExpectedNumArgs > CS.arg_size()) {
            this.CheckFailed$T(new Twine("gc.statepoint too few arguments according to length fields"), (Instruction)Native.$AddrOf((Object)CI), new Object[0]);
            return;
        }
        for (User U : CI.users$Const()) {
            CallInst Call = IrRTTI.dyn_cast_CallInst(U);
            if (Call == null) {
                this.CheckFailed$T(new Twine("illegal use of statepoint token"), (Instruction)Native.$AddrOf((Object)CI), U);
                return;
            }
            if (Call == null) continue;
            if (!IrRTTI.isa_GCRelocateInst(Call) && !IrRTTI.isa_GCResultInst(Call)) {
                this.CheckFailed$T(new Twine("gc.result or gc.relocate are the only value usesof a gc.statepoint"), (Instruction)Native.$AddrOf((Object)CI), U);
                return;
            }
            if (IrRTTI.isa_GCResultInst(Call)) {
                if (Call.getArgOperand(0) == Native.$AddrOf((Object)CI)) continue;
                this.CheckFailed$T(new Twine("gc.result connected to wrong gc.statepoint"), (Instruction)Native.$AddrOf((Object)CI), Call);
                return;
            }
            if (!IrRTTI.isa_GCRelocateInst(Call) || Call.getArgOperand(0) == Native.$AddrOf((Object)CI)) continue;
            this.CheckFailed$T(new Twine("gc.relocate connected to wrong gc.statepoint"), (Instruction)Native.$AddrOf((Object)CI), Call);
            return;
        }
    }

    private void verifyFrameRecoverIndices() {
        for (std_pair.pair Counts : this.FrameEscapeInfo) {
            Function F = (Function)Counts.first;
            int MaxRecoveredIndex = ((std_pair.pairUIntUInt)Counts.second).second;
            int EscapedObjectCount = ((std_pair.pairUIntUInt)Counts.second).first;
            if (Unsigned.$lesseq_uint((int)MaxRecoveredIndex, (int)EscapedObjectCount)) continue;
            this.CheckFailed$T(new Twine("all indices passed to llvm.localrecover must be less than the number of arguments passed ot llvm.localescape in the parent function"), F, new Object[0]);
            return;
        }
    }

    private void verifySiblingFuncletUnwinds() {
        SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 8);
        SmallPtrSet Active = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 8);
        for (std_pair.pairPtrPtr Pair : this.SiblingFuncletInfo) {
            Instruction PredPad = (Instruction)Pair.first;
            if (Visited.count((Object)PredPad) != 0) continue;
            Active.insert((Object)PredPad);
            TerminatorInst Terminator = (TerminatorInst)Pair.second;
            while (true) {
                StdVector.iterator TermI;
                Instruction SuccPad;
                if (Active.count((Object)(SuccPad = VerifierStatics.getSuccPad(Terminator))) != 0) {
                    TerminatorInst CycleTerminator;
                    Instruction CyclePad = SuccPad;
                    SmallVector CycleNodes = new SmallVector(8, (Object)null);
                    do {
                        CycleNodes.push_back((Object)CyclePad);
                        CycleTerminator = (TerminatorInst)this.SiblingFuncletInfo.$at((Object)CyclePad);
                        if (CycleTerminator == CyclePad) continue;
                        CycleNodes.push_back((Object)CycleTerminator);
                    } while ((CyclePad = VerifierStatics.getSuccPad(CycleTerminator)) != SuccPad);
                    this.CheckFailed$T(new Twine("EH pads can't handle each other's exceptions"), new ArrayRef((SmallVectorImplCommon)CycleNodes, true), new Object[0]);
                    return;
                }
                if (!Visited.insert((Object)SuccPad).second || std.$eq___normal_iterator$C((StdVector.iterator)(TermI = this.SiblingFuncletInfo.find((Object)(PredPad = SuccPad))), (StdVector.iterator)this.SiblingFuncletInfo.end())) break;
                Terminator = (TerminatorInst)((std_pair.pairPtrPtr)TermI.$arrow()).second;
                Active.insert((Object)PredPad);
            }
            Active.clear();
        }
    }

    private void verifyBitPieceExpression(DbgInfoIntrinsic I) {
        int PieceOffset;
        DIExpression E;
        DILocalVariable V;
        DbgValueInst DVI = IrRTTI.dyn_cast_DbgValueInst((IntrinsicInst)Native.$AddrOf((Object)I));
        if (DVI != null) {
            V = IrRTTI.dyn_cast_or_null_DILocalVariable(DVI.getRawVariable());
            E = IrRTTI.dyn_cast_or_null_DIExpression(DVI.getRawExpression());
        } else {
            DbgDeclareInst DDI = IrRTTI.cast_DbgDeclareInst((IntrinsicInst)Native.$AddrOf((Object)I));
            V = IrRTTI.dyn_cast_or_null_DILocalVariable(DDI.getRawVariable());
            E = IrRTTI.dyn_cast_or_null_DIExpression(DDI.getRawExpression());
        }
        if (V == null || E == null || !E.isValid()) {
            return;
        }
        if (!E.isBitPiece()) {
            return;
        }
        if (V.isArtificial()) {
            return;
        }
        long VarSize = VerifierStatics.getVariableSize((DILocalVariable)Native.$Deref((Object)V));
        if (VarSize == 0L) {
            return;
        }
        int PieceSize = Unsigned.$ulong2uint((long)E.getBitPieceSize());
        if (!Unsigned.$lesseq_uint_ulong((int)(PieceSize + (PieceOffset = Unsigned.$ulong2uint((long)E.getBitPieceOffset()))), (long)VarSize)) {
            this.CheckFailed$T(new Twine("piece is larger than or outside of variable"), (DbgInfoIntrinsic)Native.$AddrOf((Object)I), V, E);
            return;
        }
        if (Unsigned.$uint2ullong((int)PieceSize) == VarSize) {
            this.CheckFailed$T(new Twine("piece covers entire variable"), (DbgInfoIntrinsic)Native.$AddrOf((Object)I), V, E);
            return;
        }
    }

    private void verifyCompileUnits() {
        NamedMDNode CUs = this.M.getNamedMetadata(new Twine("llvm.dbg.cu"));
        SmallPtrSet Listed = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 2);
        if (CUs != null) {
            Listed.insert$T(CUs.op_begin(), CUs.op_end());
        }
        if (!std.all_of((type.iterator)this.CUVisited.begin(), (type.iterator)this.CUVisited.end(), CU -> Listed.count(CU) != 0)) {
            this.CheckFailed(new Twine("All DICompileUnits must be listed in llvm.dbg.cu"));
            return;
        }
        this.CUVisited.clear();
    }

    private void verifyDeoptimizeCallingConvs() {
        if (this.DeoptimizeDeclarations.empty()) {
            return;
        }
        Function First = (Function)this.DeoptimizeDeclarations.$at(0);
        for (Function F : llvm.makeArrayRef(this.DeoptimizeDeclarations, (boolean)true).slice(1)) {
            if (First.getCallingConv() == F.getCallingConv()) continue;
            this.CheckFailed$T(new Twine("All llvm.experimental.deoptimize declarations must have the same calling convention"), First, F);
            return;
        }
    }

    @Override
    public void $destroy() {
        this.GlobalValueVisited.$destroy();
        this.DeoptimizeDeclarations.$destroy();
        this.ConstantExprVisited.$destroy();
        this.SiblingFuncletInfo.$destroy();
        this.FrameEscapeInfo.$destroy();
        this.CUVisited.$destroy();
        this.MDNodes.$destroy();
        this.InstsInThisBlock.$destroy();
        this.DT.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Context=[LLVMContext], DT=" + (Object)((Object)this.DT) + ", InstsInThisBlock=" + this.InstsInThisBlock + ", MDNodes=" + this.MDNodes + ", CUVisited=" + this.CUVisited + ", LandingPadResultTy=" + this.LandingPadResultTy + ", SawFrameEscape=" + this.SawFrameEscape + ", FrameEscapeInfo=" + this.FrameEscapeInfo + ", SiblingFuncletInfo=" + this.SiblingFuncletInfo + ", ConstantExprVisited=" + this.ConstantExprVisited + ", DeoptimizeDeclarations=" + this.DeoptimizeDeclarations + ", GlobalValueVisited=" + this.GlobalValueVisited + super.toString();
    }
}

