/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ulong;
import org.llvm.adt.StringRef;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.Function;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.StatepointDirectives;
import org.llvm.ir.Value;
import org.llvm.ir.impl.StatepointStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;

public final class StatepointLlvmGlobals {
    public static boolean isStatepoint(ImmutableCallSite CS) {
        Function F = StatepointStatics.getCalledFunction(new ImmutableCallSite(CS));
        if (F != null) {
            return F.getIntrinsicID() == 48;
        }
        return false;
    }

    public static boolean isStatepoint_Value$C$P(Value V) {
        ImmutableCallSite CS = new ImmutableCallSite(V);
        if (CS.$bool()) {
            return IrLlvmGlobals.isStatepoint(new ImmutableCallSite(CS));
        }
        return false;
    }

    public static boolean isStatepoint_Value$C(Value V) {
        return IrLlvmGlobals.isStatepoint_Value$C$P((Value)Native.$AddrOf((Object)V));
    }

    public static boolean isGCRelocate(ImmutableCallSite CS) {
        return CS.getInstruction() != null && IrRTTI.isa_GCRelocateInst(CS.getInstruction());
    }

    public static boolean isGCResult(ImmutableCallSite CS) {
        return CS.getInstruction() != null && IrRTTI.isa_GCResultInst(CS.getInstruction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatepointDirectives parseStatepointDirectivesFromAttrs(AttributeSet AS) {
        StatepointDirectives Result2 = null;
        try {
            Result2 = new StatepointDirectives();
            Attribute AttrID = AS.getAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), new StringRef("statepoint-id"));
            ulong.ref StatepointID = NativePointer.create_ulong$ref();
            if (AttrID.isStringAttribute() && !AttrID.getValueAsString().getAsInteger$NotSigned(10, StatepointID)) {
                Result2.StatepointID.$assign(StatepointID.$deref());
            }
            uint.ref NumPatchBytes = NativePointer.create_uint$ref();
            Attribute AttrNumPatchBytes = AS.getAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), new StringRef("statepoint-num-patch-bytes"));
            if (AttrNumPatchBytes.isStringAttribute() && !AttrNumPatchBytes.getValueAsString().getAsInteger$NotSigned(10, NumPatchBytes)) {
                Result2.NumPatchBytes.$assign_T$C$R(NumPatchBytes.$deref());
            }
            StatepointDirectives statepointDirectives = new StatepointDirectives(JavaDifferentiators.JD.Move.INSTANCE, Result2);
            return statepointDirectives;
        }
        finally {
            if (Result2 != null) {
                Result2.$destroy();
            }
        }
    }

    public static boolean isStatepointDirectiveAttr(Attribute Attr) {
        return Attr.hasAttribute(new StringRef("statepoint-id")) || Attr.hasAttribute(new StringRef("statepoint-num-patch-bytes"));
    }
}

