/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;
import org.llvm.adt.aliases.DenseMapTypeUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.ilist_iterator;
import org.llvm.ir.Argument;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.CallInst;
import org.llvm.ir.DenseMapInfoAttributeSet;
import org.llvm.ir.Function;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalIFunc;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.Instruction;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.MDNode;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.Module$IR;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;

public class SlotTracker
implements Destructors.ClassWithDestructor {
    private Module$IR TheModule;
    private Function TheFunction;
    private boolean FunctionProcessed;
    private boolean ShouldInitializeAllMetadata;
    private DenseMapTypeUInt<Value> mMap;
    private int mNext;
    private DenseMapTypeUInt<Value> fMap;
    private int fNext;
    private DenseMapTypeUInt<MDNode> mdnMap;
    private int mdnNext;
    private DenseMapTypeUInt<AttributeSet> asMap;
    private int asNext;

    public SlotTracker(Module$IR M) {
        this(M, false);
    }

    public SlotTracker(Module$IR M, boolean ShouldInitializeAllMetadata) {
        this.TheModule = M;
        this.TheFunction = null;
        this.FunctionProcessed = false;
        this.ShouldInitializeAllMetadata = ShouldInitializeAllMetadata;
        this.mMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
        this.mNext = 0;
        this.fMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
        this.fNext = 0;
        this.mdnMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
        this.mdnNext = 0;
        this.asMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfoAttributeSet.$Info(), 0);
        this.asNext = 0;
    }

    public SlotTracker(Function F) {
        this(F, false);
    }

    public SlotTracker(Function F, boolean ShouldInitializeAllMetadata) {
        this.TheModule = F != null ? F.getParent$Const() : null;
        this.TheFunction = F;
        this.FunctionProcessed = false;
        this.ShouldInitializeAllMetadata = ShouldInitializeAllMetadata;
        this.mMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
        this.mNext = 0;
        this.fMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
        this.fNext = 0;
        this.mdnMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
        this.mdnNext = 0;
        this.asMap = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfoAttributeSet.$Info(), 0);
        this.asNext = 0;
    }

    public int getLocalSlot(Value V) {
        assert (!IrRTTI.isa_Constant(V)) : "Can't get a constant or global slot with this!";
        this.initialize();
        DenseMapIteratorTypeUInt FI = this.fMap.find((Object)V);
        return FI.$eq(this.fMap.end()) ? -1 : FI.$arrow().second;
    }

    public int getGlobalSlot(GlobalValue V) {
        this.initialize();
        DenseMapIteratorTypeUInt MI = this.mMap.find((Object)V);
        return MI.$eq(this.mMap.end()) ? -1 : MI.$arrow().second;
    }

    public int getMetadataSlot(MDNode N) {
        this.initialize();
        DenseMapIteratorTypeUInt MI = this.mdnMap.find((Object)N);
        return MI.$eq(this.mdnMap.end()) ? -1 : MI.$arrow().second;
    }

    public int getAttributeGroupSlot(AttributeSet AS) {
        this.initialize();
        DenseMapIteratorTypeUInt AI = this.asMap.find((Object)AS);
        return AI.$eq(this.asMap.end()) ? -1 : AI.$arrow().second;
    }

    public void incorporateFunction(Function F) {
        this.TheFunction = F;
        this.FunctionProcessed = false;
    }

    public Function getFunction() {
        return this.TheFunction;
    }

    public void purgeFunction() {
        this.fMap.clear();
        this.TheFunction = null;
        this.FunctionProcessed = false;
    }

    public DenseMapIteratorTypeUInt<MDNode> mdn_begin() {
        return this.mdnMap.begin();
    }

    public DenseMapIteratorTypeUInt<MDNode> mdn_end() {
        return this.mdnMap.end();
    }

    public int mdn_size() {
        return this.mdnMap.size();
    }

    public boolean mdn_empty() {
        return this.mdnMap.empty();
    }

    public DenseMapIteratorTypeUInt<AttributeSet> as_begin() {
        return this.asMap.begin();
    }

    public DenseMapIteratorTypeUInt<AttributeSet> as_end() {
        return this.asMap.end();
    }

    public int as_size() {
        return this.asMap.size();
    }

    public boolean as_empty() {
        return this.asMap.empty();
    }

    public void initialize() {
        if (this.TheModule != null) {
            this.processModule();
            this.TheModule = null;
        }
        if (this.TheFunction != null && !this.FunctionProcessed) {
            this.processFunction();
        }
    }

    private void CreateModuleSlot(GlobalValue V) {
        assert (V != null) : "Can't insert a null Value into SlotTracker!";
        assert (!V.getType().isVoidTy()) : "Doesn't need a slot!";
        assert (!V.hasName()) : "Doesn't need a slot!";
        int DestSlot = this.mNext++;
        this.mMap.$set((Object)V, DestSlot);
    }

    private void CreateMetadataSlot(MDNode N) {
        assert (N != null) : "Can't insert a null Value into SlotTracker!";
        int DestSlot = this.mdnNext++;
        if (!this.mdnMap.insert_pair$KeyT$ValueT((std_pair.pairTypeUInt)std.make_pair_Ptr_uint((Object)N, (int)DestSlot)).second) {
            return;
        }
        int e = N.getNumOperands();
        for (int i = 0; i != e; ++i) {
            MDNode Op = IrRTTI.dyn_cast_or_null_MDNode(N.getOperand(i));
            if (Op == null) continue;
            this.CreateMetadataSlot(Op);
        }
    }

    private void CreateFunctionSlot(Value V) {
        assert (!V.getType().isVoidTy() && !V.hasName()) : "Doesn't need a slot!";
        int DestSlot = this.fNext++;
        this.fMap.$set((Object)V, DestSlot);
    }

    private void CreateAttributeSetSlot(AttributeSet AS) {
        assert (AS.hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) : "Doesn't need a slot!";
        DenseMapIteratorTypeUInt I = this.asMap.find((Object)AS);
        if (I.$noteq(this.asMap.end())) {
            return;
        }
        int DestSlot = this.asNext++;
        this.asMap.$set((Object)AS, DestSlot);
    }

    private void processModule() {
        for (GlobalVariable Var : this.TheModule.globals$Const()) {
            if (!Var.hasName()) {
                this.CreateModuleSlot((GlobalValue)Native.$AddrOf((Object)Var));
            }
            this.processGlobalObjectMetadata(Var);
        }
        for (GlobalAlias A2 : this.TheModule.aliases$Const()) {
            if (A2.hasName()) continue;
            this.CreateModuleSlot((GlobalValue)Native.$AddrOf((Object)A2));
        }
        for (GlobalIFunc I : this.TheModule.ifuncs$Const()) {
            if (I.hasName()) continue;
            this.CreateModuleSlot((GlobalValue)Native.$AddrOf((Object)I));
        }
        for (NamedMDNode NMD : this.TheModule.named_metadata$Const()) {
            int e = NMD.getNumOperands();
            for (int i = 0; i != e; ++i) {
                this.CreateMetadataSlot(NMD.getOperand(i));
            }
        }
        for (Function F : (Module$IR)Native.$Deref((Object)this.TheModule)) {
            AttributeSet FnAttrs;
            if (!F.hasName()) {
                this.CreateModuleSlot((GlobalValue)Native.$AddrOf((Object)F));
            }
            if (this.ShouldInitializeAllMetadata) {
                this.processFunctionMetadata(F);
            }
            if (!(FnAttrs = F.getAttributes().getFnAttributes()).hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) continue;
            this.CreateAttributeSetSlot(new AttributeSet(FnAttrs));
        }
    }

    private void processFunction() {
        this.fNext = 0;
        if (!this.ShouldInitializeAllMetadata) {
            this.processFunctionMetadata((Function)Native.$Deref((Object)this.TheFunction));
        }
        ilist_iterator<Argument> AI = this.TheFunction.arg_begin$Const();
        ilist_iterator<Argument> AE = this.TheFunction.arg_end$Const();
        while (AI.$noteq(AE)) {
            if (!((Argument)AI.$arrow()).hasName()) {
                this.CreateFunctionSlot((Value)Native.$AddrOf((Object)((Argument)AI.$star())));
            }
            AI.$preInc();
        }
        for (BasicBlock BB : (Function)Native.$Deref((Object)this.TheFunction)) {
            if (!BB.hasName()) {
                this.CreateFunctionSlot((Value)Native.$AddrOf((Object)BB));
            }
            for (Instruction I : BB) {
                AttributeSet Attrs;
                CallInst CI;
                if (!I.getType().isVoidTy() && !I.hasName()) {
                    this.CreateFunctionSlot((Value)Native.$AddrOf((Object)I));
                }
                if ((CI = IrRTTI.dyn_cast_CallInst((Instruction)Native.$AddrOf((Object)I))) != null) {
                    AttributeSet Attrs2 = CI.getAttributes().getFnAttributes();
                    if (!Attrs2.hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) continue;
                    this.CreateAttributeSetSlot(new AttributeSet(Attrs2));
                    continue;
                }
                InvokeInst II = IrRTTI.dyn_cast_InvokeInst((Instruction)Native.$AddrOf((Object)I));
                if (II == null || !(Attrs = II.getAttributes().getFnAttributes()).hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) continue;
                this.CreateAttributeSetSlot(new AttributeSet(Attrs));
            }
        }
        this.FunctionProcessed = true;
    }

    private void processGlobalObjectMetadata(GlobalObject GO) {
        SmallVector MDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
        GO.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
        for (std_pair.pairUIntPtr MD : MDs) {
            this.CreateMetadataSlot((MDNode)MD.second);
        }
    }

    private void processFunctionMetadata(Function F) {
        this.processGlobalObjectMetadata(F);
        for (BasicBlock BB : F) {
            for (Instruction I : BB) {
                this.processInstructionMetadata(I);
            }
        }
    }

    private void processInstructionMetadata(Instruction I) {
        Function F;
        CallInst CI = IrRTTI.dyn_cast_CallInst((Instruction)Native.$AddrOf((Object)I));
        if (CI != null && (F = CI.getCalledFunction()) != null && F.isIntrinsic()) {
            for (Use Op : I.operands$Const()) {
                MDNode N;
                MetadataAsValue V = IrRTTI.dyn_cast_or_null_MetadataAsValue(Op);
                if (V == null || (N = IrRTTI.dyn_cast_MDNode(V.getMetadata())) == null) continue;
                this.CreateMetadataSlot(N);
            }
        }
        SmallVector MDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
        I.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
        for (std_pair.pairUIntPtr MD : MDs) {
            this.CreateMetadataSlot((MDNode)MD.second);
        }
    }

    protected SlotTracker(SlotTracker $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(SlotTracker $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public void $destroy() {
        this.asMap.$destroy();
        this.mdnMap.$destroy();
        this.fMap.$destroy();
        this.mMap.$destroy();
    }

    public String toString() {
        return "TheModule=" + this.TheModule + ", TheFunction=" + this.TheFunction + ", FunctionProcessed=" + this.FunctionProcessed + ", ShouldInitializeAllMetadata=" + this.ShouldInitializeAllMetadata + ", mMap=" + this.mMap + ", mNext=" + this.mNext + ", fMap=" + this.fMap + ", fNext=" + this.fNext + ", mdnMap=" + this.mdnMap + ", mdnNext=" + this.mdnNext + ", asMap=" + this.asMap + ", asNext=" + this.asNext;
    }
}

