/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.ulong;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDOperand;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.ProfileSummaryEntry;
import org.llvm.ir.Type;
import org.llvm.ir.java.IrRTTI;

public final class ProfileSummaryStatics {
    public static Metadata getKeyValMD(LLVMContext Context, char.ptr Key, long Val) {
        IntegerType Int64Ty = Type.getInt64Ty(Context);
        Object[] Ops = new Metadata[]{MDString.get(Context, Key), ConstantAsMetadata.get(ConstantInt.get((Type)Int64Ty, Val))};
        return MDTuple.get(Context, (ArrayRef<Metadata>)new ArrayRef(Ops, true));
    }

    public static Metadata getKeyValMD(LLVMContext Context, char.ptr Key, char.ptr Val) {
        Object[] Ops = new Metadata[]{MDString.get(Context, Key), MDString.get(Context, Val)};
        return MDTuple.get(Context, (ArrayRef<Metadata>)new ArrayRef(Ops, true));
    }

    public static boolean getVal(MDTuple MD, char.ptr Key, ulong.ref Val) {
        if (MD == null) {
            return false;
        }
        if (MD.getNumOperands() != 2) {
            return false;
        }
        MDString KeyMD = IrRTTI.dyn_cast_MDString(MD.getOperand(0));
        ConstantAsMetadata ValMD = IrRTTI.dyn_cast_ConstantAsMetadata(MD.getOperand(1));
        if (KeyMD == null || ValMD == null) {
            return false;
        }
        if (!KeyMD.getString().equals(Key)) {
            return false;
        }
        Val.$set(IrRTTI.cast_ConstantInt(ValMD.getValue()).getZExtValue());
        return true;
    }

    public static boolean isKeyValuePair(MDTuple MD, char.ptr Key, char.ptr Val) {
        if (MD == null || MD.getNumOperands() != 2) {
            return false;
        }
        MDString KeyMD = IrRTTI.dyn_cast_MDString(MD.getOperand(0));
        MDString ValMD = IrRTTI.dyn_cast_MDString(MD.getOperand(1));
        if (KeyMD == null || ValMD == null) {
            return false;
        }
        return KeyMD.getString().equals(Key) && ValMD.getString().equals(Val);
    }

    public static boolean getSummaryFromMD(MDTuple MD, std.vector<ProfileSummaryEntry> Summary) {
        if (MD == null || MD.getNumOperands() != 2) {
            return false;
        }
        MDString KeyMD = IrRTTI.dyn_cast_MDString(MD.getOperand(0));
        if (KeyMD == null || !KeyMD.getString().equals("DetailedSummary")) {
            return false;
        }
        MDTuple EntriesMD = IrRTTI.dyn_cast_MDTuple(MD.getOperand(1));
        if (EntriesMD == null) {
            return false;
        }
        for (MDOperand MDOp : EntriesMD.operands()) {
            MDTuple EntryMD = IrRTTI.dyn_cast_MDTuple(MDOp);
            if (EntryMD == null || EntryMD.getNumOperands() != 3) {
                return false;
            }
            ConstantAsMetadata Op0 = IrRTTI.dyn_cast_ConstantAsMetadata(EntryMD.getOperand(0));
            ConstantAsMetadata Op1 = IrRTTI.dyn_cast_ConstantAsMetadata(EntryMD.getOperand(1));
            ConstantAsMetadata Op2 = IrRTTI.dyn_cast_ConstantAsMetadata(EntryMD.getOperand(2));
            if (Op0 == null || Op1 == null || Op2 == null) {
                return false;
            }
            Summary.emplace_back((Object)new ProfileSummaryEntry(Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(Op0.getValue()).getZExtValue()), IrRTTI.cast_ConstantInt(Op1.getValue()).getZExtValue(), IrRTTI.cast_ConstantInt(Op2.getValue()).getZExtValue()));
        }
        return true;
    }
}

