/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.HashingGlobals;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDOperand;
import org.llvm.ir.Metadata;
import org.llvm.ir.java.MDTuple_or_GenericDINode;

public class MDNodeOpsKey {
    private ArrayRef<Metadata> RawOps;
    private ArrayRef<MDOperand> Ops;
    private int Hash;

    protected MDNodeOpsKey(ArrayRef<Metadata> Ops) {
        this.RawOps = new ArrayRef(Ops);
        this.Ops = new ArrayRef(false);
        this.Hash = MDNodeOpsKey.calculateHash((ArrayRef<Metadata>)new ArrayRef(Ops));
    }

    protected <NodeTy extends MDTuple_or_GenericDINode> MDNodeOpsKey(NodeTy N) {
        this(N, 0);
    }

    protected <NodeTy extends MDTuple_or_GenericDINode> MDNodeOpsKey(NodeTy N, int Offset) {
        this.Ops = new ArrayRef(Native.$add(N.op_begin(), (int)Offset), N.op_end(), false);
        this.Hash = N.getHash();
    }

    protected <NodeTy extends MDTuple_or_GenericDINode> boolean compareOps(NodeTy RHS) {
        return this.compareOps(RHS, 0);
    }

    protected <NodeTy extends MDTuple_or_GenericDINode> boolean compareOps(NodeTy RHS, int Offset) {
        if (Native.$noteq((int)this.getHash(), (int)RHS.getHash())) {
            return false;
        }
        assert (this.RawOps.empty() || this.Ops.empty()) : "Two sets of operands?";
        return this.RawOps.empty() ? MDNodeOpsKey.compareOps(this.Ops, (MDNode)((Object)RHS), Offset) : MDNodeOpsKey.compareOps(this.RawOps, (MDNode)((Object)RHS), Offset);
    }

    protected static int calculateHash(MDNode N) {
        return MDNodeOpsKey.calculateHash(N, 0);
    }

    protected static int calculateHash(MDNode N, int Offset) {
        int Hash = HashingGlobals.hash_combine_range((type.ptr)((type.ptr)N.op_begin().$add(Offset)), N.op_end()).$uint();
        SmallVector MDs = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, (type.iterator)N.op_begin().$add(Offset), N.op_end(), (Object)null, M -> M.$Metadata$P());
        int RawHash = MDNodeOpsKey.calculateHash((ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)MDs, true));
        assert (Hash == RawHash) : "Expected hash of MDOperand to equal hash of Metadata*";
        return Hash;
    }

    private static <T> boolean compareOps(ArrayRef<T> Ops, MDNode RHS, int Offset) {
        if (Native.$noteq((int)Ops.size(), (int)(RHS.getNumOperands() - Offset))) {
            return false;
        }
        return std.equal((type.iterator)Ops.begin(), (type.iterator)Ops.end(), (type.iterator)((type.iterator)RHS.op_begin().$add(Offset)));
    }

    private static int calculateHash(ArrayRef<Metadata> Ops) {
        return HashingGlobals.hash_combine_range_ptrs((type.ptr)Ops.begin(), (type.ptr)Ops.end()).$uint();
    }

    public int getHash() {
        return this.Hash;
    }

    public String toString() {
        return "RawOps=" + this.RawOps + ", Ops=" + this.Ops + ", Hash=" + this.Hash;
    }
}

