/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import java.util.Iterator;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.ir.DICompileUnit;
import org.llvm.ir.DIMacroNode;
import org.llvm.ir.DINode;
import org.llvm.ir.Metadata;
import org.llvm.ir.Module$IR;
import org.llvm.ir.impl.AsmWriterStatics;
import org.llvm.ir.impl.FieldSeparator;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.ir.impl.TypePrinting;
import org.llvm.support.dwarf.DwarfGlobals;
import org.llvm.support.raw_ostream;

public class MDFieldPrinter {
    public final raw_ostream Out;
    public FieldSeparator FS;
    public TypePrinting TypePrinter;
    public SlotTracker Machine;
    public Module$IR Context;

    public MDFieldPrinter(raw_ostream Out) {
        this.Out = Out;
        this.FS = new FieldSeparator();
        this.TypePrinter = null;
        this.Machine = null;
        this.Context = null;
    }

    public MDFieldPrinter(raw_ostream Out, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        this.Out = Out;
        this.FS = new FieldSeparator();
        this.TypePrinter = TypePrinter;
        this.Machine = Machine;
        this.Context = Context;
    }

    public void printTag(DINode N) {
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out("tag: ");
        char.ptr Tag = Native.$tryClone((char.ptr)DwarfGlobals.TagString((int)N.getTag()));
        if (Native.$bool((Native.Native$Bool)Tag)) {
            this.Out.$out(Tag);
        } else {
            this.Out.$out_uint(N.getTag());
        }
    }

    public void printMacinfoType(DIMacroNode N) {
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out("type: ");
        char.ptr Type2 = Native.$tryClone((char.ptr)DwarfGlobals.MacinfoString((int)N.getMacinfoType()));
        if (Native.$bool((Native.Native$Bool)Type2)) {
            this.Out.$out(Type2);
        } else {
            this.Out.$out_uint(N.getMacinfoType());
        }
    }

    public void printString(StringRef Name, StringRef Value2) {
        this.printString(Name, Value2, true);
    }

    public void printString(StringRef Name, StringRef Value2, boolean ShouldSkipEmpty) {
        if (ShouldSkipEmpty && Value2.empty()) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": \"");
        AsmWriterStatics.PrintEscapedString(new StringRef(Value2), this.Out);
        this.Out.$out(NativePointer.$DBL_QUOTE);
    }

    public void printMetadata(StringRef Name, Metadata MD) {
        this.printMetadata(Name, MD, true);
    }

    public void printMetadata(StringRef Name, Metadata MD, boolean ShouldSkipNull) {
        if (ShouldSkipNull && MD == null) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ");
        AsmWriterStatics.writeMetadataAsOperand(this.Out, MD, this.TypePrinter, this.Machine, this.Context);
    }

    public void printInt$UInt(StringRef Name, int Int) {
        this.printInt$UInt(Name, Int, true);
    }

    public void printInt$UInt(StringRef Name, int Int, boolean ShouldSkipZero) {
        if (ShouldSkipZero && Int == 0) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ").$out_uint(Int);
    }

    public void printInt$LLong(StringRef Name, long Int) {
        this.printInt$LLong(Name, Int, true);
    }

    public void printInt$LLong(StringRef Name, long Int, boolean ShouldSkipZero) {
        if (ShouldSkipZero && Int == 0L) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ").$out_llong(Int);
    }

    public void printInt$ULLong(StringRef Name, long Int) {
        this.printInt$ULLong(Name, Int, true);
    }

    public void printInt$ULLong(StringRef Name, long Int, boolean ShouldSkipZero) {
        if (ShouldSkipZero && Int == 0L) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ").$out_ullong(Int);
    }

    public void printInt$Int(StringRef Name, int Int) {
        this.printInt$Int(Name, Int, true);
    }

    public void printInt$Int(StringRef Name, int Int, boolean ShouldSkipZero) {
        if (ShouldSkipZero && Int == 0) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ").$out_int(Int);
    }

    public void printBool(StringRef Name, boolean Value2) {
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ").$out(Value2 ? NativePointer.$true : NativePointer.$false);
    }

    public void printDIFlags(StringRef Name, int Flags) {
        if (Flags == 0) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ");
        SmallVectorUInt SplitFlags = new SmallVectorUInt(8, 0);
        int Extra = DINode.splitFlags(Flags, (SmallVectorImplUInt)SplitFlags);
        FieldSeparator FlagsFS = new FieldSeparator(NativePointer.$((String)" | "));
        Iterator iterator2 = SplitFlags.iterator();
        while (iterator2.hasNext()) {
            int F = (Integer)iterator2.next();
            char.ptr StringF = Native.$tryClone((char.ptr)DINode.getFlagString(F));
            assert (Native.$bool((Native.Native$Bool)StringF)) : "Expected valid flag";
            AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, FlagsFS).$out(StringF);
        }
        if (Extra != 0 || SplitFlags.empty()) {
            AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, FlagsFS).$out_uint(Extra);
        }
    }

    public void printDwarfEnum$UInt(StringRef Name, int Value2, StringifierUInt __toString) {
        this.printDwarfEnum$UInt(Name, Value2, __toString, true);
    }

    public void printDwarfEnum$UInt(StringRef Name, int Value2, StringifierUInt __toString, boolean ShouldSkipZero) {
        if (Value2 == 0) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ");
        char.ptr S = Native.$tryClone((char.ptr)__toString.$call(Value2));
        if (Native.$bool((Native.Native$Bool)S)) {
            this.Out.$out(S);
        } else {
            this.Out.$out_uint(Value2);
        }
    }

    public void printDwarfEnum$UChar(StringRef Name, byte Value2, StringifierUChar __toString) {
        this.printDwarfEnum$UChar(Name, Value2, __toString, true);
    }

    public void printDwarfEnum$UChar(StringRef Name, byte Value2, StringifierUChar __toString, boolean ShouldSkipZero) {
        if (Value2 == 0) {
            return;
        }
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ");
        char.ptr S = Native.$tryClone((char.ptr)__toString.$call(Unsigned.$uchar2uint((byte)Value2)));
        if (Native.$bool((Native.Native$Bool)S)) {
            this.Out.$out(S);
        } else {
            this.Out.$out_uchar(Value2);
        }
    }

    public void printEmissionKind(StringRef Name, DICompileUnit.DebugEmissionKind EK) {
        AsmWriterStatics.$out_raw_ostream_FieldSeparator(this.Out, this.FS).$out(Name).$out(": ").$out(DICompileUnit.EmissionKindString(EK));
    }

    public String toString() {
        return "Out=" + this.Out + ", FS=" + this.FS + ", TypePrinter=" + this.TypePrinter + ", Machine=" + this.Machine + ", Context=" + this.Context;
    }

    @FunctionalInterface
    public static interface StringifierUChar {
        public char.ptr $call(int var1);
    }

    @FunctionalInterface
    public static interface StringifierUInt {
        public char.ptr $call(int var1);
    }
}

