/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefULong;
import org.llvm.adt.ilist_node;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BinaryOperator;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.CastInst;
import org.llvm.ir.CompositeType;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.Function;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.Module$IR;
import org.llvm.ir.OperandBundleDefT;
import org.llvm.ir.PointerType;
import org.llvm.ir.Type;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;

public final class InstructionsStatics {
    public static boolean IsConstantOne(Value val) {
        assert (val != null) : "IsConstantOne does not work with nullptr val";
        ConstantInt CVal = IrRTTI.dyn_cast_ConstantInt(val);
        return CVal != null && CVal.isOne();
    }

    public static Instruction createMalloc(Instruction InsertBefore, BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB, Function MallocF, Twine Name) {
        CallInst MCall_final;
        assert (InsertBefore == null && InsertAtEnd != null || InsertBefore != null && InsertAtEnd == null) : "createMalloc needs either InsertBefore or InsertAtEnd";
        if (ArraySize == null) {
            ArraySize = ConstantInt.get(IntPtrTy, Unsigned.$int2ulong((int)1));
        } else if (ArraySize.getType() != IntPtrTy) {
            ArraySize = InsertBefore != null ? CastInst.CreateIntegerCast(ArraySize, IntPtrTy, false, new Twine(NativePointer.$EMPTY), InsertBefore) : CastInst.CreateIntegerCast(ArraySize, IntPtrTy, false, new Twine(NativePointer.$EMPTY), InsertAtEnd);
        }
        if (!InstructionsStatics.IsConstantOne(ArraySize)) {
            if (InstructionsStatics.IsConstantOne(AllocSize)) {
                AllocSize = ArraySize;
            } else {
                Constant CO = IrRTTI.dyn_cast_Constant(ArraySize);
                if (CO != null) {
                    Constant Scale = ConstantExpr.getIntegerCast(CO, IntPtrTy, false);
                    AllocSize = ConstantExpr.getMul(Scale, IrRTTI.cast_Constant(AllocSize));
                } else {
                    AllocSize = InsertBefore != null ? BinaryOperator.CreateMul(ArraySize, AllocSize, new Twine("mallocsize"), InsertBefore) : BinaryOperator.CreateMul(ArraySize, AllocSize, new Twine("mallocsize"), InsertAtEnd);
                }
            }
        }
        assert (AllocSize.getType() == IntPtrTy) : "malloc arg is wrong size";
        BasicBlock BB = InsertBefore != null ? InsertBefore.getParent() : InsertAtEnd;
        Object M = BB.getParent().getParent();
        PointerType BPTy = Type.getInt8PtrTy(BB.getContext());
        Constant MallocFunc = MallocF;
        if (MallocFunc == null) {
            MallocFunc = ((Module$IR)M).getOrInsertFunction(new StringRef("malloc"), BPTy, IntPtrTy, null);
        }
        PointerType AllocPtrType = PointerType.getUnqual(AllocTy);
        CallInst MCall = null;
        CallInst Result2 = null;
        if (InsertBefore != null) {
            MCall = CallInst.Create_Value1(MallocFunc, (ArrayRef<Value>)new ArrayRef((Object)AllocSize, true), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(OpB), new Twine("malloccall"), InsertBefore);
            Result2 = MCall;
            if (Result2.getType() != AllocPtrType) {
                MCall_final = MCall;
                Result2 = UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst((Value)MCall_final, (Type)AllocPtrType, Name, InsertBefore));
            }
        } else {
            MCall = CallInst.Create_Value1(MallocFunc, (ArrayRef<Value>)new ArrayRef((Object)AllocSize, true), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(OpB), new Twine("malloccall"));
            Result2 = MCall;
            if (Result2.getType() != AllocPtrType) {
                InsertAtEnd.getInstList().push_back((ilist_node)MCall);
                MCall_final = MCall;
                Result2 = UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst(MCall_final, AllocPtrType, Name));
            }
        }
        MCall.setTailCall();
        Function F = IrRTTI.dyn_cast_Function(MallocFunc);
        if (F != null) {
            MCall.setCallingConv(F.getCallingConv());
            if (!F.doesNotAlias(0)) {
                F.setDoesNotAlias(0);
            }
        }
        assert (!MCall.getType().isVoidTy()) : "Malloc has void return type";
        return Result2;
    }

    public static Instruction createFree(Value Source, ArrayRef<OperandBundleDefT<Value>> Bundles, Instruction InsertBefore, BasicBlock InsertAtEnd) {
        assert (InsertBefore == null && InsertAtEnd != null || InsertBefore != null && InsertAtEnd == null) : "createFree needs either InsertBefore or InsertAtEnd";
        assert (Source.getType().isPointerTy()) : "Can not free something of nonpointer type!";
        BasicBlock BB = InsertBefore != null ? InsertBefore.getParent() : InsertAtEnd;
        Object M = BB.getParent().getParent();
        Type VoidTy = Type.getVoidTy(((Module$IR)M).getContext());
        PointerType IntPtrTy = Type.getInt8PtrTy(((Module$IR)M).getContext());
        Constant FreeFunc = ((Module$IR)M).getOrInsertFunction(new StringRef("free"), VoidTy, IntPtrTy, null);
        CallInst Result2 = null;
        Value PtrCast = Source;
        if (InsertBefore != null) {
            if (Source.getType() != IntPtrTy) {
                PtrCast = UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst(Source, IntPtrTy, new Twine(NativePointer.$EMPTY), InsertBefore));
            }
            Result2 = CallInst.Create_Value1(FreeFunc, (ArrayRef<Value>)new ArrayRef((Object)PtrCast, true), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), new Twine(NativePointer.$EMPTY), InsertBefore);
        } else {
            if (Source.getType() != IntPtrTy) {
                PtrCast = UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst(Source, IntPtrTy, new Twine(NativePointer.$EMPTY), InsertAtEnd));
            }
            Result2 = CallInst.Create_Value1(FreeFunc, (ArrayRef<Value>)new ArrayRef((Object)PtrCast, true), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), new Twine(NativePointer.$EMPTY));
        }
        Result2.setTailCall();
        Function F = IrRTTI.dyn_cast_Function(FreeFunc);
        if (F != null) {
            Result2.setCallingConv(F.getCallingConv());
        }
        return Result2;
    }

    public static Value getAISize(LLVMContext Context, Value Amt) {
        if (Amt == null) {
            Amt = ConstantInt.get(Type.getInt32Ty(Context), Unsigned.$int2ulong((int)1));
        } else {
            assert (!IrRTTI.isa_BasicBlock(Amt)) : "Passed basic block into allocation size parameter! Use other ctor";
            assert (Amt.getType().isIntegerTy()) : "Allocation array size is not an integer!";
        }
        return Amt;
    }

    public static <IndexTy extends Value> Type getIndexedTypeInternal(Type Agg, ArrayRef<IndexTy> IdxList) {
        if (IdxList.empty()) {
            return Agg;
        }
        if (!Agg.isSized()) {
            return null;
        }
        int CurIdx = 1;
        while (Native.$noteq((int)CurIdx, (int)IdxList.size())) {
            CompositeType CT = IrRTTI.dyn_cast_CompositeType(Agg);
            if (CT == null || CT.isPointerTy()) {
                return null;
            }
            Value Index = (Value)IdxList.$at(CurIdx);
            if (Native.$not((boolean)CT.indexValid(Index))) {
                return null;
            }
            Agg = CT.getTypeAtIndex(Index);
            ++CurIdx;
        }
        return Native.$eq((int)CurIdx, (int)IdxList.size()) ? Agg : null;
    }

    public static Type getIndexedTypeInternal$ULLong(Type Agg, ArrayRefULong IdxList) {
        int CurIdx;
        if (IdxList.empty()) {
            return Agg;
        }
        if (!Agg.isSized()) {
            return null;
        }
        for (CurIdx = 1; CurIdx != IdxList.size(); ++CurIdx) {
            CompositeType CT = IrRTTI.dyn_cast_CompositeType(Agg);
            if (CT == null || CT.isPointerTy()) {
                return null;
            }
            long Index = IdxList.$at(CurIdx);
            if (!CT.indexValid(Unsigned.$ullong2uint((long)Index))) {
                return null;
            }
            Agg = CT.getTypeAtIndex(Unsigned.$ullong2uint((long)Index));
        }
        return CurIdx == IdxList.size() ? Agg : null;
    }

    public static boolean isConstantAllOnes(Value V) {
        Constant C2 = IrRTTI.dyn_cast_Constant(V);
        if (C2 != null) {
            return C2.isAllOnesValue();
        }
        return false;
    }
}

