/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Native;
import org.llvm.ir.AllocaInst;
import org.llvm.ir.AtomicCmpXchgInst;
import org.llvm.ir.AtomicRMWInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.FenceInst;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.LoadInst;
import org.llvm.ir.OperandBundleUser;
import org.llvm.ir.StoreInst;
import org.llvm.ir.java.IrRTTI;

public final class InstructionStatics {
    public static boolean haveSameSpecialState(Instruction I1, Instruction I2) {
        return InstructionStatics.haveSameSpecialState(I1, I2, false);
    }

    public static boolean haveSameSpecialState(Instruction I1, Instruction I2, boolean IgnoreAlignment) {
        assert (I1.getOpcode() == I2.getOpcode()) : "Can not compare special state of different instructions";
        AllocaInst AI = IrRTTI.dyn_cast_AllocaInst(I1);
        if (AI != null) {
            return AI.getAllocatedType() == IrRTTI.cast_AllocaInst(I2).getAllocatedType() && (AI.getAlignment() == IrRTTI.cast_AllocaInst(I2).getAlignment() || IgnoreAlignment);
        }
        LoadInst LI = IrRTTI.dyn_cast_LoadInst(I1);
        if (LI != null) {
            return LI.isVolatile() == IrRTTI.cast_LoadInst(I2).isVolatile() && (LI.getAlignment() == IrRTTI.cast_LoadInst(I2).getAlignment() || IgnoreAlignment) && LI.getOrdering() == IrRTTI.cast_LoadInst(I2).getOrdering() && LI.getSynchScope() == IrRTTI.cast_LoadInst(I2).getSynchScope();
        }
        StoreInst SI = IrRTTI.dyn_cast_StoreInst(I1);
        if (SI != null) {
            return SI.isVolatile() == IrRTTI.cast_StoreInst(I2).isVolatile() && (SI.getAlignment() == IrRTTI.cast_StoreInst(I2).getAlignment() || IgnoreAlignment) && SI.getOrdering() == IrRTTI.cast_StoreInst(I2).getOrdering() && SI.getSynchScope() == IrRTTI.cast_StoreInst(I2).getSynchScope();
        }
        Instruction CI = IrRTTI.dyn_cast_CmpInst(I1);
        if (CI != null) {
            return ((CmpInst)CI).getPredicate() == IrRTTI.cast_CmpInst(I2).getPredicate();
        }
        CI = IrRTTI.dyn_cast_CallInst(I1);
        if (CI != null) {
            return ((CallInst)CI).isTailCall() == IrRTTI.cast_CallInst(I2).isTailCall() && ((CallInst)CI).getCallingConv() == IrRTTI.cast_CallInst(I2).getCallingConv() && ((CallInst)CI).getAttributes().$eq(IrRTTI.cast_CallInst(I2).getAttributes()) && CI.hasIdenticalOperandBundleSchema((OperandBundleUser)Native.$Deref((Object)IrRTTI.cast_CallInst(I2)));
        }
        CI = IrRTTI.dyn_cast_InvokeInst(I1);
        if (CI != null) {
            return ((InvokeInst)CI).getCallingConv() == IrRTTI.cast_InvokeInst(I2).getCallingConv() && ((InvokeInst)CI).getAttributes().$eq(IrRTTI.cast_InvokeInst(I2).getAttributes()) && CI.hasIdenticalOperandBundleSchema((OperandBundleUser)Native.$Deref((Object)IrRTTI.cast_InvokeInst(I2)));
        }
        InsertValueInst IVI = IrRTTI.dyn_cast_InsertValueInst(I1);
        if (IVI != null) {
            return IVI.getIndices().$eq(IrRTTI.cast_InsertValueInst(I2).getIndices());
        }
        ExtractValueInst EVI = IrRTTI.dyn_cast_ExtractValueInst(I1);
        if (EVI != null) {
            return EVI.getIndices().$eq(IrRTTI.cast_ExtractValueInst(I2).getIndices());
        }
        FenceInst FI = IrRTTI.dyn_cast_FenceInst(I1);
        if (FI != null) {
            return FI.getOrdering() == IrRTTI.cast_FenceInst(I2).getOrdering() && FI.getSynchScope() == IrRTTI.cast_FenceInst(I2).getSynchScope();
        }
        AtomicCmpXchgInst CXI = IrRTTI.dyn_cast_AtomicCmpXchgInst(I1);
        if (CXI != null) {
            return CXI.isVolatile() == IrRTTI.cast_AtomicCmpXchgInst(I2).isVolatile() && CXI.isWeak() == IrRTTI.cast_AtomicCmpXchgInst(I2).isWeak() && CXI.getSuccessOrdering() == IrRTTI.cast_AtomicCmpXchgInst(I2).getSuccessOrdering() && CXI.getFailureOrdering() == IrRTTI.cast_AtomicCmpXchgInst(I2).getFailureOrdering() && CXI.getSynchScope() == IrRTTI.cast_AtomicCmpXchgInst(I2).getSynchScope();
        }
        AtomicRMWInst RMWI = IrRTTI.dyn_cast_AtomicRMWInst(I1);
        if (RMWI != null) {
            return RMWI.getOperation() == IrRTTI.cast_AtomicRMWInst(I2).getOperation() && RMWI.isVolatile() == IrRTTI.cast_AtomicRMWInst(I2).isVolatile() && RMWI.getOrdering() == IrRTTI.cast_AtomicRMWInst(I2).getOrdering() && RMWI.getSynchScope() == IrRTTI.cast_AtomicRMWInst(I2).getSynchScope();
        }
        return true;
    }
}

