/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.DICompileUnit;
import org.llvm.ir.DICompositeType;
import org.llvm.ir.DIFile;
import org.llvm.ir.DIImportedEntity;
import org.llvm.ir.DILocalVariable;
import org.llvm.ir.DILocation;
import org.llvm.ir.DINode;
import org.llvm.ir.DIScope;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.DISubroutineType;
import org.llvm.ir.DITemplateParameter;
import org.llvm.ir.DITemplateValueParameter;
import org.llvm.ir.DIType;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDTuple;
import org.llvm.ir.MDTupleTypedArrayWrapper;
import org.llvm.ir.Metadata;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.TypedDINodeRef;
import org.llvm.ir.TypedTrackingMDRef;
import org.llvm.ir.Value;
import org.llvm.ir.ValueAsMetadata;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;

public final class DIBuilderStatics {
    public static DIScope getNonCompileUnitScope(DIScope N) {
        if (N == null || IrRTTI.isa_DICompileUnit(N)) {
            return null;
        }
        return IrRTTI.cast_DIScope(N);
    }

    public static DIImportedEntity createImportedModule(LLVMContext C2, char Tag, DIScope Context, Metadata NS, int Line, StringRef Name, SmallVectorImpl<TypedTrackingMDRef<MDNode>> AllImportedModules) {
        int EntitiesCount = C2.pImpl.DIImportedEntitys.size();
        DIImportedEntity M = DIImportedEntity.get(C2, Unsigned.$ushort2uint((char)Tag), Context, new TypedDINodeRef<DINode>(DINode.class, NS), Line, new StringRef(Name));
        if (Unsigned.$less_uint((int)EntitiesCount, (int)C2.pImpl.DIImportedEntitys.size())) {
            AllImportedModules.emplace_back(new TypedTrackingMDRef<DIImportedEntity>(M));
        }
        return M;
    }

    public static ConstantAsMetadata getConstantOrNull(Constant C2) {
        if (C2 != null) {
            return ConstantAsMetadata.get(C2);
        }
        return null;
    }

    public static DITemplateValueParameter createTemplateValueParameterHelper(LLVMContext VMContext, int Tag, DIScope Context, StringRef Name, DIType Ty, Metadata MD) {
        assert (Context == null || IrRTTI.isa_DICompileUnit(Context)) : "Expected compile unit";
        return DITemplateValueParameter.get(VMContext, Tag, new StringRef(Name), new TypedDINodeRef<DIType>(DIType.class, Ty), MD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DIType createTypeWithFlags(LLVMContext Context, DIType Ty, int FlagsToSet) {
        std_ptr.unique_ptr_with_deleter<? extends DIType> NewTy = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            NewTy = Ty.clone();
            ((DIType)NewTy.$arrow()).setFlags(((DIType)NewTy.$arrow()).getFlags() | FlagsToSet);
            DIType dIType = (DIType)$c$.clean((Object)((DIType)MDNode.replaceWithUniqued$BaseOfMDNode($c$.track(new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move(NewTy))))));
            return dIType;
        }
        finally {
            if (NewTy != null) {
                NewTy.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static void checkGlobalVariableScope(DIScope Context) {
        DICompositeType CT = IrRTTI.dyn_cast_or_null_DICompositeType(DIBuilderStatics.getNonCompileUnitScope(Context));
        if (CT != null) assert (CT.getIdentifier().empty()) : "Context of a global variable should not be a type with identifier";
    }

    public static DILocalVariable createLocalVariable(LLVMContext VMContext, DenseMap<MDNode, SmallVector<TypedTrackingMDRef<MDNode>>> PreservedVariables, DIScope Scope, StringRef Name, int ArgNo, DIFile File, int LineNo, DIType Ty, boolean AlwaysPreserve, int Flags) {
        DIScope Context = DIBuilderStatics.getNonCompileUnitScope(Scope);
        DILocalVariable Node2 = DILocalVariable.get(VMContext, IrRTTI.cast_or_null_DILocalScope(Context), new StringRef(Name), File, LineNo, new TypedDINodeRef<DIType>(DIType.class, Ty), ArgNo, Flags);
        if (AlwaysPreserve) {
            DISubprogram Fn = IrLlvmGlobals.getDISubprogram(Scope);
            assert (Fn != null) : "Missing subprogram for local variable";
            ((SmallVector)PreservedVariables.$at_T1$RR((Object)Fn)).emplace_back(new TypedTrackingMDRef<DILocalVariable>(Node2));
        }
        return Node2;
    }

    public static DISubprogram getSubprogram(boolean IsDistinct, LLVMContext Context, DIScope Scope, StringRef Name, StringRef LinkageName, DIFile File, int Line, DISubroutineType Type2, boolean IsLocalToUnit, boolean IsDefinition, int ScopeLine, DIType ContainingType, int Virtuality, int VirtualIndex, int ThisAdjustment, int Flags, boolean IsOptimized, DICompileUnit Unit, MDTupleTypedArrayWrapper<DITemplateParameter> TemplateParams, DISubprogram Declaration, MDTuple Variables) {
        if (IsDistinct) {
            return DISubprogram.getDistinct(Context, new TypedDINodeRef<DIScope>(DIScope.class, Scope), new StringRef(Name), new StringRef(LinkageName), File, Line, Type2, IsLocalToUnit, IsDefinition, ScopeLine, ContainingType == null ? new TypedDINodeRef<DIType>(DIType.class, JavaDifferentiators.JD$NullPtr.INSTANCE, null) : new TypedDINodeRef<DIType>(DIType.class, ContainingType), Virtuality, VirtualIndex, ThisAdjustment, Flags, IsOptimized, Unit, new MDTupleTypedArrayWrapper<DITemplateParameter>(TemplateParams), Declaration, new MDTupleTypedArrayWrapper<DILocalVariable>(DILocalVariable.class, Variables));
        }
        return DISubprogram.get(Context, new TypedDINodeRef<DIScope>(DIScope.class, Scope), new StringRef(Name), new StringRef(LinkageName), File, Line, Type2, IsLocalToUnit, IsDefinition, ScopeLine, ContainingType == null ? new TypedDINodeRef<DIType>(DIType.class, JavaDifferentiators.JD$NullPtr.INSTANCE, null) : new TypedDINodeRef<DIType>(DIType.class, ContainingType), Virtuality, VirtualIndex, ThisAdjustment, Flags, IsOptimized, Unit, new MDTupleTypedArrayWrapper<DITemplateParameter>(TemplateParams), Declaration, new MDTupleTypedArrayWrapper<DILocalVariable>(DILocalVariable.class, Variables));
    }

    public static Value getDbgIntrinsicValueImpl(LLVMContext VMContext, Value V) {
        assert (V != null) : "no value passed to dbg intrinsic";
        return MetadataAsValue.get(VMContext, ValueAsMetadata.get(V));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Instruction withDebugLoc(Instruction I, DILocation DL) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            I.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc(DL)));
            $c$.clean();
            Instruction instruction = I;
            return instruction;
        }
        finally {
            $c$.$destroy();
        }
    }
}

