/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.Argument;
import org.llvm.ir.CallInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Constant;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.IRBuilder;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PointerType;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.AutoUpgradeStatics$UpgradeIntrinsicFunction1$$;
import org.llvm.ir.intrinsic.IntrinsicGlobals;
import org.llvm.ir.java.IRManualRTTI;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.Regex;
import org.llvm.support.llvm;

public final class AutoUpgradeStatics {
    public static boolean UpgradeSSE41Function(Function F, int IID, type.ref<Function> NewFn) {
        Type Arg0Type = F.getFunctionType().getParamType(0);
        if (Arg0Type != VectorType.get(Type.getFloatTy(F.getContext()), 4)) {
            return false;
        }
        F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)F.getName(), (String)".old"));
        NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), IID));
        return true;
    }

    public static boolean UpgradeX86IntrinsicsWith8BitMask(Function F, int IID, type.ref<Function> NewFn) {
        Type LastArgType = F.getFunctionType().getParamType(F.getFunctionType().getNumParams() - 1);
        if (!LastArgType.isIntegerTy(32)) {
            return false;
        }
        F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)F.getName(), (String)".old"));
        NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), IID));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean UpgradeIntrinsicFunction1(Function F, type.ref<Function> NewFn) {
        assert (F != null) : "Illegal to upgrade a non-existent Function.";
        StringRef Name = F.getName();
        if (Unsigned.$lesseq_uint((int)Name.size(), (int)8) || !Name.startswith("llvm.")) {
            return false;
        }
        Name.$assignMove(Name.substr(5));
        switch (Name.$at(0)) {
            default: {
                break;
            }
            case 97: {
                Regex vldRegex = null;
                Regex vstRegex = null;
                try {
                    if (Name.startswith("arm.neon.vclz")) {
                        Object[] args = new Type[]{((Argument)F.arg_begin().$arrow()).getType(), Type.getInt1Ty(F.getContext())};
                        FunctionType fType = FunctionType.get(F.getReturnType(), (ArrayRef<Type>)new ArrayRef(args, true), false);
                        NewFn.$set((Object)Function.Create(fType, F.getLinkage(), llvm.$add_char$ptr$C_StringRef$C((String)"llvm.ctlz.", (StringRef)Name.substr(14)), (Module$IR)F.getParent()));
                        boolean bl = true;
                        return bl;
                    }
                    if (Name.startswith("arm.neon.vcnt")) {
                        NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 23, (ArrayRef<Type>)new ArrayRef((Object)((Argument)F.arg_begin().$arrow()).getType(), true)));
                        boolean args = true;
                        return args;
                    }
                    vldRegex = new Regex(new StringRef("^arm\\.neon\\.vld([1234]|[234]lane)\\.v[a-z0-9]*$"));
                    if (vldRegex.match(Name)) {
                        ArrayRef<Type> fArgs = F.getFunctionType().params();
                        SmallVector Tys = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, (type.iterator)fArgs.begin(), (type.iterator)fArgs.end(), (Object)null);
                        FunctionType fType = FunctionType.get(F.getReturnType(), (ArrayRef<Type>)new ArrayRef((SmallVectorImplCommon)Tys, true), false);
                        NewFn.$set((Object)Function.Create(fType, F.getLinkage(), llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"llvm.", (StringRef)Name), (Twine)new Twine(".p0i8")), (Module$IR)F.getParent()));
                        boolean bl = true;
                        return bl;
                    }
                    vstRegex = new Regex(new StringRef("^arm\\.neon\\.vst([1234]|[234]lane)\\.v[a-z0-9]*$"));
                    if (vstRegex.match(Name)) {
                        int[] StoreInts = AutoUpgradeStatics$UpgradeIntrinsicFunction1$$.StoreInts;
                        int[] StoreLaneInts = AutoUpgradeStatics$UpgradeIntrinsicFunction1$$.StoreLaneInts;
                        ArrayRef<Type> fArgs = F.getFunctionType().params();
                        Object[] Tys = new Type[]{(Type)fArgs.$at(0), (Type)fArgs.$at(1)};
                        if (Name.find("lane") == StringRef.npos) {
                            NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), StoreInts[fArgs.size() - 3], (ArrayRef<Type>)new ArrayRef(Tys, true)));
                        } else {
                            NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), StoreLaneInts[fArgs.size() - 5], (ArrayRef<Type>)new ArrayRef(Tys, true)));
                        }
                        boolean bl = true;
                        return bl;
                    }
                    if (llvm.$eq_StringRef((StringRef)Name, (String)"aarch64.thread.pointer") || llvm.$eq_StringRef((StringRef)Name, (String)"arm.thread.pointer")) {
                        NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 112));
                        boolean StoreInts = true;
                        return StoreInts;
                    }
                    break;
                }
                finally {
                    if (vstRegex != null) {
                        vstRegex.$destroy();
                    }
                    if (vldRegex != null) {
                        vldRegex.$destroy();
                    }
                }
            }
            case 99: {
                if (Name.startswith("ctlz.") && F.arg_size() == 1) {
                    F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                    NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 22, (ArrayRef<Type>)new ArrayRef((Object)((Argument)F.arg_begin().$arrow()).getType(), true)));
                    return true;
                }
                if (!Name.startswith("cttz.") || F.arg_size() != 1) break;
                F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 24, (ArrayRef<Type>)new ArrayRef((Object)((Argument)F.arg_begin().$arrow()).getType(), true)));
                return true;
            }
            case 109: {
                if (Name.startswith("masked.load.")) {
                    Object[] Tys = new Type[]{F.getReturnType(), ((Argument)F.arg_begin().$arrow()).getType()};
                    if (llvm.$noteq_StringRef((StringRef)F.getName(), (StringRef)new StringRef(IntrinsicGlobals.getName(80, (ArrayRef<Type>)new ArrayRef(Tys, true))))) {
                        F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                        NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 80, (ArrayRef<Type>)new ArrayRef(Tys, true)));
                        return true;
                    }
                }
                if (!Name.startswith("masked.store.")) break;
                ArrayRef<Type> Args = F.getFunctionType().params();
                Object[] Tys = new Type[]{(Type)Args.$at(0), (Type)Args.$at(1)};
                if (!llvm.$noteq_StringRef((StringRef)F.getName(), (StringRef)new StringRef(IntrinsicGlobals.getName(82, (ArrayRef<Type>)new ArrayRef(Tys, true))))) break;
                F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 82, (ArrayRef<Type>)new ArrayRef(Tys, true)));
                return true;
            }
            case 111: {
                if (F.arg_size() != 2 || !Name.startswith("objectsize.")) break;
                Object[] Tys = new Type[]{F.getReturnType(), ((Argument)F.arg_begin().$arrow()).getType()};
                if (!llvm.$noteq_StringRef((StringRef)F.getName(), (StringRef)new StringRef(IntrinsicGlobals.getName(89, (ArrayRef<Type>)new ArrayRef(Tys, true))))) break;
                F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 89, (ArrayRef<Type>)new ArrayRef(Tys, true)));
                return true;
            }
            case 115: {
                if (llvm.$eq_StringRef((StringRef)Name, (String)"stackprotectorcheck")) {
                    NewFn.$set(null);
                    return true;
                }
            }
            case 120: {
                ArrayRef<Type> Params;
                Type Idx;
                boolean IsX86 = Name.startswith("x86.");
                if (IsX86) {
                    Name.$assignMove(Name.substr(4));
                }
                if (IsX86 && (Name.startswith("sse2.pcmpeq.") || Name.startswith("sse2.pcmpgt.") || Name.startswith("avx2.pcmpeq.") || Name.startswith("avx2.pcmpgt.") || Name.startswith("avx512.mask.pcmpeq.") || Name.startswith("avx512.mask.pcmpgt.") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxsb") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pmaxs.w") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxsd") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pmaxu.b") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxuw") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxud") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminsb") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pmins.w") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminsd") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pminu.b") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminuw") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminud") || Name.startswith("avx2.pmax") || Name.startswith("avx2.pmin") || Name.startswith("avx2.vbroadcast") || Name.startswith("avx2.pbroadcast") || Name.startswith("avx.vpermil.") || Name.startswith("sse2.pshuf") || Name.startswith("avx512.pbroadcast") || Name.startswith("avx512.mask.broadcast.s") || Name.startswith("avx512.mask.movddup") || Name.startswith("avx512.mask.movshdup") || Name.startswith("avx512.mask.movsldup") || Name.startswith("avx512.mask.pshuf.d.") || Name.startswith("avx512.mask.pshufl.w.") || Name.startswith("avx512.mask.pshufh.w.") || Name.startswith("avx512.mask.vpermil.p") || Name.startswith("avx512.mask.perm.df.") || Name.startswith("avx512.mask.perm.di.") || Name.startswith("avx512.mask.punpckl") || Name.startswith("avx512.mask.punpckh") || Name.startswith("avx512.mask.unpckl.") || Name.startswith("avx512.mask.unpckh.") || Name.startswith("avx512.mask.pand.") || Name.startswith("avx512.mask.pandn.") || Name.startswith("avx512.mask.por.") || Name.startswith("avx512.mask.pxor.") || Name.startswith("sse41.pmovsx") || Name.startswith("sse41.pmovzx") || Name.startswith("avx2.pmovsx") || Name.startswith("avx2.pmovzx") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.cvtdq2pd") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.cvtps2pd") || llvm.$eq_StringRef((StringRef)Name, (String)"avx.cvtdq2.pd.256") || llvm.$eq_StringRef((StringRef)Name, (String)"avx.cvt.ps2.pd.256") || Name.startswith("avx.vinsertf128.") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.vinserti128") || Name.startswith("avx.vextractf128.") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.vextracti128") || Name.startswith("sse4a.movnt.") || Name.startswith("avx.movnt.") || Name.startswith("avx512.storent.") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.storel.dq") || Name.startswith("sse.storeu.") || Name.startswith("sse2.storeu.") || Name.startswith("avx.storeu.") || Name.startswith("avx512.mask.storeu.p") || Name.startswith("avx512.mask.storeu.b.") || Name.startswith("avx512.mask.storeu.w.") || Name.startswith("avx512.mask.storeu.d.") || Name.startswith("avx512.mask.storeu.q.") || Name.startswith("avx512.mask.store.p") || Name.startswith("avx512.mask.store.b.") || Name.startswith("avx512.mask.store.w.") || Name.startswith("avx512.mask.store.d.") || Name.startswith("avx512.mask.store.q.") || Name.startswith("avx512.mask.loadu.p") || Name.startswith("avx512.mask.loadu.b.") || Name.startswith("avx512.mask.loadu.w.") || Name.startswith("avx512.mask.loadu.d.") || Name.startswith("avx512.mask.loadu.q.") || Name.startswith("avx512.mask.load.p") || Name.startswith("avx512.mask.load.b.") || Name.startswith("avx512.mask.load.w.") || Name.startswith("avx512.mask.load.d.") || Name.startswith("avx512.mask.load.q.") || llvm.$eq_StringRef((StringRef)Name, (String)"sse42.crc32.64.8") || Name.startswith("avx.vbroadcast.s") || Name.startswith("avx512.mask.palignr.") || Name.startswith("sse2.psll.dq") || Name.startswith("sse2.psrl.dq") || Name.startswith("avx2.psll.dq") || Name.startswith("avx2.psrl.dq") || Name.startswith("avx512.psll.dq") || Name.startswith("avx512.psrl.dq") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pblendw") || Name.startswith("sse41.blendp") || Name.startswith("avx.blend.p") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.pblendw") || Name.startswith("avx2.pblendd.") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.vbroadcasti128") || llvm.$eq_StringRef((StringRef)Name, (String)"xop.vpcmov") || Name.startswith("xop.vpcom") && F.arg_size() == 2)) {
                    NewFn.$set(null);
                    return true;
                }
                if (IsX86 && Name.startswith("sse41.ptest")) {
                    if (llvm.$eq_StringRef((StringRef)Name.substr(11), (String)"c")) {
                        return AutoUpgradeStatics.UpgradeSSE41Function(F, 5878, NewFn);
                    }
                    if (llvm.$eq_StringRef((StringRef)Name.substr(11), (String)"z")) {
                        return AutoUpgradeStatics.UpgradeSSE41Function(F, 5880, NewFn);
                    }
                    if (llvm.$eq_StringRef((StringRef)Name.substr(11), (String)"nzc")) {
                        return AutoUpgradeStatics.UpgradeSSE41Function(F, 5879, NewFn);
                    }
                }
                if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"sse41.insertps")) {
                    return AutoUpgradeStatics.UpgradeX86IntrinsicsWith8BitMask(F, 5871, NewFn);
                }
                if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"sse41.dppd")) {
                    return AutoUpgradeStatics.UpgradeX86IntrinsicsWith8BitMask(F, 5869, NewFn);
                }
                if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"sse41.dpps")) {
                    return AutoUpgradeStatics.UpgradeX86IntrinsicsWith8BitMask(F, 5870, NewFn);
                }
                if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"sse41.mpsadbw")) {
                    return AutoUpgradeStatics.UpgradeX86IntrinsicsWith8BitMask(F, 5873, NewFn);
                }
                if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"avx.dp.ps.256")) {
                    return AutoUpgradeStatics.UpgradeX86IntrinsicsWith8BitMask(F, 4268, NewFn);
                }
                if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"avx2.mpsadbw")) {
                    return AutoUpgradeStatics.UpgradeX86IntrinsicsWith8BitMask(F, 4345, NewFn);
                }
                if (IsX86 && Name.startswith("xop.vfrcz.ss") && F.arg_size() == 2) {
                    F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                    NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 5958));
                    return true;
                }
                if (IsX86 && Name.startswith("xop.vfrcz.sd") && F.arg_size() == 2) {
                    F.setName(llvm.$add_StringRef$C_char$ptr$C((StringRef)Name, (String)".old"));
                    NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 5957));
                    return true;
                }
                if (IsX86 && (Name.startswith("avx512.mask.pslli.") || Name.startswith("avx512.mask.psrai.") || Name.startswith("avx512.mask.psrli."))) {
                    int ShiftID = llvm.$eq_StringRef((StringRef)Name.slice(12, 16), (String)"psll") ? (Name.$at(18) == 100 ? 5121 : 5127) : (llvm.$eq_StringRef((StringRef)Name.slice(12, 16), (String)"psra") ? (Name.$at(18) == 100 ? 5148 : 5154) : (Name.$at(18) == 100 ? 5175 : 5181));
                    F.setName(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"llvm.x86.", (StringRef)Name), (Twine)new Twine(".old")));
                    NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), ShiftID));
                    return true;
                }
                if (IsX86 && Name.startswith("fma4.")) {
                    F.setName(llvm.$add_char$ptr$C_StringRef$C((String)"llvm.x86.fma", (StringRef)Name.substr(5)));
                    NewFn.$set((Object)F);
                    return true;
                }
                if (!IsX86 || !Name.startswith("xop.vpermil2") || !(Idx = (Type)(Params = F.getFunctionType().params()).$at(2)).getScalarType().isFloatingPointTy()) break;
                F.setName(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"llvm.x86.", (StringRef)Name), (Twine)new Twine(".old")));
                int IdxSize = Idx.getPrimitiveSizeInBits();
                int EltSize = Idx.getScalarSizeInBits();
                int Permil2ID = EltSize == 64 && IdxSize == 128 ? 5969 : (EltSize == 32 && IdxSize == 128 ? 5971 : (EltSize == 64 && IdxSize == 256 ? 5970 : 5972));
                NewFn.$set((Object)IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), Permil2ID));
                return true;
            }
        }
        return false;
    }

    public static Value UpgradeX86PSLLDQIntrinsics(IRBuilder Builder, Value Op, int Shift) {
        Type ResultTy = Op.getType();
        int NumElts = ResultTy.getVectorNumElements() * 8;
        VectorType VecTy = VectorType.get(Builder.getInt8Ty(), NumElts);
        Op = Builder.CreateBitCast(Op, VecTy, new Twine("cast"));
        Value Res = Constant.getNullValue(VecTy);
        if (Unsigned.$less_uint((int)Shift, (int)16)) {
            int[] Idxs = NativePointer.new$uint((int)64);
            for (int l = 0; l != NumElts; l += 16) {
                for (int i = 0; i != 16; ++i) {
                    int Idx = NumElts + i - Shift;
                    if (Unsigned.$less_uint((int)Idx, (int)NumElts)) {
                        Idx -= NumElts - 16;
                    }
                    Idxs[l + i] = Idx + l;
                }
            }
            Res = Builder.CreateShuffleVector(Res, Op, llvm.makeArrayRef((int[])Idxs, (int)NumElts));
        }
        return Builder.CreateBitCast(Res, ResultTy, new Twine("cast"));
    }

    public static Value UpgradeX86PSRLDQIntrinsics(IRBuilder Builder, Value Op, int Shift) {
        Type ResultTy = Op.getType();
        int NumElts = ResultTy.getVectorNumElements() * 8;
        VectorType VecTy = VectorType.get(Builder.getInt8Ty(), NumElts);
        Op = Builder.CreateBitCast(Op, VecTy, new Twine("cast"));
        Value Res = Constant.getNullValue(VecTy);
        if (Unsigned.$less_uint((int)Shift, (int)16)) {
            int[] Idxs = NativePointer.new$uint((int)64);
            for (int l = 0; l != NumElts; l += 16) {
                for (int i = 0; i != 16; ++i) {
                    int Idx = i + Shift;
                    if (Unsigned.$greatereq_uint((int)Idx, (int)16)) {
                        Idx += NumElts - 16;
                    }
                    Idxs[l + i] = Idx + l;
                }
            }
            Res = Builder.CreateShuffleVector(Op, Res, llvm.makeArrayRef((int[])Idxs, (int)NumElts));
        }
        return Builder.CreateBitCast(Res, ResultTy, new Twine("cast"));
    }

    public static Value getX86MaskVec(IRBuilder Builder, Value Mask, int NumElts) {
        VectorType MaskTy = VectorType.get(Builder.getInt1Ty(), IrRTTI.cast_IntegerType(Mask.getType()).getBitWidth());
        Mask = Builder.CreateBitCast(Mask, MaskTy);
        if (Unsigned.$less_uint((int)NumElts, (int)8)) {
            int[] Indices = NativePointer.new$uint((int)4);
            for (int i = 0; i != NumElts; ++i) {
                Indices[i] = i;
            }
            Mask = Builder.CreateShuffleVector(Mask, Mask, llvm.makeArrayRef((int[])Indices, (int)NumElts), new Twine("extract"));
        }
        return Mask;
    }

    public static Value EmitX86Select(IRBuilder Builder, Value Mask, Value Op0, Value Op1) {
        Constant C2 = IrRTTI.dyn_cast_Constant(Mask);
        if (C2 != null && C2.isAllOnesValue()) {
            return Op0;
        }
        Mask = AutoUpgradeStatics.getX86MaskVec(Builder, Mask, Op0.getType().getVectorNumElements());
        return Builder.CreateSelect(Mask, Op0, Op1);
    }

    public static Value UpgradeX86PALIGNRIntrinsics(IRBuilder Builder, Value Op0, Value Op1, Value Shift, Value Passthru, Value Mask) {
        int ShiftVal = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(Shift).getZExtValue());
        int NumElts = Op0.getType().getVectorNumElements();
        assert (Unsigned.$rem_uint((int)NumElts, (int)16) == 0);
        if (Unsigned.$greatereq_uint((int)ShiftVal, (int)32)) {
            return Constant.getNullValue(Op0.getType());
        }
        if (Unsigned.$greater_uint((int)ShiftVal, (int)16)) {
            ShiftVal -= 16;
            Op1 = Op0;
            Op0 = Constant.getNullValue(Op0.getType());
        }
        int[] Indices = NativePointer.new$uint((int)64);
        for (int l = 0; l != NumElts; l += 16) {
            for (int i = 0; i != 16; ++i) {
                int Idx = ShiftVal + i;
                if (Unsigned.$greatereq_uint((int)Idx, (int)16)) {
                    Idx += NumElts - 16;
                }
                Indices[l + i] = Idx + l;
            }
        }
        Value Align = Builder.CreateShuffleVector(Op1, Op0, llvm.makeArrayRef((int[])Indices, (int)NumElts), new Twine("palignr"));
        return AutoUpgradeStatics.EmitX86Select(Builder, Mask, Align, Passthru);
    }

    public static Value UpgradeMaskedStore(IRBuilder Builder, Value Ptr, Value Data, Value Mask, boolean Aligned) {
        Ptr = Builder.CreateBitCast(Ptr, PointerType.getUnqual(Data.getType()));
        int Align = Aligned ? Unsigned.$div_uint((int)IrRTTI.cast_VectorType(Data.getType()).getBitWidth(), (int)8) : 1;
        Constant C2 = IrRTTI.dyn_cast_Constant(Mask);
        if (C2 != null && C2.isAllOnesValue()) {
            return Builder.CreateAlignedStore(Data, Ptr, Align);
        }
        int NumElts = Data.getType().getVectorNumElements();
        Mask = AutoUpgradeStatics.getX86MaskVec(Builder, Mask, NumElts);
        return Builder.CreateMaskedStore(Data, Ptr, Align, Mask);
    }

    public static Value UpgradeMaskedLoad(IRBuilder Builder, Value Ptr, Value Passthru, Value Mask, boolean Aligned) {
        Ptr = Builder.CreateBitCast(Ptr, PointerType.getUnqual(Passthru.getType()));
        int Align = Aligned ? Unsigned.$div_uint((int)IrRTTI.cast_VectorType(Passthru.getType()).getBitWidth(), (int)8) : 1;
        Constant C2 = IrRTTI.dyn_cast_Constant(Mask);
        if (C2 != null && C2.isAllOnesValue()) {
            return Builder.CreateAlignedLoad(Ptr, Align);
        }
        int NumElts = Passthru.getType().getVectorNumElements();
        Mask = AutoUpgradeStatics.getX86MaskVec(Builder, Mask, NumElts);
        return Builder.CreateMaskedLoad(Ptr, Align, Mask, Passthru);
    }

    public static Value upgradeIntMinMax(IRBuilder Builder, CallInst CI, CmpInst.Predicate Pred) {
        Value Op0 = CI.getArgOperand(0);
        Value Op1 = CI.getArgOperand(1);
        Value Cmp = Builder.CreateICmp(Pred, Op0, Op1);
        return Builder.CreateSelect(Cmp, Op0, Op1);
    }

    public static Value upgradeMaskedCompare(IRBuilder Builder, CallInst CI, CmpInst.Predicate Pred) {
        Value Op0 = CI.getArgOperand(0);
        int NumElts = Op0.getType().getVectorNumElements();
        Value Cmp = Builder.CreateICmp(Pred, Op0, CI.getArgOperand(1));
        Value Mask = CI.getArgOperand(2);
        Constant C2 = IrRTTI.dyn_cast_Constant(Mask);
        if (C2 == null || !C2.isAllOnesValue()) {
            Cmp = Builder.CreateAnd(Cmp, AutoUpgradeStatics.getX86MaskVec(Builder, Mask, NumElts));
        }
        if (Unsigned.$less_uint((int)NumElts, (int)8)) {
            int i;
            int[] Indices = NativePointer.new$uint((int)8);
            for (i = 0; i != NumElts; ++i) {
                Indices[i] = i;
            }
            for (i = NumElts; i != 8; ++i) {
                Indices[i] = NumElts + Unsigned.$rem_uint((int)i, (int)NumElts);
            }
            Cmp = Builder.CreateShuffleVector(Cmp, (Value)Constant.getNullValue(Cmp.getType()), new ArrayRefUInt(Indices));
        }
        return Builder.CreateBitCast(Cmp, IntegerType.get(CI.getContext(), std.max((int)NumElts, (int)8)));
    }

    public static boolean isOldLoopArgument(Metadata MD) {
        MDTuple T2 = IrRTTI.dyn_cast_or_null_MDTuple(MD);
        if (T2 == null) {
            return false;
        }
        if (Unsigned.$less_uint((int)T2.getNumOperands(), (int)1)) {
            return false;
        }
        MDString S = IRManualRTTI.dyn_cast_or_null_MDString(T2.getOperand(0));
        if (S == null) {
            return false;
        }
        return S.getString().startswith("llvm.vectorizer.");
    }

    public static MDString upgradeLoopTag(LLVMContext C2, StringRef OldTag) {
        StringRef OldPrefix = new StringRef("llvm.vectorizer.");
        assert (OldTag.startswith(OldPrefix)) : "Expected old prefix";
        if (llvm.$eq_StringRef((StringRef)OldTag, (String)"llvm.vectorizer.unroll")) {
            return MDString.get(C2, NativePointer.$((String)"llvm.loop.interleave.count"));
        }
        return MDString.get(C2, new StringRef(llvm.$add_Twine$C((Twine)new Twine("llvm.loop.vectorize."), (Twine)new Twine(OldTag.drop_front(OldPrefix.size()))).str()));
    }

    public static Metadata upgradeLoopArgument(Metadata MD) {
        MDTuple T2 = IrRTTI.dyn_cast_or_null_MDTuple(MD);
        if (T2 == null) {
            return MD;
        }
        if (Unsigned.$less_uint((int)T2.getNumOperands(), (int)1)) {
            return MD;
        }
        MDString OldTag = IRManualRTTI.dyn_cast_or_null_MDString(T2.getOperand(0));
        if (OldTag == null) {
            return MD;
        }
        if (!OldTag.getString().startswith("llvm.vectorizer.")) {
            return MD;
        }
        SmallVector Ops = new SmallVector(8, (Object)null);
        Ops.reserve(T2.getNumOperands());
        Ops.push_back((Object)AutoUpgradeStatics.upgradeLoopTag(T2.getContext(), OldTag.getString()));
        int E = T2.getNumOperands();
        for (int I = 1; I != E; ++I) {
            Ops.push_back((Object)T2.getOperand(I).$Metadata$P());
        }
        return MDTuple.get(T2.getContext(), (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Ops, true));
    }
}

