/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.CallInst;
import org.llvm.ir.CastInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.DiagnosticInfoDebugMetadataVersion;
import org.llvm.ir.Function;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.IRBuilder;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMConstants;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LoadInst;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDOperand;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.Module$IR;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.PointerType;
import org.llvm.ir.StoreInst;
import org.llvm.ir.Type;
import org.llvm.ir.UndefValue;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.AutoUpgradeStatics;
import org.llvm.ir.intrinsic.IntrinsicGlobals;
import org.llvm.ir.java.IRManualRTTI;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class AutoUpgradeLlvmGlobals {
    public static boolean UpgradeIntrinsicFunction(Function F, type.ref<Function> NewFn) {
        int id;
        NewFn.$set(null);
        boolean Upgraded = AutoUpgradeStatics.UpgradeIntrinsicFunction1(F, NewFn);
        assert (F != NewFn.$deref()) : "Intrinsic function upgraded to the same function";
        if (NewFn.$deref() != null) {
            F = (Function)NewFn.$deref();
        }
        if ((id = F.getIntrinsicID()) != 0) {
            F.setAttributes(IntrinsicGlobals.getAttributes(F.getContext(), id));
        }
        return Upgraded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UpgradeIntrinsicCall(CallInst CI, Function NewFn) {
        IRBuilder Builder = null;
        try {
            Function F = CI.getCalledFunction();
            LLVMContext C2 = CI.getContext();
            Builder = new IRBuilder(C2);
            Builder.SetInsertPoint(CI.getParent(), (ilist_iterator<Instruction>)CI.getIterator());
            assert (F != null) : "Intrinsic call is not direct?";
            if (NewFn == null) {
                Value Rep;
                StringRef Name = F.getName();
                assert (Name.startswith("llvm.")) : "Intrinsic doesn't start with 'llvm.'";
                Name.$assignMove(Name.substr(5));
                boolean IsX86 = Name.startswith("x86.");
                if (IsX86) {
                    Name.$assignMove(Name.substr(4));
                }
                if (IsX86 && (Name.startswith("sse2.pcmpeq.") || Name.startswith("avx2.pcmpeq."))) {
                    Rep = Builder.CreateICmpEQ(CI.getArgOperand(0), CI.getArgOperand(1), new Twine("pcmpeq"));
                    Rep = Builder.CreateSExt(Rep, CI.getType(), new Twine(NativePointer.$EMPTY));
                } else if (IsX86 && (Name.startswith("sse2.pcmpgt.") || Name.startswith("avx2.pcmpgt."))) {
                    Rep = Builder.CreateICmpSGT(CI.getArgOperand(0), CI.getArgOperand(1), new Twine("pcmpgt"));
                    Rep = Builder.CreateSExt(Rep, CI.getType(), new Twine(NativePointer.$EMPTY));
                } else if (IsX86 && Name.startswith("avx512.mask.pcmpeq.")) {
                    Rep = AutoUpgradeStatics.upgradeMaskedCompare(Builder, (CallInst)Native.$Deref((Object)CI), CmpInst.Predicate.ICMP_EQ);
                } else if (IsX86 && Name.startswith("avx512.mask.pcmpgt.")) {
                    Rep = AutoUpgradeStatics.upgradeMaskedCompare(Builder, (CallInst)Native.$Deref((Object)CI), CmpInst.Predicate.ICMP_SGT);
                } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxsb") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pmaxs.w") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxsd") || Name.startswith("avx2.pmaxs"))) {
                    Rep = AutoUpgradeStatics.upgradeIntMinMax(Builder, (CallInst)Native.$Deref((Object)CI), CmpInst.Predicate.ICMP_SGT);
                } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pmaxu.b") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxuw") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pmaxud") || Name.startswith("avx2.pmaxu"))) {
                    Rep = AutoUpgradeStatics.upgradeIntMinMax(Builder, (CallInst)Native.$Deref((Object)CI), CmpInst.Predicate.ICMP_UGT);
                } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminsb") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pmins.w") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminsd") || Name.startswith("avx2.pmins"))) {
                    Rep = AutoUpgradeStatics.upgradeIntMinMax(Builder, (CallInst)Native.$Deref((Object)CI), CmpInst.Predicate.ICMP_SLT);
                } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pminu.b") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminuw") || llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pminud") || Name.startswith("avx2.pminu"))) {
                    Rep = AutoUpgradeStatics.upgradeIntMinMax(Builder, (CallInst)Native.$Deref((Object)CI), CmpInst.Predicate.ICMP_ULT);
                } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.cvtdq2pd") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.cvtps2pd") || llvm.$eq_StringRef((StringRef)Name, (String)"avx.cvtdq2.pd.256") || llvm.$eq_StringRef((StringRef)Name, (String)"avx.cvt.ps2.pd.256"))) {
                    boolean Int2Double;
                    Value Src = CI.getArgOperand(0);
                    VectorType SrcTy = IrRTTI.cast_VectorType(Src.getType());
                    VectorType DstTy = IrRTTI.cast_VectorType(CI.getType());
                    Rep = CI.getArgOperand(0);
                    int NumDstElts = DstTy.getNumElements();
                    if (Unsigned.$less_uint((int)NumDstElts, (int)SrcTy.getNumElements())) {
                        assert (NumDstElts == 2) : "Unexpected vector size";
                        int[] ShuffleMask = NativePointer.new$uint((int)2, (int[])new int[]{0, 1});
                        Rep = Builder.CreateShuffleVector(Rep, (Value)UndefValue.get(SrcTy), new ArrayRefUInt(ShuffleMask));
                    }
                    boolean bl = Int2Double = StringRef.npos != Name.find("cvtdq2");
                    Rep = Int2Double ? Builder.CreateSIToFP(Rep, DstTy, new Twine("cvtdq2pd")) : Builder.CreateFPExt(Rep, DstTy, new Twine("cvtps2pd"));
                } else {
                    if (IsX86 && Name.startswith("sse4a.movnt.")) {
                        Object M = F.getParent();
                        SmallVector Elts = new SmallVector(1, (Object)null);
                        Elts.push_back((Object)ConstantAsMetadata.get(ConstantInt.get(Type.getInt32Ty(C2), Unsigned.$int2ulong((int)1))));
                        MDTuple Node2 = MDNode.get(C2, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Elts, true));
                        Value Arg0 = CI.getArgOperand(0);
                        Value Arg1 = CI.getArgOperand(1);
                        Type SrcEltTy = IrRTTI.cast_VectorType(Arg1.getType()).getElementType();
                        PointerType EltPtrTy = PointerType.getUnqual(SrcEltTy);
                        Value Addr = Builder.CreateBitCast(Arg0, EltPtrTy, new Twine("cast"));
                        Value Extract = Builder.CreateExtractElement(Arg1, Unsigned.$int2ulong((int)0), new Twine("extractelement"));
                        StoreInst SI = Builder.CreateAlignedStore(Extract, Addr, 1);
                        SI.setMetadata(((Module$IR)M).getMDKindID(new StringRef("nontemporal")), (MDNode)Node2);
                        CI.eraseFromParent();
                        return;
                    }
                    if (IsX86 && (Name.startswith("avx.movnt.") || Name.startswith("avx512.storent."))) {
                        Object M = F.getParent();
                        SmallVector Elts = new SmallVector(1, (Object)null);
                        Elts.push_back((Object)ConstantAsMetadata.get(ConstantInt.get(Type.getInt32Ty(C2), Unsigned.$int2ulong((int)1))));
                        MDTuple Node3 = MDNode.get(C2, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Elts, true));
                        Value Arg0 = CI.getArgOperand(0);
                        Value Arg1 = CI.getArgOperand(1);
                        Value BC = Builder.CreateBitCast(Arg0, PointerType.getUnqual(Arg1.getType()), new Twine("cast"));
                        VectorType VTy = IrRTTI.cast_VectorType(Arg1.getType());
                        StoreInst SI = Builder.CreateAlignedStore(Arg1, BC, Unsigned.$div_uint((int)VTy.getBitWidth(), (int)8));
                        SI.setMetadata(((Module$IR)M).getMDKindID(new StringRef("nontemporal")), (MDNode)Node3);
                        CI.eraseFromParent();
                        return;
                    }
                    if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"sse2.storel.dq")) {
                        Value Arg0 = CI.getArgOperand(0);
                        Value Arg1 = CI.getArgOperand(1);
                        VectorType NewVecTy = VectorType.get(Type.getInt64Ty(C2), 2);
                        Value BC0 = Builder.CreateBitCast(Arg1, NewVecTy, new Twine("cast"));
                        Value Elt = Builder.CreateExtractElement(BC0, Unsigned.$int2ulong((int)0));
                        Value BC = Builder.CreateBitCast(Arg0, PointerType.getUnqual(Elt.getType()), new Twine("cast"));
                        Builder.CreateAlignedStore(Elt, BC, 1);
                        CI.eraseFromParent();
                        return;
                    }
                    if (IsX86 && (Name.startswith("sse.storeu.") || Name.startswith("sse2.storeu.") || Name.startswith("avx.storeu."))) {
                        Value Arg0 = CI.getArgOperand(0);
                        Value Arg1 = CI.getArgOperand(1);
                        Arg0 = Builder.CreateBitCast(Arg0, PointerType.getUnqual(Arg1.getType()), new Twine("cast"));
                        Builder.CreateAlignedStore(Arg1, Arg0, 1);
                        CI.eraseFromParent();
                        return;
                    }
                    if (IsX86 && (Name.startswith("avx512.mask.storeu.p") || Name.startswith("avx512.mask.storeu.b.") || Name.startswith("avx512.mask.storeu.w.") || Name.startswith("avx512.mask.storeu.d.") || Name.startswith("avx512.mask.storeu.q."))) {
                        AutoUpgradeStatics.UpgradeMaskedStore(Builder, CI.getArgOperand(0), CI.getArgOperand(1), CI.getArgOperand(2), false);
                        CI.eraseFromParent();
                        return;
                    }
                    if (IsX86 && (Name.startswith("avx512.mask.store.p") || Name.startswith("avx512.mask.store.b.") || Name.startswith("avx512.mask.store.w.") || Name.startswith("avx512.mask.store.d.") || Name.startswith("avx512.mask.store.q."))) {
                        AutoUpgradeStatics.UpgradeMaskedStore(Builder, CI.getArgOperand(0), CI.getArgOperand(1), CI.getArgOperand(2), true);
                        CI.eraseFromParent();
                        return;
                    }
                    if (IsX86 && (Name.startswith("avx512.mask.loadu.p") || Name.startswith("avx512.mask.loadu.b.") || Name.startswith("avx512.mask.loadu.w.") || Name.startswith("avx512.mask.loadu.d.") || Name.startswith("avx512.mask.loadu.q."))) {
                        Rep = AutoUpgradeStatics.UpgradeMaskedLoad(Builder, CI.getArgOperand(0), CI.getArgOperand(1), CI.getArgOperand(2), false);
                    } else if (IsX86 && (Name.startswith("avx512.mask.load.p") || Name.startswith("avx512.mask.load.b.") || Name.startswith("avx512.mask.load.w.") || Name.startswith("avx512.mask.load.d.") || Name.startswith("avx512.mask.load.q."))) {
                        Rep = AutoUpgradeStatics.UpgradeMaskedLoad(Builder, CI.getArgOperand(0), CI.getArgOperand(1), CI.getArgOperand(2), true);
                    } else if (IsX86 && Name.startswith("xop.vpcom")) {
                        int Imm;
                        int intID;
                        if (Name.endswith("ub")) {
                            intID = 5964;
                        } else if (Name.endswith("uw")) {
                            intID = 5967;
                        } else if (Name.endswith("ud")) {
                            intID = 5965;
                        } else if (Name.endswith("uq")) {
                            intID = 5966;
                        } else if (Name.endswith("b")) {
                            intID = 5961;
                        } else if (Name.endswith("w")) {
                            intID = 5968;
                        } else if (Name.endswith("d")) {
                            intID = 5962;
                        } else if (Name.endswith("q")) {
                            intID = 5963;
                        } else {
                            throw new llvm_unreachable("Unknown suffix");
                        }
                        Name.$assignMove(Name.substr(9));
                        if (Name.startswith("lt")) {
                            Imm = 0;
                        } else if (Name.startswith("le")) {
                            Imm = 1;
                        } else if (Name.startswith("gt")) {
                            Imm = 2;
                        } else if (Name.startswith("ge")) {
                            Imm = 3;
                        } else if (Name.startswith("eq")) {
                            Imm = 4;
                        } else if (Name.startswith("ne")) {
                            Imm = 5;
                        } else if (Name.startswith("false")) {
                            Imm = 6;
                        } else if (Name.startswith("true")) {
                            Imm = 7;
                        } else {
                            throw new llvm_unreachable("Unknown condition");
                        }
                        Function VPCOM = IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), intID);
                        Rep = Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(VPCOM, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{CI.getArgOperand(0), CI.getArgOperand(1), Builder.getInt8(Unsigned.$uint2uchar((int)Imm))}, true));
                    } else if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"xop.vpcmov")) {
                        Value Arg0 = CI.getArgOperand(0);
                        Value Arg1 = CI.getArgOperand(1);
                        Value Sel = CI.getArgOperand(2);
                        int NumElts = CI.getType().getVectorNumElements();
                        Constant MinusOne = ConstantVector.getSplat(NumElts, Builder.getInt64(Unsigned.$int2ulong((int)-1)));
                        Value NotSel = Builder.CreateXor(Sel, MinusOne);
                        Value Sel0 = Builder.CreateAnd(Arg0, Sel);
                        Value Sel1 = Builder.CreateAnd(Arg1, NotSel);
                        Rep = Builder.CreateOr(Sel0, Sel1);
                    } else if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"sse42.crc32.64.8")) {
                        Function CRC32 = IntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), 5887);
                        Value Trunc0 = Builder.CreateTrunc(CI.getArgOperand(0), Type.getInt32Ty(C2));
                        Rep = Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(CRC32, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{Trunc0, CI.getArgOperand(1)}, true));
                        Rep = Builder.CreateZExt(Rep, CI.getType(), new Twine(NativePointer.$EMPTY));
                    } else if (IsX86 && Name.startswith("avx.vbroadcast")) {
                        Type VecTy = CI.getType();
                        Type EltTy = VecTy.getVectorElementType();
                        int EltNum = VecTy.getVectorNumElements();
                        Value Cast = Builder.CreateBitCast(CI.getArgOperand(0), EltTy.getPointerTo());
                        LoadInst Load = Builder.CreateLoad(EltTy, Cast);
                        IntegerType I32Ty = Type.getInt32Ty(C2);
                        Rep = UndefValue.get(VecTy);
                        int I = 0;
                        while (Unsigned.$less_uint((int)I, (int)EltNum)) {
                            Rep = Builder.CreateInsertElement(Rep, (Value)Load, ConstantInt.get((Type)I32Ty, Unsigned.$uint2ulong((int)I)));
                            ++I;
                        }
                    } else if (IsX86 && (Name.startswith("sse41.pmovsx") || Name.startswith("sse41.pmovzx") || Name.startswith("avx2.pmovsx") || Name.startswith("avx2.pmovzx"))) {
                        VectorType SrcTy = IrRTTI.cast_VectorType(CI.getArgOperand(0).getType());
                        VectorType DstTy = IrRTTI.cast_VectorType(CI.getType());
                        int NumDstElts = DstTy.getNumElements();
                        SmallVectorUInt ShuffleMask = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 8, NumDstElts, 0);
                        for (int i = 0; i != NumDstElts; ++i) {
                            ShuffleMask.$set(i, i);
                        }
                        Value SV = Builder.CreateShuffleVector(CI.getArgOperand(0), (Value)UndefValue.get(SrcTy), new ArrayRefUInt((SmallVectorImplUInt)ShuffleMask));
                        boolean DoSext = StringRef.npos != Name.find("pmovsx");
                        Rep = DoSext ? Builder.CreateSExt(SV, DstTy) : Builder.CreateZExt(SV, DstTy);
                    } else if (IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"avx2.vbroadcasti128")) {
                        VectorType VT = VectorType.get(Type.getInt64Ty(C2), 2);
                        Value Op = Builder.CreatePointerCast(CI.getArgOperand(0), PointerType.getUnqual(VT));
                        LoadInst Load = Builder.CreateLoad(VT, Op);
                        int[] Idxs = NativePointer.new$uint((int)4, (int[])new int[]{0, 1, 0, 1});
                        Rep = Builder.CreateShuffleVector((Value)Load, (Value)UndefValue.get(Load.getType()), new ArrayRefUInt(Idxs));
                    } else if (IsX86 && (Name.startswith("avx2.pbroadcast") || Name.startswith("avx2.vbroadcast") || Name.startswith("avx512.pbroadcast") || Name.startswith("avx512.mask.broadcast.s"))) {
                        Value Op = CI.getArgOperand(0);
                        int NumElts = CI.getType().getVectorNumElements();
                        VectorType MaskTy = VectorType.get(Type.getInt32Ty(C2), NumElts);
                        Rep = Builder.CreateShuffleVector(Op, (Value)UndefValue.get(Op.getType()), Constant.getNullValue(MaskTy));
                        if (CI.getNumArgOperands() == 3) {
                            Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(2), Rep, CI.getArgOperand(1));
                        }
                    } else if (IsX86 && Name.startswith("avx512.mask.palignr.")) {
                        Rep = AutoUpgradeStatics.UpgradeX86PALIGNRIntrinsics(Builder, CI.getArgOperand(0), CI.getArgOperand(1), CI.getArgOperand(2), CI.getArgOperand(3), CI.getArgOperand(4));
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.psll.dq") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.psll.dq"))) {
                        int Shift = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        Rep = AutoUpgradeStatics.UpgradeX86PSLLDQIntrinsics(Builder, CI.getArgOperand(0), Unsigned.$div_uint((int)Shift, (int)8));
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.psrl.dq") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.psrl.dq"))) {
                        int Shift = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        Rep = AutoUpgradeStatics.UpgradeX86PSRLDQIntrinsics(Builder, CI.getArgOperand(0), Unsigned.$div_uint((int)Shift, (int)8));
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.psll.dq.bs") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.psll.dq.bs") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512.psll.dq.512"))) {
                        int Shift = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        Rep = AutoUpgradeStatics.UpgradeX86PSLLDQIntrinsics(Builder, CI.getArgOperand(0), Shift);
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.psrl.dq.bs") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.psrl.dq.bs") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512.psrl.dq.512"))) {
                        int Shift = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        Rep = AutoUpgradeStatics.UpgradeX86PSRLDQIntrinsics(Builder, CI.getArgOperand(0), Shift);
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse41.pblendw") || Name.startswith("sse41.blendp") || Name.startswith("avx.blend.p") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.pblendw") || Name.startswith("avx2.pblendd."))) {
                        Value Op0 = CI.getArgOperand(0);
                        Value Op1 = CI.getArgOperand(1);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(2)).getZExtValue());
                        VectorType VecTy = IrRTTI.cast_VectorType(CI.getType());
                        int NumElts = VecTy.getNumElements();
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 16, NumElts, 0);
                        for (int i = 0; i != NumElts; ++i) {
                            Idxs.$set(i, (Imm >>> Unsigned.$rem_uint((int)i, (int)8) & 1) != 0 ? i + NumElts : i);
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op1, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                    } else if (IsX86 && (Name.startswith("avx.vinsertf128.") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.vinserti128"))) {
                        int i;
                        Value Op0 = CI.getArgOperand(0);
                        Value Op1 = CI.getArgOperand(1);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(2)).getZExtValue());
                        VectorType VecTy = IrRTTI.cast_VectorType(CI.getType());
                        int NumElts = VecTy.getNumElements();
                        Imm &= 1;
                        UndefValue UndefV = UndefValue.get(Op1.getType());
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 8, NumElts, 0);
                        for (i = 0; i != NumElts; ++i) {
                            Idxs.$set(i, i);
                        }
                        Rep = Builder.CreateShuffleVector(Op1, (Value)UndefV, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        for (i = 0; i != Unsigned.$div_uint((int)NumElts, (int)2); ++i) {
                            Idxs.$set(i, Imm != 0 ? i : i + NumElts);
                        }
                        for (i = Unsigned.$div_uint((int)NumElts, (int)2); i != NumElts; ++i) {
                            Idxs.$set(i, Imm != 0 ? i + Unsigned.$div_uint((int)NumElts, (int)2) : i);
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Rep, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                    } else if (IsX86 && (Name.startswith("avx.vextractf128.") || llvm.$eq_StringRef((StringRef)Name, (String)"avx2.vextracti128"))) {
                        Value Op0 = CI.getArgOperand(0);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        VectorType VecTy = IrRTTI.cast_VectorType(CI.getType());
                        int NumElts = VecTy.getNumElements();
                        Imm &= 1;
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 4, NumElts, 0);
                        for (int i = 0; i != NumElts; ++i) {
                            Idxs.$set(i, Imm != 0 ? i + NumElts : i);
                        }
                        UndefValue UndefV = UndefValue.get(Op0.getType());
                        Rep = Builder.CreateShuffleVector(Op0, (Value)UndefV, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                    } else if (!IsX86 && llvm.$eq_StringRef((StringRef)Name, (String)"stackprotectorcheck")) {
                        Rep = null;
                    } else if (IsX86 && (Name.startswith("avx512.mask.perm.df.") || Name.startswith("avx512.mask.perm.di."))) {
                        Value Op0 = CI.getArgOperand(0);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        VectorType VecTy = IrRTTI.cast_VectorType(CI.getType());
                        int NumElts = VecTy.getNumElements();
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 8, NumElts, 0);
                        for (int i = 0; i != NumElts; ++i) {
                            Idxs.$set(i, (i & 0xFFFFFFFC) + (Imm >>> 2 * (i & 3) & 3));
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op0, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        if (CI.getNumArgOperands() == 4) {
                            Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                        }
                    } else if (IsX86 && (Name.startswith("avx.vpermil.") || llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pshuf.d") || Name.startswith("avx512.mask.vpermil.p") || Name.startswith("avx512.mask.pshuf.d."))) {
                        Value Op0 = CI.getArgOperand(0);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        VectorType VecTy = IrRTTI.cast_VectorType(CI.getType());
                        int NumElts = VecTy.getNumElements();
                        int IdxSize = Unsigned.$div_uint((int)64, (int)VecTy.getScalarSizeInBits());
                        int IdxMask = (1 << IdxSize) - 1;
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 8, NumElts, 0);
                        for (int i = 0; i != NumElts; ++i) {
                            Idxs.$set(i, Imm >>> Unsigned.$rem_uint((int)(i * IdxSize), (int)8) & IdxMask | i & ~IdxMask);
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op0, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        if (CI.getNumArgOperands() == 4) {
                            Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                        }
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pshufl.w") || Name.startswith("avx512.mask.pshufl.w."))) {
                        Value Op0 = CI.getArgOperand(0);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        int NumElts = CI.getType().getVectorNumElements();
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 16, NumElts, 0);
                        for (int l = 0; l != NumElts; l += 8) {
                            int i;
                            for (i = 0; i != 4; ++i) {
                                Idxs.$set(i + l, (Imm >>> 2 * i & 3) + l);
                            }
                            for (i = 4; i != 8; ++i) {
                                Idxs.$set(i + l, i + l);
                            }
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op0, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        if (CI.getNumArgOperands() == 4) {
                            Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                        }
                    } else if (IsX86 && (llvm.$eq_StringRef((StringRef)Name, (String)"sse2.pshufh.w") || Name.startswith("avx512.mask.pshufh.w."))) {
                        Value Op0 = CI.getArgOperand(0);
                        int Imm = Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(CI.getArgOperand(1)).getZExtValue());
                        int NumElts = CI.getType().getVectorNumElements();
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 16, NumElts, 0);
                        for (int l = 0; l != NumElts; l += 8) {
                            int i;
                            for (i = 0; i != 4; ++i) {
                                Idxs.$set(i + l, i + l);
                            }
                            for (i = 0; i != 4; ++i) {
                                Idxs.$set(i + l + 4, (Imm >>> 2 * i & 3) + 4 + l);
                            }
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op0, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        if (CI.getNumArgOperands() == 4) {
                            Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                        }
                    } else if (IsX86 && (Name.startswith("avx512.mask.movddup") || Name.startswith("avx512.mask.movshdup") || Name.startswith("avx512.mask.movsldup"))) {
                        Value Op0 = CI.getArgOperand(0);
                        int NumElts = CI.getType().getVectorNumElements();
                        int NumLaneElts = Unsigned.$div_uint((int)128, (int)CI.getType().getScalarSizeInBits());
                        int Offset = 0;
                        if (Name.startswith("avx512.mask.movshdup.")) {
                            Offset = 1;
                        }
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 16, NumElts, 0);
                        for (int l = 0; l != NumElts; l += NumLaneElts) {
                            for (int i = 0; i != NumLaneElts; i += 2) {
                                Idxs.$set(i + l + 0, i + l + Offset);
                                Idxs.$set(i + l + 1, i + l + Offset);
                            }
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op0, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(2), Rep, CI.getArgOperand(1));
                    } else if (IsX86 && (Name.startswith("avx512.mask.punpckl") || Name.startswith("avx512.mask.unpckl."))) {
                        Value Op0 = CI.getArgOperand(0);
                        Value Op1 = CI.getArgOperand(1);
                        int NumElts = CI.getType().getVectorNumElements();
                        int NumLaneElts = Unsigned.$div_uint((int)128, (int)CI.getType().getScalarSizeInBits());
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 64, NumElts, 0);
                        for (int l = 0; l != NumElts; l += NumLaneElts) {
                            for (int i = 0; i != NumLaneElts; ++i) {
                                Idxs.$set(i + l, l + i / 2 + NumElts * (i % 2));
                            }
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op1, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                    } else if (IsX86 && (Name.startswith("avx512.mask.punpckh") || Name.startswith("avx512.mask.unpckh."))) {
                        Value Op0 = CI.getArgOperand(0);
                        Value Op1 = CI.getArgOperand(1);
                        int NumElts = CI.getType().getVectorNumElements();
                        int NumLaneElts = Unsigned.$div_uint((int)128, (int)CI.getType().getScalarSizeInBits());
                        SmallVectorUInt Idxs = new SmallVectorUInt(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 64, NumElts, 0);
                        for (int l = 0; l != NumElts; l += NumLaneElts) {
                            for (int i = 0; i != NumLaneElts; ++i) {
                                Idxs.$set(i + l, NumLaneElts / 2 + l + i / 2 + NumElts * (i % 2));
                            }
                        }
                        Rep = Builder.CreateShuffleVector(Op0, Op1, new ArrayRefUInt((SmallVectorImplUInt)Idxs));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                    } else if (IsX86 && Name.startswith("avx512.mask.pand.")) {
                        Rep = Builder.CreateAnd(CI.getArgOperand(0), CI.getArgOperand(1));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                    } else if (IsX86 && Name.startswith("avx512.mask.pandn.")) {
                        Rep = Builder.CreateAnd(Builder.CreateNot(CI.getArgOperand(0)), CI.getArgOperand(1));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                    } else if (IsX86 && Name.startswith("avx512.mask.por.")) {
                        Rep = Builder.CreateOr(CI.getArgOperand(0), CI.getArgOperand(1));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                    } else if (IsX86 && Name.startswith("avx512.mask.pxor.")) {
                        Rep = Builder.CreateXor(CI.getArgOperand(0), CI.getArgOperand(1));
                        Rep = AutoUpgradeStatics.EmitX86Select(Builder, CI.getArgOperand(3), Rep, CI.getArgOperand(2));
                    } else {
                        throw new llvm_unreachable("Unknown function for CallInst upgrade.");
                    }
                }
                if (Rep != null) {
                    CI.replaceAllUsesWith(Rep);
                }
                CI.eraseFromParent();
                return;
            }
            std.string Name = CI.getName().$string();
            if (!Name.empty()) {
                CI.setName(new Twine(std.$add_string$C_T$C$P((std.string)Name, (String)".old")));
            }
            switch (NewFn.getIntrinsicID()) {
                default: {
                    throw new llvm_unreachable("Unknown function for CallInst upgrade.");
                }
                case 474: 
                case 475: 
                case 476: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 5121: 
                case 5127: 
                case 5148: 
                case 5154: 
                case 5175: 
                case 5181: {
                    SmallVector Args = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, (type.iterator)((type.ptr)CI.arg_operands().begin()), (type.iterator)((type.ptr)CI.arg_operands().end()), (Object)null, a -> a.$Value$P());
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)Args, true)));
                    CI.eraseFromParent();
                    return;
                }
                case 22: 
                case 24: {
                    assert (CI.getNumArgOperands() == 1) : "Mismatch between function args and call args";
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{CI.getArgOperand(0), Builder.getFalse()}, true), new Twine(Name)));
                    CI.eraseFromParent();
                    return;
                }
                case 89: {
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{CI.getArgOperand(0), CI.getArgOperand(1)}, true), new Twine(Name)));
                    CI.eraseFromParent();
                    return;
                }
                case 23: {
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{CI.getArgOperand(0)}, true)));
                    CI.eraseFromParent();
                    return;
                }
                case 5957: 
                case 5958: {
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{CI.getArgOperand(1)}, true), new Twine(Name)));
                    CI.eraseFromParent();
                    return;
                }
                case 5969: 
                case 5970: 
                case 5971: 
                case 5972: {
                    SmallVector Args = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, (type.iterator)((type.ptr)CI.arg_operands().begin()), (type.iterator)((type.ptr)CI.arg_operands().end()), (Object)null, a -> a.$Value$P());
                    VectorType FltIdxTy = IrRTTI.cast_VectorType(((Value)Args.$at(2)).getType());
                    VectorType IntIdxTy = VectorType.getInteger(FltIdxTy);
                    Args.$set(2, (Object)Builder.CreateBitCast((Value)Args.$at(2), IntIdxTy));
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)Args, true), new Twine(Name)));
                    CI.eraseFromParent();
                    return;
                }
                case 5878: 
                case 5879: 
                case 5880: {
                    Value Arg0 = CI.getArgOperand(0);
                    if (Arg0.getType() != VectorType.get(Type.getFloatTy(C2), 4)) {
                        return;
                    }
                    Value Arg1 = CI.getArgOperand(1);
                    VectorType NewVecTy = VectorType.get(Type.getInt64Ty(C2), 2);
                    Value BC0 = Builder.CreateBitCast(Arg0, NewVecTy, new Twine("cast"));
                    Value BC1 = Builder.CreateBitCast(Arg1, NewVecTy, new Twine("cast"));
                    CallInst NewCall = Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((Object[])new Value[]{BC0, BC1}, true), new Twine(Name));
                    CI.replaceAllUsesWith(NewCall);
                    CI.eraseFromParent();
                    return;
                }
                case 4268: 
                case 4345: 
                case 5869: 
                case 5870: 
                case 5871: 
                case 5873: {
                    SmallVector Args = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, (type.iterator)((type.ptr)CI.arg_operands().begin()), (type.iterator)((type.ptr)CI.arg_operands().end()), (Object)null, a -> a.$Value$P());
                    Args.ref$back().$set((Object)Builder.CreateTrunc((Value)Args.back(), Type.getInt8Ty(C2), new Twine("trunc")));
                    CallInst NewCall = Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)Args, true));
                    CI.replaceAllUsesWith(NewCall);
                    CI.eraseFromParent();
                    return;
                }
                case 112: {
                    CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef(true)));
                    CI.eraseFromParent();
                    return;
                }
                case 80: 
                case 82: 
            }
            SmallVector Args = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, (type.iterator)((type.ptr)CI.arg_operands().begin()), (type.iterator)((type.ptr)CI.arg_operands().end()), (Object)null, a -> a.$Value$P());
            CI.replaceAllUsesWith(Builder.CreateCall_Function$P_ArrayRef$Value$P_Twine$C_MDNode$P(NewFn, (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)Args, true)));
            CI.eraseFromParent();
            return;
        }
        finally {
            if (Builder != null) {
                Builder.$destroy();
            }
        }
    }

    public static void UpgradeCallsToIntrinsic(Function F) {
        assert (F != null) : "Illegal attempt to upgrade a non-existent intrinsic.";
        type.ref NewFn = NativePointer.create_type$ref();
        if (AutoUpgradeLlvmGlobals.UpgradeIntrinsicFunction(F, (type.ref<Function>)NewFn)) {
            Value.user_iterator_impl<User> UI = F.user_begin();
            Value.user_iterator_impl<User> UE = F.user_end();
            while (UI.$noteq(UE)) {
                CallInst CI = IrRTTI.dyn_cast_CallInst((Value)UI.$postInc(0).$star());
                if (CI == null) continue;
                AutoUpgradeLlvmGlobals.UpgradeIntrinsicCall(CI, (Function)NewFn.$deref());
            }
            F.eraseFromParent();
        }
    }

    public static boolean UpgradeGlobalVariable(GlobalVariable GV) {
        return false;
    }

    public static boolean UpgradeModuleFlags(Module$IR M) {
        NamedMDNode ModFlags = M.getModuleFlagsMetadata();
        if (ModFlags == null) {
            return false;
        }
        boolean HasObjCFlag = false;
        boolean HasClassProperties = false;
        int E = ModFlags.getNumOperands();
        for (int I = 0; I != E; ++I) {
            MDString ID2;
            MDNode Op = ModFlags.getOperand(I);
            if (Unsigned.$less_uint((int)Op.getNumOperands(), (int)2) || (ID2 = IRManualRTTI.dyn_cast_or_null_MDString(Op.getOperand(1))) == null) continue;
            if (llvm.$eq_StringRef((StringRef)ID2.getString(), (String)"Objective-C Image Info Version")) {
                HasObjCFlag = true;
            }
            if (!llvm.$eq_StringRef((StringRef)ID2.getString(), (String)"Objective-C Class Properties")) continue;
            HasClassProperties = true;
        }
        if (HasObjCFlag && !HasClassProperties) {
            M.addModuleFlag(Module$IR.ModFlagBehavior.Error, new StringRef("Objective-C Class Properties"), 0);
            return true;
        }
        return false;
    }

    public static void UpgradeInstWithTBAATag(Instruction I) {
        MDNode MD = I.getMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue());
        assert (MD != null) : "UpgradeInstWithTBAATag should have a TBAA tag";
        if (IRManualRTTI.isa_MDNode(MD.getOperand(0)) && Unsigned.$greatereq_uint((int)MD.getNumOperands(), (int)3)) {
            return;
        }
        if (MD.getNumOperands() == 3) {
            Object[] Elts = new Metadata[]{MD.getOperand(0).$Metadata$P(), MD.getOperand(1).$Metadata$P()};
            MDTuple ScalarType = MDNode.get(I.getContext(), (ArrayRef<Metadata>)new ArrayRef(Elts, true));
            Object[] Elts2 = new Metadata[]{ScalarType, ScalarType, ConstantAsMetadata.get(Constant.getNullValue(Type.getInt64Ty(I.getContext()))), MD.getOperand(2).$Metadata$P()};
            I.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue(), (MDNode)MDNode.get(I.getContext(), (ArrayRef<Metadata>)new ArrayRef(Elts2, true)));
        } else {
            Object[] Elts = new Metadata[]{MD, MD, ConstantAsMetadata.get(Constant.getNullValue(Type.getInt64Ty(I.getContext())))};
            I.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue(), (MDNode)MDNode.get(I.getContext(), (ArrayRef<Metadata>)new ArrayRef(Elts, true)));
        }
    }

    public static Instruction UpgradeBitCastInst(int Opc, Value V, Type DestTy, type.ref<Instruction> Temp) {
        if (Opc != 47) {
            return null;
        }
        Temp.$set(null);
        Type SrcTy = V.getType();
        if (SrcTy.isPtrOrPtrVectorTy() && DestTy.isPtrOrPtrVectorTy() && SrcTy.getPointerAddressSpace() != DestTy.getPointerAddressSpace()) {
            LLVMContext Context = V.getContext();
            IntegerType MidTy = Type.getInt64Ty(Context);
            Temp.$set((Object)CastInst.Create(45, V, MidTy));
            return CastInst.Create(46, (Value)Temp.$deref(), DestTy);
        }
        return null;
    }

    public static Value UpgradeBitCastExpr(int Opc, Constant C2, Type DestTy) {
        if (Opc != 47) {
            return null;
        }
        Type SrcTy = C2.getType();
        if (SrcTy.isPtrOrPtrVectorTy() && DestTy.isPtrOrPtrVectorTy() && SrcTy.getPointerAddressSpace() != DestTy.getPointerAddressSpace()) {
            LLVMContext Context = C2.getContext();
            IntegerType MidTy = Type.getInt64Ty(Context);
            return ConstantExpr.getIntToPtr(ConstantExpr.getPtrToInt(C2, MidTy), DestTy);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean UpgradeDebugInfo(Module$IR M) {
        int Version = IrLlvmGlobals.getDebugMetadataVersionFromModule(M);
        if (Version == LLVMConstants.DEBUG_METADATA_VERSION.getValue()) {
            return false;
        }
        boolean RetCode = IrLlvmGlobals.StripDebugInfo(M);
        if (RetCode) {
            DiagnosticInfoDebugMetadataVersion DiagVersion = null;
            try {
                DiagVersion = new DiagnosticInfoDebugMetadataVersion(M, Version);
                M.getContext().diagnose(DiagVersion);
            }
            finally {
                if (DiagVersion != null) {
                    DiagVersion.$destroy();
                }
            }
        }
        return RetCode;
    }

    public static boolean mayBeOldLoopAttachmentTag(StringRef Name) {
        return Name.startswith("llvm.vectorizer.");
    }

    public static MDNode upgradeInstructionLoopAttachment(MDNode N) {
        MDTuple T2 = IrRTTI.dyn_cast_MDTuple((Metadata)Native.$AddrOf((Object)N));
        if (T2 == null) {
            return (MDNode)Native.$AddrOf((Object)N);
        }
        if (!llvm.any_of(T2.operands(), MD -> AutoUpgradeStatics.isOldLoopArgument(MD.$Metadata$P()))) {
            return (MDNode)Native.$AddrOf((Object)N);
        }
        SmallVector Ops = new SmallVector(8, (Object)null);
        Ops.reserve(T2.getNumOperands());
        for (MDOperand operand : T2.operands()) {
            Metadata MD2 = operand.$Metadata$P();
            Ops.push_back((Object)AutoUpgradeStatics.upgradeLoopArgument(MD2));
        }
        return MDTuple.get(T2.getContext(), (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Ops, true));
    }
}

